package miiee.TGraph;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.Vector;
import java.awt.event.*;
import miiee.util.*;
import miiee.mml.*;
import miiee.client.*;
import java.util.HashMap;
import java.util.Iterator;
import javax.help.*;
import javax.swing.border.*;

// Referenced classes of package miiee.TGraph:
//            GraphCanvas, SetupFrame

class ArrayIndexRec extends Object {
  int _array_index[];
  String _array_index_name[];
  int _comp_index;
  
  ArrayIndexRec( int component_index, int array_index[], String array_index_name[] ) {
	_comp_index = component_index;
	_array_index = array_index;
	_array_index_name = array_index_name;
  }

  int getIndex( int index ) { return _array_index[index]; }
  String getIndexName( int index ) { return _array_index_name[index]; }
  int getCompIndex() { return _comp_index; }
}

class ComponentRec extends Object {
  Vector _arrayRecs = new Vector();
  int _comp_index;
  
  ComponentRec( int index ) { _comp_index = index; }

  void addArrayIndexRec( ArrayIndexRec rec ) { _arrayRecs.add(rec); }
  Iterator getArrayIndexRecs() { return _arrayRecs.iterator(); }
  int getCompIndex() { return _comp_index; }
}

public class TimeGraph extends JPanel  implements Runnable, DisposableListDataListener, ActionListener
{

    public TimeGraph() {
        super();
        _run = true;
        _engine = null;
	}
	
    public TimeGraph(AppletController ac)  {
        super();
        _run = true;
        _engine = null;
        _ac = ac;
    }

    public TimeGraph(int t0, int tf, float dt, float y0, float ymax, int units, AppletController ac)   {
        super();
        _run = true;
        _engine = null;
        setDimensions(t0, tf, dt, y0, ymax, units);
        _ac = ac;
    }

    public void setDimensions(int t0, int tf, float dt, float y0, float ymax, int units)
    {
        _t0 = t0;
        _tf = tf;
        _dt = dt;
        _y0 = y0;
        _ymax = ymax;
        time_units = units;
        if(_canvas != null) { _canvas.setDimensions(_t0, _tf, _dt, _y0, _ymax, time_units); }
		if(_DEBUG) SimIO.print( "Set Graph dimensions: ( t0: " + Float.toString(t0) + ", tf: "  + Float.toString(tf) + ", dt: "  + Float.toString(dt) + ", y0: "  + Float.toString(y0)+ ", ymax: "  + Float.toString(ymax)+ ") "  );
    }

    public void Enlarge(int t0, int tf, float dt, float y0, float ymax, int units)
    {
        if(_t0 > t0)
            _t0 = t0;
        if(_tf < tf)
            _tf = tf;
        if(_dt != dt || time_units != units)
            SimIO.print("Error, unmatched dt's in graph");
        if(_y0 > y0)
            _y0 = y0;
        if(_ymax < ymax)
            _ymax = ymax;
        _canvas.setDimensions(_t0, _tf, _dt, _y0, _ymax, time_units);
    }

	public void waitForInit() {
		if( _canvas == null ) {
		  SimIO.print("Waiting for init ");
		  while ( _canvas == null ) {       
			  try {  Thread.sleep(200L);   }  
			  catch (InterruptedException e0) {  return;  }
			  System.out.print(".");
		  }
		}		
	}
	
    public void addComponent(int component_index, String color, String name) {
//		waitForInit();
		initCanvas(); 
        _canvas.setComponent(component_index, color, name);
    }
   
    public void addComponent( int component_index, DataSet d ) {
//		waitForInit();
		initCanvas(); 
		int index = d.index();
		int adim = d.getArrayDimension();
		if( index >= _component_index_map.size() ) { _component_index_map.setSize(index+16); }
		String name = d.toString();
		ComponentRec cr;
		if( d.format() == 3 ) {
		  cr = new ComponentRec(-1);
		  ArrayIndexRec ar = getArrayIndexRec( component_index, d );
		  if( ar == null ) return;
		  for( int i=0; i<adim; i++ ) {
			name = ( name + "[" + ar.getIndexName( i ) + "]" );
		  }
		  cr.addArrayIndexRec( ar );
		} else {
		  cr = new ComponentRec(component_index);
		}
		_component_index_map.setElementAt( cr, index );
		_canvas.setComponent( component_index, null, name );
    }
    
    public ArrayIndexRec getArrayIndexRec( int component_index, DataSet d ) {  
		int array_index[] = new int[3];
		String array_index_name[] = new String[3];
		int adim = d.getArrayDimension();
		for( int i=0; i<3; i++ ) {
		  if( i < adim ) {
			String[] options = getArrayArgList( d.toString(), i, d.size(i) );      
			int rv = getArrayIndexSelector( options );
			if( rv < 0 ) { SimIO.print("No Index Selection: " + rv); return null; }
			array_index[i] = rv;
			array_index_name[i] = options[rv];
		  } else {
			array_index[i] = 0;
			array_index_name[i]	= null;
		  }
		}  
		return new ArrayIndexRec( component_index, array_index, array_index_name );
    }
 //	String arrayIndexLabel = (String) _arrayIndexSelector.getSelectedItem();
   
    String[] getArrayArgList( String vname, int dim_index, int dim_size ) {
	  String[] rv = new String[dim_size];
	  Variable v = null;
	  String aname = null;
	  try {
		SNPClient sc = SMEInterface.getClient();
		v = sc.getVariable( vname );
		aname = v.getArray( dim_index );
		MMLConfigCommand mcc = v.getArrayConfig( aname );
		for( int i=0; i<dim_size; i++ ) {
		  MMLConfigArg mca = mcc.getArg(i+1);
		  rv[i] = mca.getValue();
		}
	  } catch ( Exception err ) {
		System.out.println("Can't get array declaration, vname:" + vname + ", var: " + v + ", array_name: " + aname );
		err.printStackTrace();
		for( int i=0; i<dim_size; i++ ) {
		  rv[i] = Integer.toString(i);
		}
	  } 
	  return rv; 
    }    

	int getArrayIndexSelector( String[] options ) {
	  String s = (String) JOptionPane.showInputDialog( null, 
		"Please choose array index:" , "Index Selection Dialog",
		JOptionPane.QUESTION_MESSAGE, null, options, options[0] );
	  if( s== null ) return -2;
	  for( int i=0; i<options.length; i++ ) {
		if( options[i] == s ) return i;
	  }
	  return -1;
	}
	  

	  
    public void addComponent( int component_index, DataSet d, int row, int col ) {
//		waitForInit();
		initCanvas(); 
		int index = d.index();
		if( index >= _component_index_map.size() ) { _component_index_map.setSize(index+16); }
		ComponentRec cr = new ComponentRec(component_index);
		String name = d.toString() + "(" + row + "," + col + ")";
		_component_index_map.setElementAt( cr, index );
        _canvas.setComponent( component_index, null, name );
    }

    public void setDataValues(int component_index, int x0, int npoints, float data[]) {
//		waitForInit();
		initCanvas(); 
        _canvas.setDataValues(component_index, x0, npoints, data);
    }
    
	public synchronized void  addDataEntries( DataSet d ) {
//		waitForInit();
		initCanvas(); 
	  ComponentRec cr = null;
	  try {
		cr = (ComponentRec) _component_index_map.elementAt( d.index() );
	  } catch (ArrayIndexOutOfBoundsException err) {;}
	  
	  if (cr == null ) {
		SimIO.print("No Graph Component for DatSet.");
		return;
	  }
	  int component_index = cr.getCompIndex();
	  if( component_index == -1 ) {
		Iterator iter = cr.getArrayIndexRecs();
		while( iter.hasNext() ) {
		   ArrayIndexRec ar = (ArrayIndexRec) iter.next();
		   component_index = ar.getCompIndex();
		   _canvas.setDataValues(component_index, d, ar.getIndex(0), ar.getIndex(1),ar.getIndex(2) );
		}
	  } else {
		_canvas.setDataValues(component_index,d);
	  }
	}

	public synchronized void  addDataEntries( DataSet d, int row, int col ) {
//		waitForInit();
		initCanvas(); 
	  ComponentRec cr = null;
	  try {
		cr = (ComponentRec) _component_index_map.elementAt( d.index() );
	  } catch (ArrayIndexOutOfBoundsException err) {;}
	  
	  if (cr == null ) {
		SimIO.print("No Graph Component for DatSet.");  
		return;
	  }
	  int component_index = cr.getCompIndex();
	  _canvas.setDataValues( component_index, d, row, col );
	}
   
    synchronized public void intervalAdded(ListDataEvent e) {
	  DataSet d = (DataSet) e.getSource();
	  addDataEntries(d);
    }   

    public void intervalRemoved(ListDataEvent e){;}
    public void contentsChanged(ListDataEvent e){;}
    
	public JPanel constructButtonPanel() { 

		JPanel           buttonPanel = new JPanel(false);
		buttonPanel.setLayout(new FlowLayout());
		_openSetup = new JButton("Configure...");
		_openSetup.addActionListener( this );
		_zoomIn = new JButton("Zoom In");
		_zoomIn.addActionListener(this);
		_zoomOut = new JButton("Zoom Out");
		_zoomOut.addActionListener(this);
		_Reset = new JButton("Reset");
		_Reset.addActionListener(this);
		_openAbout = new JButton("About");
		try {		
			HelpBroker hb = SimIO.getHelpBroker( "SME", "Vtimeseries"  );
			_openAbout.addActionListener( new CSH.DisplayHelpFromSource(hb)  );
		} catch( Exception err ) {;}

		_close = new JButton("Close");
		_close.addActionListener(this);
		buttonPanel.add(_openSetup);
		buttonPanel.add(_zoomIn);
		buttonPanel.add(_zoomOut);
		buttonPanel.add(_Reset);
		buttonPanel.add(_openAbout);
		buttonPanel.add(_close);
		AboutText = "This graph viewer is based on some classes extracted for the TimeGraph applet developed by...";
		return buttonPanel;
	}
    public void run()
    {
        Thread me = Thread.currentThread();
        me.setPriority(5);
        while(_run) 
        {
            if(_canvas.brokenMsg != null)
                Break(_canvas.brokenMsg);
            try
            {
                Thread.sleep(1000L);
            }
            catch(Exception ex) {}
        }

        _canvas.repaint();
    }

    public void start()
    {
        if(_engine == null)
        {
            _engine = new Thread(this);  
            _engine.start();
        }
    }

    public void stop_thread()
    {
        _run = false;
    }

    public void stop()
    {
        _run = false;
        _engine = null;
    }

	public void initDemo() {

	  addComponent( 0, "blue", "cos" );
	  addComponent( 1, "red", "sin" );
	  
	  int npoints = 200;
	  float[] sdata = new float[npoints];
	  float[] cdata = new float[npoints];
	  float f = (float) (6*Math.PI);
	  
	  for( int i=0; i<npoints; i++ ) {
		sdata[i] = (float) Math.sin((f*i)/npoints);
		cdata[i] = (float) Math.cos((f*i)/npoints);
	  }		
	  setDataValues( 0, 0, npoints, cdata );	
	  setDataValues( 1, 0, npoints, sdata );	
	}
	
    public void Break(String msg)
    {
        String str = "";
        int nextSpc;
        for(int ind = 0; ind < msg.length(); ind = nextSpc)  
        {
            str = str + "\n";
            try
            {
                nextSpc = msg.indexOf(32, ind + 50);
                str = str + msg.substring(ind, nextSpc);
            }
            catch(StringIndexOutOfBoundsException ex)
            {
                nextSpc = msg.length();
                str = str + msg.substring(ind);
            }
        }

        TextFrame tf = TextFrame.NewDisposable("TimeGraph Error", str, _ac);
    }

    public void actionPerformed(ActionEvent e)
    {
        Object b = e.getSource();
        if(b == _zoomIn)
            _canvas.zoomIn();
        else
        if(b == _zoomOut)
            _canvas.zoomOut();
        else
        if(b == _Reset)
            _canvas.reset();
        else
        if(b == _close)
        {
            stop();
            destroy();
        }
        else
        if(b == _openSetup) {
            if(_setupFrame == null) {
                _setupFrame = new SetupFrame("Setup Graph", _canvas );
			}
            _setupFrame.setVisible(true);
        }
    }


    public void destroy()  {        
        if(_setupFrame != null)  {
            _setupFrame. setVisible(false);
            _setupFrame.dispose();
            _setupFrame = null;
        }
		if(_ac != null ) { _ac.notifyDestroyed(this); }
    }
	
    public void dispose() {  
	  destroy(); 
	  if( _frame != null ) {
		_frame.setVisible(false);
		_frame.dispose();
		_frame = null;
	  }
	}

	void initCanvas() {
	  if( _canvas == null )   {  	  
		_canvas = new GraphCanvas(8);
		if( _dt > 0.0f ) { _canvas.setDimensions(_t0, _tf, _dt, _y0, _ymax, time_units); }
	  }	
	}
	
	public synchronized JFrame show( String name ) {         		  		
	  if( _frame == null )   {  
		_frame = new JFrame( " TimeGraph: " + name );
		WindowListener l = new WindowAdapter() {
			public void windowClosing(WindowEvent e) { destroy(); }
		};	  
		_frame.addWindowListener( l );

		initCanvas(); 
		setLayout(new BorderLayout());
		add( "Center", _canvas );
		add( "South", constructButtonPanel());					
		_frame.getContentPane().add( "Center", this );
		 
		_frame.setSize(500,300);
	  }
	  _frame.setVisible(true);
	  return _frame;
	}

	public Container getContentPane() { return this; }
	public  DataSet getDataSet() { return null; }

    static final int _numGraphs = 8;
    protected static final boolean _DEBUG = false;
    protected boolean _run;
    protected boolean _highestGroups;
    protected boolean _graphDeltas;
    protected boolean _usDates;
    protected int _dynamicMemorySize;
    protected JButton _zoomIn;
    protected JButton _zoomOut;
    protected JButton _openSetup;
    protected JButton _openAbout;
    protected JButton _Reset;
    protected JButton _close;
    protected SetupFrame _setupFrame;
    GraphCanvas _canvas;
    protected Thread _engine;
    protected int _t0;
    protected int _tf;
    protected int time_units;
    protected float _y0;
    protected float _ymax;
    protected float _dt = -1.0f;
    protected String AboutText;
    protected AppletController _ac;
    protected JFrame _frame;
    protected Vector _component_index_map = new Vector(16,16);

}
