package miiee.client;

import java.util.Vector;
import org.xml.sax.Attributes;
import miiee.mml.*;
import miiee.xml.*;
import miiee.util.*;
import javax.swing.*;

public class Action extends ConfigurableObject {

    protected String _code;
    public Vector _dependencies;
    public Vector _ports;
    public byte  _cmdType;
    public byte  _depIndex;
    public byte  _exType;
    public byte  _status;
    public byte  _function;
    public byte  _data[] = new byte[8];
    public final static byte[] _ref_byte = (new String("0a")).getBytes();

	protected static Icon _actionIcon  = null;
	
   static {
	  _actionIcon      = SimIO.loadIcon( "update.gif" );
	}
	
	public  Action( Attributes atts ) throws XMLException {
	   super(atts,null);
	   String type = (String) _properties.get( "type" );
	   if( type != null ) {
		 if( type.equals("code") ) { _cmdType = 2; }
	   }
	}  

    public Action(String name, String data) {
	  super(name);
	  int cnt=0;
	  byte[] cmd_data = data.getBytes();
	  _cmdType = (byte) (cmd_data[cnt++] - _ref_byte[1]);
	  _depIndex = (byte) (cmd_data[cnt++] - _ref_byte[1]);
	  _exType = (byte) (cmd_data[cnt++] - _ref_byte[1]);
	  _status = (byte) (cmd_data[cnt++] - _ref_byte[1]);
	  _function = cmd_data[cnt++];
	  for( int i=0; i<8; i++ ) { _data[i] = (byte) (cmd_data[cnt++] - _ref_byte[1]); }
	  _code = data.substring(cnt);
	  _icon = _actionIcon;
    }

    public void addDependency( Variable v ) {
        if(_dependencies == null)
            _dependencies = new Vector(5, 5);
        _dependencies.addElement(v);
    }

    public void addPort( Port p ) {
        if(_ports == null) {  _ports = new Vector(5, 5); }
        _ports.addElement(p);
    }
    
    public Vector getPorts() {
	  return _ports;
    }

    public void addCode(String s) {
        _code = s;
    }
    
    public String getCode() {
	  String rv = _code;
	  if( rv == null ) { rv = (String)  getProperty( "code" );  }
	  return rv;
    }
    
	public String ID() { 
	  String rv = (String) _properties.get( "event" );
	  if( rv == null ) { rv = super.toString(); }
	  return rv;
	}
    
	public String toString() { 
	  String rv = (String) _properties.get( "event" );
	  if( rv == null ) { rv = super.toString(); }
	  switch( _cmdType ) {
		case 0: rv += " (Undefined) "; break;
		case 1: rv += " (Init) "; break;
		case 2: rv += " (Update) "; break;
		case 3: rv += " (Integrate) "; break;
		case 4: rv += " (Function) "; break;
		case 5: rv += " (Derivative) "; break;
	  }
	  return rv; 
	}
	
	public Icon getIcon() { 
	  return _icon; 
	}	

}
