package miiee.client;

import java.util.Vector;
import miiee.util.StringVector;
import miiee.xml.*;
import miiee.wizard.*;

//---- ConfigCommand ---------------------------------------------------------

public class ConfigCommand extends StringVector  {
	String _command;
	
	public ConfigCommand( String command ) {
	  super(16,16);
	  _command = command;
	}

	public ConfigCommand() { super(16,16); }
		

	public void setCommand( String cmd ) {
	  _command = cmd;
	}
	
	public String ID() { return _command; }
	
	public void clear() {  
	  _command = null;  
	  super.clear();  
	}

	public void clearArgs() {  
	  super.clear();  
	}
	  
	protected String getPrefix() { 
	  if( _command == null ) { 
		invalidate(); 
		return "("; 
	  }
	  return  _command + "(";
	}
	protected String getSuffix() { return ")"; }
		
	protected String getPreSeparator( int i ) { return " "; }
	protected String getPostSeparator( int i ) { return ( i < ( size()-1) ) ? "," : " "; }
	
	public boolean createWizard( XMLData config ) { 
	  try {	
		Wizard w = new Wizard( _command, config.toString() );
		w.setSaveData( false );
		WizardPanel wp = new  WizardPanel( "Init", "Configure:  " + config.toString(), (String) config.getProperty("doc") , w );
		for( int i=0; i<config.getDataCount(); i++ ) {
		  XMLData arg = (XMLData) config.getData(i);
		  System.out.println("Adding wizard panel: " + arg.toString() );
		  wp = new  WizardPanel( "WP" + i, "Input config data: " + arg.toString(), (String) arg.getProperty("doc") , w );
		  String opt = ( String ) arg.getProperty("required");
		  if( (opt != null) && ( opt.equals("false") ) ) {
			wp.addBooleanField(  "Enable?", "This checkbox enables this optional argument", false, "true" );
		  }
		  String type = (String) arg.getProperty("type");
		  String value = null;
		  try {
			value = (String) get(i);
		  } catch ( ArrayIndexOutOfBoundsException err ) {;}
		  if( value == null ) {
			value = (String) config.getProperty("default");
		  }
		  if( type.equals("int") ) {
			wp.addIntField(  "value", "Input Integer:", " ", false, value );
		  } else if ( type.equals("float") ) {
			wp.addFloatField( "value", "Input Float:", " ", false, value );
		  } else if ( type.equals("string") ) {
			wp.addStringField( "value", "Input String:", " ", false, value );
		  } else if ( type.equals("char") ) {
			wp.addStringField( "value", "Input char:", " ", false, value );
		  } else if ( type.equals("dir") ) {
			wp.addDirectoryField( "value", "Input Directory:", " ", true, value, null );
		  } else if ( type.equals("file") ) {
			wp.addFileField( "value", "Input File path:", " ", true, value, null );
		  } else {
			throw new XMLException("Unknown Field type in Configuration Wizard: " + type );
		  }
		}
		w.show( true );
		if( w.completed()  ) {
		  clearArgs();
		  for( int i=1; i<w.getDataCount(); i++ ) {
			wp = (WizardPanel) w.getData(i);
			Field f = (Field) wp.getField("value");
			if( f!= null ) {
			  String value = (String) f.getProperty( "value" );
			  if( value == null ) break;
			  addArg( value );
			}
		  }
		  return true;
		}
	  } catch ( XMLException err ) {
		err.show( null, "Unable to create Config Command Wizard." );
	  }
	  return false;
	}	
}
