package miiee.client;

import miiee.xml.*;
import miiee.mml.*;
import javax.swing.*;
import org.xml.sax.Attributes;
import java.util.Iterator;
import java.util.Vector;
import java.util.Map;
import java.util.Enumeration;

public class  ConfigurableObject extends MMLContainer  { 

  static StringBuffer _sbuf = new  StringBuffer();
  private boolean _config_data_current = false;
  private static boolean _debug = false;
  protected static ConfigurationHandler _configHandler;
  int _cmd_index = 0;
    
  public  ConfigurableObject( String name )  {
	 super(name);
	 init_configurations();
  }	

  public  ConfigurableObject( Attributes atts, XMLContainer parent ) throws XMLException {
	 super(atts,parent);
	 init_configurations();
  } 
  
  void	 init_configurations() {
	 if( _configHandler == null ) {
	   if( _debug ) { System.out.println("\n\n*************** Initializing Configurations **********************" ); }
	   _configHandler = new ConfigurationHandler();
	   _configHandler.readXML("sme");
	 }
  }
  
  public static XMLComponent getConfigurationCommand(int level) { 
	if( _configHandler.showTreeView(level,true) ) {
	  return _configHandler.getSelectedCommand();
	}
	return null;
  } 

  public static XMLComponent getConfigurationCommand( int level, XMLData config ) {
	return _configHandler.getCommand( level, config.ID() );
  } 


  public void invalidate_config_data() { _config_data_current = false; }
  
  public static ConfigurationHandler getConfigurationHandler() { return _configHandler; }
  
  public boolean getConfigurationData( SNPClient client, boolean recurse ) throws SNPException {
	if( _config_data_current ) return false;
	_config_data_current = true;
	int level = -1;
	String cdata = null;
	ConfigurableObject parent =  (ConfigurableObject) getParent();
	if( Variable.class.isInstance(this) ) {
		cdata = client.sme_var_config_info( parent.ID(), ID(), 'v' ); 
		level = ConfigurationHandler.kVariableL;	
	} else if ( Module.class.isInstance(this) ) {
		if ( parent == null ) {
		  cdata = client.sme_var_config_info( ID(), null, 'a' ); 
		  level = ConfigurationHandler.kModelL;	
		} else {
		  cdata = client.sme_var_config_info( ID(), null, 'm' ); 
		  level = ConfigurationHandler.kModuleL;	
		}
	} else return false;
	if( _debug ) { System.out.println("Querying server for config data: " + ID() + " data: " + cdata); }
	parseConfigString( cdata,  level );
	return true;
  }
  


 	public int  getQualifiedName( StringBuffer name ) {
	  name.setLength(0);
	  try { 
		Variable v = (Variable)this;
		name.append( v.getModule().ID() );
		name.append(".");
		name.append(v.ID());
		return ConfigurationHandler.kVariableL;
	  } catch( NullPointerException err ) { 
		return -1; 	  
	  } catch( ClassCastException err ) {
		try {
		  Module m = (Module)this;
		  if( m.getParent()==null  ) {
			 name.append( "SME" );
			 return ConfigurationHandler.kModelL;
		  } else {
			 name.append( m.ID() );
			 return ConfigurationHandler.kModuleL;
		  } 
		} catch( ClassCastException err1 ) {
		  JOptionPane.showMessageDialog( null, "Unexpected object type of Configurable Object: " + toString(), "Config error", JOptionPane.ERROR_MESSAGE );
		}
	  }
	  return -1;
	}

 	public int  getQualifiedName( String name[] ) {
	  try { 
		Variable v = (Variable)this;
		name[0] = v.getModule().ID();
		name[1] = v.ID();
		return ConfigurationHandler.kVariableL;
	  } catch( NullPointerException err ) { 
		return -1; 	  
	  } catch( ClassCastException err ) {
		try {
		  Module m = (Module)this;
		  if( m.getParent()==null  ) {
			 name[0] = "SME";
			 return ConfigurationHandler.kModelL;
		  } else {
			 name[0] = m.ID();
			 return ConfigurationHandler.kModuleL;
		  } 
		} catch( ClassCastException err1 ) {
		  JOptionPane.showMessageDialog( null, "Unexpected object type of Configurable Object: " + toString(), "Config error", JOptionPane.ERROR_MESSAGE );
		}
	  }
	  return -1;
	}
  
   public static String getBaseName( String name ) {
	  int index = name.indexOf('.');
	  return (index<0) ? name : name.substring(0,index);
   }
   
   public void  processConfigurations() {
	  Iterator iter = dataIterator();
	  while( iter.hasNext() ) {
		XMLData data = (XMLData)iter.next();
		try {
		  processConfiguration( (MMLConfigCommand) data );		
		} catch (Exception err ) {
		  if(_debug) { System.out.println("Can't process as config: " + data.ID() + " in " + ID() ); }
		}
	  } 
   }
   
   public void processConfiguration( MMLConfigCommand cc ) { 
	 _config_data_current = true;
   }
   
   public void setCurrentlyConfigured() { _config_data_current = true; }
   
   void addConfiguration ( int level, MMLConfigCommand cc ) throws XMLException {
	  String name = (String) cc.getProperty( "name" );
	  XMLComponent cdata = null;
	  if( name != null ) {
		cdata = _configHandler.getCommand(level,name);
		cc.addProperty( "config", cdata );
	  }
	  if(_debug) { System.out.println("Adding configuration " + name + ", cdata: " + cdata + " to " + ID() ); }
	  addData( cc ); 
   }
 
   void addConfiguration ( int level, ConfigCommand command ) throws XMLException {
   	  String name = command.ID();
	  MMLConfigCommand data = new MMLConfigCommand( name + Integer.toString( _cmd_index++ ) );
	  data.addProperty( "name", name );
	  data.addProperty( "command", command );
	  Enumeration args = command.elements();
	  int cnt = 0;
	  while( args.hasMoreElements() ) {
		String arg_value = (String) args.nextElement();
		String arg_id = "a" + Integer.toString(cnt++);
		data.addArg(arg_id, arg_value);
	  }
	  addConfiguration ( level, data );
   }   
  
  int parseConfigString( String s, int level )  throws SNPException {
	if( s == null ) return 0;
	clearData();
	int len = s.length();
	int state = 0, arg_index=0;
	MMLConfigCommand data = null;
	boolean isConfigData = false;
	ConfigCommand command = null;
	_sbuf.setLength(0);
	for ( int i=0; i<len; i++ ) {
	  char c = s.charAt(i);
	  if( !Character.isWhitespace(c) ) {
		if( c == '(' ) {
		  if( state != 1 ) { parse_error( i ); }
		  state = 2; arg_index=0;
		  String name = _sbuf.toString();
		  isConfigData = name.equals("cdata");
		  if( !isConfigData ) {
			data = new MMLConfigCommand( name + Integer.toString( _cmd_index++ ) );
			data.addProperty( "name", name );
			String bn = getBaseName( name );
			command = new ConfigCommand( bn );
			data.addProperty( "command", command );
		  }
		  _sbuf.setLength(0);
		} else if ( c == ')' ) {
		  if( state != 2 ) { parse_error( i ); }
		  state = 0;
		  if( _sbuf.length() > 0 ) { 
			if( isConfigData ) {
			  ((Variable)this).setVariableData( _sbuf.toString() );
			} else {
			  command.addArg( _sbuf.toString() );
			}
			_sbuf.setLength(0);
		  }
		  try {
			addConfiguration( level, data ); 
		  } catch ( XMLException err ) { 
			throw new SNPException( "Config data error ", err );
		  }
		} else if ( c == ',' ) {
		  if( (state != 2) || isConfigData ) { parse_error( i );  }
			String arg_value = _sbuf.toString();
			command.addArg( arg_value );
			String arg_id = "a" + Integer.toString( arg_index++ );
			try {
			  MMLConfigArg a = new MMLConfigArg( arg_id, arg_value );
			  data.addData( a ); 
			} catch ( XMLException err ) { 
			  throw new SNPException( "Config data error ", err );
			}
			_sbuf.setLength(0);
		} else {
		  _sbuf.append(c);
		  if( state == 0 ) { state = 1; }
		}
	  } 
	}
	return len;
  }
  
  public String getCommands() {
 	_sbuf.setLength(0); 	
 	Iterator iter = dataIterator();
	while( iter.hasNext() ) {
	  XMLData data = (XMLData)iter.next();
	  ConfigCommand cc = (ConfigCommand) data.getProperty( "command" );
	  if( cc != null ) {
		  _sbuf.append("  ");
		  _sbuf.append(cc.toString());
	  }
	}
 	return _sbuf.toString();
 }
  
  void parse_error( int pos ) throws SNPException {
	throw new SNPException( "Parse error in config string at position " + pos + " : " +  _sbuf.toString(), null );
  }
  
}
