package miiee.client;

import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import java.util.Vector;
import java.util.Random;
import java.util.Date;
import javax.swing.text.*;
import java.util.HashMap;
import java.awt.*;
import java.awt.font.TextAttribute;
import javax.swing.table.*;
import java.text.SimpleDateFormat;
import java.awt.Container;
import javax.swing.tree.*;
import miiee.util.*;
import miiee.mml.*;
import miiee.xml.*;
import miiee.tree.*;
import miiee.dataview.ParameterViewer;
import javax.swing.border.*;
import java.awt.event.*;
import javax.help.*;
import java.util.ListIterator;
import javax.swing.filechooser.*;

public class ConfigurationPanel extends JTabbedPane implements TableModelListener, ChangeListener {

    protected SMEInterface _sme_interface;
    VariableConfigPanel _configPanel;
     protected Vector	_parameter_map = new Vector();
     ParameterViewer _parameters;
     public final static boolean _debug = true;
   
	public final static int MODEL = 0;
	public final static int PARAMETERS = 1;
//	public final static int SPATIAL_DATA = 2;

	public ConfigurationPanel( SMEInterface intf ) {
	  super();
	  _sme_interface = intf;
	  _configPanel = new VariableConfigPanel(  _sme_interface, ((SMEClient)_sme_interface.getClient()).getTreeRoot() );
	  addPanels();
	  addChangeListener(this);  
	}
	
		
	public static ConfigurationPanel getPanel( SMEInterface intf  ) { 
	  ConfigurationPanel cp = new ConfigurationPanel(intf);
	  CSH.setHelpIDString(cp, "ConfigPanel" );
	  return cp;
	}
	
	public void setEditingEnabled( boolean enable ) {
	  _configPanel.setEditingEnabled( enable );
	}
	
	public  Variable getVariable(  String full_name ) { return 	_configPanel.getVariable( full_name ); }
	
	void addPanels() {	  
	  JPanel p;	
	  p = _configPanel.getPanel();
	  p.setName("Model");
	  add( p, MODEL );
	  
	  p = new JPanel( new BorderLayout(), false );
	  p.setName("Parameters");
	  add( p, PARAMETERS );
	  	 
//	  p = new JPanel( new BorderLayout(), false );
//	  p.setName("SpatialData");
//	  add( p, SPATIAL_DATA );
	}	  	 
	
	public void stateChanged( ChangeEvent ev ) { refresh(); }
	
	public void refresh() {
	  int index = getSelectedIndex();
	  if( _debug ) {
		System.out.println( "\n\n\n ############ Refresh Configuration Panel " + index );
	  }
	  switch(index) {
		case MODEL: { _configPanel.refresh(); }  break;
		case PARAMETERS: create_parameter_panel(); break;
//		case SPATIAL_DATA: break;
	  } 
	}

	public void create_parameter_panel() { 
	  if( _debug ) {
		System.out.println( "\n\n\n ######### Creating parameter table #### \n\n" );
	  }
	  if( _parameters == null ) {
		DataSet parm_data = _configPanel.getParameters( _parameter_map );
		_parameters = new  ParameterViewer( parm_data, 2 );
		_parameters.setColumnWidths(400,200);
		_parameters.setColumnHeaders( "Parameter",  "Value" );
		_parameters.init();
		JPanel cp = (JPanel) getComponentAt(PARAMETERS);
		
		JPanel   parmPanel = new JPanel(false);
		BoxLayout bl = new BoxLayout(parmPanel, BoxLayout.X_AXIS ); parmPanel.setLayout( bl ); 	 
		parmPanel.setPreferredSize(new Dimension(Short.MAX_VALUE,  Short.MAX_VALUE)); 
		cp.add(parmPanel, BorderLayout.CENTER );
		parmPanel.add(_parameters); 
		_parameters.setAlignmentX( Component.CENTER_ALIGNMENT );
		_parameters.addTableModelListener(this);
	  }
	}
	    
   public void tableChanged(TableModelEvent e) {
	 try {
	   int row = e.getFirstRow();
	   TableModel tm = (TableModel) e.getSource();
	   FormattedFloat ff = (FormattedFloat) tm.getValueAt( row, 1 );
	   Variable v = (Variable) _parameter_map.get(row);
	   float fval = ff.floatValue();
	   _sme_interface.getClient().sme_set_scalar( v.getModule().toString(), v.toString(), fval ); 
	   v.setValue(fval);
	   System.out.println("\nSMEClient.set_scalar: " + v.getModule().toString() + "." + v.toString() + " = " + ff );
	 } catch ( SNPException err ) {
	   SimIO.print("Error setting value: " + err );
	 }
   }
	
}
