package miiee.client;

import miiee.xml.*;
import miiee.util.*;
import miiee.mml.Port;
import miiee.mml.Data;
import miiee.mml.Link;
import miiee.mml.MMLContainer;
import miiee.mml.MMLConfigCommand;
import miiee.mml.MMLConfigArg;
import miiee.mml.MMLContainer;
import miiee.mml.ConfigurationHandler;
import org.xml.sax.*;
import java.util.Vector;
import java.io.*;


public class MMLHandler extends XMLHandler {

  public static final int MODEL_DECLARATION = 0;
  public static final int MODEL_CONFIGURATION = 1;

  ModelObjectTree _modelTree;
  Module _current_module = null;
  Variable _current_variable = null;
  MMLConfigCommand _current_config = null;
  Vector _ports = new Vector();
  Vector _variables = new Vector();
  private boolean _debug = false;
  private int _mode = MODEL_DECLARATION;
  private int _config_level = ConfigurationHandler.kModelL;	
  	 
  public MMLHandler( ModelObjectTree tree, int mode ) { 
	super(); 
	_mode = mode;	 
	if( tree != null ) { 
	  _modelTree = tree;  
	  _tree_root =  tree.getRoot(); 
	}
  }
  			   
  public XMLComponent getComponentFromName( String name, Attributes atts, XMLComponent parent, boolean create ) {
	if( _debug ) System.out.println("xx-getComponentFromName: " + name + ", parent: " + parent );
	try {
	  if( name.equals("compound") ) { 
		_config_level = ConfigurationHandler.kModuleL;	
		switch( _mode ) {
		  case MODEL_DECLARATION:
			Module m = new Module(atts);
			_current_module = _modelTree.addModule(m);
			_current_module.unresolve(); 
		  break;
		  case MODEL_CONFIGURATION:
			String mid = atts.getValue("id");
			_current_module = _modelTree.getModule(mid);
			_current_module.waitUntilResolved();
			if( _debug ) System.out.println("Processing model configuration: " + mid );
			_current_module.importAttributes( atts, false );
			_current_module.unconfigure(); 
		  break;
		}
		_current_module.setMMLHandler(this);
		return _current_module; 
	  }
	  if( name.equals("atom") )  { 
		Module mod = (Module)parent;
		_config_level = ConfigurationHandler.kVariableL;	
		switch( _mode ) {
		  case MODEL_DECLARATION: {
			_current_variable = createVariable( atts, mod ); 
			_current_variable.unresolve(); 
		  } break;
		  case MODEL_CONFIGURATION: {
			String vid = atts.getValue("id");
			_current_variable = (Variable) _modelTree.getVariable(mod,vid);
			if( _debug ) System.out.println("Processing variable configuration: " + vid );
			if( _current_variable == null ) {
			  if( _debug ) { System.out.println( "Unknown Variable " + vid + " in module: " + mod.ID() ); }
			  _current_variable = createVariable( atts, mod ); 
			} else {
			  _current_variable.importAttributes( atts, false );
			}
		  } break;
		}
		_current_variable.setCurrentlyConfigured();
		return _current_variable; 
	  }
	  if( name.equals("dynamic") )  { 
		Action a = new Action(atts); 
		_modelTree.addAction((XMLContainer)parent,a,false);
		for( int i=0; i<_ports.size(); i++ ) {
			Port p = (Port) _ports.get(i);
			a.addPort(p);
		}
		_ports.clear();
		return a; 
	  }

	  if( name.equals("config") )  { 
		ConfigurableObject co = (ConfigurableObject)parent;
		int index = co.getDataCount();
		String id = "c" + Integer.toString(index);
		_current_config = new MMLConfigCommand( id, atts ); 
		co.addConfiguration ( _config_level, _current_config );
		return _current_config;
	  }

	  if( name.equals("arg") )  { 
		int index = parent.getDataCount();
		String id = "a" + Integer.toString(index);
		MMLConfigArg arg = new MMLConfigArg( id, atts ); 
		parent.addData(arg);
		if( _debug ) { 
		  System.out.println( "Adding arg " + id + " to config-cmd " + parent.ID() + " for object " + parent.getParent().ID() ); 
		}
		return arg;
	  }
	  	  
	  if( name.equals("link") )  {
		Link link = new Link(atts); 
		if( parent != null ) { 
		  ((MMLContainer)parent).addLink(link); 
		  if( _debug ) { System.out.println( "Adding link in getComponentFromName: " + link.ID() + ", parent: " + parent.ID() ); }
		}
		return link;
	  }
	  
	  if( name.equals("port") )  {
		Port p = new Port( atts ); 
		if( parent != null ) { 
		  ((MMLContainer)parent).addPort(p); 
		  _ports.add(p);
		  if( _debug ) { System.out.println( "Adding port in getComponentFromName: " + p.ID() + ", parent: " + parent.ID() ); }
		}
		return p;
	  }
	  
	  if( name.equals("lut") || name.equals("array") )  {
		Data d = new Data(atts,name); 
		if( parent != null ) { parent.addData(d); }
		return d;
	  }
	} catch ( XMLException err ) {
	  System.out.print(err);
	  return _current_Component;
	}
	
	return null;
  }

  public void endDocument() throws SAXException { 
	  super.endDocument();
  }

  public void endElement( String namespaceURI, String local_name, String name )  throws SAXException {
	if( _debug ) { System.out.println("endElement: " + name + ", local_name: " + local_name ); }
	super.endElement( namespaceURI, local_name, name );
	if( name.equals("config") ) { 
	  _current_config = null;
	}
	else if( name.equals("atom") ) { 
	  _current_variable.processConfigurations();
	  _current_variable = null;
	  _config_level = ConfigurationHandler.kModuleL;	
	}
	else if( name.equals("compound") ) { 
	  _current_module = null;
	  _config_level = ConfigurationHandler.kModelL;	
	}
  }  
/* 
  public void addDependencies( Action a ) {
	 for( int i=0; i<_dependencies.size(); i++ ) {
		Port p = (Port) _dependencies.get(i);
		String dep_name = p.ID();
		if( dep_name.endsWith( "_Dep" ) ) {
		  dep_name = dep_name.substring(0, dep_name.length()-4 );
		}
		if( _debug ) System.out.println("\t\tD: " + dep_name);
		XMLContainer vn = (XMLContainer) _modelTree.getVariable(  _current_module, dep_name );
		if( vn != null ) {
		  Variable dv = (Variable)vn;
		  _modelTree.addDependency( a, dv, false );
		} else {
		  System.out.println( "Unknown Variable dependency: " + dep_name ); 
		}
	 }
	 _dependencies.clear();
   }
*/	

 Variable createVariable( Attributes atts, Module mod ) throws XMLException {
	  Variable v =  new Variable(atts,mod); 
	  Port p = new Port( "out", Port.kOutput ); 
	  v.addPort( p );	
	  _modelTree.addVariable(mod,v);
	  _variables.add(v);
	  try {
		Port p0 = mod.getLocalPort( v.ID(), Port.kOutput );
		if( p0 != null ) {
		  Link link = new Link(p,p0);
		  mod.addLink(link);
		  if( _debug ) { System.out.println( "Adding link in getComponentFromName: " + link.ID() + ", module: " + mod.ID() ); }
		} else {
		  if( _debug ) { System.out.println( "Can't find output port " + v.ID() + " in module: " + mod.ID() ); }
		}
	  } catch ( XMLException err ) {;}
	  return v;
  }

  public void processDependencies() {  
	Port p = null;
	if( _debug ) { System.out.println("ProcessDependencies: Processing " + Integer.toString(_variables.size()) + " dependencies " ); }
	for( int i=0; i<_variables.size(); i++ ) {
	  Variable v = (Variable) _variables.get(i);
	  for( int j=0; j<v.getChildCount(); j++ ) {
		XMLContainer n = (XMLContainer) v.getChild(j);
		try {
		  Action a = (Action) n;
		  Vector ports = a.getPorts();
		  if( ports != null ) {
			for( int k=0; k<ports.size(); k++ ) {
			  p = (Port) ports.get(k);
			  if( p.getMode() == Port.kInput ) {
				if( _debug ) { 
				  XMLComponent pc = v.getParent();
				  System.out.println("ProcDep, var: " + pc + "." + v.ID() + ", Action: " + n.ID() + ", Port: " + p ); 
				}
				Port cp = null;
				try {
				  cp = p.getRemoteSourcePort();
				  if( cp != null ) {
					Variable dv = (Variable) cp.getParent();
					Dependency d = (Dependency) _modelTree.addDependency( a, dv, false );
					if( _debug ) { 
					  System.out.println("Add Dependency: " + d.ID() ); 
					}
				  } else {
					if( _debug ) {   System.out.println("Unconnected port" );  }
				  }
				} catch ( ClassCastException err1 ) { 
				  if( _debug ) { System.out.println( "ClassCastException in getConnectedPort: Expected Variable, found " + cp.getParent().ID() ); }
				}
			  }
			}
		  }
		} catch ( ClassCastException err ) { 
		  if( _debug ) { System.out.println("ClassCastException, var: " + v.ID() + ", Action: " + n.ID() + ", Port: " + p ); }
		}
	  }
	}
  }	
  
  class ProcessDependenciesAction extends QueuedExecutable  {
	XMLParser _parser;
	ProcessDependenciesAction( XMLParser p ) { _parser = p; }
	public void execute() {
	  _parser.waitUntilParseCompleted(); 
	  processDependencies();
	}
  } 
  
  public void runProcessDependencies(XMLParser p) {
	ProcessDependenciesAction pda = new ProcessDependenciesAction(p);
	pda.actionPerformed(null);
  }

  public static boolean loadResource( String resource, ModelObjectTree mt, int mode ) { 
	  MMLHandler handler = new MMLHandler(mt,mode);	  
	  System.out.println(" Processing object tree from resource: " + resource );
	  XMLParser p;
	  try {
		p = XMLParser.getParser( null, handler );
	  } catch ( XMLException err ) {
		System.out.println( err.getMessage() );
		return false;
	  }
	  boolean rv = p.parse( null, null, resource );
	  
	  if( rv && (mode == MODEL_DECLARATION) ) { 
		handler.runProcessDependencies(p);
	  }
	  return rv;
	}

  public static boolean loadStringResource( String xml_data, ModelObjectTree mt, int mode ) { 
	  MMLHandler handler = new MMLHandler(mt,mode);	  
	  XMLParser p;
	  try {
		p = XMLParser.getParser( null, handler );
		p.parseString( xml_data );
	  } catch ( XMLException err ) {
		System.out.println( err.getMessage() );
		return false;
	  }	  
	  if( mode == MODEL_DECLARATION ) { 
		handler.runProcessDependencies(p);
	  }
	  return true;
	}      
}
