package miiee.client;

import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import java.util.Vector;
import javax.swing.text.*;
import java.util.HashMap;
import java.awt.*;
import javax.swing.table.*;
import java.awt.Container;
import javax.swing.tree.*;
import miiee.util.*;
import miiee.mml.*;
import miiee.xml.*;
import miiee.xml.XMLContainer;
import miiee.tree.*;
import javax.swing.border.*;
import java.awt.event.*;
import java.util.ListIterator;

public class ModelObjectTree {

	protected JTreeTable _simtree;
    protected AbstractTreeTableModel _treeModel;
  	protected Module  _top_simnode;
    private Toolkit _toolkit = Toolkit.getDefaultToolkit();
    private int _data_col_width = 20; 
    
	public ModelObjectTree( AbstractTreeTableModel treeModel ) {
	  _treeModel = treeModel;
	  _top_simnode = (Module) treeModel.getRoot();
	  _simtree = new JTreeTable(_treeModel);
	  _simtree.getTree().setCellRenderer( new ModelObjectTreeCellRenderer() ); 
	  _simtree.getTree().getSelectionModel().setSelectionMode( TreeSelectionModel.SINGLE_TREE_SELECTION );
	  _simtree.setSelectionMode( ListSelectionModel.SINGLE_SELECTION );
	  _simtree.setCellSelectionEnabled( true );
	  formatColumns();	
	}
	
	public Module getRoot() { return _top_simnode; }
	
	public void refresh() {
	  _treeModel.reload();
	  getTree().expandPath( getPath( _top_simnode ) );
	}
	
	public void setDataColWidth( int width ) { _data_col_width = width; }
		
   	public void formatColumns() {
//		_simtree.setCellSelectionEnabled(true);
		_simtree.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		TableColumnModel cm = _simtree.getColumnModel();
        DefaultTableCellRenderer dataColumnRenderer = new DefaultTableCellRenderer() {
			public void setValue(Object value) {
			  if( value != null ) {
				try {
				  setIcon( (Icon)value ); 
				  setText( null );  
//				  setBackground(  Color.white  );
				} catch ( java.lang.ClassCastException err ) {
				  setText( value.toString() ); 
				  setIcon( null ); 
//				  setBackground( Color.white ); 
				}				  
			  } else {
				setText( null ); 
				setIcon( null ); 
//				setBackground( Color.lightGray ); 
			  }
			}
        };
        dataColumnRenderer.setHorizontalAlignment(JLabel.CENTER);
		for( int columnIndex = 0; columnIndex < _treeModel.getColumnCount(); columnIndex++ ) {
		  TableColumn tableColumn =  cm.getColumn(columnIndex);
		  if( columnIndex == 0 ) {
			tableColumn.setMinWidth(300);
		  } else {
			tableColumn.setCellRenderer(dataColumnRenderer); 
			tableColumn.setMinWidth( _data_col_width );
			tableColumn.setMaxWidth( _data_col_width );
		  }
		}
    } 
	
	public JTree getTree() { return _simtree.getTree(); }
	public JTreeTable getTreeTable() { return _simtree; }
	public void addTreeSelectionListener( TreeSelectionListener tsl ) { 
	  _simtree.getTree().addTreeSelectionListener( tsl ); 
	}
	
	public void addTreeExpansionListener( TreeExpansionListener tsl ) { 
	  _simtree.getTree().addTreeExpansionListener( tsl ); 
	}
	
    public void clear() {
        _top_simnode.removeChildren();
        _treeModel.reload();
    }
    
    public static TreePath getPath( XMLContainer tn ) {
	   return new TreePath(((XMLContainer)tn).getPath());
    }
    
    public TreePath getSelectionPath() {
	  int row = _simtree.getSelectedRow();
	  return getTree().getPathForRow(row);
	}
	
    public float selectNextVariableContaining( String name ) {
	  XMLContainer module_node = null, var_node = null;
	  TreePath tp = getSelectionPath();
	  int found_row = -1;
	  try {
		XMLContainer tn = (XMLContainer) tp.getLastPathComponent();
//		Class tnc = tn.getClass();
		if( Variable.class.isInstance(tn) ) {
			var_node = tn;    			               module_node = (XMLContainer) tn.getParent(); 		
		} else if ( Module.class.isInstance(tn) ) {
			var_node = null;  			               module_node = tn;     
		} else if ( Action.class.isInstance(tn) ) {
			var_node = (XMLContainer) tn.getParent();  module_node = (XMLContainer) var_node.getParent(); 
		} 
	  }
	  catch( java.lang.ClassCastException err ) {;}
	  catch( NullPointerException err ) {;}
	  
	  Module top = _top_simnode;
	  int mstart = ( module_node != null ) ? top.getChildIndex(module_node) : 0;		
	  XMLContainer found_var_node = null;
	  for( int i=mstart; i<top.getChildCount(); i++ ) {
		module_node = (XMLContainer) top.getChild(i);
		found_var_node = getNextVariableContaining(  module_node, var_node, name );
		if( found_var_node != null ) break;
		var_node = null;
	  }
	  if( found_var_node != null ) {
		TreePath new_selection = getPath( found_var_node );
		getTree().expandPath(new_selection);
		found_row = getTree().getRowForPath(new_selection); 
		_simtree.setRowSelectionInterval(found_row, found_row);
		getTree().setSelectionPath(new_selection);
	  } else {
		SimIO.beep();
	  }
	  return ((float)found_row)/(_simtree.getRowCount());
    }
    
	public Module addModule( Module m ) {
		_treeModel.addChild( _top_simnode, m ); 
		getTree().expandPath( getPath( _top_simnode ) );
		return m;
	}


	public void addDependencies( SNPClient client, Module m, Variable v ) {
		boolean debug = false;
		if( v.nActions() > 0 ) {
		  expand(v);
		  return;
		}
		try { 
		  Vector listBuffer = new Vector(16,16);
		  Vector actionList = new Vector(16,16);
		  client.sme_var_actions ( v._module.ID(), v.ID(),  actionList );
		  if( debug ) System.out.println("\nGot Actions and Dependencies: ");
		  for( int i=0; i < actionList.size(); i++ ) {
			String action_name = (String) actionList.elementAt(i);
			if( debug ) System.out.println("Action: " + action_name );
			String action_data = client.sme_var_actioninfo ( v._module.ID(), v.ID(),  action_name );
			if( action_data == null ) { System.out.println( "Unknown Action:" + action_name );  }
			else {
			  Action a = new Action(action_name,action_data);
			  XMLContainer act_node = addAction( v, a, true );
			  listBuffer.setSize(0);
			  client.sme_var_dependencies ( v._module.ID(), v.ID(), action_name, listBuffer );
			  if( debug ) System.out.println("\nGot dep: ");
			  for( int j=0; j < listBuffer.size(); j++ ) {
				String dep_name = (String) listBuffer.elementAt(j);
				if( dep_name.endsWith( "_Dep" ) ) {
				  dep_name = dep_name.substring(0, dep_name.length()-4 );
				}
				if( debug ) System.out.println("\t\tD: " + dep_name);
				XMLContainer vn = (XMLContainer) getVariable(  m, dep_name );
				if( vn != null ) {
				  Variable dv = (Variable)vn;
				  if( dv.isImport() ) {
/*
					try {
					  Port p0 = ((MMLContainer)mn).getLocalPort( dv.ID(), Port.kInput );
					  Port p1 = p0.getConnectedPort( 0  );		  
					  dv = (Variable) p1.getParent();		
					} catch ( Exception any ) {
					  System.out.println( "Error making connection for " + dv.ID() + " : " + any.getMessage() ); 
					  any.printStackTrace();
					  return;					
					} 
*/
					return;
				  } 
				  addDependency( act_node, dv );
				} else {
				  System.out.println( "Unknown Variable dependency: " + dep_name ); 
				}
			  }
			}
		  }
		} 
		catch ( SNPException err ) { System.out.println( err ); }
		catch ( NullPointerException err ) { System.out.println( "No known Variable selected" );  }
	}	
		
	public  XMLContainer addVariable(  XMLContainer module_node, Variable v ) {		
		_treeModel.addChild( module_node, v ); 
		return v;
   }

   public  XMLContainer addAction( XMLContainer var_node, Action a, boolean visible ) {
	   _treeModel.addChild( var_node, a ); 
	   if( visible ) {
		 getTree().expandPath( getPath( var_node ) );
		 getTree().scrollPathToVisible( getPath( var_node ) );
	   }
       return a;
   }

	public  XMLContainer getVariable(  XMLContainer module_node, String var_name ) {
	  for( int i=0; i<module_node.getChildCount(); i++ ) {
		XMLContainer n = (XMLContainer) module_node.getChild(i);
		try {
		  Variable v = (Variable) n;
		  if( var_name.equals( v.ID() ) ) return (Variable) n; 
		} catch ( ClassCastException err ) { ; }
	  }
       return null;
   }

	public  XMLContainer getNextVariableContaining(  XMLContainer module_node, XMLContainer var_node, String var_name ) {
	  int start = ( var_node != null ) ? module_node.getChildIndex(var_node) : 0;
	  if( start >= 0 ) {
		for( int i=start+1; i<module_node.getChildCount(); i++ ) {
		  XMLContainer n = (XMLContainer) module_node.getChild(i);
		  try {
			Variable v = (Variable) n;
			if( v.ID().indexOf( var_name ) >= 0 ) return n; 
		  } catch ( ClassCastException err ) { ; }
		}
	  }
	  return null;
   }

	public  Module getModule( String mod_name ) {
	  Module top_node = (Module) _top_simnode;
	  for( int i=0; i<top_node.getChildCount(); i++ ) {
		XMLContainer n = (XMLContainer)top_node.getChild(i);
		try {
		  Module m = (Module) n;
		  if( mod_name.equals( m.ID() ) ) return (Module) n; 
		} catch ( ClassCastException err ) { ; }
	  }
       return null;
   }
   
   public  DataSet getParameters( HashMap map, SNPClient client  ) {
   	  ProgressDialog pd = new ProgressDialog("Downloading Configuration data");
	  pd.show( false );
	  SimIO.print("Getting parameter data ");
	  DataSet parm_data = new DataSet( 1, 1, 1, (byte)0, "Parameters", null, null, (byte)0, (byte)0 );
	  Module top_node = _top_simnode;
	  short[] sdata = new short[1];  sdata[0] = (short)(256*256-1);
	  for( int i=0; i<top_node.getChildCount(); i++ ) {
		XMLContainer module_node = (XMLContainer)top_node.getChild(i);
		if( !pd.isShowing() ) { break; }
		else { pd.setValue( ((float)i)/top_node.getChildCount() ); }
		for( int j=0; j<module_node.getChildCount(); j++ ) {
		  XMLContainer n = (XMLContainer) module_node.getChild(j);
		  String name =  "** Module " + module_node + " ** ";
		  DataEntry de = new DataEntry( sdata, name, Float.NaN, 0f, 0f );
		  parm_data.addElement(de);
		  try {
			Variable v = (Variable) n;
			try {
			  v.getConfigurationData( client, false );
			} catch ( SNPException err ) {
			   SimIO.print("Error getting parameter data: " + err );
			}
			if( (v._initMode == Variable.PARAMETER) && !v.isImport() && !v.isSpatial() ) {
			  float value = v.Value();
			  de = new 	DataEntry( sdata, v.ID(), value, 0f, 0f );
			  parm_data.addElement(de);
			  if( map != null ) { map.put(de,v);}  
			} 
		  } catch ( ClassCastException err ) { ; }
		}
	  }
	  pd.finalize();
	  return parm_data;
   }
   
   public  void expand( XMLContainer node ) {
	   TreePath tp = getPath( node );
	   getTree().expandPath( tp );
	   getTree().scrollPathToVisible( tp );
   }

	public  XMLContainer addDependency( XMLContainer act_node, Variable v ) {
	  return addDependency( act_node, v, true );
	}
   
	public  XMLContainer addDependency( XMLContainer act_node, Variable v, boolean visible ) {
	   Dependency dep = new Dependency(v);
	   _treeModel.addChild( act_node, dep, false ); 
	   if( visible ) {
		 getTree().expandPath( getPath( dep ) );
		 getTree().scrollPathToVisible( getPath( dep ) );
	   }
       return dep;
   }

}

class ModelObjectTreeCellRenderer extends DefaultTreeCellRenderer  {

	public ModelObjectTreeCellRenderer() { 
	  super(); 
	}
	
	void setDefaultIcon( boolean leaf, boolean expanded ) {
		if (leaf) {
			setIcon(getLeafIcon());
		} else if (expanded) {
			setIcon(getOpenIcon());
		} else {
			setIcon(getClosedIcon());
		}
	}
	
    public Component getTreeCellRendererComponent(JTree tree, Object value,
						  boolean sel,
						  boolean expanded,
						  boolean leaf, int row,
						  boolean hasFocus) {

	  String         stringValue = tree.convertValueToText(value, sel,
						expanded, leaf, row, hasFocus);
	  setText(stringValue);
	  if(sel)
		  setForeground(getTextSelectionColor());
	  else
		  setForeground(getTextNonSelectionColor());
		
	  try {   
		XMLContainer sim_obj = (XMLContainer) value;
		setIcon( sim_obj.getIcon() );
	  } catch ( ClassCastException err ) {
		setDefaultIcon( leaf, expanded );
	  }
	  selected = sel;
	  
	  return this;
    }
}

