package miiee.client;

import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import java.util.Vector;
import javax.swing.text.*;
import java.util.HashMap;
import java.awt.*;
import javax.swing.table.*;
import java.awt.Container;
import javax.swing.tree.*;
import miiee.util.*;
import miiee.mml.*;
import miiee.xml.*;
import miiee.xml.XMLContainer;
import miiee.tree.*;
import javax.swing.border.*;
import java.awt.event.*;
import java.util.ListIterator;

public class ModelTree {

	protected XMLTree _simtree;
    protected XMLTreeModel _treeModel;
  	protected Module  _top_simnode;
    private Toolkit _toolkit = Toolkit.getDefaultToolkit();
    
	public ModelTree(Module root) {
//	  try {
//		UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
//	  } catch( java.lang.IllegalAccessException err ) {;}
	  _simtree = new XMLTree(root,XMLTree.kHasDataTree );
	  _treeModel = (XMLTreeModel) _simtree.getModel();
	  _top_simnode = (Module) _treeModel.getRoot();
	  _simtree.getSelectionModel().setSelectionMode( TreeSelectionModel.SINGLE_TREE_SELECTION );	
	  _simtree.putClientProperty( "JTree.lineStyle", "Horizontal" ); 
 

	}
		 
	public void refresh() {
	  _treeModel.reload();
	  getTree().expandPath( getPath( _top_simnode ) );
	  System.out.println( "Expanding Path: " + _top_simnode );
	}
	
	public XMLTree getTree() { return _simtree; }
	public void addTreeSelectionListener( TreeSelectionListener tsl ) { 
	  _simtree.addTreeSelectionListener( tsl ); 
	}
	
    public void clear() {
        _top_simnode.removeChildren();
        _treeModel.reload();
    }
    
    public static TreePath getPath( XMLContainer tn ) {
	   return new TreePath(((XMLContainer)tn).getPath());
    }
    
    public TreePath getSelectionPath() {
	  return getTree().getSelectionPath();
	}
	
    public float selectNextVariableContaining( String name ) {
	  XMLContainer module_node = null, var_node = null;
	  TreePath tp = getSelectionPath();
	  int found_row = -1;
	  try {
		XMLContainer tn = (XMLContainer) tp.getLastPathComponent();
//		Class tnc = tn.getClass();
		if( Variable.class.isInstance(tn) ) {
			var_node = tn;    			               module_node = (XMLContainer) tn.getParent(); 		
		} else if ( Module.class.isInstance(tn) ) {
			var_node = null;  			               module_node = tn;     
		} else if ( Action.class.isInstance(tn) ) {
			var_node = (XMLContainer) tn.getParent();  module_node = (XMLContainer) var_node.getParent(); 
		} 
	  }
	  catch( java.lang.ClassCastException err ) {;}
	  catch( NullPointerException err ) {;}
	  
	  Module top = _top_simnode;
	  int mstart = ( module_node != null ) ? top.getChildIndex(module_node) : 0;		
	  XMLContainer found_var_node = null;
	  for( int i=mstart; i<top.getChildCount(); i++ ) {
		module_node = (XMLContainer) top.getChild(i);
		found_var_node = getNextVariableContaining(  module_node, var_node, name );
		if( found_var_node != null ) break;
		var_node = null;
	  }
	  if( found_var_node != null ) {
		TreePath new_selection = getPath( found_var_node );
		getTree().expandPath(new_selection);
		getTree().setSelectionPath(new_selection);
	  } else {
		SimIO.beep();
	  }
	  return ((float)found_row)/(_simtree.getRowCount());
    }
    
	public XMLContainer addModule( Module m ) {
		_treeModel.addChild( _top_simnode, m ); 
		getTree().expandPath( getPath( _top_simnode ) );
       return m;
	}

		
	public  XMLContainer addVariable(  XMLContainer module_node, Variable v ) {
		_treeModel.addChild( module_node, v ); 
	   getTree().expandPath( getPath( module_node ) );
       return v;
   }

   public  XMLContainer addAction( XMLContainer var_node, Action a ) {
	   _treeModel.addChild( var_node, a ); 
	   getTree().expandPath( getPath( var_node ) );
	   getTree().scrollPathToVisible( getPath( var_node ) );
       return a;
   }
   

	public  Variable getVariable(  String full_name ) {
	  String full_name1 = full_name.replace(':','.');
	  int index = full_name1.indexOf('.');
	  String mod_name = full_name1.substring(0,index);
	  String var_name = full_name1.substring(index+1);
	  XMLContainer module_node = getModule( mod_name );
	  return getVariable(  module_node, var_name );
   }

	public  Variable getVariable(  String mod_name, String var_name ) {
	  XMLContainer module_node = getModule( mod_name );
	  return getVariable(  module_node, var_name );
   }

	public  Variable getVariable(  XMLContainer module_node, String var_name ) {
	  if( module_node == null ) return null;
	  for( int i=0; i<module_node.getChildCount(); i++ ) {
		XMLContainer n = (XMLContainer) module_node.getChild(i);
		try {
		  Variable v = (Variable) n;
		  if( var_name.equals( v.ID() ) ) return (Variable) n; 
		} catch ( ClassCastException err ) { ; }
	  }
       return null;
   }

	public  XMLContainer getNextVariableContaining(  XMLContainer module_node, XMLContainer var_node, String var_name ) {
	  int start = ( var_node != null ) ? module_node.getChildIndex(var_node) : 0;
	  if( start >= 0 ) {
		for( int i=start+1; i<module_node.getChildCount(); i++ ) {
		  XMLContainer n = (XMLContainer) module_node.getChild(i);
		  try {
			Variable v = (Variable) n;
			if( v.ID().indexOf( var_name ) >= 0 ) return n; 
		  } catch ( ClassCastException err ) { ; }
		}
	  }
	  return null;
   }
   
   public XMLContainer getRoot() { return _top_simnode; }

	public  XMLContainer getModule( String mod_name ) {
	  Module top_node = (Module) _top_simnode;
	  for( int i=0; i<top_node.getChildCount(); i++ ) {
		XMLContainer n = (XMLContainer)top_node.getChild(i);
		try {
		  Module m = (Module) n;
		  if( mod_name.equals( m.ID() ) ) return n; 
		} catch ( ClassCastException err ) { ; }
	  }
       return null;
   }

   public  DataSet getParameters( Object map, SNPClient client ) {
	  DataSet parm_data = new DataSet( 1, 1, 1, (byte)0, "Parameters", null, null, (byte)0, (byte)0 );
	  Module top_node = _top_simnode;
//   	  ProgressDialog pd = new ProgressDialog("Downloading Configuration data");
//	  pd.show( false );
	  short[] sdata = new short[1];  sdata[0] = (short)(256*256-1);
	  int row = 0;
	  for( int i=0; i<top_node.getChildCount(); i++ ) {
//		if( !pd.isShowing() ) { break; }
//		else { pd.setValue( ((float)i)/top_node.getChildCount() ); }
		XMLContainer module_node = (XMLContainer)top_node.getChild(i);
		String name =  "** Module " + module_node + " ** ";
		DataEntry de = new DataEntry( sdata, name, Float.NaN, 0f, 0f );
		parm_data.addElement(de); row++;
		for( int j=0; j<module_node.getChildCount(); j++ ) {
		  XMLContainer n = (XMLContainer) module_node.getChild(j);
		  try {
			Variable v = (Variable) n;
			try {
			  v.getConfigurationData( client, false );
			} catch ( SNPException err ) {
			   SimIO.print("Error getting parameter data: " + err );
			}
			if( (v._initMode == Variable.PARAMETER) && !v.isImport() && !v.isSpatial() ) {
			  float value = v.Value();
			  de = new 	DataEntry( sdata, v.ID(), value, 0f, 0f );
			  parm_data.addElement(de); row++;
			  if( map != null ) { 
				try {
				  ((HashMap)map).put(de,v);
				} catch ( ClassCastException err ) {
				  Vector vmap = (Vector)map;
				  if( row >= vmap.size() ) { vmap.setSize(row + 16); }
				  vmap.add(row-1,v);
				}
			  }  
			} 
		  } catch ( ClassCastException err ) { ; }
		}
	  }
//	  pd.finalize();
	  return parm_data;
   }
   
   public  void expand( XMLContainer node ) {
	   TreePath tp = getPath( node );
	   getTree().expandPath( tp );
	   getTree().scrollPathToVisible( tp );
   }
   
	public  XMLContainer addDependency( XMLContainer act_node, Variable v ) {
	   _treeModel.addChild( act_node, v ); 
	   getTree().expandPath( getPath( v ) );
	   getTree().scrollPathToVisible( getPath( v ) );
       return act_node;
   }
   
   	public static void main(String args[])  {
	  
	  Module root = new Module("root");
	  ModelTree tree = new ModelTree(root);	
	  
	  Module m = new Module("module1");
	  tree.addModule(m);
	  
	  Variable v1 = new Variable("var1",m);
	  tree.addVariable(m,v1);
	  Variable v2 = new Variable("var2",m);
	  tree.addVariable(m,v2);
	  Variable v3 = new Variable("var3",m);
	  tree.addVariable(m,v3);
	  
	  XMLData d1 = new XMLData("d1");
	  XMLData d2 = new XMLData("d2");
	  XMLData d3 = new XMLData("d3");
	  try {
		v2.addData(d1);
		v2.addData(d2);
		v3.addData(d3);
	  } catch ( XMLException err ) { ; }
	  
	  EmptyBorder eb7 = new EmptyBorder( 7, 7, 7, 7 );	
	  EmptyBorder eb3 = new EmptyBorder( 3, 3, 3, 3 );
	  BoxLayout bl;	

	  JPanel main_panel = new JPanel(true);
	  main_panel.setLayout( new BorderLayout() );

	  JPanel tree_panel  = new JPanel(false);
	  bl = new BoxLayout(tree_panel, BoxLayout.Y_AXIS );  tree_panel.setLayout( bl ); 
	  main_panel.add( tree_panel, "Center" );
	  	   	  	  	  
	  JLabel title = new JLabel("Simulation Objects:");
	  title.setBorder(eb7);
	  title.setAlignmentX(Component.CENTER_ALIGNMENT);
	  tree_panel.add(title);
	  
	  JPanel p = tree.getTree().getDisplayPanel();
	  p.setBorder( BorderFactory.createEtchedBorder() );
	  tree_panel.add( p );

	  JFrame frame  = new JFrame("Model Tree test");
	  frame.setContentPane( main_panel );		
	  frame.setSize(650,650);
	  frame.setResizable(false);
	  
	  Dimension         paneSize = frame.getSize();
	  Dimension         screenSize = frame.getToolkit().getScreenSize();
	  frame.setLocation((screenSize.width - paneSize.width) / 2, (screenSize.height - paneSize.height) / 2);
	  frame.setVisible(true);	
	}

}

