package miiee.client;

import java.util.Vector;
import org.xml.sax.Attributes;
import miiee.mml.*;
import miiee.xml.*;
import miiee.util.*;
import javax.swing.*;

public class Module extends ConfigurableObject {

	protected static Icon _moduleIcon  = null;
	protected boolean _hasVariableData = false;
	static final boolean _debug = false;
	protected static MMLHandler _handler = null;
 	
   static {
	  _moduleIcon  = SimIO.loadIcon(  "module.gif" );
	}
	
    public Module(String name) {
        super(name);
    }

  public  Module( Attributes atts ) throws XMLException {  
	 super(atts,null);
  }  
  
  public void setMMLHandler( MMLHandler m ) { 
	_handler = m; 
  }

    public void addVariable(Variable v) { 
	  try {
		addChild(v); 
	  } catch ( XMLException err ) { ; }
	}
	
	public Icon getIcon() { 
	  if( _icon == null ) { _icon = _moduleIcon; }
	  return _icon; 
	}

	public boolean getConfigurationData( SMEClient client, boolean recurse  ) throws SNPException {
	  boolean rv = super.getConfigurationData( client, recurse );
	  if( recurse ) {
		for( int i=0; i<getChildCount(); i++ ) {
		  XMLContainer n = (XMLContainer) getChild(i);
		  try {
			Variable v = (Variable) n;
			if( v.getConfigurationData( client, false ) ) rv = true;
		  } catch ( ClassCastException err ) { 
			try {
			  Module m = (Module) n;
			  if( m.getConfigurationData( client, false ) ) rv = true;
			} catch ( ClassCastException err1 ) {;} 
		  }
		}
	  }
	  return rv;
	}
	
	public boolean getVariableInfo( SMEClient client, boolean recurse  ) throws SNPException {
	  if( _hasVariableData ) return false;
	  if( !client.initialized() ) return false;
	  for( int i=0; i<getChildCount(); i++ ) {
		XMLContainer n = (XMLContainer) getChild(i);
		try {
		  Variable v = (Variable) n;
		  if( !v.hasVarData() ) {
			System.out.println("Fetching status data for " + v.ID() );
			String var_info = client.sme_shell_varinfo_string(ID(),v.ID(),"qA");
			v.setVariableData( var_info );
		  }
		} catch ( ClassCastException err ) { 
		  try {
			if( recurse ) {
			  Module m = (Module) n;
			  m.getVariableInfo( client, false );
			}
		  } catch ( ClassCastException err1 ) {;} 
		}
	  }
	  return _hasVariableData = true;
	}
	
	public boolean isLeaf() { return (getChildCount() == 0); }
	public String getElementType( int format ) { return "module"; }
/*	
	public void resolveLinks() {
	  super.resolveLinks();
	  processDependencies();
	}

  public void processDependencies() {
	if( _handler == null ) return; 
	for( int i=0; i<getChildCount(); i++ ) {
	  XMLContainer cv = (XMLContainer) getChild(i);
	  try {
		_handler.processDependencies((Variable) cv );
	  } catch ( ClassCastException err ) { ; }
	}
  }
*/  
   public void processPorts() {
	  if( _debug ) { SimIO.print("Process Ports in module: " + ID()  ); }
	  Vector ports = getPorts( false );
	  if( ports != null ) {
		for( int k=0; k<ports.size(); k++ ) {
		  Port p = (Port) ports.get(k);
		  if( p.getMode() == Port.kOutput ) {
			Link inlink = p.getInLink();
			if( inlink == null ) {
			  String id = p.ID();
			  if( _debug ) { SimIO.print("Linking output port: " + id ); }
			  try {
				Variable v = (Variable) getChild( id );
				Port p0 = v.getOutputPort();
				Link link = new Link( p0, p );
				addLink(link); 
				if( _debug ) { SimIO.print("Add internal link from: " + p0.ID() ); }
			  } catch ( Exception err ) {
				  SimIO.print("ProcessPorts error, module " + ID() + ", port: " + id );
				  err.printStackTrace();
			  }
			}
		  }
		}
	  }
   }

}
