package miiee.client;

import java.awt.*;
import java.io.PrintStream;
import java.net.*;
import javax.swing.*;
import java.awt.event.*;
import miiee.mml.WorkSpace;
import miiee.mml.ProjectHandler;
import miiee.servlet.*;
import miiee.util.SimIO;
import miiee.xml.XMLHandler;

public class  PortalApplication {

    String _workBenceName;
    boolean _debug;
    boolean _running;
    boolean _active;
    boolean _getProjectsFromServlet;
    ServletClient _sc;
    ProjectHandler _workBenceHandler;
	String _LocalHost = "localhost";
    JPanel _contentPane;
    UserRegister _ur;
    JFrame _frame;

    public PortalApplication(String workBenceName) {
        _debug= true; 
        _running= false; 
        _active= false; 
        _getProjectsFromServlet= false; 
        _workBenceName = workBenceName;
    }

    public void destroy() {
        System.out.println("PortalApplication::destroy"); 
        if (_sc != null) {
            _sc.destroy(); 
            _sc= null; 
        }
        _active= false; 
    }

    ServletClient getServletClient() {
        return _sc; 
    }

    public void init( String host, int port, String servletContext, String servletName ) {
        System.out.println("PortalApplet::init"); 
        String url= "http://" + host + ":" + port + "/" + servletContext; 
        if (_running) {
            stop(); 
        }
        if (_active) {
            destroy(); 
        }
//        SimIO.setApplet(((JApplet)this)); 

        if (_workBenceName == null)  {
            _workBenceName= "SME"; 
        }
        
        try {
            URL servletBase;
            if (servletName != null)  {
				 servletBase= new URL(url); 
//				 String codeBase = servletBase.toString() + "/workspace";
				 String codeBase = servletBase.toString();
				 SimIO.setWorkbenchDirectory( codeBase );
				 SimIO.setCodebase( servletBase.toString() );
				 SimIO.print(" Attaching to Servlet, base: " + servletBase + ", servlet name: " + servletName );
                _sc= ServletClient.getInstance(servletBase, servletName); 
                _sc.setWorkBench(_workBenceName, _LocalHost); 
            }
        }
        catch (java.net.MalformedURLException MalformedURLException0)   {
            SimIO.show_error( _frame.getContentPane(), "Malformed URL: " + url); 
        }
        catch ( Exception err ) {
			SimIO.show_error( _frame.getContentPane(), err ); 
       }
        _active= true; 
    }

    public void start() {
        System.out.println("PortalApplication::start"); 
        
        if (_running) { stop(); }
        
        if (_ur == null) try {
        
            _ur= new UserRegister(_workBenceName, _sc); 
            
        } catch( Exception err ) {
			SimIO.show_error( _frame.getContentPane(), err ); 
        }
        
        if (_ur.showConnectionDialog(((String)null))) {
		  try {
			User u = _ur.getCurrentUser();
			WorkSpace ws = u.getWebSpace();
            _workBenceHandler= ProjectHandler.create(_workBenceName, _LocalHost); 
            _workBenceHandler.setUserRegister(_ur); 
            _workBenceHandler.readXML(ws); 
            _workBenceHandler.blockUntilReadCompleted(); 
            System.out.println("adding Content Pane"); 
            Container top= _frame.getContentPane();	
            _contentPane= _workBenceHandler.createContentPane(); 
            top.add(((Component)_contentPane)); 
            _contentPane.invalidate(); 
            top.invalidate(); 
            _frame.repaint(); 
		  } catch( Exception err ) {
			SimIO.show_error( _frame.getContentPane(), err ); 
		  }
		} else {
		  System.exit(1);
		}
        _running= true; 
    }

	public synchronized JFrame show( String name ) {
	  _frame = new JFrame(name);
	  WindowListener l = new WindowAdapter() {
		  public void windowClosing(WindowEvent e) { stop(); System.exit(0); }
	  };
	  _frame.addWindowListener( l );
      
	  start();
 
//	  _frame.setJMenuBar( constructMenuBar() );
	  _frame.setBackground(Color.lightGray);
	  _frame.setSize(950,550);
	  
	  Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
	  int x = (screenDim.width - _frame.getSize().width) / 4;
	  int y = (screenDim.height - _frame.getSize().height) / 4;
	  _frame.setLocation(x, y);	   

	  _frame.setVisible(true);
	  return _frame;
	}

    public static void main(String args[]) {
	  String workBenceName = "SME";
	  String host = "gannet.cbl.umces.edu";
	  int port = 8080;
	  String servletContext = "sme";
	  String servletName = "portal";

	  for( int i=0; i<args.length; i++ ) {
		String arg = args[i];
				
		if( arg.equals("-wb") ) {
		  workBenceName = args[++i];
		}

		if( arg.equals("-port") ) {
		  port = Integer.parseInt(args[++i]);
		}

		if( arg.equals("-host") ) {
		  host = args[++i];
		}
		
		if( arg.equals("-servlet") ) {
		  servletName = args[++i];
		}		
	  }	  
	  PortalApplication pa = new PortalApplication(workBenceName);
	  pa.init(host,port,servletContext,servletName);
	  pa.show("SME Portal");
	}
		
    public void stop() {
        System.out.println("PortalApplet::stop"); 
        try {
        	_frame.getContentPane().remove(((Component)_contentPane)); 
        } catch( Exception err ) {;}
        _workBenceHandler.dispose(); 
        _workBenceHandler= null; 
        _contentPane= null; 
        _running= false; 
    }
}

