package miiee.client;

import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import java.util.Vector;
import java.util.Random;
import java.util.Date;
import javax.swing.text.*;
import java.util.HashMap;
import java.awt.*;
import java.awt.font.TextAttribute;
import javax.swing.table.*;
import java.text.SimpleDateFormat;
import java.awt.Container;
import javax.swing.tree.*;
import miiee.util.*;
import miiee.mml.*;
import miiee.xml.*;
import miiee.tree.*;
import miiee.dataview.*;
import javax.swing.border.*;
import java.awt.event.*;
import java.util.ListIterator;
import javax.help.*;
import javax.swing.filechooser.*;

public class PortalInformationPanel extends JPanel {

	protected JButton  _creationButton;
	protected JButton  _closeButton;
	protected int _port;
	protected String  _proj_name;
	protected String _model_name;
	protected String _proj_path;
    protected String _helpText;
    protected SMEInterface _sme_interface;
    protected Vector _listBuffer = new Vector(16,16);
    protected Vector _parmSliders = new Vector(16,16);
	protected Module _root= new Module("Model");
    protected float _stop_time = 100f;
    protected float _time = 0f;
    protected float _DT = 1f;
    protected boolean _run_simulation;
	protected AttributeValuePair _stop_timeAVP;
    protected AttributeValuePair _timeAVP;
    protected AttributeValuePair _timestepAVP;
    protected JPanel _parmeterAdjustmentPanel = new JPanel(false);
    protected JTextArea _docArea = new JTextArea(100,70);
	private ModelObjectTree _objectTree;
    
    protected static JFrame _frame;
	private Font _font; 
	private boolean _initialized = false;
	private boolean _sim_started = false;


	public PortalInformationPanel( SMEInterface intf, int shell_mode ) {
	  super();
	  generateHelpText();
	  _sme_interface = intf;
	  _objectTree= new ModelObjectTree( new VariableTreeModel(_root) );
	}
 		
	public void init() {
	  if( !_initialized ) {
		_initialized = true;
		setLayout( new BorderLayout() );
		setFontSize( 10f );
		CSH.setHelpIDString( this, "ControlPanel" );

		JPanel status_panel = new JPanel(true);
		Border bb = new SoftBevelBorder(SoftBevelBorder.LOWERED);  	
		status_panel.setBorder( bb );
		add(status_panel, "South" );

		JPanel time_step_panel = new JPanel( new FlowLayout() );
		time_step_panel.setBorder( bb );
		status_panel.add( time_step_panel );

		_timestepAVP = AttributeValuePair.New( "time step:", true, 6 );
		try {
		  _timestepAVP.setValue( Float.toString( _DT = _sme_interface.getClient().sme_model_timestep() ) );
		} catch ( SNPException ex ) {  _sme_interface.getClient().error(ex.toString());}
		time_step_panel.add( _timestepAVP );

		JPanel stop_time_panel = new JPanel( new FlowLayout() );
		stop_time_panel.setBorder( bb );
		status_panel.add( stop_time_panel );

		_stop_timeAVP = AttributeValuePair.New( "stop time:", true, 6 );
		_stop_timeAVP.setValue( Float.toString( _stop_time ) );
		stop_time_panel.add( _stop_timeAVP );

		JPanel time_panel = new JPanel( new FlowLayout() );
		time_panel.setBorder( bb );
		status_panel.add( time_panel );

		_timeAVP = AttributeValuePair.New( "current time:", false, 6 );
		try {
		   _timeAVP.setValue( Float.toString( _sme_interface.getClient().sme_model_start_time() ) );
		} catch ( SNPException ex ) {  _sme_interface.getClient().error(ex.toString());}
		time_panel.add( _timeAVP );
		
		add( create_data_panel(), "Center" );
		setBorder( BorderFactory.createEtchedBorder() );
	  }		
	} 
	
	public void addParameter( String mod, String var, String label, String doc, float pval, float pmax, float pmin ) {
	  ParmSlider pm = new ParmSlider(mod, var, label, doc, pval, pmax, pmin);
	  _parmSliders.add(pm);	
	  _parmeterAdjustmentPanel.add(pm.getSliderPanel());
	  _parmeterAdjustmentPanel.invalidate();
	  _parmeterAdjustmentPanel.repaint();
	}

	public JPanel getPanel() { init(); return this; }
	
	
	public void setFrame( JFrame f ) { _frame = f; }
	
	JPanel create_data_panel() {

	  EmptyBorder eb7 = new EmptyBorder( 7, 7, 7, 7 );	
	  EmptyBorder eb3 = new EmptyBorder( 3, 3, 3, 3 );
	  BoxLayout bl;	
	  
	  JPanel pH  = new JPanel(false);
	  bl = new BoxLayout(pH, BoxLayout.X_AXIS );  pH.setLayout( bl ); 

	  JPanel pV0  = new JPanel(false);
	  bl = new BoxLayout(pV0, BoxLayout.Y_AXIS );  pV0.setLayout( bl ); 

	  _docArea.setMargin( new Insets( 4, 4, 4, 4 ) ); 
	  _docArea.setWrapStyleWord(true);
	  _docArea.setLineWrap(true);
	  _docArea.setBackground( new Color(0, 0, 200) );
	  _docArea.setForeground( Color.yellow );

	  JLabel title = new JLabel("Adjustable Simulation Parameters:");
	  title.setBorder(eb7);
	  title.setAlignmentX(Component.CENTER_ALIGNMENT);
	  pV0.add(title);

	  Border bb = new SoftBevelBorder(SoftBevelBorder.LOWERED);  	
	  JScrollPane scrollpane1 = new JScrollPane();
	  scrollpane1.getViewport().setView(_docArea);
	  scrollpane1.setPreferredSize(new Dimension( 300, 100 ));
	  scrollpane1.setBorder( bb );
	  pV0.add(scrollpane1);
	  	   
	  bl = new BoxLayout(_parmeterAdjustmentPanel, BoxLayout.Y_AXIS );  
	  _parmeterAdjustmentPanel.setLayout( bl ); 	  	   
	  bb = BorderFactory.createCompoundBorder( new BevelBorder(BevelBorder.LOWERED), eb3 );  	
	  _parmeterAdjustmentPanel.setBorder( bb );
	  _parmeterAdjustmentPanel.setMaximumSize(new Dimension( Short.MAX_VALUE,  Short.MAX_VALUE ) ); 
	  pV0.add(_parmeterAdjustmentPanel);
		
	  JPanel pV1  = new JPanel(false);
	  bl = new BoxLayout(pV1, BoxLayout.Y_AXIS );  pV1.setLayout( bl ); 
	  
	  bb = BorderFactory.createCompoundBorder( new BevelBorder(BevelBorder.LOWERED), eb3 );   pV1.setBorder( bb );
	  pV1.setMaximumSize(new Dimension( 250,  Short.MAX_VALUE ) ); 
	  pH.add(pV1);

	  JLabel title1 = new JLabel("Run Control:");
	  title1.setBorder(eb7);
	  pV1.add(title1);

	  JButton  initButton = new JButton("init");
	  initButton.addActionListener( new InitAction() );
	  initButton.setMaximumSize( new Dimension( Short.MAX_VALUE, initButton.getMaximumSize().height ) );
	  pV1.add( initButton );

	  JButton  stepButton = new JButton("step");
	  stepButton.addActionListener( new StepAction() );
	  stepButton.setMaximumSize( new Dimension( Short.MAX_VALUE, stepButton.getMaximumSize().height ) );
	  pV1.add( stepButton );

	  JButton  runButton = new JButton("run");
	  runButton.addActionListener( new RunAction() );
	  runButton.setMaximumSize( new Dimension( Short.MAX_VALUE, runButton.getMaximumSize().height ) );
	  pV1.add( runButton );

	  JButton stopButton = new JButton("stop");
	  stopButton.addActionListener( new StopAction() );
	  stopButton.setMaximumSize( new Dimension( Short.MAX_VALUE, stopButton.getMaximumSize().height ) );
	  pV1.add( stopButton );

	  JButton rsButton = new JButton("restart");
	  rsButton.addActionListener( new RestartAction() );
	  rsButton.setMaximumSize( new Dimension( Short.MAX_VALUE, rsButton.getMaximumSize().height ) );
	  pV1.add( rsButton );
	  	  	  
	  return pH;
	}


	class RunAction extends QueuedExecutable  {
	  public void execute() {
		try {
		  setStopTime(); 
		  run_simulation( _stop_time );
		} catch ( SNPException ex ) { _sme_interface.getClient().error(ex.toString());}
	  }
    }

	class InitAction extends QueuedExecutable  {
	  public void execute() {
		try {
		  run_simulation( 0f );
		} catch ( SNPException ex ) { _sme_interface.getClient().error(ex.toString());}
	  }
    }
       
    void run_simulation( float stop_time ) throws SNPException {
	  if( !_sim_started ) {
		 send_parameter_choices();
	  }
	  _run_simulation = true;
	  ProgressDialog pd = new ProgressDialog("Running Model");
	  UpdateTimeAction timeUpdate = new UpdateTimeAction();
	  pd.show( false );
	  float start_time = _time;
	  if( (stop_time == 0f) && !_sim_started ) {
		_sim_started = true;
		try {
		  _sme_interface.getClient().sme_run( 0f );
		  _sme_interface.getClient().retrieve_messages( "initialize model, time = " + _time );
		} catch ( SNPException ex ) {  _sme_interface.getClient().error(ex.toString());}
	  } else {
		setTimeStep();
		while(_run_simulation) {
		  if( _time >= stop_time ) { break; }
		  _sim_started = true;
		  try {  Thread.sleep(200L);   }
		  catch (InterruptedException e0) {  break;  }
		  if( !pd.isShowing() ) { break; }
		  else { pd.setValue( ( _time-start_time ) / ( stop_time-start_time ) ); }
		  try {
			_sme_interface.getClient().sme_step();
			_time = _sme_interface.getClient().sme_current_time();
			_sme_interface.getClient().retrieve_messages( "step model, time = " + _time );
			timeUpdate.executeOnEventDispatchTread();
		  } catch ( SNPException ex ) {  _sme_interface.getClient().error(ex.toString());}
		  repaint();
		} 
	  }
	  pd.finalize();
    } 
    
    void send_parameter_choices() {
	  int nps = _parmSliders.size();
	  StringBuffer sb = new StringBuffer();
	  ConfigCommand cmd = new ConfigCommand();
	  for(int i = 0; i < nps; i++) {
		  sb.setLength(0); cmd.clear();
		  ParmSlider pm  = ((ParmSlider)_parmSliders.elementAt(i)); 
		  float val = pm.getSliderValue() ;
		  sb.append("pm("); sb.append( Float.toString(val) ); sb.append(")");
		  cmd.setCommand( sb.toString() );
		  try {
			_sme_interface.getClient().sme_configure_variable( pm.getMod(), pm.getVar(), cmd );
		  } catch ( SNPException ex ) {  _sme_interface.getClient().error(ex.toString());}
	  }
    }
    
	class UpdateTimeAction extends QueuedExecutable  {
	  public void execute() {
		  _timeAVP.setValue( Float.toString( _time ) );
	  }
    } 

	class StepAction extends QueuedExecutable  {
	  public void execute() {
		try {
		  setTimeStep();
		  run_simulation( _time + _DT );
		} catch ( SNPException ex ) {  _sme_interface.getClient().error(ex.toString());}
	  }
    } 

	class StopAction extends QueuedExecutable   {
	  public void execute() { _run_simulation = false; }
    } 

	class RestartAction extends QueuedExecutable   {
	  public void execute() {
		try {
		  _sme_interface.getClient().sme_restart();
		  _time = 0f;
		  _timeAVP.setValue( "0.0" );
		  setTimeStep();
		  setStopTime();
		  run_simulation( _stop_time );
		} catch ( SNPException ex ) {  _sme_interface.getClient().error(ex.toString());}
	  }
    } 

	void setStopTime()  {
	  try {
		 String val =  _stop_timeAVP.getValue();
		 Float stop = Float.valueOf(val);
		 _stop_time = stop.floatValue();
	  } catch ( NumberFormatException ex ) { SimIO.print(" NumberFormatException "); }
    } 

	void setTimeStep() {
		try {
		   String val =  _timestepAVP.getValue();
		   Float DT = Float.valueOf(val);
		   if( DT.floatValue() != _DT ) {
			 _sme_interface.getClient().sme_set_timestep( _DT = DT.floatValue() );
		   }
		} catch ( NumberFormatException ex ) { SimIO.print(" NumberFormatException "); }
    } 
	
	class ShutdownAction  extends QueuedExecutable   {
	  public void execute() {
		try {
	  // stop remote driver run 
		  _sme_interface.getClient().stop_model();
	  	  // close connection 
		  _sme_interface.getClient().close_model();
		} 
		catch ( SNPException ex ) {;}
		catch ( NullPointerException ex ) {;}
		System.exit(0);
	  }
    } 

	class OpenAction  extends QueuedExecutable   {
	  public OpenAction() { super("Open",null); }
	  public void execute() {;}
    } 

	class SaveAction  extends QueuedExecutable   {
	  public SaveAction() { super("Save",null); }
	  public void execute() {;}
    } 

    public void setFontSize( float font_size ) {
	  HashMap font_attr = new HashMap();
	  font_attr.put( TextAttribute.SIZE, new Float(font_size) );
	  _font = new Font(font_attr);
    }
	    	
	public static void main(String args[])  {	}
	

	public static JFrame startup( SMEInterface intf ) {
	  PortalInformationPanel cp = new PortalInformationPanel(intf, SMEInterface.kGUI );
	
	  _frame  = new JFrame("Variable Information Panel");
	  cp.setFrame(_frame);
	  
	  cp.init();
	  _frame.setContentPane( cp );		
	  _frame.setSize(650,650);
	  _frame.setResizable(false);
	  
	  Dimension         paneSize = _frame.getSize();
	  Dimension         screenSize = _frame.getToolkit().getScreenSize();
	  _frame.setLocation((screenSize.width - paneSize.width) / 2,
				  (screenSize.height - paneSize.height) / 2);
	  return _frame;
	}
	
	public static void showPanel() {
	  _frame.setVisible(true);
	}
	
	public static void hidePanel() {
	  _frame.setVisible(false);
	}
 	
	void generateHelpText() {
	  _helpText = 
		"  To generate Viewers: \n"
	  + "  1. Select the dataSet(s) to be viewed, \n"
	  + "  2. Select a Viewer Type, \n"
	  + "  3. Press the 'Create' button. \n"
	  + "  This will create viewer(s) for all relevant selected dataSets.  \n"
	  + "  A dataSet is relevant if can be displayed by the selected Viewer type. \n"
	  + "  Viewer Types will be enabled if there are dataSets selected that are relevant for that type.  \n"
	  + "  Selecting a simulation node will select all dataSets in that simulation. \n"				
	  + "  Double-click on a dataSet node to view the data objects in that set. \n\n"			
	  + "  Press the 'Close' button to close all viewers of the selected Viewer type associated with the selected dataSets.";				
	}
	
	public ModelObjectTree getModelObjectTree() { 
	  return _objectTree;
	}

	class ParmSlider implements ChangeListener {
	  String _mod; 
	  String _var; 
	  String _label; 
	  String _doc; 
	  float _pmax; 
	  float _pmin;
	  float _pinit;
	  boolean _parm_adjusted = false;
	  JPanel   _sliderPanel = new JPanel(false);
	  JSlider  _parmSlider;
	  AttributeValuePair _parmLabel;
	  
	  public ParmSlider( String mod, String var, String label, String doc, float parm_initial_value, float pmax, float pmin ) {
		_mod = mod; _var = var;  _pmax=pmax;  _pmin = pmin; _pinit = parm_initial_value;
		_sliderPanel.setLayout(new FlowLayout());
		Icon icon = SimIO.loadIcon("question.gif");
		AbstractAction docAction = new AbstractAction( null, icon ) {
		  public void actionPerformed(ActionEvent e) {_docArea.setText(_doc); }
		}; 
		JButton aButton = createToolbarButton( icon, "Show parameter description", "doc", docAction );
		_sliderPanel.add(aButton);
		_label = (label.length() == 0) ? var : label;
		_parmLabel = AttributeValuePair.New( _label, false, 8 );
		_doc = doc;
		_parmLabel.setValue(Float.toString(parm_initial_value));
		_sliderPanel.add(_parmLabel);
		int slider_max_value = 100;
		int slider_init_value = (int)(((parm_initial_value-pmin)*slider_max_value)/(pmax-pmin));
		_parmSlider = new JSlider( JSlider.HORIZONTAL, 0, slider_max_value, slider_init_value );
		_parmSlider.addChangeListener(this);
		_sliderPanel.add(_parmSlider);
	  }
	  
	  public JPanel getSliderPanel() { return _sliderPanel; }
	  public float getSliderValue() { return (_parm_adjusted) ? ( _pmin + ( _pmax - _pmin )*(_parmSlider.getValue()/100f)) : _pinit; }
	  public String getVar() { return _var; }
	  public String getMod() { return _mod; }
	  public void stateChanged(ChangeEvent e) {
		float sv = getSliderValue();
		_parmLabel.setValue(Float.toString(sv));
		_parm_adjusted = true;
	  }
	  
     protected JButton createToolbarButton( Icon icon, String tooltip, String actionCommand, AbstractAction a ) {
		JButton b = new JButton( icon ) {
				public float getAlignmentY() { return 0.5f; }
		};
		b.setRequestFocusEnabled(false);
		b.setMargin(new Insets(1,1,1,1));
		b.setToolTipText(tooltip);
		b.setActionCommand(actionCommand);
		b.addActionListener(a);
        return b;
    } 
	};
	
}
