package miiee.client;

import miiee.util.StringVector;

//---- Response ---------------------------------------------------------

public class Response extends StringVector {

  public static final int kOrdinaryType  = 0;
  public static final int kDefaultType  = 1;
  public static final int kIgnoreType  = 2;
  public static final int kClosedFileDescriptor  = -1;
  
  public static final Response kDefault  = new Response(kDefaultType);
  public static final Response kIgnore = new Response(kIgnoreType);

  public int codeType;
  public int code;
  public int printMode;
  public boolean eofOkay = true;
  public boolean hadEof = false;
  public int responseType;

  public Response() {
	this(kOrdinaryType);
  }

  public Response( int rType ) {
	responseType = rType;
  }
  
  public int addLine( String line ) {
	add(line);
	return size() - 1;
  }
  
  protected String getPostSeparator( int i ) { return "\n"; }
  protected String getPreSeparator( int i ) { return ""; }

}
