package miiee.client;

import java.util.Vector;
import miiee.dataview.ViewserverControlPanel;
import miiee.client.MMLHandler;
import miiee.util.*;
import javax.swing.tree.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import miiee.xml.*;
import miiee.mml.ProjectHandler;
import miiee.mml.Project;
import java.util.HashMap;
import java.security.*;
import java.io.*;
import miiee.mml.MMLException;  

//---- SMEClient ---------------------------------------------------------

public class SMEClient extends SNPClient  {  

  ViewserverControlPanel _viewserver;
  StringBuffer _buffer = new StringBuffer(); 
  SMEInterface _sme_interface;
  boolean bPause = true;
  boolean bUseSNI = true;
  boolean bInitialized = false;
  Module _root= new Module("Model");
  VariableInformationPanel _variableInformationPanel;
  String _scenario;
  ConfigurationPanel _configPanel;
  int _config_index = -1;
  static int _port = 17735;
  private static  ExternalClassStub _python_interface;


 // fields for connection panel
 
    static String[] ConnectOptionNames = { "Connect", "Cancel" };
    static String   ConnectTitle = "Connection Information";
	static JPanel      connectionPanel;
    static JLabel      userNameLabel;
    static JTextField  userNameField;
    static JLabel      passwordLabel;
    static JTextField  passwordField;
    static JLabel      serverLabel;
    static JTextField  serverField;
    static JLabel      portLabel;
    static JTextField  portField;
 
  public SMEClient( String host, int port, boolean useSNI, int mode, int shell_mode, String scenario ) { 
	super(host,port); 
	bUseSNI = useSNI;
	_scenario = scenario;
	System.out.println( "Connecting to host " + host + " using port " + port );
	_sme_interface = new SMEInterface(this,mode);
	_variableInformationPanel = new VariableInformationPanel( _sme_interface, (Module) getTreeRoot(), shell_mode );
  }

  public String getScenarioName() { return _scenario; }
  public  Variable getVariable(  String full_name ) { return  _configPanel.getVariable( full_name ); }
  
  public int connect( String username, String password ) throws SNPException, java.net.UnknownHostException  {
	  open();
	  System.out.println( "opened host, logging in with user:" + username + ", pw: " + password );
	  return login( username, password );
  }
  
  public SMEInterface getInterface() { return _sme_interface; }
  
  public void shutdown( boolean closeWindow ) { _sme_interface.shutdown( closeWindow ); }
	  
  public void show_control_panel() {
	int mode = _sme_interface.getMode();
	SimIO.print("Starting up SME interface, mode: " + mode );
	if( mode == SMEInterface.kRun ) {
	  _sme_interface.addPanel( "Control", _variableInformationPanel.getPanel() );
	  _sme_interface.addPanel( "Messages",  _msg_reader.getPanel() );
	}
	_config_index = _sme_interface.addPanel( "Configure",  _configPanel = ConfigurationPanel.getPanel(_sme_interface) );
	_sme_interface.show();
  }

  public  static ExternalClassStub  getPythonInterface() throws MMLException {
	  if( _python_interface == null ) {
		_python_interface = new ExternalClassStub( "miiee.python.SPyStubs" );
		_python_interface.addMethod("start", "startup_shell( miiee.client.SMEClient )" );
	  } 
	  return _python_interface;
  }
 
  public void show_python_shell() {
	try {
	  ExternalClassStub  python = getPythonInterface();
	  python.execMethod("start", new Object[] { this }  );
	} catch ( MMLException err ) {
	  SimIO.show_error( null, "Must have JPython properly installed to use this feature.", err );
	}
  }
  
 
  public ModelObjectTree getModelObjectTree() { 
	return _variableInformationPanel.getModelObjectTree();
  }
  
  public boolean loadModelResource( String model_spec_resource, String model_config_resource, ProgressDialog pd ) { 
	ModelObjectTree mt = _variableInformationPanel.getModelObjectTree();
	boolean rv = MMLHandler.loadResource(model_spec_resource,mt,MMLHandler.MODEL_DECLARATION);
	if( rv ) { 
	  if( pd != null ) { pd.setValue(0.5f); }
	  MMLHandler.loadResource(model_config_resource,mt,MMLHandler.MODEL_CONFIGURATION); 
	}
	return rv;
  }
	  
  public void refresh() {  _configPanel.refresh(); }
   
  public void setStandAlone() { _sme_interface.setStandAlone(); }
  
   
  public ViewserverControlPanel getViewserver() { return _viewserver; }

  
/*
int snp_sme_set_spatial (  const char* module, const char* var,  float* value) {
  int x, y, i, j, cnt = 0;

  if (snp_sme_var_size(snp_id, module, var, &x, &y) == SNP_ERROR) return SNP_ERROR;
  for (i = 0; i < y; i++)
    for (j = 0; j < x; j++) {
		if (snp_sme_set_spatial_at(snp_id, module, var, j, i, value[cnt++]) == SNP_ERROR)  return SNP_ERROR;
	}
  return SNP_OK;
}
*/

/*
  void indent( int depth ) {
	for( int i=0; i<depth; i++ ) {
	  System.out.print('\t');
	}
  }
  
  void print ( String s, int depth ) {
	indent( depth ); 
	System.out.print( s );
  }
  
  void print_node_structure( Node elem, int depth ) {
	boolean dump = true;
	switch( elem.getNodeType() ) {
	  case Node.ELEMENT_NODE:
		String element_name = elem.getNodeName();
		if( dump ) { print( " Element Node: " + element_name + "\n", depth ); }
		NamedNodeMap  attributes = elem.getAttributes();
		for( int ai = 0; ai < attributes.getLength(); ai++ ) {
		  Node anode = attributes.item(ai);
		  if( dump ) { print( " ATTR: " + anode.getNodeName() + ";  VALUE: " + anode.getNodeValue() + "\n" , depth + 1 ); }
		}
	  break;
	  case Node.TEXT_NODE:
		Text text_node = (Text)elem;
		String tdata = text_node.getData();
		if( dump ) { print( " TEXT Node: " + tdata + "\n", depth ); }
	  break;
	  default:
	  break;
	} 
	NodeList nl =  elem.getChildNodes();
	for( int ni = 0; ni < nl.getLength(); ni++ ) {
	  Node n = nl.item(ni);
	  print_node_structure(n,depth+1);
	}
  }
  
  String process_PCDATA( Node elem, int level ) {
	NodeList nl =  elem.getChildNodes();
	if( level == 0 ) _buffer.setLength(0);
	for( int ni = 0; ni < nl.getLength(); ni++ ) {
	  Node n = nl.item(ni);
	  switch( n.getNodeType() ) {
		case Node.ELEMENT_NODE:
		  process_PCDATA( n, level+1 );
		break;
		case Node.TEXT_NODE:
		  _buffer.append( ((Text)n).getData() );
		break;
		default:
		break;
	  } 
	}
	return _buffer.toString();
  }

  DefaultMutableTreeNode process_top_nodes( Node elem, String proj ) {
	NodeList nl =  elem.getChildNodes();
	String name=null, acro=null, doc=null;
	for( int ni = 0; ni < nl.getLength(); ni++ ) {
	  Node n = nl.item(ni);
	  switch( n.getNodeType() ) {
		case Node.ELEMENT_NODE:
		  String element_name = n.getNodeName();
		  if( element_name.equals("name") ) {
			name = process_PCDATA(n,0);
		  }
		  if( element_name.equals("acro") ) {
			acro = process_PCDATA(n,0);
			if( !acro.equals(proj) ) {
			  SimIO.print( "Warning, incorrect project acronym ignored: " + acro + " in project " + proj );
			}
		  }
		  if( element_name.equals("doc") ) {
			doc = process_PCDATA(n,0);
		  }
		break;
		default:
		break;
	  } 
	}
	DefaultMutableTreeNode pn = ProjectHandler.addProject( proj, name, doc );
	
	for( int ni = 0; ni < nl.getLength(); ni++ ) {
	  Node n = nl.item(ni);
	  switch( n.getNodeType() ) {
		case Node.ELEMENT_NODE:
		  if( n.getNodeName().equals("model") ) {
			process_model(pn,n);
		  }
		break;
		default:
		break;
	  } 
	}
	return pn;
  }

  void process_model( DefaultMutableTreeNode proj_node, Node elem ) {
	NodeList nl =  elem.getChildNodes();
	String name=null, acro=null, doc=null;
	for( int ni = 0; ni < nl.getLength(); ni++ ) {
	  Node n = nl.item(ni);
	  switch( n.getNodeType() ) {
		case Node.ELEMENT_NODE:
		  String element_name = n.getNodeName();
		  if( element_name.equals("name") ) {
			name = process_PCDATA(n,0);
		  }
		  if( element_name.equals("acro") ) {
			acro = process_PCDATA(n,0);
		  }
		  if( element_name.equals("doc") ) {
			doc = process_PCDATA(n,0);
		  }
		break;
		default:
		break;
	  } 
	}
	ProjectHandler.addModel( proj_node, acro, name, doc );
	_hasModels = true;
  }
*/  

    public XMLContainer addVariable(  XMLContainer module_node, Variable v ) {
	  return _variableInformationPanel.addVariable(module_node,v);
	}
    public XMLContainer addModule( Module m ) {
	  return _variableInformationPanel.addModule(m);
	}
	
	public JTree getVariableTree() {
	  return _variableInformationPanel.getTree();
	}
	
	public XMLContainer addDependency( XMLContainer var_node, Variable v ) {
	  return _variableInformationPanel.addDependency(var_node,v);
	}

  public static String[] startupSME( String project, String proj_directory, String model_id, String scenario, 
															String rhost, String port ) throws XMLException, IOException {
	return startupSME( project, proj_directory, model_id, scenario, rhost, port, ProjectHandler.LOCAL_MODE );
  }

  public static String[] startupSME( String project, String proj_directory, String model_id, String scenario, 
															String rhost, String port, int _interaction_mode ) throws XMLException, IOException {
	if( proj_directory.equals("local") ) { proj_directory = SimIO.getCodebase() + "/workbench/SME/Projects/"; }
	String run_script = " SME project " + project + " " + proj_directory + ";";
	run_script +=  " SME model " + model_id + ";";
	run_script += "SME scenario " + scenario + ";";
	if( port == null ) { port = Integer.toString(++_port); }
	int debug = 2;
	switch( _interaction_mode ) {
	  case ProjectHandler.LOCAL_MODE: {
		if( rhost == null ) {
		  run_script += "SME -java local run ";
		} else {
		  run_script += "SME -java " + rhost + " -CSport " + port + " run ";
		}
	  } break;
	  case ProjectHandler.GLOBUS_MODE: {
		try {
		  System.out.println( "Running model " + project + " : " + model_id + " with globus "  );
		  miiee.globus.SMEGram build_request = new miiee.globus.SMEGram( rhost, project, model_id );  
		  build_request.run(miiee.globus.SMEGram.SME_RUN_CMD);  
		} catch( Exception err ) {
		  SimIO.show_error( null, "Globus error: ", err );
		}
	  } break;
	}
	System.out.println( "\nstartupSME: Running model " + model_id + " with run script: " + run_script );
	ScriptExecutable se = new ScriptExecutable(false);
	se.execute(run_script,null);
	String lhost = SimIO.getLocalHostAddress();
	String rv[] = { lhost, port };
	return rv;
  } 
  
   public static SMEClient startupClient( String alt_port, String host, String model, String scenario, boolean useDebugger, 
																	  boolean getMessages, boolean useSNI, int mode, int shell_mode )  {
	// connect to server 
	SMEClient client = null;
	String port = (alt_port==null) ? "17736" : alt_port;
	
	while( client == null ) {
	  client = getNewClient(useSNI,host,port,mode,shell_mode,scenario);
	}
	try {
	  int code; 
	  if( useSNI ) {
		code = client.set_server_timeout ( -1 ); 
		System.out.println("set_server_timeout returned code " + code );

		/* select project/model PLM/PLM */
		code = client.select_interface("SME");
		System.out.println("select_interface returned code " + code );

		Vector proj_list = new Vector();
		Vector model_list = new Vector();
		Project project = null;
		int pl_size = client.project_list ( proj_list );

		ProjectHandler ps = new ProjectHandler("SME",ProjectHandler.LOCAL_MODE);
		for( int i=0; i<pl_size; i++ ) {
		  boolean hasModels = false;
		  String proj = (String)proj_list.get(i); 
		  client.select_project( proj );
		  String proj_info = client.get_project_info();
  //		SimIO.print("Got Project: " + proj + " Info: " + proj_info + "\n" );
		  if( proj_info.startsWith("<?xml") ) { 
			StringReader sr = new StringReader(proj_info);
			XMLParser xp = null;
			try {
			  xp = XMLParser.getParser( null, ps );
			} catch( XMLException err ) {;}
			xp.parse(sr); 
			ps.overrideCurrentProjectAcro( proj );
			hasModels = ps.hasModels();
//		    SimIO.print("Parsing XML: \n" + proj_info + "\n");
		  } else {
			int cutoff = ( proj_info == null ) ? -1 : proj_info.indexOf('\n');
			String name = ( cutoff == -1 ) ? proj_info : proj_info.substring(0,cutoff);
			String doc = ( cutoff == -1 ) ? null : proj_info.substring(cutoff);
			project = ps.addProject( null, proj, name, null, doc );
		  }
		  if( hasModels == false ) { 
			int ml_size = client.model_list ( model_list );
			for( int j=0; j<ml_size; j++ ) {
			  String mod = (String)model_list.get(j); 
			  client.select_model( mod );
			  String model_info = client.get_model_info();
			  int cutoff = ( model_info == null ) ? -1 : model_info.indexOf('\n');
			  String name = ( cutoff == -1 ) ? model_info : model_info.substring(0,cutoff);
			  String doc = ( cutoff == -1 ) ? null : model_info.substring(cutoff);
			  ps.addModel( project, model, name, doc );
			}	
		  }  
		}
		if( !ps.showTreeView(true) ) { System.exit(1); }

		Project proj = ps.selectedProject();
		code = client.select_project( proj.ID() );
		System.out.println("select_project returned code " + code );
		String model_name = (String) ps.selectedModel().getProperty("name");
		code = client.select_model( model_name );
		System.out.println("select_model returned code " + code );
	  } else {
		client.set_model(model);
	  }

	  /* start remote driver */
	  code = client.run_model();
	  System.out.println("run_model returned code " + code);
	  
//	  if( JOptionPane.showConfirmDialog(null, "Attach debugger?", "debug", JOptionPane.YES_NO_OPTION ) == JOptionPane.YES_OPTION ) {
//		client.sme_start_debugger ();
//	  }	  
	  if( getMessages ) { client.retrieve_messages("run model"); }
	  
	  /* init simulation */

	  /* cut the info messages */
	  ConfigCommand cc = new ConfigCommand("debugLevel");
	  cc.addArg("0");
	  code = client.sme_configure_object( "SME", cc );
	  System.out.println("sme_configure_object returned code " + code);
	  
	  String model_path = client.get_model();
	  int pindex = model_path.indexOf('.');
	  String pname = ( pindex < 0 ) ? model_path : model_path.substring(0,pindex);
	  String mname = ( pindex < 0 ) ? model_path : model_path.substring(pindex+1);
	  String model_spec = "workspace/projects/" + pname + "/" + mname + "/" + mname + "_module.xml";  
	  String model_config = "workspace/projects/" + pname + "/" + mname + "/" + scenario + "/" + mname + "_module.xml";  
	  ProgressDialog pd = new ProgressDialog("Loading Model Specs");
	  pd.show( false ); pd.setValue( 0f );
	  if( !client.loadModelResource( model_spec, model_config, pd ) ) { 
		/* retrieve module names */
		Vector mod_list = new Vector( 64, 64 );
		Vector var_list = new Vector( 64, 64 );
		String var0 = null, mod0 = null;
		code = client.sme_modules(mod_list);

		System.out.println("\nsme_modules returned n = " + mod_list.size() + ", code: " + code );

		/* print all modules */

		int nmod = mod_list.size();
		for ( int i = 0; i < nmod; i++) {
			/* retrieve variable list for module */
			if( !pd.isShowing() ) { break; }
			else { pd.setValue( ((float)i)/nmod ); }
			String mod_name = (String) mod_list.get(i);
			Module mod_obj = new Module(mod_name);
			XMLContainer mod_node = client.addModule( mod_obj );
			var_list.clear();
			code = client.sme_variables(mod_name,var_list);

			for (int j = 0; j < var_list.size(); j++) {
			  String var_name = (String) var_list.get(j);
			  Variable var_obj = new Variable(var_name,mod_obj);
			  client.addVariable( mod_node, var_obj );
			}
		}
	  }
	  pd.finalize();
	  if( shell_mode == SMEInterface.kGUI ) { client.show_control_panel(); }
	  else { client.show_python_shell(); }

	  client.initialize_model_configuration( getMessages );
	  
	} catch ( SNPException ex ) {
		error( ex.toString() );	
		ex.printStackTrace(); 
	} 
	return client;
  }
  public int getViewserverPort() { 
	if( _viewserver == null ) return -1;
	return _viewserver.getPort(); 
  }
    
  public boolean initViewserver( int port ) {
	if( _viewserver == null ) {
	  _viewserver = ViewserverControlPanel.getInstance( port, ViewserverControlPanel.kShellTab );
	  _viewserver.setScenarioName( _scenario );
	  _sme_interface.addPanel("View",_viewserver);
	} 
	return  true; 
  }
  
 public static void main(String args[])  {
	boolean useDebugger = false;
	boolean getMessages = true;
	boolean useSNI = false;
	
	String port = "17736";
	String host = null;	  
	String model = null;
	String scenario = null;
	int mode = SMEInterface.kRun;	  
	int shell_mode = SMEInterface.kGUI;	 
	 
	for( int i=0; i<args.length; i++ ) {
		String arg = args[i];
		SimIO.print("Processing arg: " + arg);
		if( arg.equals("-d") ) {
		  useDebugger = true;
		}
		else if( arg.equals("-p") ) {
		  try {
			  port = args[++i];
			  SimIO.print("Setting Port to " + port);
		  }
		  catch( ArrayIndexOutOfBoundsException ex ) {
			  SimIO.print("Missing Port argument.");
		  }
		}
		else if( arg.equals("-h") ) {
		  try {
			  host = args[++i];
			  SimIO.print("Setting Host to " + host);
		  }
		  catch( ArrayIndexOutOfBoundsException ex ) {
			  SimIO.print("Missing Host argument.");
		  }
		}
		else if( arg.equals("-scen") ) {
		  try {
			  scenario = args[++i];
			  SimIO.print("Setting scenario to " + scenario);
		  }
		  catch( ArrayIndexOutOfBoundsException ex ) {
			  SimIO.print("Missing scenario argument.");
		  }
		}
		else if( arg.equals("-m") ) {
		  try {
			  model = args[++i];
			  SimIO.print("Setting Model to " + model);
		  }
		  catch( ArrayIndexOutOfBoundsException ex ) {
			  SimIO.print("Missing Model argument.");
		  }
		}
		else if( arg.equals("-c") ) {
			  mode = SMEInterface.kConfig;
			  SimIO.print("Setting Mode to config");
		}
		else if( arg.equals("-python") ) {
			  shell_mode = SMEInterface.kPython;
			  SimIO.print("Setting Shell Mode to python");
		}
		else if( arg.equals("-sni") ) {
		  useSNI = true;
		}
	}
	
	SMEClient c = startupClient(port,host,model,scenario,useDebugger,getMessages,useSNI,mode,shell_mode);
	c.setStandAlone();	
  }
 
  public void initialize( boolean getMessages ) { 
	if( bInitialized ) return;
	if( _configPanel != null ) {
	  _configPanel.setEditingEnabled( false );	
	}
	try {
	  int code = sme_open();
	  System.out.println("sme_open returned code " + code);

	  if( getMessages ) { retrieve_messages("open Model"); }
	  code = sme_configure_viewserver( 17726 );

	  System.out.println("sme_configure_viewserver returned code " + code );

	  if( getMessages ) { retrieve_messages("sme_configure_viewserver"); }

	  _variableInformationPanel.addTreeExpansionListener( new VariableDataListener(this, _variableInformationPanel.getTree()) );
	} catch ( SNPException ex ) {
		error( ex.toString() );	
		ex.printStackTrace(); 
	} 	
	
	bInitialized = true;
  }
  
  public boolean initialized() { return bInitialized; }

  public void initialize_model_configuration( boolean getMessages ) {
	if( _config_index >= 0 ) {
	  _sme_interface.setSelection( _config_index );
	  _sme_interface.addListener( new initChangeListener(getMessages) );
	}
  }
      
  public static void createConnectionDialog( String host, String port ) {
 	// Create the labels and text fields.
 	String username = SMEInterface.getProperty("user.name");
 	if( username == null ) { 
	  try {
		  username = System.getProperty("user.name");
	  } catch ( AccessControlException err ) {
		  username = "user";
	  }
	}
	userNameLabel = new JLabel("User name: ", JLabel.RIGHT);
 	userNameField = new JTextField(username);

 	String password = SMEInterface.getProperty("user.password");
 	if( password == null ) { password = ""; }
	passwordLabel = new JLabel("Password: ", JLabel.RIGHT);
	passwordField = new JPasswordField( password );

	if( host == null ) { host = SMEInterface.getProperty("server.host"); }
	if( host == null ) { host = "localhost"; }
	serverLabel = new JLabel("Server: ", JLabel.RIGHT);
	serverField = new JTextField( host, 25 );

	if( port == null ) { port = SMEInterface.getProperty("server.port"); }
	if( port == null ) { port = "10000"; }
	portLabel = new JLabel("Port: ", JLabel.RIGHT);
	portField = new JTextField( port );


	connectionPanel = new JPanel(false);
	connectionPanel.setLayout(new BoxLayout(connectionPanel, BoxLayout.X_AXIS));

	JPanel namePanel = new JPanel(false);
	namePanel.setLayout(new GridLayout(0, 1));
	namePanel.add(userNameLabel);
	namePanel.add(passwordLabel);
	namePanel.add(serverLabel);
	namePanel.add(portLabel);

	JPanel fieldPanel = new JPanel(false);
	fieldPanel.setLayout(new GridLayout(0, 1));
	fieldPanel.add(userNameField);
	fieldPanel.add(passwordField);
	fieldPanel.add(serverField);
	fieldPanel.add(portField);

	connectionPanel.add(namePanel);
	connectionPanel.add(fieldPanel);
  }
  
  class initChangeListener extends QueuedExecutable {
	boolean _getMessages;
	public initChangeListener(boolean getMessages) { _getMessages = getMessages; }
	public void execute() { initialize( _getMessages ); }
  };
  
  synchronized static SMEClient getNewClient( boolean useSNI, String host, String port, int mode, int shell_mode, String scenario ) {
	SMEClient client = null;
	if( connectionPanel == null ) createConnectionDialog( host, port );
	if( !useSNI || JOptionPane.showOptionDialog( null, connectionPanel, ConnectTitle,
		   JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE,
                   null, ConnectOptionNames, ConnectOptionNames[0]) == 0 ) {
        try {           
		  client = new SMEClient( serverField.getText(), Integer.parseInt(portField.getText()), useSNI, mode, shell_mode, scenario );
		  client.connect( userNameField.getText(), passwordField.getText() );
		} catch ( java.net.UnknownHostException ex1 ) {
		  error( ex1.toString() );
		} catch ( SNPException ex1 ) {
		  error( ex1.toString() );
		  ex1.printStackTrace();
		} catch( NumberFormatException err) {
		  error( "Port must be a number." );
		}
	} else {
	  System.exit(0);
	}
	return client;
  }
  
  XMLContainer getTreeRoot() { return _root; }
}

class VariableDataListener extends QueuedExecutable {
  SMEClient _client;
  VariableDataListener( SMEClient client, JTree tree ) { super(tree); _client = client; }
  public  void execute() {
	 TreePath path = ((TreeExpansionEvent)_event).getPath(); 
	 JTree tree = (JTree)_source;
	  try {
		Module m = (Module)(path.getLastPathComponent());
		if( m.getVariableInfo( _client, false ) ) {
		  tree.collapsePath(path);
		  tree.expandPath(path);
		}
	  } catch ( ClassCastException err ) { 
		return;  
	  } catch ( SNPException err ) { 
		 SimIO.print("Error getting Variable data: " + err );
	  } 
  }
}

