package miiee.client;

import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import java.util.Vector;
import java.util.Properties;
import java.util.HashMap;
import java.awt.*;
import miiee.util.*;
import miiee.tree.*;
import javax.swing.border.*;
import java.awt.event.*;
import java.util.ListIterator;
import javax.help.*;
import miiee.dataview.ViewserverControlPanel;  

public class SMEInterface extends Object implements ChangeListener {
	JFrame _frame;
	JTabbedPane _mainPanel = new JTabbedPane(); 
	JMenuBar    _menuBar = new JMenuBar();
	HashMap _menus = new HashMap(32);
	static SNPClient _sme_client;
	int _ExecMode = kRun;
	boolean _useMenuBar = false;
	static Properties _properties = new Properties();
	boolean _standAlone = false;
	
	public static final int kRun = 0;
	public static final int kConfig = 1;

	public static final int kGUI = 0;
	public static final int kPython = 1;
	
	static {
	  String pfile = null;
	  try {
		pfile = System.getProperty("user.home") + "/.sme/defaults";
		readProperties(pfile);
		pfile = System.getProperty("LIBDIR") + "/sysdef/defaults";
		readProperties(pfile);
	  } catch ( java.security.AccessControlException err ) {
		try {
		  pfile = SimIO.getXMLUsrDirectory() + "defaults";
		  readProperties(pfile);
		} catch ( java.security.AccessControlException err1 ) {;}
	  } 
	}
	
	public SMEInterface( SNPClient sme_client, int exe_mode ) {
	  super();
	  _sme_client = sme_client;
	  _ExecMode = exe_mode;
	  _mainPanel.addChangeListener(this);
	}
	
	public SMEInterface( SNPClient sme_client ) {
	  this(sme_client,kRun);
	}
	
	public void setStandAlone() { _standAlone = true; }
	
	public JFrame getFrame() { return startup(false); }
		
	public JMenu addAction( String menuName, javax.swing.Action a  ) {
	  JMenu  menu = (JMenu) _menus.get(menuName);
	  if( menu == null ) {
		menu = new JMenu( menuName );
		_menus.put( menuName, menu );
		_menuBar.add(menu);
	  }
	  menu.add( a );
	  return menu;
	}

	public JMenu addMenuItem( String menuName, String itemName, ActionListener a  ) {
	  JMenu  menu = (JMenu) _menus.get(menuName);
	  if( menu == null ) {
		menu = new JMenu( menuName );
		_menus.put( menuName, menu );
		_menuBar.add(menu);
	  }
	  JMenuItem menuItem = menu.add( new JMenuItem(itemName) );
	  menuItem.addActionListener( a );
	  return menu;
	}
	
	static public SNPClient getClient() { return _sme_client; }
		
	static void readProperties( String pfile ) {
	  FileInputStream fis = null;
	  try {
		  fis = new FileInputStream(  new File(pfile) );
		  if (fis != null)  {
			System.out.println("Loading properties from file: " + pfile);
			_properties.load(fis);
			fis.close();
		  }
	  } catch( FileNotFoundException err ) {
	  } catch( IOException err ) {}
	}

	static void saveProperties(String name ) {
	  String pfile = System.getProperty("user.home") + "/.sme/" + name;
	  FileOutputStream fos = null;
	  try {
		  fos = new FileOutputStream(  new File(pfile) );
		  if (fos != null) {
			_properties.store(fos, "SME preferences" );
			fos.close();
		  }
	  } catch( IOException err ) {;}
	}
	
	public synchronized static Object setProperty(String key, String value) {
	  return _properties.put(key, value);
    }

	public static String getProperty(String key) {
	  return _properties.getProperty(key);
    }
		
	public void shutdown( boolean closeWindow ) {
//	  if( SimIO.show_confirm2( _frame, "Shut down the simulation?"  ) > 0 ) {
		try {
	  // stop remote driver run 
		  _sme_client.stop_model();
	  	  // close connection 
		  _sme_client.close_model();
		} 
		catch ( SNPException ex ) {;}
		catch ( NullPointerException ex ) {;}
		try {
		  saveProperties("defaults");
		} catch ( Exception err ) {
		  SimIO.print( "Can't save properties: " + err.getMessage() );
		}
		ViewserverControlPanel vcp = (ViewserverControlPanel) getPanel("View");
		if( vcp != null ) {
		  vcp.dispose();
		}
		dispose(closeWindow);
		System.out.println("SME interface exit, standalone: " + _standAlone);	
		if( _standAlone ) { System.exit(0); }
//	  }
	}

    public void dispose( boolean closeWindow ) {
	  if( _frame == null ) return;
	  if( closeWindow ) { _frame.setVisible(false);	}
	  _frame.dispose();	
	  _frame = null;
    }
	
	class ShutdownAction  extends AbstractAction   {
	  public ShutdownAction() { super("Quit",null); }
	  public void actionPerformed( ActionEvent e ) { shutdown(true); }
    } 


	class OpenAction  extends AbstractAction   {
	  public OpenAction() { super("Open",null); }
	  public void actionPerformed( ActionEvent e ) {;}
    } 

	class SaveAction  extends AbstractAction   {
	  public SaveAction() { super("Save",null); }
	  public void actionPerformed( ActionEvent e ){;}
    } 

	public int addPanel( String name, Component panel ) {
	  int rv = _mainPanel.indexOfComponent( _mainPanel.add(name,panel) );
	  try {
		((ViewserverControlPanel)panel).setTabbedPane ( _mainPanel );
//		((ViewserverControlPanel)panel).setScenarioName( _scenario );
	  } catch( ClassCastException err ) { ; }
	  return rv;
	}

	public Component getPanel( String name ) {
	  int tabIndex = _mainPanel.indexOfTab(name);
	  return ( tabIndex < 0 ) ? null : _mainPanel.getComponentAt( tabIndex );
	}
	
	public int getMode() { return _ExecMode; }

	public void setSelection( int index ) {
	  _mainPanel.getModel().setSelectedIndex(index);
	}

	public void addListener( ChangeListener listener ) {
	  _mainPanel.getModel().addChangeListener(listener); 
	}
	
	public void stateChanged( ChangeEvent ev ) { 
	  Component c = _mainPanel.getSelectedComponent();
	  if( c == null ) return;
	  try { 
		((ConfigurationPanel)c).refresh(); 
	  } catch ( ClassCastException err ) { ; }
	}

	
	public synchronized JFrame startup(boolean pack) {
	  if( _frame == null ) {
		_frame  = new JFrame("SME Interface");
		WindowListener l = new WindowAdapter() {
			public void windowClosing(WindowEvent e) { 
			  shutdown(false); 
			}
		};
		_frame.addWindowListener( l );		
		_frame.getContentPane().add( _mainPanel, BorderLayout.CENTER );

		if( _useMenuBar ) { 
		  addAction( "File", new OpenAction()  ); 
		  addAction( "File", new SaveAction()  ); 
		  addAction( "File", new ShutdownAction()  );

		  try {		   
			HelpBroker hb = SimIO.getHelpBroker( "SME", "JavaPortal"  );
			addMenuItem( "Help", "Interface Help", new CSH.DisplayHelpFromSource(hb) ); 
		  } catch ( Exception err ) {; }

		  _frame.getRootPane().setJMenuBar( _menuBar ); 
		}
		
		JToolBar toolbar = new JToolBar();
		_frame.getContentPane().add( toolbar, BorderLayout.NORTH );	  
	  			
		JButton aButton = toolbar.add ( new AbstractAction( null, SimIO.loadIcon("close.gif") ) {
			public void actionPerformed(ActionEvent e) { 
			  if( SimIO.show_confirm2( _frame, "Shut down the simulation?"  ) > 0 ) {
				 shutdown(true); 
			  }
			}
		} ); 
		aButton.setToolTipText( "Shutdown Simulation" );
		aButton.setAlignmentY(0.5f);

		aButton = toolbar.add ( new AbstractAction( null, SimIO.loadIcon("question.gif") ) {
			public void actionPerformed(ActionEvent e) {
			  HelpBroker hb = SimIO.getHelpBroker( "SME", "JavaPortal"  );
			  String id = "top";
			  try {
				id = CSH.getHelpIDString( _mainPanel.getSelectedComponent() );
				hb.setCurrentID(id);
				SimIO.print( "Setting help id: " + id );
			  } catch ( BadIDException err ) {
				SimIO.print( "Bad help id: " + id );
			  }
			  if( !hb.isDisplayed() ) { 
				hb.setDisplayed(true);
			  }
			}
		} ); 
		aButton.setToolTipText( "Help" );
		aButton.setAlignmentY(0.5f);

		if( pack ) {
		  _frame.setSize(700,400);
		  _frame.setResizable(true);
		} else {
		  _frame.setSize(650,750);
		  _frame.setResizable(false);
		}
		Dimension         paneSize = _frame.getSize();
		Dimension         screenSize = _frame.getToolkit().getScreenSize();
		_frame.setLocation((screenSize.width - paneSize.width) / 2,
					(screenSize.height - paneSize.height) / 2);
	  }
	  return _frame;
	}
	
	public void show( boolean pack ) {
	  startup(pack);
	  _frame.setVisible(true);
	  _sme_client.refresh();
	}
	
	public void show() { this.show(false); }
	
	public void hide() {
	  if( _frame != null ) {
		_frame.setVisible(false);
	  }
	}
 	
}
