package miiee.client;

import java.util.Vector;
import miiee.dataview.ViewserverControlPanel;
import miiee.client.MMLHandler;
import miiee.util.*;
import javax.swing.tree.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import miiee.xml.*;
import miiee.mml.ProjectHandler;
import miiee.mml.Project;
import java.util.HashMap;
import java.security.*;
import java.io.*;
import miiee.mml.MMLException;  
import miiee.mml.MMLConfigCommand;
import miiee.mml.MMLConfigArg;

//---- SMEClient ---------------------------------------------------------

public class SMEPortalClient extends SNPClient  {  

  ViewserverControlPanel _viewserver;
  StringBuffer _buffer = new StringBuffer(); 
  SMEInterface _sme_interface;
  boolean bPause = true;
  boolean bInitialized = false;
  PortalInformationPanel _variableInformationPanel;
  String _scenario;
  ConfigurationPanel _configPanel;
  int _config_index = -1;
  static int _port = 17735;


 // fields for connection panel
 
    static String[] ConnectOptionNames = { "Connect", "Cancel" };
    static String   ConnectTitle = "Connection Information";
	static JPanel      connectionPanel;
    static JLabel      userNameLabel;
    static JTextField  userNameField;
    static JLabel      passwordLabel;
    static JTextField  passwordField;
    static JLabel      serverLabel;
    static JTextField  serverField;
    static JLabel      portLabel;
    static JTextField  portField;
 
  public SMEPortalClient( String host, int port, int mode, int shell_mode, String scenario ) { 
	super(host,port); 
	_scenario = scenario;
	System.out.println( "Connecting to host " + host + " using port " + port );
	_sme_interface = new SMEInterface(this,mode);
	_variableInformationPanel = new PortalInformationPanel( _sme_interface, shell_mode );
  }

  public String getScenarioName() { return _scenario; }
  public  Variable getVariable(  String full_name ) { return  null; }
  
  public int connect( String username, String password ) throws SNPException, java.net.UnknownHostException  {
	  open();
	  System.out.println( "opened host, logging in with user:" + username + ", pw: " + password );
	  return login( username, password );
  }
  
  public SMEInterface getInterface() { return _sme_interface; }
  
  public void shutdown( boolean closeWindow ) { _sme_interface.shutdown( closeWindow ); }
	  
  public void show_control_panel() {
	int mode = _sme_interface.getMode();
	SimIO.print("Starting up SME interface, mode: " + mode );
	if( mode == SMEInterface.kRun ) {
	  _sme_interface.addPanel( "Control", _variableInformationPanel.getPanel() );
	}
	_sme_interface.show(true);
  }
	  
  public void refresh() { ; }  
  public void setStandAlone() { _sme_interface.setStandAlone(); }
  
   
  public ViewserverControlPanel getViewserver() { return _viewserver; } 

  public static String[] startupSME( String project, String proj_directory, String model_id, String scenario, 
															String rhost, String port ) throws XMLException, IOException {
	return startupSME( project, proj_directory, model_id, scenario, rhost, port, ProjectHandler.LOCAL_MODE );
  }

  public static String[] startupSME( String project, String proj_directory, String model_id, String scenario, 
															String rhost, String port, int _interaction_mode ) throws XMLException, IOException {
	if( proj_directory.equals("local") ) { proj_directory = SimIO.getCodebase() + "/workbench/SME/Projects/"; }
	String run_script = " SME project " + project + " " + proj_directory + ";";
	run_script +=  " SME model " + model_id + ";";
	run_script += "SME scenario " + scenario + ";";
	if( port == null ) { port = Integer.toString(++_port); }
	int debug = 2;
	switch( _interaction_mode ) {
	  case ProjectHandler.LOCAL_MODE: {
		if( rhost == null ) {
		  run_script += "SME -java local run ";
		} else {
		  run_script += "SME -java " + rhost + " -CSport " + port + " run ";
		}
	  } break;
	  case ProjectHandler.GLOBUS_MODE: {
		try {
		  System.out.println( "Running model " + project + " : " + model_id + " with globus "  );
		  miiee.globus.SMEGram build_request = new miiee.globus.SMEGram( rhost, project, model_id );  
		  build_request.run(miiee.globus.SMEGram.SME_RUN_CMD);  
		} catch( Exception err ) {
		  SimIO.show_error( null, "Globus error: ", err );
		}
	  } break;
	}
	System.out.println( "\nstartupSME: Running model " + model_id + " with run script: " + run_script );
	ScriptExecutable se = new ScriptExecutable(false);
	se.execute(run_script,null);
	String lhost = SimIO.getLocalHostAddress();
	String rv[] = { lhost, port };
	return rv;
  }
  
  public ModelObjectTree getModelObjectTree() { return _variableInformationPanel.getModelObjectTree(); }
  
  public void addParameter( String mod, String var, String label, String doc, float pval, float pmax, float pmin ) {
	_variableInformationPanel.addParameter(mod, var, label, doc, pval, pmax, pmin ); 
  }
  
   public static SMEPortalClient startupPortalClient( String alt_port, String host, String model, String scenario, boolean useDebugger, int mode, int shell_mode )  {
	// connect to server 
	SMEPortalClient client = null;
	String port = (alt_port==null) ? "17736" : alt_port;
	
	while( client == null ) {
	  client = getNewClient(host,port,mode,shell_mode,scenario);
	}
	try {
	  int code; 
	  client.set_model(model);

	  /* start remote driver */
	  code = client.run_model();
	  System.out.println("run_model returned code " + code);
	  
	  
	  /* init simulation */

	  /* cut the info messages */
	  ConfigCommand cc = new ConfigCommand("debugLevel");
	  cc.addArg("0");
	  code = client.sme_configure_object( "SME", cc );
	  System.out.println("sme_configure_object returned code " + code);
	  
	  client.show_control_panel(); 
	  client.initialize();
/*
	  String model_path = client.get_model();
	  int pindex = model_path.indexOf('.');
	  String pname = ( pindex < 0 ) ? model_path : model_path.substring(0,pindex);
	  String mname = ( pindex < 0 ) ? model_path : model_path.substring(pindex+1);
	  String model_spec = "workspace/projects/" + pname + "/" + mname + "/" + mname + "_module.xml";  
	  String model_config = "workspace/projects/" + pname + "/" + mname + "/" + scenario + "/" + mname + "_module.xml";  
	  ProgressDialog pd = new ProgressDialog("Loading Model Specs");
	  pd.show( false ); pd.setValue( 0f );
*/

	  String parm_data = client.sme_xml_cmd ( "scenario_cnfg" );
	  if( parm_data != null ) { 
		client.loadStringResource( parm_data );	  
		ModelObjectTree mt = client.getModelObjectTree();
		TreeModel tm = mt.getTree().getModel();
		Module root = (Module) tm.getRoot();
		int ct0 = root.getChildCount();
		for( int i0=0; i0<ct0; i0++ ) {
		  Module m = (Module) root.getChild(i0);
		  String mod = m.ID();
		  int ct1 = m.getChildCount();
		  for( int i1=0; i1<ct1; i1++ ) {
			Variable v = (Variable) m.getChild(i1);
			String var = v.ID();
			int ct2 = v.getChildCount();
			for( int i2=0; i2<ct2; i2++ ) {
			  MMLConfigCommand cc1 = (MMLConfigCommand) v.getChild(i2);
			  if( cc1.toString().equals("pm") ) {
				MMLConfigArg ca_label = cc1.getArg( "label" );
				MMLConfigArg ca_pval = cc1.getArg( "value" );
				MMLConfigArg ca_pmax = cc1.getArg( "pmax" );
				MMLConfigArg ca_pmin = cc1.getArg( "pmin" );
				MMLConfigArg ca_doc = cc1.getArg( "doc" );
				String label = (ca_label == null) ? "" : ca_label.getValue();
				String pval = (ca_pval == null) ? "0.0" : ca_pval.getValue();
				String doc = (ca_doc == null) ? "" : ca_doc.getValue();
				String pmax = (ca_pmax == null) ? "0.0" : ca_pmax.getValue();
				String pmin = (ca_pmin == null) ? "0.0" : ca_pmin.getValue();
				client.addParameter( mod, var, label, doc, Float.parseFloat(pval), Float.parseFloat(pmax), Float.parseFloat(pmin) );
				System.out.println("Got parameter- " + mod + " : " + var + " (" + label + ") = " + pval + ", range = ( " + pmax + " , " + pmin + " ) " );
			  }
			}
		  }
		}
	  
	  } else {
		Vector parm_list = new Vector( 64, 64 );
		code = client.sme_scenario_parameters(parm_list);
		System.out.println("sme_scenario_parameters returned code " + code);

		int nparm = parm_list.size();
		for ( int i = 0; i < nparm; i++) {
		  /* retrieve variable list for module */
		  String parm_name = (String) parm_list.get(i);
		  int sbreak = parm_name.indexOf(".");
		  String mod = parm_name.substring(0,sbreak);
		  String var = parm_name.substring(sbreak+1);
		  float pmax = client.sme_varinfo_float ( mod, var, "pmax" );
		  float pmin = client.sme_varinfo_float ( mod, var, "pmin" );
		  float pval = client.sme_varinfo_float ( mod, var, "pval" );
		  String label = client.sme_varinfo_string ( mod, var, "comment" );
		  String doc = client.sme_varinfo_string ( mod, var, "doc" );
		  System.out.println("Got parameter- " + mod + " : " + var + " (" + label + ") = " + pval + ", range = ( " + pmax + " , " + pmin + " ) " );
		  
		  client.addParameter( mod, var, label, doc, pval, pmax, pmin );
		}
	  }
	} catch ( SNPException ex ) {
		error( ex.toString() );	
		ex.printStackTrace(); 
	} 
	return client;
  }
  
  public int getViewserverPort() { 
	if( _viewserver == null ) return -1;
	return _viewserver.getPort(); 
  }
    
  public boolean initViewserver( int port ) {
	if( _viewserver == null ) {
	  _viewserver = ViewserverControlPanel.getInstance( port, ViewserverControlPanel.kShellTab );
	  _viewserver.setScenarioName( _scenario );
	  _sme_interface.addPanel("View",_viewserver);
	} 
	return  true; 
  }

  public boolean loadModelResource( String model_spec_resource, String model_config_resource, ProgressDialog pd ) { 
	ModelObjectTree mt = _variableInformationPanel.getModelObjectTree();
	boolean rv = MMLHandler.loadResource(model_spec_resource,mt,MMLHandler.MODEL_DECLARATION);
	if( rv ) { 
	  if( pd != null ) { pd.setValue(0.5f); }
	  MMLHandler.loadResource(model_config_resource,mt,MMLHandler.MODEL_CONFIGURATION); 
	}
	return rv;
  }

  public void loadStringResource( String xml_data ) { 
	ModelObjectTree mt = _variableInformationPanel.getModelObjectTree();
	MMLHandler.loadStringResource(xml_data,mt,MMLHandler.MODEL_DECLARATION);
  }
  
  

    
 public static void main(String args[])  {
	boolean useDebugger = false;
	boolean getMessages = true;
	boolean useSNI = false;
	
	String port = "17736";
	String host = null;	  
	String model = null;
	String scenario = null;
	int mode = SMEInterface.kRun;	  
	int shell_mode = SMEInterface.kGUI;	 
	 
	for( int i=0; i<args.length; i++ ) {
		String arg = args[i];
		SimIO.print("Processing arg: " + arg);
		if( arg.equals("-d") ) {
		  useDebugger = true;
		}
		else if( arg.equals("-p") ) {
		  try {
			  port = args[++i];
			  SimIO.print("Setting Port to " + port);
		  }
		  catch( ArrayIndexOutOfBoundsException ex ) {
			  SimIO.print("Missing Port argument.");
		  }
		}
		else if( arg.equals("-h") ) {
		  try {
			  host = args[++i];
			  SimIO.print("Setting Host to " + host);
		  }
		  catch( ArrayIndexOutOfBoundsException ex ) {
			  SimIO.print("Missing Host argument.");
		  }
		}
		else if( arg.equals("-scen") ) {
		  try {
			  scenario = args[++i];
			  SimIO.print("Setting scenario to " + scenario);
		  }
		  catch( ArrayIndexOutOfBoundsException ex ) {
			  SimIO.print("Missing scenario argument.");
		  }
		}
		else if( arg.equals("-m") ) {
		  try {
			  model = args[++i];
			  SimIO.print("Setting Model to " + model);
		  }
		  catch( ArrayIndexOutOfBoundsException ex ) {
			  SimIO.print("Missing Model argument.");
		  }
		}
		else if( arg.equals("-c") ) {
			  mode = SMEInterface.kConfig;
			  SimIO.print("Setting Mode to config");
		}
		else if( arg.equals("-python") ) {
			  shell_mode = SMEInterface.kPython;
			  SimIO.print("Setting Shell Mode to python");
		}
		else if( arg.equals("-sni") ) {
		  useSNI = true;
		}
	}
	
	SMEPortalClient c = startupPortalClient(port,host,model,scenario,useDebugger,mode,shell_mode);
	c.setStandAlone();	
  }
 
  public void initialize() { 
	if( bInitialized ) return;
	try {
	  int code = sme_open();
	  System.out.println("sme_open returned code " + code);
	  code = sme_configure_viewserver( 17726 );
	  System.out.println("sme_configure_viewserver returned code " + code );

	} catch ( SNPException ex ) {
		error( ex.toString() );	
		ex.printStackTrace(); 
	} 	
	
	bInitialized = true;
  }
  
  public boolean initialized() { return bInitialized; }

    
  public static void createConnectionDialog( String host, String port ) {
 	// Create the labels and text fields.
 	String username = SMEInterface.getProperty("user.name");
 	if( username == null ) { 
	  try {
		  username = System.getProperty("user.name");
	  } catch ( AccessControlException err ) {
		  username = "user";
	  }
	}
	userNameLabel = new JLabel("User name: ", JLabel.RIGHT);
 	userNameField = new JTextField(username);

 	String password = SMEInterface.getProperty("user.password");
 	if( password == null ) { password = ""; }
	passwordLabel = new JLabel("Password: ", JLabel.RIGHT);
	passwordField = new JPasswordField( password );

	if( host == null ) { host = SMEInterface.getProperty("server.host"); }
	if( host == null ) { host = "localhost"; }
	serverLabel = new JLabel("Server: ", JLabel.RIGHT);
	serverField = new JTextField( host, 25 );

	if( port == null ) { port = SMEInterface.getProperty("server.port"); }
	if( port == null ) { port = "10000"; }
	portLabel = new JLabel("Port: ", JLabel.RIGHT);
	portField = new JTextField( port );


	connectionPanel = new JPanel(false);
	connectionPanel.setLayout(new BoxLayout(connectionPanel, BoxLayout.X_AXIS));

	JPanel namePanel = new JPanel(false);
	namePanel.setLayout(new GridLayout(0, 1));
	namePanel.add(userNameLabel);
	namePanel.add(passwordLabel);
	namePanel.add(serverLabel);
	namePanel.add(portLabel);

	JPanel fieldPanel = new JPanel(false);
	fieldPanel.setLayout(new GridLayout(0, 1));
	fieldPanel.add(userNameField);
	fieldPanel.add(passwordField);
	fieldPanel.add(serverField);
	fieldPanel.add(portField);

	connectionPanel.add(namePanel);
	connectionPanel.add(fieldPanel);
  }

  synchronized static SMEPortalClient getNewClient( String host, String port, int mode, int shell_mode, String scenario ) {
	SMEPortalClient client = null;
	if( connectionPanel == null ) createConnectionDialog( host, port );
	if( JOptionPane.showOptionDialog( null, connectionPanel, ConnectTitle,
		   JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE,
                   null, ConnectOptionNames, ConnectOptionNames[0]) == 0 ) {
        try {           
		  client = new SMEPortalClient( serverField.getText(), Integer.parseInt(portField.getText()), mode, shell_mode, scenario );
		  client.connect( userNameField.getText(), passwordField.getText() );
		} catch ( java.net.UnknownHostException ex1 ) {
		  error( ex1.toString() );
		} catch ( SNPException ex1 ) {
		  error( ex1.toString() );
		  ex1.printStackTrace();
		} catch( NumberFormatException err) {
		  error( "Port must be a number." );
		}
	} else {
	  System.exit(0);
	}
	return client;
  }
}

