package miiee.client;

import java.util.Vector;
import miiee.util.StringVector;
import javax.swing.*;

//---- SNPCommand ---------------------------------------------------------

public class SNPCommand extends StringVector  {
	String _code;
	String _command;
	Icon _icon;
	
	public SNPCommand( String code ) {
	  super(16,16);
	  _code = code;
	}

	public SNPCommand() { super(16,16); }
		
	public void setCode( String code ) {
	  _code = code;
	}

	public String getCode( ) {
	  return _code;
	}

	public Icon getIcon( ) {
	  return _icon;
	}
		
	public void setCommand( String cmd ) {
	  _command = cmd;
	}

	public void setIcon( Icon icon ) {
	  _icon = icon;
	}
	
	public void clear() {  
	  _command = null;  
	  _code = null;  
	  super.clear();  
	}
	  
	protected String getPrefix() { 
	  if( _code == null ) { 
		invalidate(); 
		return ""; 
	  }
	  return ( _command == null ) ? _code : _code + " " + _command;
	}	
}
