package miiee.client;

// import newpackage.*;

//---- newclass ---------------------------------------------------------

public class SNPException  extends Exception {

  /* internal error codes (snp_errno is set to these on SNP_ERROR) */
  public final static int  NOERR  =  (0);    /* reset value */
  public final static int  WRITE   = (101);  /* error writing to server */
  public final static int  NOCONN  = (102);  /* no more connections available */
  public final static int  CONNREF = (103);  /* connection refused by server */
  public final static int  OPENSOCK =(104);  /* can't fdopen sockets */
  public final static int  NOHOST  = (105);  /* host is unreachable */
  public final static int  NOSOCKET =(106);  /* can't get socket */
  public final static int  IREP    = (107);  /* invalid reply */
  public final static int  EOF     = (108);  /* unexpected EOF found on socket */
  public final static int  CLOSECON= (109);  /* connection closed */
  public final static int  TIMEOUT = (110);  /* server timeout */
  public final static int  HANGUP  = (111);  /* server has hung up */
  public final static int  INVCTL  = (112);  /* invalid control stream */
  public final static int  INVUSER = (113);  /* invalid username */
  public final static int  INVPASS = (114);  /* invalid password */
  public final static int  SOCKDUP = (115);  /* can't duplicate control socket */
  public final static int  MEMORY =  (116);  /* can't allocate buffer memory */
  public final static int  FULLCBUF= (117);  /* client response buffer overflow */
  public final static int  SERVER  = (118);  /* unspecified server error */
  public final static int  INTERNAL= (119);  /* internal client error */

  /* these are the errors communicated by the server */
  public final static int  ILLCMD   = (500);  /* wrong command to server */
  public final static int  DTIMEOUT = (501);  /* simulation driver timed out */
  public final static int  DEOF    = (502);  /* eof found on driver output stream */
  public final static int  FULLDBUF= (503);  /* driver answer buffer overflow */
  public final static int  LOGIN   = (530);  /* login error (generic) */
  public final static int  NOLOGIN = (531);  /* operation requires login */
  public final static int  HACC    = (532);  /* host privileges insufficient */
  public final static int  PRACC   = (533);  /* user can't access project */
  public final static int  PRUNDEF = (534);  /* project/model undefined */
  public final static int  NODRIVER= (535);  /* simulation driver does not exist */
  public final static int  DSPAWN  = (536);  /* driver spawn() failed */
  public final static int  NORUN   = (537);  /* model is not running */
  public final static int  NOWEI   = (538);  /* warning/error/info requested unexistent */
  public final static int  INUSE   = (539);  /* simulation driver in use */
  public final static int  SSHUT   = (550);  /* server shutdown at startup */
  public final static int  HAUTH    =(560);  /* client host not authorized */
  public final static int  SABORT  = (570);  /* server abort on configuration error*/
  public final static int  SPIPE   = (580);  /* server caught SIGPIPE on driver */

  int _errno = -1;
  Exception _err;
  String _SNPString;
  StringBuffer _buffer = new StringBuffer(128);
  
  public SNPException( int errno, Exception err  ) { 
	super( getSNPMessage ( errno ) ); 	
	_errno = errno;
	_err = err;
  }

  public SNPException( String msg, Exception err  ) { 
	super( msg ); 	
	_err = err;
  }

  public SNPException( int errno, String msg  ) { 
	super( getSNPMessage ( errno ) ); 	
	_errno = errno;
	_SNPString =  msg;
  }
    
  public int getErrno() { return _errno; }
  public Exception getException() { return _err; }
  public String getSNPString() { return _SNPString; }
  
  public static String getSNPMessage ( int errno ) {
	String msg = "Unknown error";
	switch ( errno ) {
	  case 101:   msg = "error writing to server"; break;
	  case 102:   msg = "no more connections available"; break;
	  case 103:   msg = "connection refused by server"; break;
	  case 104:   msg = "can't fdopen sockets"; break;
	  case 105:   msg = "host is unreachable"; break;
	  case 106:   msg = "can't get socket"; break;
	  case 107:   msg = "invalid reply"; break;
	  case 108:   msg = "unexpected EOF found on socket"; break;
	  case 109:   msg = "connection closed"; break;
	  case 110:   msg = "server timeout"; break;
	  case 111:   msg = "server has hung up"; break;
	  case 112:   msg = "invalid control stream"; break;
	  case 113:   msg = "invalid username"; break;
	  case 114:   msg = "invalid password"; break;
	  case 115:   msg = "can't duplicate control socket"; break;
	  case 116:   msg = "can't allocate buffer memory"; break;
	  case 117:   msg = "client response buffer overflow"; break;
	  case 118:   msg = "unspecified server error"; break;
	  case 119:   msg = "internal client error"; break;
	  case 500:   msg = "wrong command to server"; break;
	  case 501:   msg = "simulation driver timed out"; break;
	  case 502:   msg = "eof found on driver output stream "; break;
	  case 503:   msg = "driver answer buffer overflow"; break;
	  case 530:   msg = "login error (generic)"; break;
	  case 531:   msg = "operation requires login"; break;
	  case 532:   msg = "host privileges insufficient"; break;
	  case 533:   msg = "user can't access project"; break;
	  case 534:   msg = "project/model undefined"; break;
	  case 535:   msg = "simulation driver does not exist"; break;
	  case 536:   msg = "driver spawn() failed"; break;
	  case 537:   msg = "model is not running"; break;
	  case 538:   msg = "warning/error/info requested unexistent"; break;
	  case 539:   msg = "simulation driver in use"; break;
	  case 550:   msg = "server shutdown at startup"; break;
	  case 560:   msg = "client host not authorized"; break;
	  case 570:   msg = "server abort on configuration error"; break;
	  case 580:   msg = "server caught SIGPIPE on driver"; break;
	  case 590:   msg = "driver fatal error"; break;
	}
	return msg;
  }
  
  public String toString() {
	String s = super.toString();
	_buffer.setLength(0);
	_buffer.append( "\n\n" );
	_buffer.append(s);
	if( _SNPString != null )  {
	  _buffer.append(":\n\t");
	  _buffer.append( _SNPString );
	}
	if( _err != null ) {
	  _buffer.append(":\n\t");
	  _buffer.append( _err );
	}
	_buffer.append( "\n\n" );
	return _buffer.toString();
  }

}
