package miiee.client;

import java.beans.Beans;
import java.net.*;
import java.io.*;
import java.util.Vector;
import miiee.util.*;
import java.security.*;

//---- TelnetStream ---------------------------------------------------------

public class TelnetStream extends Object {

	public final static int 	IAC	 = 255;		/* interpret as command: */
	public final static int 	DONT	= 254;		/* you are not to use option */
	public final static int 	DO	= 253;		/* please, you use option */
	public final static int 	WONT	= 252;		/* I won't use option */
	public final static int 	WILL	= 251;		/* I will use option */
	public final static int 	SB	= 250;		/* interpret as subnegotiation */
	public final static int 	GA	= 249;		/* you may reverse the line */
	public final static int 	EL	= 248;		/* erase the current line */
	public final static int 	EC	= 247;		/* erase the current character */
	public final static int 	AYT	= 246;		/* are you there */
	public final static int 	AO	= 245;		/* abort output--but let prog finish */
	public final static int 	IP	= 244;		/* interrupt process--permanently */
	public final static int 	BREAK	= 243;		/* break */
	public final static int 	DM	= 242;		/* data mark--for connect. cleaning */
	public final static int 	NOP	= 241;		/* nop */
	public final static int 	SE	= 240;		/* end sub negotiation */
	public final static int 	EOR	= 239;		/* end of record (transparent mode) */
	public final static int 	ABORT	= 238;		/* Abort process */
	public final static int 	SUSP	= 237;		/* Suspend process */
	public final static int 	xEOF	= 236;		/* End of file: EOF is already used... */
	public final static int 	EOF     =  -1;
	public static final int     kDontPrint  = -1;

  Socket _socket;
  InetAddress _remoteIAddr;
  InetAddress _localIAddr;
  BufferedInputStream _is;
  BufferedOutputStream _os;
  ByteBuffer _buffer = new ByteBuffer(256,256);
  String gActualHostName;  							// Real name (not alias) registered to the host we're connected to.
  String gActualLocalHostName;  					// Real name (not alias) registered to the host we're connected to.
  String gIPStr;  									// Internet Protocol address of host we're connected to, as a string.
  int gPortNumberUsed = -1; 
  int _debug = 0;

  boolean gAttemptingConnection = false;
  boolean gConnected = false;
  byte _dash;
  byte _zero;
  byte _space;
  byte[] _line_terminator;
  
  public TelnetStream() {  
	getReferenceByteValues();
  }

  /* On entry, you should have 'host' be set to a symbolic name (like
   * cse.unl.edu), or set to a numeric address (like 129.93.3.1).
   * If the function fails, it will return NULL, but if the host was
   * a numeric style address, you'll have the ip_address to fall back on.
   */
  
  int open( String host, int port ) throws UnknownHostException, SNPException {
	if( gConnected == true ) return 1;
	gAttemptingConnection = true;
	gActualHostName = host;
	gPortNumberUsed = port;
	
	_remoteIAddr = InetAddress.getByName(host);	
	gActualHostName = _remoteIAddr.getHostName();
	gIPStr = _remoteIAddr.getHostAddress();

	int count = 0;
	IOException ex = null;
	while( true ) {	
	
	   try {
		  _socket = new Socket(_remoteIAddr, gPortNumberUsed);
	   } catch( IOException ex1 ) { 	
		 _socket = null;	
	   }
	   if( _socket != null ) break;	  
 
/*
	  try {
		SocketPermission sp = new SocketPermission(_remoteIAddr + ":" + gPortNumberUsed,"connect,listen");
		AccessController.checkPermission(sp);
		ex = (IOException) AccessController.doPrivileged( new PrivilegedAction() {
		   public Object run() {
			 try {
				_socket = new Socket(_remoteIAddr, gPortNumberUsed);
			 } catch( IOException ex1 ) { 	
			   _socket = null;	
			   return ex1;
			 }
			 return null; // nothing to return
		   }
		}); 
	  } catch( SecurityException se ) { 	
		SimIO.show_error( null, "Failed Socket open:", se );
	  }
	  if( ex == null ) { break; }
*/

	  try {  Thread.sleep(400L);   }
	  catch (InterruptedException e0) { ; }
	  if( count++ > 50 ) {
		int cont = SimIO.show_confirm2( null, "Attempting to connect to host " + _remoteIAddr 
						+ " on port " + port + ":  no response yet. Continue trying?" );
		if( cont == 0 ) { throw new SNPException( SNPException.NOSOCKET, ex );  }
	  }            
	}
	
	_localIAddr = _socket.getLocalAddress();
	gActualLocalHostName = _localIAddr.getHostName();

	try {
	  _is = new BufferedInputStream( _socket.getInputStream() );
	  _os = new BufferedOutputStream( _socket.getOutputStream() ); 
	} catch ( IOException err ) {
	  throw new SNPException( SNPException.OPENSOCK, err );
	}
	gConnected = true; 
	SimIO.print("Opened socket connection, " + gActualLocalHostName + " -> " + gActualHostName );
	return 1;
  }

  public String getLocalHostName() { return gActualLocalHostName; }
  public String getRemoteHostName() { return gActualHostName; }
  
  public void close() throws IOException {
	if( gConnected == false ) return;
//	SimIO.show_warning( null, " Closing socket connection " );
	if( _is != null ) { _is.close();  }
	if( _os != null ) { _os.close();  }
	_os = null;
	_is = null;
  }

  public void getReferenceByteValues() {
	String s = "0- ";
	byte[] cbytes = s.getBytes();
	_zero = cbytes[0];
	_dash = cbytes[1];
	_space = cbytes[2];
	s = "\r\n";
	_line_terminator = s.getBytes();
  }
  
  // Since the control stream is defined by the Telnet protocol (RFC 854),
  // we follow Telnet rules when reading the control stream.  We use this
  // routine when we want to read a response from the host.
  
  int getTelnetString() throws EOFException, SNPException {
	boolean firstDigit = false;
	try {
	  int c;
	  _buffer.clear();
	  if( _is == null ) { throw new SNPException(SNPException.CLOSECON,"Attempt to get response on closed connection"); }
	  if( _os == null ) { throw new SNPException(SNPException.CLOSECON,"Attempt to send message on closed connection"); }
	  
	  while(true) {
		c = _is.read(); 

		if (c == EOF) {
			throw new EOFException();
		} else if ( !firstDigit && ( (c == '\r' ) || (c == '\n') )  ) {
												// Ignore controls (except EOF) prior to first digit.
		} else if (c == '\r' ) {
												// A telnet string can have a CR by itself.  But to denote that,
												// the protocol uses \r\0;  an end of line is denoted \r\n.
			c = _is.read();
			if (c == '\n') {
			  break;       					// Had \r\n, so done.
			} else if (c == EOF) {		  
			  if( _debug > 1 ) { System.out.println( _buffer.getString() ); }
			  throw new EOFException();
			} else if (c == '\0') {
			  c = '\r';
			  _buffer.add((byte)c);
			} else {
			  if( _debug > 1 ) { System.out.println( _buffer.getString() ); }
			  throw new TelnetProtocolException( " illegal CR ");
			}
		  } else if (c == '\n') {
											  // Really shouldn't get here.  If we do, the other side
											  // violated the TELNET protocol, since eoln's are CR/LF,
											  // and not just LF.
			if( _debug > 1 ) { System.out.println( _buffer.getString() ); }
			throw new TelnetProtocolException( " raw LF");
		  } else if (c == IAC) {
			/* Since the control connection uses the TELNET protocol,
			 * we have to handle some of its commands ourselves.
			 * IAC is the protocol's escape character, meaning that
			 * the next character after the IAC (Interpret as Command)
			 * character is a telnet command.  But, if there just
			 * happened to be a character in the text stream with the
			 * same numerical value of IAC, 255, the sender denotes
			 * that by having an IAC followed by another IAC.
			 */

			/* Get the telnet command. */
			c = _is.read();

			switch (c) {
				case WILL:
				case WONT:
				  /* Get the option code. */
				  c = _is.read();

				  /* Tell the other side that we don't want
				   * to do what they're offering to do.
				   */
				   writeCommand( DONT, c );
				  break;
				case DO:
				case DONT:
				  /* Get the option code. */
				  c = _is.read();

				  /* The other side said they are DOing (or not)
				   * something, which would happen if our side
				   * asked them to.  Since we didn't do that,
				   * ask them to not do this option.
				   */
				   writeCommand( WONT, c );
				  break;

				case EOF:
				  throw new EOFException();

				default:
			  /* Just add this character, since it was most likely
			   * just an escaped IAC character.
			   */
			  _buffer.add((byte)c);
			}
		  } else {
			_buffer.add((byte)c);
			firstDigit = true;
		  }
	  }	  
	} catch( TelnetProtocolException ex1 ) {
	  throw new SNPException("Telnet protocol exception",ex1);
	} catch ( IOException ex2 ) {
	  if( EOFException.class.isInstance(ex2) ) {
		throw (EOFException)ex2;
	  }
	  throw new SNPException("IO Error getting response: " + _buffer + " : " ,ex2);
	}
	return 0;
  }
  
  public String getCurrentTelnetString() { 
	return _buffer.getString(); 
  }

  public void writeCommand( int b0, int b1 ) throws IOException, SNPException {
	if( _os == null ) { throw new SNPException(SNPException.CLOSECON,"Attempt to send message on closed connection"); }
    _os.write(IAC); 
    _os.write((byte)b0); 
    _os.write((byte)b1);
	_os.flush();
  }

  public void writeLine( byte[] data ) throws IOException, SNPException  {
	if( _os == null ) { throw new SNPException(SNPException.CLOSECON,"Attempt to send message on closed connection"); }

	if( _debug > 1 ) {
	  System.out.println();
	  System.out.print( "\nJAVA: Sending telnet string :  " );
	  System.out.write( data );
   }

    _os.write( data ); 
    _os.write( _line_terminator );
	_os.flush();	
  }

  public int getResponse( Response rp ) throws SNPException {

	/* You can tell us to do the default action on the response,
	 * or tell us to ignore the response if the caller doesn't want
	 * to handle it.
	 */
	int codeType = -1;
	try {
	  if ( rp == Response.kDefault ) {
		rp = new Response();
	  } else if ( rp == Response.kIgnore ) {
		rp = new Response();
		rp.printMode = kDontPrint;
	  }  else {
		rp.clear();
	  }

	  /* RFC 959 states that a reply may span multiple lines.  A single
	   * line message would have the 3-digit code <space> then the msg.
	   * A multi-line message would have the code <dash> and the first
	   * line of the msg, then additional lines, until the last line,
	   * which has the code <space> and last line of the msg.
	   *
	   * For example:
	   *	123-First line
	   *	Second line
	   *	234 A line beginning with numbers
	   *	123 The last line
	   */

	  /* Get the first line of the response. */

		try {
		  getTelnetString();
		} catch ( EOFException err ) {
		  processEOF( rp, err );
		  return -1;
		} 

		String code0 = _buffer.getString(0, 3);	
		codeType = rp.codeType = _buffer.get(0) - _zero;
		boolean continuation = ( _buffer.get(3) == _dash );
		try {
		  rp.code = Integer.parseInt( code0 );
		} catch ( NumberFormatException err ) {
		  SimIO.show_warning( null, " Telnet Number format exception: " + code0 );
		  rp.code = 0;
		}
		rp.addLine( _buffer.getString(4) );

		while (continuation) {
		  try {
			getTelnetString();
		  } catch ( EOFException err ) { 
			  processEOF( rp, null );
		  }

		  String code1 = _buffer.getString(0, 3);	
		  if ( code1.equals(code0) ) {
			if ( _buffer.get(3) == _space ) {
			  continuation = false;
			}
		  }
		  if( continuation ) {
			rp.addLine( _buffer.getString() );
		  } else {
			rp.addLine( _buffer.getString(4) );
		  }
		}

		if (rp.code == 421) {
		  /*
		   *   421 Service not available, closing control connection.
		   *       This may be a reply to any command if the service knows it
		   *       must shut down.
		   */
			processEOF( rp, null );
		}

		if( codeType == 5 ) {
				//   Server sent an error code.
		  if( !((rp.code == SNPException.DEOF) && rp.eofOkay) ) {  // ignore EOF errors when closing connection.
//			if( rp.code == SNPException.DTIMEOUT ) {
//			  SimIO.print( " Driver timeout " );
//			}	else {  
			  throw new SNPException( rp.code, _buffer.getString() );
//			}
		  }

		} 
	  
	  if( _debug > 0 ) {	  
		System.out.print("\nJAVA: Got response(" + rp.code + "): " + rp.toString() );
		System.out.flush();
	  }

	  return (codeType);
	} catch( EOFException err ) {
	  throw new SNPException( SNPException.EOF, err );
	}
  }	


  private void processEOF( Response rp, EOFException err  ) throws EOFException, SNPException {
	  /* Most of the time, we don't want EOFs from the other side. */
	  SimIO.print( "Processing EOF" );
	  rp.hadEof = true;
	  rp.addLine( _buffer.getString(3) );
	  
	  try {
		if ( gAttemptingConnection == false ) {
		  close();
		} else if ( rp.eofOkay == false ) {
		  /* Give up and return to Open(). */
		  close();
		}	/* else rp.eofOkay, which meant we already closed. */
	  } catch ( IOException ex1 ) { ; }
	  
	  if ( rp.eofOkay == false ) {
		throw new SNPException( SNPException.CLOSECON, err );
	  }
  }
}

class EOFException extends IOException {
  public EOFException() { super(" Unexpected EOF "); }
}

class TelnetProtocolException extends IOException {
  public TelnetProtocolException( String s ) { super(" Telnet protocol violation: " + s ); }
}
