package miiee.client;

import java.util.*;
import org.xml.sax.Attributes;
import javax.swing.*;
import miiee.mml.*;
import miiee.xml.*;
import miiee.util.*;

public class Variable extends ConfigurableObject {

	public static final int DEFAULT = 0;
	public static final int MAP = 1;
	public static final int TIMESERIES = 2;
	public static final int PTS = 3;
	public static final int DBASE = 4;
	public static final int PARAMETER = 5;
	
    protected Vector _actions;
    protected static Vector _arrayConfigs;
    protected StringVector _arrays;
    protected boolean _isSpatial = false;
    protected boolean _isTemporal = false;
    protected boolean _isFlux = false;
    protected boolean _isState = false;
    protected boolean _isImport = false;
    protected boolean _isExport = false;
    protected boolean _isClamped = false;
    protected boolean _isDualConnection = false;
 //   protected boolean _iHasNegFlux = false;
    protected boolean _isDisplayed = false;
    protected boolean _hasVarData = false;
    protected byte _mode;
    protected byte _varType;
    protected byte _initMode;
    protected Module _module;
    protected float _value;
    protected final static byte[] _ref_byte = (new String("01")).getBytes();

	protected static Icon _statevarIcon = null;
	protected static Icon _fluxIcon = null;
	protected static Icon _auxvarIcon  = null;
	protected static final boolean _debug = false;

   static {
	  _statevarIcon      = SimIO.loadIcon(  "statevar.gif" );
	  _fluxIcon      = SimIO.loadIcon(  "flux.gif" );
	  _auxvarIcon      = SimIO.loadIcon(  "auxvar.gif" );
	  _arrayConfigs = new Vector();
	}

    public Variable( String name, Module m, boolean isSpatial, boolean isTemporal, 
											boolean isImport, boolean isFlux, boolean isState ) {
        super(name);
        _module = m;
        _isSpatial = isSpatial;
		_isTemporal = isTemporal;
		_isImport = isImport;
		_isFlux = isFlux;
		_isState = isState;
		setProperties();
		_hasVarData = true;	
    }

    public Variable( String name, Module m, String var_data ) {
        super(name);
        _module = m;
        setVariableData( var_data );
    }

    public Variable( String name, Module m ) { 
        super(name);
        _module = m;
	}

	public  Variable( Attributes atts, Module m ) throws XMLException {
	   super(atts,null);
	   _module = m;
	} 
	
	public String FullName() { 
	  XMLComponent p = getParent();
	  return  (p == null) ? ID() : p.ID() + "." + ID(); 
	}
	
	public boolean hasVarData() { return _hasVarData; }
		
	public void setVariableData( String var_data ) {
		_hasVarData = true;
		_icon = null;
        int cnt = 0;
        byte[] bytes = var_data.getBytes();
        _isSpatial = bytes[cnt++] == _ref_byte[1];
		_isTemporal = bytes[cnt++] == _ref_byte[0];
		_isState = bytes[cnt++] == _ref_byte[1];
		_isFlux = bytes[cnt++] == _ref_byte[1];
		_isImport = bytes[cnt++] == _ref_byte[1];
		_isExport = bytes[cnt++] == _ref_byte[1];
		_isClamped = bytes[cnt++] == _ref_byte[1];
		_isDualConnection = bytes[cnt++] == _ref_byte[1];
//		_iHasNegFlux = bytes[cnt++] == _ref_byte[1];
		_mode = (byte) (bytes[cnt++] - _ref_byte[0]);
		_initMode = (byte) (bytes[cnt++] - _ref_byte[0]);
		_varType = (byte) (bytes[cnt++] - _ref_byte[0]);
		String value = new String( bytes, cnt, bytes.length - cnt ); 
		_value = Float.valueOf(value).floatValue();
		setProperties();
		if( _debug ) {
		  System.out.println( "Setting variable data for " + FullName() + " : " + var_data + " -> ( " +  
		  _isSpatial + ',' + _isTemporal + ',' + _isState + ',' + _isFlux + ',' + _isImport + ',' + _isExport +
		  ',' + _isClamped + ',' + _isDualConnection  + ',' + _mode + ',' + _initMode + ',' + _varType + ')' );	
		}
    }
    
	public boolean processAttribute( String name, String value, String type ) {
	  if( name.equals("status_data") ) {
		setVariableData( value ); 
		return false;
	  }
	  return super.processAttribute( name, value, type );
	} 
     
    void setProperties() {
	  String variability = ( _isSpatial ? "space " : " " ) + ( _isTemporal ? "time" : "" );
	  addProperty( "variability",  variability );
	  if( !_properties.containsKey("type") ) {
		String type = ( _isState ? "state" : (  _isFlux ? "flux" : "aux" ) );
		addProperty( "type",  type );
	  }
	  String io = ( _isImport ? "import " : " " ) + ( _isExport ? "export" : "" );
	  addProperty( "io_mode",  io );
    }
	
	public float Value() { return _value; }
	public void setValue( float value ) { _value = value; }
	
    public void addAction(Action c)
    {
        if(_actions == null)
            _actions = new Vector(4, 4);
        _actions.addElement(c);
    }

    public boolean isSpatial() { return _isSpatial; }
    public boolean isDisplayed() { return _isDisplayed; }
    public boolean isTemporal() {  return _isTemporal; }
    public boolean isImport() {  return _isImport; }
    public boolean isFlux() {  return _isFlux; }
    public boolean isState() {  return _isState; }
    public int nActions() { return (_actions == null) ? 0 : _actions.size(); }
    public void display() { _isDisplayed = true; }
    public Module getModule() { return _module; }

	public static void addArrayConfig(MMLConfigCommand cc) {
	  _arrayConfigs.add(cc);
	  MMLConfigArg ca = cc.getArg( 0 );
	  String aname = ca.getValue();
	  System.out.println( " Adding array configuration: " + aname );	
	}

	public static MMLConfigCommand getArrayConfig( String name ) {
	  Iterator iter = _arrayConfigs.iterator();
	  while( iter.hasNext() ) {
		 MMLConfigCommand cc = (MMLConfigCommand) iter.next();
		 MMLConfigArg ca = cc.getArg( 0 );
		 String aname = ca.getValue();
		 System.out.println( " Checking array arg: " + aname );	
		 if( name.equalsIgnoreCase(aname) ) return cc;
	  }
	  return null;
	}

	public void addArrayDependencies(MMLConfigCommand cc) {
	  int narg = cc.getArgCount();
	  for( int i=0; i<narg; i++ ) {
		MMLConfigArg ca = cc.getArg( i );
		String aname = ca.getValue();
		addArray( aname );
	  }	
	}
	
	public void addArray( String name ) {
	  if( _arrays == null ) { _arrays = new StringVector(); }
	  _arrays.addArg(name);
	}
	
	public String getArray( int index ) {
	   if( _arrays == null ) { return null; }
	   return _arrays.getArg( index );
	}
	    
	public int getArrayDimension() {
	   if( _arrays == null ) { return 0; }
	   return _arrays.size();
	}
	
	public void processConfiguration( MMLConfigCommand cc ) {
	  super.processConfiguration( cc );
	  String name = (String) cc.getProperty("name");
	  if( name.equals("DD" ) ) {
		_isDisplayed = true;
	  }
	  if( name.equals("Ar" ) ) {
		addArrayConfig(cc);
	  }
	  if( name.equals("ArDep" ) ) {
		addArrayDependencies(cc);
	  }
	  if( name.equals("pm" ) ) {
		try {
		  MMLConfigArg arg0 =  cc.getArg( 0 ) ;
		  String value = arg0.getValue();
		  _value = Float.parseFloat(value);
		} catch ( Exception err ) {
		  System.out.println( ID() + "-> Error in parameter config- no data " );	
		  err.printStackTrace();		
		}
		_initMode = PARAMETER;
	  }
	}
    
    void setIcon() {
	  if( isFlux() ) {
		_icon = _fluxIcon;
	  } else if( isState() ) {
		_icon = _statevarIcon;
	  } else {
		_icon = _auxvarIcon;
	  }
	}
	
	public Icon getIcon() { 
	  if( _icon == null ) setIcon();
	  return _icon; 
	}
	
	public boolean isLeaf() { return (getChildCount() == 0); }

	public String getElementType( int format ) { return "variable"; }

}
