package miiee.client;

import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import java.util.Vector;
import java.util.Random;
import java.util.Date;
import javax.swing.text.*;
import java.util.HashMap;
import java.awt.*;
import java.awt.font.TextAttribute;
import javax.swing.table.*;
import java.text.SimpleDateFormat;
import java.awt.Container;
import javax.swing.tree.*;
import miiee.util.*;
import miiee.mml.*;
import miiee.xml.*;
import miiee.tree.*;
import miiee.dataview.ParameterViewer;
import javax.swing.border.*;
import java.awt.event.*;
import java.util.ListIterator;
import javax.swing.filechooser.*;

public class VariableConfigPanel extends JPanel implements ItemListener {

	protected JButton  _findButton;	
	protected JButton  _editButton;
	protected JButton  _addButton; 
	protected JButton  _deleteButton;
	protected JButton  _saveButton;
	protected int _port;
	protected String  _proj_name;
	protected String _model_name;
	protected String _proj_path;
    protected String _helpText;
    protected String _configFileName;
     protected String _configFileDirectory;
   protected SMEInterface _sme_interface; 
    protected Vector _listBuffer = new Vector(16,16);
    protected StringBuffer _buff = new StringBuffer();
    protected float _stop_time = 100f;
    protected float _time = 0f;
    protected float _DT = 1f;
    protected boolean _run_simulation;
    protected JTextField _codeField;
    protected JTextField _searchField;
    protected static JFrame _frame;
    protected JFrame _varSearchFrame;
	private Font _font; 
	private JScrollBar _treeTableScroller;  
	private ModelTree _model_tree;
	private boolean _initialized = false;
	private boolean _useTreeTable = false;
	private boolean _debug = false;
	protected Module _current_module = null;  
	protected Variable _current_variable = null;
 
	public VariableConfigPanel( SMEInterface intf, XMLContainer root ) {
	  super();
	  generateHelpText();
	  _sme_interface = intf;
	  if( root == null ) { root = new Module("global" ); }
	  _model_tree = new ModelTree( (Module) root );	
	}
	
	public  Variable getVariable(  String full_name ) { return 	_model_tree.getVariable( full_name ); }
		
	public void init() {
	  if( !_initialized ) {
		_initialized = true;
		setLayout( new BorderLayout() );
		setFontSize( 10f );

		JTextArea ta = new JTextArea(100,70);
		ta.setMargin( new Insets( 4, 4, 4, 4 ) ); 
		ta.setWrapStyleWord(true);
		ta.setLineWrap(true);
		ta.setBackground( new Color(0, 0, 200) );
		ta.setForeground( Color.yellow );

		Border bb = new SoftBevelBorder(SoftBevelBorder.LOWERED);  	
		JScrollPane scrollpane1 = new JScrollPane();
		scrollpane1.getViewport().setView(ta);
		scrollpane1.setPreferredSize(new Dimension( 300, 100 ));
		scrollpane1.setBorder( bb );
		add(scrollpane1, "North" );

		JPanel status_panel = new JPanel(true);
		status_panel.setBorder( bb );
		add(status_panel, "South" );
		
		add( create_data_panel(), "Center" );
		XMLTree tree = _model_tree.getTree();
		tree.addTreeSelectionListener( new ConfigPanelDocListener(ta,tree) );	  
		XMLTree data_tree = tree.getDataTree();
		data_tree.addTreeSelectionListener( new ConfigPanelDocListener(ta,data_tree) );	  
		setBorder( BorderFactory.createEtchedBorder() );
	  }		
	}
	
	public void refresh() { _model_tree.refresh(); }
 
	public void setEditingEnabled( boolean enable ) { 
	  _editButton.setEnabled(enable);	
	  _addButton.setEnabled(enable);	
	  _deleteButton.setEnabled(enable);	
	  _saveButton.setEnabled(enable);	
	}
	
	public void setFrame( JFrame f ) { _frame = f; }
	
	JPanel create_data_panel() {

	  EmptyBorder eb7 = new EmptyBorder( 7, 7, 7, 7 );	
	  EmptyBorder eb3 = new EmptyBorder( 3, 3, 3, 3 );
	  BoxLayout bl;	
	  	  	   
	  JPanel pV0  = new JPanel(false);
	  bl = new BoxLayout(pV0, BoxLayout.Y_AXIS );  pV0.setLayout( bl ); 
	  	   
	  Border bb = BorderFactory.createCompoundBorder( new BevelBorder(BevelBorder.LOWERED), eb3 );  	pV0.setBorder( bb );
	  pV0.setMaximumSize(new Dimension(Short.MAX_VALUE,  Short.MAX_VALUE)); 
	  	  	  
	  JLabel title = new JLabel("Configure Simulation Objects:");
	  title.setBorder(eb7);
	  title.setAlignmentX(Component.CENTER_ALIGNMENT);
	  pV0.add(title);
	  
	  JScrollPane scrollPane = new JScrollPane();
	  JPanel p = _model_tree.getTree().getDisplayPanel();
	  p.setBorder( BorderFactory.createEtchedBorder() );
	  pV0.add( p );
	  
	  if( _sme_interface != null ) {
	     _model_tree.getTree().addTreeExpansionListener( new ConfigurationDataListener( _sme_interface.getClient(), _model_tree.getTree() ) );
	  }
	  
	  JPanel buttonPanel  = new JPanel(false);
	  bl = new BoxLayout(buttonPanel, BoxLayout.X_AXIS );  buttonPanel.setLayout( bl ); 
	  buttonPanel.setBorder( eb7 );

	  _findButton = new JButton("Find");
	  _findButton.setToolTipText( "find variable" );
	  _findButton.addActionListener( new FindAction() );
	  _findButton.setMaximumSize( new Dimension( Short.MAX_VALUE, 50 ) );
	  buttonPanel.add( _findButton );
	    
	  _addButton = new JButton("Add");
	  _addButton.setToolTipText( "add configuration" );
	  _addButton.addActionListener( new AddConfigAction() );
	  _addButton.setMaximumSize( new Dimension( Short.MAX_VALUE, 50 ) );
	  buttonPanel.add( _addButton );

	  _editButton = new JButton("Edit");
	  _editButton.setToolTipText( "edit selected configuration" );
	  _editButton.addActionListener( new EditConfigAction() );
	  _editButton.setMaximumSize( new Dimension( Short.MAX_VALUE, 50 ) );
	  buttonPanel.add( _editButton );

	  _deleteButton = new JButton("Delete");
	  _deleteButton.setToolTipText( "delete selected configuration" );
	  _deleteButton.addActionListener( new DeleteConfigAction() );
	  _deleteButton.setMaximumSize( new Dimension( Short.MAX_VALUE, 50 ) );
	  buttonPanel.add( _deleteButton );

	  _saveButton = new JButton("Save");
	  _saveButton.setToolTipText( "save configuration" );
	  _saveButton.addActionListener( new SaveConfigAction() );
	  _saveButton.setMaximumSize( new Dimension( Short.MAX_VALUE, 50 ) );
	  buttonPanel.add( _saveButton );
	  
	  buttonPanel.setMaximumSize( new Dimension( Short.MAX_VALUE, 50 ) );
	  buttonPanel.setPreferredSize( new Dimension( 500, 40 ) );
	  pV0.add( buttonPanel );
	  
	  return pV0;
	}

    public void itemStateChanged(ItemEvent e) {
//	  _creationButton.setEnabled( ViewerData.getSelectionIndex() >= 0 );
//	  _closeButton.setEnabled( ViewerData.getSelectionIndex() >= 0 );
    }
	
	public void treeValueChanged( TreeSelectionEvent e) {;}

	public void showVarSearch() {
	  if( _varSearchFrame == null ) { 
		_varSearchFrame = new JFrame("Search");
		WindowListener l = new WindowAdapter() {
			public void windowClosing(WindowEvent e) { ; }
		};
		_varSearchFrame.addWindowListener( l );
		EmptyBorder eb7 = new EmptyBorder( 7, 7, 7, 7 );	
		JPanel search_panel = (JPanel)_varSearchFrame.getContentPane();	

		JLabel msgLabel = new JLabel("Find next variable whose name contains:", JLabel.RIGHT);
		msgLabel.setBorder( eb7 );

		JPanel button_panel  = new JPanel( new FlowLayout() );
		button_panel.setBorder( eb7 );
		JButton  cancelButton = new JButton("cancel");
		cancelButton.addActionListener( new VarSearchCancelAction() );
		button_panel.add(cancelButton);
		JButton  findButton = new JButton("find");
		findButton.addActionListener( new VarSearchFindAction() );
		button_panel.add(findButton);
		
		_searchField = new JTextField(30);
		_searchField.setBorder( new BevelBorder(BevelBorder.LOWERED)  );

		search_panel.add( "North", msgLabel );
		search_panel.add( "Center", _searchField );
		search_panel.add( "South", button_panel );
		_varSearchFrame.pack();
		_varSearchFrame.setResizable(false);

		Dimension         paneSize = _frame.getSize();
		Dimension         screenSize = _frame.getToolkit().getScreenSize();
		_varSearchFrame.setLocation((screenSize.width - paneSize.width) / 2,
					(screenSize.height - paneSize.height) / 2);
	  } 
	  _varSearchFrame.setVisible(true);
	}
	
	class VarSearchCancelAction extends QueuedExecutable  {
	  public void execute() {
		_varSearchFrame.setVisible(false);
	  }
    } 
    
	class VarSearchFindAction extends QueuedExecutable  {
	  public void execute() {
		String value = _searchField.getText();
		float fvalue = _model_tree.selectNextVariableContaining(value); 
		if( fvalue >= 0f ) { scrollTreeTable( fvalue ); } 
	  }
    }
        
    void creatConfiguration(  XMLData defaults ) {
	  ConfigurableObject targ = (ConfigurableObject) getSelectedObject();
	  int level = targ.getQualifiedName( _buff );
	  String targ_name = _buff.toString();
	  XMLData xcmd = null;
	  ConfigCommand cc = null;
	  if( defaults == null ) {   
		xcmd = (XMLData) ConfigurableObject.getConfigurationCommand(level);
		if( xcmd != null ) {
		  cc = new ConfigCommand( ConfigurableObject.getBaseName(xcmd.ID()) ); 
		}
	  } else {
		cc = (ConfigCommand) defaults.getProperty( "command" );
		xcmd = (XMLData) defaults.getProperty( "config" );
		if( xcmd == null ) {
		  JOptionPane.showMessageDialog( null, "Can't find structural data on this Command", "XML error", JOptionPane.ERROR_MESSAGE );
		  return;
		}
	  }
	  if( ( cc != null ) && cc.createWizard( xcmd ) ) {
		try {
		  if( _sme_interface != null ) {
		    _sme_interface.getClient().sme_configure_object( targ_name, cc ) ;
		    refresh_tree( targ ); 
		  } 
		  targ.addConfiguration ( level, cc );	
		} catch ( Exception err ) {
		  JOptionPane.showMessageDialog( null, "Configuration execution error: " + err.getMessage(), "XML error", JOptionPane.ERROR_MESSAGE );
		}
	  }
    }

	class AddConfigAction  extends QueuedExecutable   {
	  public AddConfigAction() { super("Add",null); }
	  public void execute() {
		creatConfiguration(  null );
	  }
    }
    
    XMLData getSelectedDataElement() {
	   XMLComponent obj = _model_tree.getTree().getSelectedComponent();
	   XMLData data = null;
	   try {
		 data = (XMLData)obj;
	   } catch ( ClassCastException err ) { 
		  JOptionPane.showMessageDialog( null, "Must select a data element to edit", "XML error", JOptionPane.ERROR_MESSAGE );
	   }
	   return data;
    } 
    
	class EditConfigAction  extends QueuedExecutable   {
	  public EditConfigAction() { super("Open",null); }
	  public void execute() {
		 XMLData data = getSelectedDataElement();
		 creatConfiguration(  data );
	  }
    }
     
	class DeleteConfigAction  extends QueuedExecutable   {
	  public DeleteConfigAction() { super("Open",null); }
	  public void execute() {
		 XMLData data = getSelectedDataElement();
		 if( data != null ) {
		   ConfigurableObject targ = (ConfigurableObject) getSelectedObject();
		   int level = targ.getQualifiedName( _buff );
		   String targ_name = _buff.toString();
		   ConfigCommand cc = (ConfigCommand) data.getProperty( "command" );
		   try {
		      if( _sme_interface != null ) {
			    _sme_interface.getClient().sme_delete_configuration(targ_name,cc);
			    refresh_tree( targ ); 
		      }
		   } catch( SNPException err ) {
			  JOptionPane.showMessageDialog( null, "Error deleting cmd: " + err.getMessage(), "XML error", JOptionPane.ERROR_MESSAGE );
		   }
		 }
	  }
    }

	class SaveConfigAction  extends QueuedExecutable   {
	  public SaveConfigAction() { super("Save",null); }
	  public void execute() {
		 try {
		   if( _sme_interface != null ) {
			   String model = _sme_interface.getClient().get_model();
			   _configFileName = model + ".conf.out";
		   }
		   Frame f = (_sme_interface == null ) ? _frame : _sme_interface.getFrame();
		   String name = SimIO.showTextInputDialog( f, "Config File Name:", "Save Configuration", _configFileName  );
		   if( name != null ) {
			 if( _sme_interface != null ) {
			 	if( _debug ) { SimIO.print( "Saving configuration to file: " + name ); }
			 	_sme_interface.getClient().sme_save_configuration(name);
			 } else {
			 	File file = new File(_configFileDirectory,name);
			 	saveConfigutationToFile(file);
			 }
		   }
		 } catch( SNPException err ) {
			JOptionPane.showMessageDialog( null, "Error deleting cmd: " + err.getMessage(), "XML error", JOptionPane.ERROR_MESSAGE );
		 }
	  }
    }
    
    void saveConfigutationToFile( File f ) {
 		if( _debug ) { SimIO.print("Saving configuration to file: " + f.getPath() ); }
	    BufferedWriter out = null;
	    try {
		  FileOutputStream fos = new FileOutputStream( f );
		  out = new BufferedWriter(new OutputStreamWriter(fos));
	    } catch ( Exception e ) {
		  SimIO.print( "Error opening file stream: " + f.getPath() ); 
		  return;
	    }
	    XMLContainer top_node = _model_tree.getRoot();

	    try {
		    for( int i=0; i<top_node.getChildCount(); i++ ) {
			    ConfigurableObject cobj = (ConfigurableObject)top_node.getChild(i);
	  		    String cmds = cobj.getCommands(); 
	   		    out.write("$ ");	
	  		    out.write( cobj.ID() );	
	 		    out.write(cmds);	
		 		out.write("\n");	
			    for( int j=0; j<cobj.getChildCount(); j++ ) {
				  ConfigurableObject cobj1 = (ConfigurableObject)cobj.getChild(j);
		  		  String cmds1 = cobj1.getCommands(); 
		   		  out.write("* ");	
		  		  out.write( cobj1.ID() );	
		  		  int nspace = 35 - cobj1.ID().length();
		  		  if( nspace < 1 ) nspace = 1;
		  		  for( int k=0; k<nspace; k++ ) { out.write(' '); }
		 		  out.write(cmds1);	
		 		  out.write("\n");	
			    }		
		    }
		    out.close();
	    } catch( Exception err ) {
		  SimIO.print( "Error writing to file: " + f.getPath() ); 
		  err.printStackTrace();
		  return;
	    }		
     }
    
    void refresh_tree( ConfigurableObject targ ) throws SNPException {
      if( _sme_interface != null ) {
	    targ.invalidate_config_data();
	    targ.getConfigurationData( _sme_interface.getClient(), false );
	    _model_tree.getTree().reload( targ );
      }
	} 

	class OpenAction  extends QueuedExecutable   {
	  public OpenAction() { super("Open",null); }
	  public void execute() {;}
    } 

	class SaveAction  extends QueuedExecutable   {
	  public SaveAction() { super("Save",null); }
	  public void execute() {;}
    } 
    
	public DataSet getParameters( Vector map ) {
	  return  _model_tree.getParameters( map, _sme_interface.getClient() );
	}
			
	private void show_messages( Vector info, Vector warn, Vector error ) {
	
	}
	
	private void scrollTreeTable( float fvalue ) {
	  if( _treeTableScroller == null ) return;
	  int max = _treeTableScroller.getMaximum();
	  int min = _treeTableScroller.getMinimum();
	  int ivalue = (int) (min + (max-min)*fvalue);
	  _treeTableScroller.setValue(ivalue); 
	  repaint();
	}

	public XMLComponent getSelectedObject() {
	  TreePath tp =  _model_tree.getSelectionPath();
	  return (XMLComponent) ((tp==null) ? null : tp.getLastPathComponent());
	}

	public Variable getSelectedVariable() {
	  Variable v = null;
	  TreePath tp =  _model_tree.getSelectionPath();
	  if( tp == null ) return null;
	  XMLContainer tn = (XMLContainer) tp.getLastPathComponent();
	  XMLContainer mn = (XMLContainer) tp.getPathComponent(1);
	  try { 
		v = (Variable)tn;
		if( _debug ) {  
		  System.out.println("\nGot module:" + v._module.ID());
		  System.out.println("\nGot variable:" + v.ID() );
		}
	  } catch( NullPointerException err ) {
		SimIO.beep();
	  } catch( ClassCastException err ) {
		SimIO.beep();
	  }
	  return v;
	}

    class FindAction extends QueuedExecutable  {
	  public void execute() { showVarSearch(); }
	} 
	
    class ViewAction  extends QueuedExecutable   {
	  public void execute() {
		Variable v = getSelectedVariable();
		try { 
		  if( _sme_interface != null ) {
		    _sme_interface.getClient().sme_var_browse_data ( v._module.ID(), v.ID(), false, true );
		  }  
		} 
		catch ( SNPException err ) { System.out.println( err ); }
		catch ( NullPointerException err ) { System.out.println( "No known Variable selected" ); }
	  }
	}
     
    public XMLContainer addModule( Module m ) {
	  return  _model_tree.addModule(m);
	}
    public XMLContainer addVariable(  XMLContainer module_node, Variable v ) {
	  return  _model_tree.addVariable(module_node,v);
	}
	public XMLContainer addDependency( XMLContainer var_node, Variable v ) {
	  return  _model_tree.addDependency(var_node,v);
	}

	public void valueChanged(TreeSelectionEvent e) {
	  TreePath tp = e.getNewLeadSelectionPath();
	  XMLContainer tn = (XMLContainer) tp.getLastPathComponent();
	  Action a = null;
	  try { 
		a = (Action)tn;
	  } catch( NullPointerException err ) {
		return;
	  } catch( java.lang.ClassCastException err ) {
		return;
	  }
	  if( a != null ) {
		String code = a.getCode();
		if( _debug ) {  SimIO.print("Action code: " + code ); }
		_codeField.setText(code);
		repaint();
	  }
	}

    public void setFontSize( float font_size ) {
	  HashMap font_attr = new HashMap();
	  font_attr.put( TextAttribute.SIZE, new Float(font_size) );
	  _font = new Font(font_attr);
    }
	    	
	public static void main(String args[])  {
	}
	
	public JPanel getPanel( ) {
	  init();
	  return this;
	}

	public void showConfigEditor( String config_file, boolean writable ) {
	  if( config_file == null ) { 
		SimIO.print("No config file specified.");
		return; 
	  }
	  File f = new File(config_file);
	  if( f.canRead() ) {
		parseConfigFile( f );
		JPanel p = getPanel();
		JFrame frame = new JFrame("Configuration Editor");
		frame.addWindowListener(
			new WindowAdapter() {
			  public void windowClosing(WindowEvent e) { ; }
			}
		);

		frame.getContentPane().add(p);
		frame.setSize(500, 600);
		frame.setVisible(true);
	  } else {
		XMLException.show_error( null, "Can't read config file: " +  config_file );  
	  }
	}
	 	
	void generateHelpText() {;}
	

  public void parseConfigFile( File f ) {
	  String line;
	  int cct, next_cct = -1;
	  StringBuffer buff = new StringBuffer();
	  _configFileName = f.getName();
	  _configFileDirectory = f.getParent();
	  if( _debug ) {  System.out.println("Loading config File [ " + f.getPath() + " ]"); }
	  try {
		  FileReader fr = new FileReader(f);
		  BufferedReader br = new BufferedReader(fr);
		  while((line = br.readLine()) != null) {
			  //System.out.println("--- " + line);
			  String s = line.trim();
			  if( s.length() > 0 ) {
			  	  cct = next_cct;
				  next_cct = controlCharacterType( s.charAt(0) );
				  if( cct >= 0 ) {
					if( buff.length() > 0 ) {
					  parseConfigLine(buff.substring(1),cct);
					  buff.setLength(0);
					}
				  } 			  
				  buff.append(s);
				  buff.append(' ');  
			  }
		  }
	  } catch (FileNotFoundException e) {
		  System.out.println("Cannot find specified file: " +  f.getPath() + ". Please check the path");
	  } catch (IOException e) {
		  System.out.println("IO Exception!");
		  e.printStackTrace();
	  } 
  }
  
  int controlCharacterType( char c ) {
	if ( c == '#' ) return ConfigurationHandler.kModelL;
	if ( c == '$' ) return ConfigurationHandler.kModuleL;
	if ( c == '*' ) return ConfigurationHandler.kVariableL;
	if ( c == '~' ) return ConfigurationHandler.kVariableL;
	return -1;
  }
  
   public void parseConfigLine( String line, int ctype ) {
	 String s = line.trim();
	 StringBuffer name = new StringBuffer();
	 
	 int iloc = 0; char c;
	 try {
	 	while( !Character.isWhitespace( c = s.charAt(iloc++) ) ) { name.append(c); }
	 } catch ( StringIndexOutOfBoundsException err ) { iloc = -1; }
	 String n = name.toString();
	 int commentIndex = ( iloc > 0 ) ? s.indexOf("|",iloc) : -1;
	 if( commentIndex == -1 ) { commentIndex = s.length(); }
	 String cmd_string = ( iloc > 0 ) ? s.substring(iloc,commentIndex) : null;
	 
	 try {
	   switch( ctype ) {
		 case ConfigurationHandler.kModelL:
		   _current_module = (Module) _model_tree.getModule( n );
		   if( _current_module == null ) {
			 _current_module = new Module(n);
			 _model_tree.addModule(_current_module);
		   }
		   _current_module.parseConfigString(cmd_string,ctype);
		 break;
		 case ConfigurationHandler.kModuleL:
		   _current_module = (Module) _model_tree.getModule( n );
		   if( _current_module == null ) {
			 _current_module = new Module(n);
			 _model_tree.addModule(_current_module);
		   }
		   _current_module.parseConfigString(cmd_string,ctype);
		 break;
		 case ConfigurationHandler.kVariableL:
		   _current_variable = (Variable) _model_tree.getVariable( _current_module, n );
		   if( _current_variable == null ) {
			 _current_variable = new Variable(n,_current_module);
			 _model_tree.addVariable(_current_module,_current_variable);
		   }
		   _current_variable.parseConfigString(cmd_string,ctype);
		 break;
	   }
	  } catch ( SNPException err ) {
		  SimIO.print(err.getMessage());
	  }
   }
   

 

}

class ConfigPanelDocListener extends Object implements TreeSelectionListener {
  JTextArea _text;
  XMLTree _tree;
  boolean _debug = false;
  ConfigPanelDocListener( JTextArea ta, XMLTree tree ) {
	_text = ta;
	_tree = tree;
  }
  public void valueChanged(TreeSelectionEvent e) {
	try {
	  XMLData cmd = (XMLData)_tree.getSelectedComponent();
	  if( _debug ) {  System.out.println("Setting doc string from selected element: " + cmd ); }
	  if( cmd != null ) {
		String sdoc = (String) cmd.getProperty("doc");
		if( sdoc == null ) {
		  XMLData cmd_data = (XMLData) cmd.getProperty("config");
		  if( cmd_data != null ) {
			sdoc = (String) cmd_data.getProperty("doc");
		  }
		}
		_text.setText( (sdoc==null) ? "" : sdoc );
		_text.invalidate(); _text.repaint();
	  } else { _text.setText(""); }
	} catch ( ClassCastException err ) { 
	  _text.setText("");
	} 
  }
}

class DocListener extends Object implements ListSelectionListener {
  PropertyTable _table;
  boolean _debug = false;
  DocListener( PropertyTable ta ) {
	_table = ta;
  }
  public void valueChanged(ListSelectionEvent e) {
	Object source = e.getSource();
	if( _debug ) {  System.out.println("Table value selected: " + source ); }
/*
	try {
	  XMLComponent n =  (XMLComponent) e.getPath().getLastPathComponent();
	  _table.setProperties( n.getProperties() );
	} catch ( ClassCastException err ) { 
	  _table.setProperties(null);
	} catch ( NullPointerException err ) { 
	  _table.setProperties(null);
	}
*/
  }
}

class ConfigurationTreeModel extends AbstractTreeTableModel {
    protected static Icon config1;
    protected static Icon config2;
    protected static Icon config3;

	static	{	
	  config1      = SimIO.loadIcon(  "config1.gif" );
	  config2      = SimIO.loadIcon(  "config2.gif" );
	  config3      = SimIO.loadIcon(  "config3.gif" );
	}
	
    // Names of the columns.
    static protected String[]  cNames = {"Name", "1", "2", "3", "4", "5" };

    // Types of the columns.
    static protected Class[]  cTypes = { TreeTableModel.class, String.class, String.class, String.class, String.class, String.class };

    // The the returned file length for directories. 
    public static final Integer ZERO = new Integer(0); 

    public ConfigurationTreeModel( XMLContainer root ) { 
	  super( root ); 
    }

    //
    //  The TreeTableNode interface. 
    //
	
    public int getColumnCount() {
	  return cNames.length;
    }

    public String getColumnName(int column) {
	  return cNames[column];
    }

    public Class getColumnClass(int column) {
	  return cTypes[column];
    }
 
    public Object getValueAt(Object node, int column) {
	  try {
		  Variable v = (Variable)node;
		  if(column == 0 ) { return   v; }
		  else {
			  int config_index = column-1;
			  if( config_index < v.getDataCount() ) {
				Object rv = null;
				XMLData cmd_data = (XMLData) v.getData( config_index );
				if( cmd_data != null ) { 
//				  rv = cmd_data.getIcon(); 
				  rv = cmd_data.toString();
				}
			  }
		  }
	  } catch ( ClassCastException err ) {;}   
	  return null; 
    }
}
 
class ConfigurationDataListener extends QueuedExecutable {
  SNPClient _client;
  ConfigurationDataListener( SNPClient client, JTree tree ) { super(tree); _client = client; }
  public  void execute() {
	 TreePath path = ((TreeExpansionEvent)_event).getPath(); 
	 JTree tree = (JTree)_source;
	  Object target = path.getLastPathComponent(); 
	  try {
		Module m = (Module)target;
		if( m.getConfigurationData( _client, true ) ) {
		  tree.collapsePath(path);
		  tree.expandPath(path);
		}
	  } 
	  catch ( ClassCastException err ) {
		System.out.println("error (SNP): " + err );
		err.printStackTrace(System.out);
	  }
	  catch ( SNPException err ) { System.out.println("error (SNP): " + err ); }
  }
}
