package miiee.client;

import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import java.util.Vector;
import java.util.Random;
import java.util.Date;
import javax.swing.text.*;
import java.util.HashMap;
import java.awt.*;
import java.awt.font.TextAttribute;
import javax.swing.table.*;
import java.text.SimpleDateFormat;
import java.awt.Container;
import javax.swing.tree.*;
import miiee.util.*;
import miiee.mml.*;
import miiee.xml.*;
import miiee.tree.*;
import miiee.dataview.*;
import javax.swing.border.*;
import java.awt.event.*;
import java.util.ListIterator;
import javax.help.*;
import javax.swing.filechooser.*;

public class VariableInformationPanel extends JPanel implements ItemListener, TreeSelectionListener, TableModelListener {

	protected JButton  _creationButton;
	protected JButton  _closeButton;
	protected JButton _editButton; 
	protected JButton _viewButton; 
	protected int _port;
	protected String  _proj_name;
	protected String _model_name;
	protected String _proj_path;
	protected JTreeTable _variableTree;
    protected String _helpText;
    protected SMEInterface _sme_interface;
    protected Vector _listBuffer = new Vector(16,16);
    protected float _stop_time = 100f;
    protected float _time = 0f;
    protected float _DT = 1f;
    protected boolean _run_simulation;
	protected AttributeValuePair _stop_timeAVP;
    protected AttributeValuePair _timeAVP;
    protected AttributeValuePair _timestepAVP;
    protected JTextField _codeField;
    protected JTextField _searchField;
    protected static JFrame _frame;
    protected JFrame _varSearchFrame;
	private Font _font; 
	private JScrollBar _treeTableScroller; 
	private ModelObjectTree _objectTree;
	private boolean _initialized = false;
	private boolean _sim_started = false;


	public VariableInformationPanel( SMEInterface intf, Module root, int shell_mode ) {
	  super();
	  generateHelpText();
	  _sme_interface = intf;
	  if( shell_mode == SMEInterface.kPython ) {
		_objectTree= new ModelObjectTree( new PyVariableTreeModel(root) );
	  } else {
		_objectTree= new ModelObjectTree( new VariableTreeModel(root) );
	  }
	}
	 
	public void addTreeExpansionListener( TreeExpansionListener tsl ) { 
	  _objectTree.addTreeExpansionListener( tsl ); 
	}
		
	public void init() {
	  if( !_initialized ) {
		_initialized = true;
		setLayout( new BorderLayout() );
		_objectTree.addTreeSelectionListener( this );
		setFontSize( 10f );
		CSH.setHelpIDString( this, "ControlPanel" );

		JPanel status_panel = new JPanel(true);
		Border bb = new SoftBevelBorder(SoftBevelBorder.LOWERED);  	
		status_panel.setBorder( bb );
		add(status_panel, "South" );

		JPanel time_step_panel = new JPanel( new FlowLayout() );
		time_step_panel.setBorder( bb );
		status_panel.add( time_step_panel );

		_timestepAVP = AttributeValuePair.New( "time step:", true, 6 );
		try {
		  _timestepAVP.setValue( Float.toString( _DT = _sme_interface.getClient().sme_model_timestep() ) );
		} catch ( SNPException ex ) {  _sme_interface.getClient().error(ex.toString());}
		time_step_panel.add( _timestepAVP );

		JPanel stop_time_panel = new JPanel( new FlowLayout() );
		stop_time_panel.setBorder( bb );
		status_panel.add( stop_time_panel );

		_stop_timeAVP = AttributeValuePair.New( "stop time:", true, 6 );
		_stop_timeAVP.setValue( Float.toString( _stop_time ) );
		stop_time_panel.add( _stop_timeAVP );

		JPanel time_panel = new JPanel( new FlowLayout() );
		time_panel.setBorder( bb );
		status_panel.add( time_panel );

		_timeAVP = AttributeValuePair.New( "current time:", false, 6 );
		try {
		   _timeAVP.setValue( Float.toString( _sme_interface.getClient().sme_model_start_time() ) );
		} catch ( SNPException ex ) {  _sme_interface.getClient().error(ex.toString());}
		time_panel.add( _timeAVP );
		
		add( create_data_panel(), "Center" );
		setBorder( BorderFactory.createEtchedBorder() );
	  }		
	} 

	public JPanel getPanel() { init(); return this; }
	
	public JTree getTree() { 
	  if( _variableTree == null ) { _variableTree = _objectTree.getTreeTable(); }
	  return _variableTree.getTree(); 
	} 
	
	public ModelObjectTree getModelObjectTree() { 
	  return _objectTree;
	}
	
	public void setFrame( JFrame f ) { _frame = f; }
	
	JPanel create_data_panel() {

	  EmptyBorder eb7 = new EmptyBorder( 7, 7, 7, 7 );	
	  EmptyBorder eb3 = new EmptyBorder( 3, 3, 3, 3 );
	  BoxLayout bl;	
	  
	  JPanel pH  = new JPanel(false);
	  bl = new BoxLayout(pH, BoxLayout.X_AXIS );  pH.setLayout( bl ); 
	  	   
	  JPanel pV0  = new JPanel(false);
	  bl = new BoxLayout(pV0, BoxLayout.Y_AXIS );  pV0.setLayout( bl ); 
	  	   
	  Border bb = BorderFactory.createCompoundBorder( new BevelBorder(BevelBorder.LOWERED), eb3 );  	pV0.setBorder( bb );
	  pV0.setMaximumSize(new Dimension(Short.MAX_VALUE,  Short.MAX_VALUE)); 
	  pH.add(pV0);

	  JPanel pV1  = new JPanel(false);
	  bl = new BoxLayout(pV1, BoxLayout.Y_AXIS );  pV1.setLayout( bl ); 
	  
	  bb = BorderFactory.createCompoundBorder( new BevelBorder(BevelBorder.LOWERED), eb3 );   pV1.setBorder( bb );
	  pV1.setMaximumSize(new Dimension( 250,  Short.MAX_VALUE ) ); 
	  pH.add(pV1);

	  JLabel title1 = new JLabel("Run Control:");
	  title1.setBorder(eb7);
	  pV1.add(title1);

	  JButton  initButton = new JButton("init");
	  initButton.addActionListener( new InitAction() );
	  initButton.setMaximumSize( new Dimension( Short.MAX_VALUE, initButton.getMaximumSize().height ) );
	  pV1.add( initButton );

	  JButton  stepButton = new JButton("step");
	  stepButton.addActionListener( new StepAction() );
	  stepButton.setMaximumSize( new Dimension( Short.MAX_VALUE, stepButton.getMaximumSize().height ) );
	  pV1.add( stepButton );

	  JButton  runButton = new JButton("run");
	  runButton.addActionListener( new RunAction() );
	  runButton.setMaximumSize( new Dimension( Short.MAX_VALUE, runButton.getMaximumSize().height ) );
	  pV1.add( runButton );

	  JButton stopButton = new JButton("stop");
	  stopButton.addActionListener( new StopAction() );
	  stopButton.setMaximumSize( new Dimension( Short.MAX_VALUE, stopButton.getMaximumSize().height ) );
	  pV1.add( stopButton );

	  JButton rsButton = new JButton("restart");
	  rsButton.addActionListener( new RestartAction() );
	  rsButton.setMaximumSize( new Dimension( Short.MAX_VALUE, rsButton.getMaximumSize().height ) );
	  pV1.add( rsButton );

	  JButton dumpButton = new JButton("dump");
	  dumpButton.addActionListener( new DumpAction() );
	  dumpButton.setMaximumSize( new Dimension( Short.MAX_VALUE, dumpButton.getMaximumSize().height ) );
	  pV1.add( dumpButton );

	  JButton dbButton = new JButton("debug");
	  dbButton.addActionListener( new DebugAction() );
	  dbButton.setMaximumSize( new Dimension( Short.MAX_VALUE, dbButton.getMaximumSize().height ) );
	  pV1.add( dbButton );
	  	  	  
	  JLabel title = new JLabel("Simulation Objects:");
	  title.setBorder(eb7);
	  title.setAlignmentX(Component.CENTER_ALIGNMENT);
	  pV0.add(title);
	  
	  JScrollPane scrollPane = new JScrollPane();
	  _variableTree = _objectTree.getTreeTable();
	  _variableTree.setBorder( BorderFactory.createEtchedBorder()  );
	  _objectTree.getTree().addTreeSelectionListener(
		new TreeSelectionListener() {
		   public void valueChanged(TreeSelectionEvent e) { treeValueChanged(); }
	   });
	  scrollPane.getViewport().setView(_variableTree);
	  scrollPane.setBorder( eb7 );
	  scrollPane.setMaximumSize( new Dimension( Short.MAX_VALUE, 500 ) );
	  _treeTableScroller = scrollPane.getVerticalScrollBar();
	  pV0.add(scrollPane);

	  JPanel buttonPanel  = new JPanel(false);
	  bl = new BoxLayout(buttonPanel, BoxLayout.X_AXIS );  buttonPanel.setLayout( bl ); 
	  buttonPanel.setBorder( eb7 );

	  JButton findButton = new JButton("Find");
	  findButton.addActionListener( new FindAction() );
	  findButton.setMaximumSize( new Dimension( Short.MAX_VALUE, 50 ) );
	  buttonPanel.add( findButton );
	    
	  JButton openButton = new JButton("Equations");
	  openButton.addActionListener( new AddDependenciesAction() );
	  openButton.setMaximumSize( new Dimension( Short.MAX_VALUE, 50 ) );
	  buttonPanel.add( openButton );

	  _viewButton = new JButton("View");
	  _viewButton.addActionListener( new ViewAction() );
	  _viewButton.setMaximumSize( new Dimension( Short.MAX_VALUE, 50 ) );
	  _viewButton.setEnabled(false);
	  buttonPanel.add( _viewButton );

	  _editButton = new JButton("Edit");
	  _editButton.addActionListener( new EditAction(this) );
	  _editButton.setMaximumSize( new Dimension( Short.MAX_VALUE, 50 ) );
	  _editButton.setEnabled(false);
	  buttonPanel.add( _editButton );

	  JButton deleteButton = new JButton("Animate");
	  deleteButton.addActionListener( new PipeViewServerAction() );
	  deleteButton.setMaximumSize( new Dimension( Short.MAX_VALUE, 50 ) );
	  buttonPanel.add( deleteButton );
	  
	  buttonPanel.setMaximumSize( new Dimension( Short.MAX_VALUE, 50 ) );
	  buttonPanel.setPreferredSize( new Dimension( 500, 40 ) );
	  pV0.add( buttonPanel );
	  
	  _codeField = new JTextField(512);
	  scrollPane = new JScrollPane();
	  scrollPane.getViewport().setView(_codeField);
	  if( _font != null ) { _codeField.setFont(_font); }
	  scrollPane.setMaximumSize( new Dimension( Short.MAX_VALUE, 50 ) );
	  scrollPane.setPreferredSize( new Dimension( 600, 30) );
	  pV0.add( scrollPane );

/*	  
	  buttonPanel  = new JPanel( new FlowLayout() );
	  _creationButton = new JButton("Create");
	  _creationButton.addActionListener( new CreateViewerAction() );
	  _creationButton.setMaximumSize( new Dimension( Short.MAX_VALUE, _creationButton.getMaximumSize().height ) );
	  _creationButton.setEnabled(false);
	  buttonPanel.add( _creationButton );

	  _closeButton = new JButton("Close");
	  _closeButton.addActionListener( new CloseViewersAction() );
	  _closeButton.setMaximumSize( new Dimension( Short.MAX_VALUE, _closeButton.getMaximumSize().height ) );
	  _closeButton.setEnabled(false);
	  buttonPanel.add( _closeButton );
	  buttonPanel.setMaximumSize( new Dimension( Short.MAX_VALUE, _creationButton.getMaximumSize().height ) );
	  pV1.add( buttonPanel );
*/	  
	  return pH;
	}

    public void itemStateChanged(ItemEvent e) {
//	  _creationButton.setEnabled( ViewerData.getSelectionIndex() >= 0 );
//	  _closeButton.setEnabled( ViewerData.getSelectionIndex() >= 0 );
    }

	public void treeValueChanged() {
/*
	  boolean[] has_data = { false, false, false, false };
	  int nSelections = _variableTree.getSelectionCount();
	  if( nSelections == 1 ) { has_data[0] = true; }
	  TreePath[] tps = _variableTree.getSelectionPaths(); 
	  for( int i=0; i<nSelections; i++ ) {
		TreePath tp = tps[i]; 
		DefaultMutableTreeNode tn = (DefaultMutableTreeNode)tp.getLastPathComponent();
		if( tp.getPathCount() == 3 ) { 
		  DataSet d = (DataSet) tn.getUserObject();
		  has_data[ d.dims() ] = true;
		} else if ( tp.getPathCount() == 2 ) {  // List and add components;
		  int cc = tn.getChildCount();
		  for( int j=0; j<cc ; j++ ) {
			DefaultMutableTreeNode tnc = (DefaultMutableTreeNode)tn.getChild(j);
			DataSet d = (DataSet) tnc.getUserObject();
			has_data[ d.dims() ] = true;
		  }
		}
	  }
	  ViewerData.setActivation( has_data );
*/
	}

	public void showVarSearch() {
	  if( _varSearchFrame == null ) { 
		_varSearchFrame = new JFrame("Search");
		WindowListener l = new WindowAdapter() {
			public void windowClosing(WindowEvent e) { ; }
		};
		_varSearchFrame.addWindowListener( l );
		EmptyBorder eb7 = new EmptyBorder( 7, 7, 7, 7 );	
		JPanel search_panel = (JPanel)_varSearchFrame.getContentPane();	

		JLabel msgLabel = new JLabel("Find next variable whose name contains:", JLabel.RIGHT);
		msgLabel.setBorder( eb7 );

		JPanel button_panel  = new JPanel( new FlowLayout() );
		button_panel.setBorder( eb7 );
		JButton  cancelButton = new JButton("cancel");
		cancelButton.addActionListener( new VarSearchCancelAction() );
		button_panel.add(cancelButton);
		JButton  findButton = new JButton("find");
		findButton.addActionListener( new VarSearchFindAction() );
		button_panel.add(findButton);
		
		_searchField = new JTextField(30);
		_searchField.setBorder( new BevelBorder(BevelBorder.LOWERED)  );

		search_panel.add( "North", msgLabel );
		search_panel.add( "Center", _searchField );
		search_panel.add( "South", button_panel );
		_varSearchFrame.pack();
		_varSearchFrame.setResizable(false);

		Dimension         paneSize = _frame.getSize();
		Dimension         screenSize = _frame.getToolkit().getScreenSize();
		_varSearchFrame.setLocation((screenSize.width - paneSize.width) / 2,
					(screenSize.height - paneSize.height) / 2);
	  } 
	  _varSearchFrame.setVisible(true);
	}
	
	class VarSearchCancelAction extends QueuedExecutable  {
	  public void execute() {
		_varSearchFrame.setVisible(false);
	  }
    } 
    
	class VarSearchFindAction extends QueuedExecutable  {
	  public void execute() {
		String value = _searchField.getText();
		float fvalue = _objectTree.selectNextVariableContaining(value); 
		if( fvalue >= 0f ) { scrollTreeTable( fvalue ); } 
	  }
    } 

	class RunAction extends QueuedExecutable  {
	  public void execute() {
		try {
		  setStopTime(); 
		  run_simulation( _stop_time );
		} catch ( SNPException ex ) { _sme_interface.getClient().error(ex.toString());}
	  }
    }

	class InitAction extends QueuedExecutable  {
	  public void execute() {
		try {
		  run_simulation( 0f );
		} catch ( SNPException ex ) { _sme_interface.getClient().error(ex.toString());}
	  }
    }

	public DataSet getParameters( HashMap map ) {
	  return _objectTree.getParameters( map, _sme_interface.getClient() );
	}

	public void setViewingEnabled( boolean enable ) { 
	  _editButton.setEnabled(enable);	
	  _viewButton.setEnabled(enable);	
	}
       
    void run_simulation( float stop_time ) throws SNPException {
	  _run_simulation = true;
	  ProgressDialog pd = new ProgressDialog("Running Model");
	  UpdateTimeAction timeUpdate = new UpdateTimeAction();
	  pd.show( false );
	  float start_time = _time;
	  if( (stop_time == 0f) && !_sim_started ) {
		_sim_started = true;
		try {
		  _sme_interface.getClient().sme_run( 0f );
		  _sme_interface.getClient().retrieve_messages( "initialize model, time = " + _time );
		} catch ( SNPException ex ) {  _sme_interface.getClient().error(ex.toString());}
	  } else {
		setTimeStep();
		while(_run_simulation) {
		  if( _time >= stop_time ) { break; }
		  _sim_started = true;
		  try {  Thread.sleep(200L);   }
		  catch (InterruptedException e0) {  break;  }
		  if( !pd.isShowing() ) { break; }
		  else { pd.setValue( ( _time-start_time ) / ( stop_time-start_time ) ); }
		  try {
			_sme_interface.getClient().sme_step();
			_time = _sme_interface.getClient().sme_current_time();
			_sme_interface.getClient().retrieve_messages( "step model, time = " + _time );
			timeUpdate.executeOnEventDispatchTread();
		  } catch ( SNPException ex ) {  _sme_interface.getClient().error(ex.toString());}
		  repaint();
		} 
	  }
	  pd.finalize();
	  setViewingEnabled( _sim_started );
    } 

	class UpdateTimeAction extends QueuedExecutable  {
	  public void execute() {
		  _timeAVP.setValue( Float.toString( _time ) );
	  }
    } 

	class StepAction extends QueuedExecutable  {
	  public void execute() {
		try {
		  setTimeStep();
		  run_simulation( _time + _DT );
		} catch ( SNPException ex ) {  _sme_interface.getClient().error(ex.toString());}
	  }
    } 

	class StopAction extends QueuedExecutable   {
	  public void execute() { _run_simulation = false; }
    } 

	class DebugAction extends QueuedExecutable  {
	  public void execute() {
		try {
		  int code = _sme_interface.getClient().sme_start_debugger();
		  System.out.println("sme_start_debugger returned code " + code);
		} catch ( SNPException ex ) {  _sme_interface.getClient().error(ex.toString());}
	  }
    } 

	class DumpAction extends QueuedExecutable  {
	  public void execute() {
//		show_messages(_sme_interface.getClient().get_info_messages(),_sme_interface.getClient().get_warning_messages(),_sme_interface.getClient().get_error_messages());
	  }
    } 

	class RestartAction extends QueuedExecutable   {
	  public void execute() {
		try {
		  _sme_interface.getClient().sme_restart();
		  _time = 0f;
		  _timeAVP.setValue( "0.0" );
		  setTimeStep();
		  setStopTime();
		  run_simulation( _stop_time );
		} catch ( SNPException ex ) {  _sme_interface.getClient().error(ex.toString());}
	  }
    } 

	void setStopTime()  {
	  try {
		 String val =  _stop_timeAVP.getValue();
		 Float stop = Float.valueOf(val);
		 _stop_time = stop.floatValue();
	  } catch ( NumberFormatException ex ) { SimIO.print(" NumberFormatException "); }
    } 

	void setTimeStep() {
		try {
		   String val =  _timestepAVP.getValue();
		   Float DT = Float.valueOf(val);
		   if( DT.floatValue() != _DT ) {
			 _sme_interface.getClient().sme_set_timestep( _DT = DT.floatValue() );
		   }
		} catch ( NumberFormatException ex ) { SimIO.print(" NumberFormatException "); }
    } 
	
	class ShutdownAction  extends QueuedExecutable   {
	  public void execute() {
		try {
	  // stop remote driver run 
		  _sme_interface.getClient().stop_model();
	  	  // close connection 
		  _sme_interface.getClient().close_model();
		} 
		catch ( SNPException ex ) {;}
		catch ( NullPointerException ex ) {;}
		System.exit(0);
	  }
    } 

	class OpenAction  extends QueuedExecutable   {
	  public OpenAction() { super("Open",null); }
	  public void execute() {;}
    } 

	class SaveAction  extends QueuedExecutable   {
	  public SaveAction() { super("Save",null); }
	  public void execute() {;}
    } 

	class PipeViewServerAction extends QueuedExecutable   {
	  public void execute() {
		Variable v = getSelectedVariable();
		try { 
		  v.display(); 
		  _sme_interface.getClient().sme_var_display_data ( v._module.ID(), v.ID() );
		  repaint();
		} 
		catch ( SNPException err ) { System.out.println( err ); }
		catch ( NullPointerException err ) { System.out.println( "No known Variable selected" ); }
	  }
    } 
			
	private void show_messages( Vector info, Vector warn, Vector error ) {
	
	}
	
	private void scrollTreeTable( float fvalue ) {
	  int max = _treeTableScroller.getMaximum();
	  int min = _treeTableScroller.getMinimum();
	  int ivalue = (int) (min + (max-min)*fvalue);
	  _treeTableScroller.setValue(ivalue); 
	  repaint();
	}

	Variable getSelectedVariable() {
	  Variable v = null;
	  try { 
		TreePath tp = _objectTree.getSelectionPath();
		XMLContainer tn = (XMLContainer) tp.getLastPathComponent();
		XMLContainer mn = (XMLContainer) tp.getPathComponent(1);
		v = (Variable)tn;
		System.out.println("Got variable:" + v._module.ID() + ":" + v.ID() );
	  } catch( NullPointerException err ) {
		SimIO.beep();
	  } catch( ClassCastException err ) {
		SimIO.beep();
	  }
	  return v;
	}

    class FindAction extends QueuedExecutable  {
	  public void execute() { showVarSearch(); }
	} 
	
    class ViewAction  extends QueuedExecutable   {
	  public void execute() {
		Variable v = getSelectedVariable();
		try { 
		  _sme_interface.getClient().sme_var_browse_data ( v._module.ID(), v.ID(), false, true );
		} 
		catch ( SNPException err ) { System.out.println( err ); }
		catch ( NullPointerException err ) { System.out.println( "No known Variable selected" ); }
	  }
	}
	  
    class EditAction  extends QueuedExecutable   {
	  VariableInformationPanel _panel;
	  EditAction ( VariableInformationPanel panel ) { _panel = panel; }
	  public void execute() {
		Variable v = getSelectedVariable();
		try { 
		  ((SMEClient)_sme_interface.getClient()).getViewserver().setTableModelListener(_panel);
		  _sme_interface.getClient().sme_var_browse_data ( v._module.ID(), v.ID(), true, true );  
		} 
		catch ( SNPException err ) { System.out.println( err ); }
		catch ( NullPointerException err ) { System.out.println( "No known Variable selected" ); }
	  }
	}

	class SetValueAction  extends QueuedExecutable   {
	  public void execute() {
		TableModelEvent e = (TableModelEvent) _event;
		int type = e.getType(); 	
		if( type == TableModelEvent.UPDATE ) {
		  int col = e.getColumn(); 
		  int row = e.getFirstRow() ;
		  if( col >= 0 ) {
			DataTableModel tm = (DataTableModel) e.getSource();
			DataTable dt = tm.getDataTable();
			FormattedFloat ff = (FormattedFloat) tm.getValueAt( row, col ); 
			String value = ff.toString();
			DataEntry de = tm.getDataSet().getSelectedEntry();
			String label = de.toString();
			int namelen = label.indexOf('(');
			String vname = ( namelen < 0 ) ? label : label.substring(0,namelen);
			col += dt.getOffset(0)-1;
			row += dt.getOffset(1);
			System.out.println("\ninfo: Setting value for variable " + vname + " at: ( " + row + " , " + col + " ) : "  + value  );
			try {
			  _sme_interface.getClient().sme_set_spatial_at ( vname, col, row, value ); 
			} catch ( SNPException err ) {
			  System.out.println( "error setting value: " + err.toString() ); 
			} 
		  }
		} 
	  }
	}

	public void tableChanged(TableModelEvent e) {
	  SetValueAction setValueAction = new SetValueAction();
	  setValueAction.processEvent(e);
	}

	class AddDependenciesAction  extends QueuedExecutable   {
	  public void execute() {
		TreePath tp = _objectTree.getSelectionPath();
		XMLContainer tn = (XMLContainer) tp.getLastPathComponent();
		XMLContainer mn = (XMLContainer) tp.getPathComponent(1);
		try { 
		  Variable v = (Variable)tn;  
		  Module m = (Module)mn;  
		  _objectTree.addDependencies( _sme_interface.getClient(), m, v );
		} catch( NullPointerException err ) {
		  SimIO.beep();
		  return;
		} catch( java.lang.ClassCastException err ) {
		  SimIO.beep();
		  return;
		}
	  }
    }
     
    public XMLContainer addVariable(  XMLContainer module_node, Variable v ) {
	  return _objectTree.addVariable(module_node,v);
	}
    public XMLContainer addModule( Module m ) {
	  return _objectTree.addModule(m);
	}
	public XMLContainer addDependency( XMLContainer var_node, Variable v ) {
	  return _objectTree.addDependency(var_node,v);
	}

	public void valueChanged(TreeSelectionEvent e) {
	  TreePath tp = e.getNewLeadSelectionPath();
	  if( tp == null ) return;  
	  XMLContainer tn = (XMLContainer) tp.getLastPathComponent();
	  Action a = null;
	  try { 
		a = (Action)tn;
	  } catch( NullPointerException err ) {
		return;
	  } catch( java.lang.ClassCastException err ) {
		return;
	  }
	  if( a != null ) {
		String code = a.getCode();
		SimIO.print("Action code: " + code );
		_codeField.setText(code);
		repaint();
	  }
	}

    public void setFontSize( float font_size ) {
	  HashMap font_attr = new HashMap();
	  font_attr.put( TextAttribute.SIZE, new Float(font_size) );
	  _font = new Font(font_attr);
    }
	    
	public void paint(Graphics g) {	
	  _objectTree.formatColumns();       //   Java bug(?) workaround.
	  super.paint(g);
	}
	
	public static void main(String args[])  {	}
	

	public static JFrame startup( SMEInterface intf, Module root ) {
	  VariableInformationPanel cp = new VariableInformationPanel(intf, root, SMEInterface.kGUI );
	
	  _frame  = new JFrame("Variable Information Panel");
	  cp.setFrame(_frame);
	  
	  cp.init();
	  _frame.setContentPane( cp );		
	  _frame.setSize(650,650);
	  _frame.setResizable(false);
	  
	  Dimension         paneSize = _frame.getSize();
	  Dimension         screenSize = _frame.getToolkit().getScreenSize();
	  _frame.setLocation((screenSize.width - paneSize.width) / 2,
				  (screenSize.height - paneSize.height) / 2);
	  return _frame;
	}
	
	public static void showPanel() {
	  _frame.setVisible(true);
	}
	
	public static void hidePanel() {
	  _frame.setVisible(false);
	}
 	
	void generateHelpText() {
	  _helpText = 
		"  To generate Viewers: \n"
	  + "  1. Select the dataSet(s) to be viewed, \n"
	  + "  2. Select a Viewer Type, \n"
	  + "  3. Press the 'Create' button. \n"
	  + "  This will create viewer(s) for all relevant selected dataSets.  \n"
	  + "  A dataSet is relevant if can be displayed by the selected Viewer type. \n"
	  + "  Viewer Types will be enabled if there are dataSets selected that are relevant for that type.  \n"
	  + "  Selecting a simulation node will select all dataSets in that simulation. \n"				
	  + "  Double-click on a dataSet node to view the data objects in that set. \n\n"			
	  + "  Press the 'Close' button to close all viewers of the selected Viewer type associated with the selected dataSets.";				
	}

}

class VariableTreeModel extends AbstractTreeTableModel   implements TreeTableModel {
/*
    protected Icon directoryIcon = null;
    protected Icon fileIcon = null;

    protected Icon newFolderIcon = null;
    protected Icon upFolderIcon = null;
    protected Icon homeFolderIcon = null;
    protected Icon listViewIcon = null;
    protected Icon detailsViewIcon = null;
*/    
    protected Icon spatialIcon = null;
	protected Icon temporalIcon = null;
	protected Icon importIcon  = null;
	protected Icon arrayIcon  = null;
	protected Icon readMapIcon  = null;
	protected Icon readTimeseriesIcon  = null;
	protected Icon readDBPIcon  = null;
	protected Icon readParameterIcon  = null;
	protected Icon readInterpTimeseriesIcon  = null;
    protected Icon computerIcon = null;


    // Names of the columns.
    static protected String[]  cNames = {"Name", "S", "T", "A", "I", "R", "D" };

    // Types of the columns.
    static protected Class[]  cTypes = { TreeTableModel.class, Icon.class, Icon.class, Icon.class, Icon.class, Icon.class, Icon.class };

    // The the returned file length for directories. 
    public static final Integer ZERO = new Integer(0); 

    public VariableTreeModel( Module root ) { 
	  super( root ); 
	  getIcons();
    }

    //
    //  The TreeTableNode interface. 
    //
    public void getIcons() { 
/*
	  directoryIcon    = UIManager.getIcon("FileView.directoryIcon");
	  fileIcon         = UIManager.getIcon("FileView.fileIcon");

	  newFolderIcon    = UIManager.getIcon("FileChooser.newFolderIcon");
	  upFolderIcon     = UIManager.getIcon("FileChooser.upFolderIcon");
	  homeFolderIcon   = UIManager.getIcon("FileChooser.homeFolderIcon");
	  detailsViewIcon  = UIManager.getIcon("FileChooser.detailsViewIcon");
	  listViewIcon     = UIManager.getIcon("FileChooser.listViewIcon");
	  parameterIcon      = new ImageIcon("/flock/maxwell/lib/images/parameter.gif");
*/

	  computerIcon     = UIManager.getIcon("FileView.computerIcon");
	  spatialIcon      = SimIO.loadIcon(  "spatial.gif" );
	  temporalIcon      = SimIO.loadIcon(  "temporal.gif" );
	  readMapIcon      = SimIO.loadIcon(  "read_map.gif" );
	  readTimeseriesIcon      = SimIO.loadIcon(  "read_timeseries.gif" );
	  readInterpTimeseriesIcon      = SimIO.loadIcon(  "read_interp_ts.gif" );
	  readParameterIcon      = SimIO.loadIcon(  "read_parameter.gif" );
	  readDBPIcon      = SimIO.loadIcon(  "read_dbp.gif" );
	  importIcon      = SimIO.loadIcon(  "import.gif" );
	  arrayIcon      = SimIO.loadIcon(  "array.gif" );
	}
	
    public int getColumnCount() {
	  return cNames.length;
    }

    public String getColumnName(int column) {
	  return cNames[column];
    }

    public Class getColumnClass(int column) {
	  return cTypes[column];
    }
 
    public Object getValueAt(Object node, int column) {
	  try {
		  Variable v = (Variable)node;
		  switch(column) {
			case 0:
			  return   v;
			case 1:
			  return  v.isSpatial() ? (Object)spatialIcon : (Object)"";
			case 2:
			  return  v.isTemporal() ? (Object)temporalIcon : (Object)"";
			case 3:
			  return   ( v.getArrayDimension() > 0 ) ? (Object)arrayIcon : (Object)"";
			case 4:
			  return   v.isImport() ? (Object)importIcon : (Object)"";
			case 5:
			  switch( v._initMode ) {
				case Variable.DEFAULT: 		return null; // kDefault
				case Variable.MAP: 			return readMapIcon; // kMap
				case Variable.TIMESERIES: 	return readTimeseriesIcon; //  kTimeSeries
				case Variable.PTS: 			return readInterpTimeseriesIcon; //  kPtTimeSeries
				case Variable.DBASE: 		return readDBPIcon; //  kDBase
				case Variable.PARAMETER: 	return readParameterIcon; //  kParameter
				default: 					return   null;
			  }			
			case 6:
			  return  v.isDisplayed() ? (Object)computerIcon : (Object)"";
		  }
	  } 
	  catch ( ClassCastException err ) {;}   
	  catch ( NullPointerException err ) {;}   
	  return null; 
    }
}

class PyVariableTreeModel extends AbstractTreeTableModel   implements TreeTableModel {
/*
    protected Icon directoryIcon = null;
    protected Icon fileIcon = null;

    protected Icon newFolderIcon = null;
    protected Icon upFolderIcon = null;
    protected Icon homeFolderIcon = null;
    protected Icon listViewIcon = null;
    protected Icon detailsViewIcon = null;   
	protected Icon importIcon  = null;
	protected Icon readMapIcon  = null;
	protected Icon readTimeseriesIcon  = null;
	protected Icon readDBPIcon  = null;
	protected Icon readParameterIcon  = null;
	protected Icon readInterpTimeseriesIcon  = null;
*/
    protected Icon computerIcon = null;
    protected Icon spatialIcon = null;
	protected Icon temporalIcon = null;

    // Names of the columns.
    static protected String[]  cNames = {"Name", "S", "T", "V" };

    // Types of the columns.
    static protected Class[]  cTypes = { TreeTableModel.class, Icon.class, Icon.class, Icon.class };

    // The the returned file length for directories. 
    public static final Integer ZERO = new Integer(0); 

    public PyVariableTreeModel( Module root ) { 
	  super( root ); 
	  getIcons();
    }

    //
    //  The TreeTableNode interface. 
    //
    public void getIcons() { 
/*
	  directoryIcon    = UIManager.getIcon("FileView.directoryIcon");
	  fileIcon         = UIManager.getIcon("FileView.fileIcon");

	  newFolderIcon    = UIManager.getIcon("FileChooser.newFolderIcon");
	  upFolderIcon     = UIManager.getIcon("FileChooser.upFolderIcon");
	  homeFolderIcon   = UIManager.getIcon("FileChooser.homeFolderIcon");
	  detailsViewIcon  = UIManager.getIcon("FileChooser.detailsViewIcon");
	  listViewIcon     = UIManager.getIcon("FileChooser.listViewIcon");
	  parameterIcon      = new ImageIcon("/flock/maxwell/lib/images/parameter.gif");
	  readMapIcon      = SimIO.loadIcon(  "read_map.gif" );
	  readTimeseriesIcon      = SimIO.loadIcon(  "read_timeseries.gif" );
	  readInterpTimeseriesIcon      = SimIO.loadIcon(  "read_interp_ts.gif" );
	  readParameterIcon      = SimIO.loadIcon(  "read_parameter.gif" );
	  readDBPIcon      = SimIO.loadIcon(  "read_dbp.gif" );
	  importIcon      = SimIO.loadIcon(  "import.gif" );
*/
	  computerIcon     = UIManager.getIcon("FileView.computerIcon");
	  spatialIcon      = SimIO.loadIcon(  "spatial.gif" );
	  temporalIcon      = SimIO.loadIcon(  "temporal.gif" );
	}
	
    public int getColumnCount() {
	  return cNames.length;
    }

    public String getColumnName(int column) {
	  return cNames[column];
    }

    public Class getColumnClass(int column) {
	  return cTypes[column];
    }
 
    public Object getValueAt(Object node, int column) {
	  if( node == null ) return null;
	  try {
		  Variable v = (Variable)node;
		  switch(column) {
			case 0: return   v;
			case 1:
			  return  v.isSpatial() ? (Object)spatialIcon : (Object)"";
			case 2:
			  return  v.isTemporal() ? (Object)temporalIcon : (Object)"";
			case 3:
			  return  v.isDisplayed() ? (Object)computerIcon : (Object)"";
		  }
	  } 
	  catch ( ClassCastException err ) { 
/*
		try {
			Action a = (Action)node;
			switch(column) {
			  case 0: return   a;
			  case 1: return  a.getIcon();;
			}
		} 
		catch ( ClassCastException err1 ) {;}  
*/
	  }  
	  return null; 
    }
}

