package miiee.dataview;

import java.awt.*;
import javax.swing.JComponent;
import com.sun.image.codec.jpeg.*;
import javax.swing.JViewport;
import java.awt.image.*;
import java.io.*;
import java.awt.geom.AffineTransform;
import java.awt.font.TextLayout;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowAdapter;
import java.util.Vector;
import java.util.HashMap;
import java.util.StringTokenizer;
import miiee.util.SimIO;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import miiee.util.*;

class LegendEntry extends Object {  
  public int _key;
  public String _value; 
  public LegendEntry( int key, String value ) { _key = key; _value = value; }
  public String toString() { 
	return  String.valueOf( _key ) + " : " + _value; 
  }
}

class OffsetArray extends Object {
  public byte[] _mask;
  public int[][][] _offsets;
  public int _width;
  public int _height;
  public int _depth;

  public OffsetArray( byte[] mask, int width, int height, int depth ) {
	_mask = mask;
	_width = width;
 	_height = height;
 	_depth = depth;
 	_offsets = new int[width][height][depth];
  }
  
  boolean same( byte[] mask, int width, int height, int depth ) {
	if( _width != width ) return false;
	if( _height != height ) return false;
	if( _depth != depth ) return false;
	if( mask != null ) {
	  int ncells = _width*_height;
	  if( mask.length != ncells ) return false;
	  for( int i=0; i<ncells; i++ ) {
		if( mask[i] != _mask[i] ) { return false; }
	  }
	}
	return true;
  }
}

public class AnimationImage2D extends JComponent implements Runnable, MouseListener, MouseMotionListener, 
															AnimationStepper, ColorChangeListener {

    public static final int Greyscale	= 0;
    public static final int Rainbow	    = 1;
    public static final int Custom	    = 2;

	private Vector _images;
//	private IndexColorModel _cm;
	private double _scale_x = 1;
	private double _scale_y = 1;
	private double _scale_z = 1;
	private double _log_scaler = 0;
	private double _translate_x = 0;
	private double _translate_y = 0;
	private double _translate_z = 0;
	private int _base_offset_x = 5;
	private int _base_offset_y = 5;
	private int _slice = SLICE_DEF;
	private int _layer_offset = 0;
	private int _image_width = 0;
	private int _image_height = 0;	
	private static Vector _offset_arrays = new Vector();
	private int[][][] _offsets;
	private float _start_time = 0;
	private float _dt = 1.0f;
	private DataSet _imageData;
	private boolean _int_mag = false;
	private int _current_image = 0;
	private int _bandOffsets[];
	private int _dataSize =  0;
	private float _max_raster_val;
	private float _max_uns_raster_val;
	private Point _origin;
	private boolean _interp = false;
	private boolean _reset_transform = true;
	private boolean _reset_scaling = true;
	private boolean _fix_scaling = false;
	private boolean _smooth_image = false;
	private boolean _clear_canvas = true;
	private boolean _uniform_scale = true;
	private boolean _debug =  true;
	private boolean _slave_process =  true;
	private float _data_max_value = -Float.MAX_VALUE;
	private float _data_min_value = Float.MAX_VALUE;
	private int _anim_control_mode = ANIM_WAIT;
	private AffineTransform _transform;
	private AffineTransformOp _transformOp; 
	private int _selX = 0;
	private int _selY = 0;
	private int _selW = 0;
	private int _selH = 0;
	private boolean _selectionAreaActive = false;
	private Vector _Legend;
	private int _colormapIndex = Rainbow; 
	private ColorMap _colormap; // _colorWidget.getColorMap();
	private boolean _useLogScale = false;
	private boolean _editMode = false;
	protected String _output_directory;
	protected byte _write_format = 0; 
	protected String _write_suffix;
	
	private final static double _Exp_1 = Math.E; 
	private final static double _Exp_255 = Math.pow(Math.E,255); 
	
	private static final int nfont_data[][][] = {
	  { { 1, 1, 1 }, { 1, 0, 1 }, { 1, 0, 1 }, { 1, 0, 1 }, { 1, 1, 1 } }, // 0
	  { { 0, 1, 0 }, { 0, 1, 0 }, { 0, 1, 0 }, { 0, 1, 0 }, { 0, 1, 0 } }, // 1
	  { { 1, 1, 1 }, { 0, 0, 1 }, { 1, 1, 1 }, { 1, 0, 0 }, { 1, 1, 1 } }, // 2
	  { { 1, 1, 1 }, { 0, 0, 1 }, { 1, 1, 1 }, { 0, 0, 1 }, { 1, 1, 1 } }, // 3
	  { { 1, 0, 1 }, { 1, 0, 1 }, { 1, 1, 1 }, { 0, 0, 1 }, { 0, 0, 1 } }, // 4
	  { { 1, 1, 1 }, { 1, 0, 0 }, { 1, 1, 1 }, { 0, 0, 1 }, { 1, 1, 1 } }, // 5 
	  { { 1, 1, 1 }, { 1, 0, 0 }, { 1, 1, 1 }, { 1, 0, 1 }, { 1, 1, 1 } }, // 6
	  { { 1, 1, 1 }, { 0, 0, 1 }, { 0, 0, 1 }, { 0, 0, 1 }, { 0, 0, 1 } }, // 7 
	  { { 1, 1, 1 }, { 1, 0, 1 }, { 1, 1, 1 }, { 1, 0, 1 }, { 1, 1, 1 } }, // 8 
	  { { 1, 1, 1 }, { 1, 0, 1 }, { 1, 1, 1 }, { 0, 0, 1 }, { 0, 0, 1 } }, // 9 
	  { { 0, 0, 0 }, { 0, 0, 0 }, { 0, 0, 0 }, { 0, 0, 0 }, { 0, 1, 0 } }, // . 
	  { { 0, 0, 0 }, { 0, 0, 0 }, { 0, 0, 0 }, { 0, 0, 0 }, { 0, 0, 0 } }  //   
	};
	  
	protected Thread _animThread;
	protected AnimationController _ddl;
	private BufferedImage _offImg;
	private Color _background = Color.black;
	private RenderingHints _rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);

    public static final int ANIM_EXIT	= 0;
    public static final int ANIM_RUN	= 1;
    public static final int ANIM_PAUSE	= 2;
    public static final int ANIM_STEP	= 3;
    public static final int ANIM_WAIT	= 4;
    public static final int SLICE_DEF	= 0;
    public static final int SLICE_Z	    = 1;
    public static final int SLICE_X	    = 2;
    public static final int SLICE_Y	    = 3;

    public AnimationImage2D( DataSet d ) {
	   super();
	   _imageData = d;
	   if( d.dims() == 3 ) {
		 _slice = SLICE_Z;
		 _image_width  =    _imageData.size(0);
		 _image_height =    _imageData.size(1);
		 calcLayerOffsets();
	   } else {
		 _image_width = _imageData.size(0);
		 _image_height =    _imageData.size(1);
	   }
	   _dataSize = _image_width * _image_height;
	   float byte_max = 256f;	
	   _max_raster_val = Short.MAX_VALUE; 		
	   _max_uns_raster_val = byte_max*byte_max - 1;		
        _images = new Vector(16,16);
		_bandOffsets = new int[1];
		_bandOffsets[0] = 0;
		_origin = new Point(0,0);
		CreateLegend();
//		_sample_model = new ComponentSampleModel( DataBuffer.TYPE_USHORT, width,height,1,width,_bandOffsets);
//		_cm = CreateColorModel();
    }
    
    void calcLayerOffsets() {
	  byte format = _imageData.format();
	  byte[] map = (format==0) ? null : _imageData.getActiveRegion();
	  int nlayers = _imageData.size(2);
	  int Nx = _imageData.size(0), Ny = _imageData.size(1);
	  if( map != null ) {
		_offsets = getOffsetArray( map, Nx, Ny, nlayers );
		if( _offsets[0][0][0] < 0 ) {
		  int cell_cnt = 0;
		  for( int iz=0; iz<nlayers; iz++ ) {
			for( int iy=0; iy<Ny; iy++ ) {
			  for( int ix=0; ix<Nx; ix++ ) {
				byte bval = map[ ix + iy*Nx ];
				if( ((format==1) && ( bval > iz )) || ((format==2) && ( bval > 0 )) ) { _offsets[ix][iy][iz] = cell_cnt++; }
			  }
			}
		  }
		}
	  }
	}
	
	int[][][] getOffsetArray( byte[] mask, int width, int height, int depth ) {
	  OffsetArray off_array =  null;
	  for( int i=0; i<_offset_arrays.size(); i++ ) {
		 off_array = (OffsetArray) _offset_arrays.get(i);
		 if( off_array.same( mask, width, height, depth ) ) {
		   return off_array._offsets;
		 }
	  }
	  off_array = new OffsetArray(mask,width,height,depth);
	  _offset_arrays.add(off_array);
	  int[][][] iarray = off_array._offsets;
	  iarray[0][0][0] = -1;
	  System.out.println("Creating offset array: ( " + width + " , " + height + " , " + depth + " ) " );
	  return iarray;
	}
		
	public synchronized void setColormapType( int type ) {
	  _colormapIndex = type;
	  if( type == Custom ) {
		ColorWidget colorWidget = ColorWidget.display( false );
		_colormap = colorWidget.getColorMap();	
		colorWidget.addColorChangeListener(this);
	  }
	}

	/** The function called when the color widget has changed */
	
	private static final long _skip_time = 25;
	private static long _current_time = 0;
	public void colorChanged(ColorChangeEvent e) {
	  long time = System.currentTimeMillis();
	  if( ( time - _current_time ) > _skip_time ) { repaint(); }
	  _current_time = time;
	}
	
	   
    public void AddAnimationController(AnimationController ddl) {
		_ddl = ddl;    
    }
    
    public void setSliceAxis( int axis ) {
	  _slice = axis;
	  _layer_offset = 0;
	  repaint();
    }
    
    public void enableLogScale( boolean enable ) { 
	  if( _useLogScale != enable ) {
		_useLogScale = enable; 
		_reset_scaling = true;
		repaint();
	  }
	}
	   
    public int  moveSlice( boolean up ) {
	  if( up ) {
		switch( _slice ) {
			case SLICE_X:
			  if ( _layer_offset < _imageData.size(0)-1 )  _layer_offset++;
			break;
			case SLICE_Y:
			  if ( _layer_offset < _imageData.size(1)-1 )  _layer_offset++;
			break;
			case SLICE_Z:
			  if ( _layer_offset < _imageData.size(2)-1 )  _layer_offset++;
			break;
			default:
			break;
		}
	  } else {
		if( _layer_offset > 0 ) { _layer_offset--; }	  
	  } 
	  repaint(); 
	  return  _layer_offset; 
    }
    
    public int getSliceAxis() { return _slice; }
    
    public void setSliceOffset( int offset ) {
	  _layer_offset = offset;
	  repaint();
    }
    
    private void CreateLegend() {
	  String cats = _imageData.Legend();
	  if( (_Legend == null) && ( cats != null ) ) {
		StringTokenizer st = new StringTokenizer(cats,",");
		_Legend = new Vector(32,32);
		while( st.hasMoreTokens() ) { 
		  String t = st.nextToken();
		  int cut = t.indexOf(':');
		  String skey = new String( t.substring(0,cut) );
		  String svalue = new String( t.substring(cut+1) );
		  LegendEntry le = new LegendEntry( Integer.parseInt(skey), svalue );
		  _Legend.add(le);
		}
	  }
    }
    
    public void printLegend() {
	  CreateLegend();
	  if( _Legend != null ) {
		SimIO.print( " Legend: " );
		for( int i=0; i< _Legend.size(); i++ ) {
		  SimIO.print( _Legend.get(i).toString() );
		}
	  }
    }
    
    public void SetTime( float start, float dt ) {
	  _start_time = start;
	  _dt = dt;
    }
    
    public synchronized void start()  {
		if( _animThread == null ) {
		  addMouseListener(this);
		  addMouseMotionListener(this);
		  if( !_slave_process ) {
			_animThread= new Thread(((Runnable)this)); 
			_animThread.start(); 
			SimIO.print(" Starting " + _animThread ); 
		  }
		}
    }

	public synchronized void ReadJpgImage( String imagePathName ) {

		Image img = getToolkit().getImage( imagePathName );
		try {
			MediaTracker tracker = new MediaTracker(this);
			tracker.addImage(img, 0);
			tracker.waitForID(0);
		} catch (Exception e) {}
		int iw = img.getWidth(this);
		int ih = img.getHeight(this);
		BufferedImage bi = new BufferedImage(iw, ih, BufferedImage.TYPE_INT_RGB);
		_images.addElement(bi);
		Graphics2D big = bi.createGraphics();
		big.drawImage(img,0,0,this);	
	}

	private BufferedImage CreateImage( int index ) {
	  BufferedImage bi = new BufferedImage ( _image_width, _image_height, BufferedImage.TYPE_INT_RGB );	  
	  if( index >= _images.size() ) { _images.setSize(index+16); }
	  _images.setElementAt(bi, index);
	  return bi;
	}
	
	public int Size() {
	  return _imageData.size();
	}
		
	public void setCurrentImage( int index ) { 
	  if( index != _current_image ) { _current_image = index; repaint(); }
	}
  
	public void stepAnimation() { 
	  SimIO.print("Stepping animation.");
	  _anim_control_mode = ANIM_STEP;
	}

	public void pauseAnimation() { 
	  _anim_control_mode = ANIM_PAUSE;
	}

	public void runAnimation() { 
	  _anim_control_mode = ANIM_RUN;
	}

    public boolean setAnimationTime1( float time ) {  
	  int max_index = _imageData.size() - 1;
	  int index = Math.round(time/_dt);
	  index = ( index > max_index ) ? max_index : index;
	  setAnimationIndex( index );
	  return ( index == max_index );
    }

    public int setAnimationTime( float time, boolean forward ) {
	  if( time == 0.0f  ) {
		if( _current_image > 0 ) { setAnimationIndex( 0 ); } 
		return 0;
	  }
	  DataEntry id =  (DataEntry) _imageData.getEntry( _current_image );
	  int max_index = _imageData.size() - 1;
	  if( id == null ) { return 2; }
	  float  tcur = id.time();
	  if( _debug ) {  SimIO.print("AnimationImage2D::setAnimationTime: step time=" + time + ", anim time=" + tcur + ", image_index=" + _current_image ); }
	  if( !forward ) {            // backwards stepping  
		if( time > tcur ) { return 0; }
		if( _current_image == 0 ) { return 0; }
		DataEntry id1 =  (DataEntry) _imageData.getEntry( _current_image-1 );
		float tnext = id1.time();
		if( ( time < tnext ) || ( ( (time-tnext)/(tcur-tnext) ) < 0.5f ) ) { 
		  setAnimationIndex( _current_image-1 ); 
		  return 1;
		} 
	  } else {                // forward stepping  
		if( _current_image == max_index ) { return 3; }
		DataEntry id1 =  (DataEntry) _imageData.getEntry( _current_image+1 );
		float tnext = id1.time();
		if( ( time > tnext ) || ( ( (tnext-time)/(tnext-tcur) ) < 0.5f ) ) { 
		  setAnimationIndex( _current_image+1 ); 
		  if( _current_image == max_index ) { return 2; }
		  else { return 0; }
		} 
	  }
	  return 0;
    }

    public void setAnimationIndex( int index ) {
	  _anim_control_mode = ANIM_PAUSE;
	  _current_image = index;
	  repaint();
    }

	public  DataSet getDataSet() { return _imageData; }

    public float getTime() {
	  DataEntry id =  (DataEntry) _imageData.getEntry( _current_image );
	  try {
		return id.time();
	  } catch ( NullPointerException e) {
		return _current_image * _dt;
	  }
    }
    
    public float getBaseTimestep() {
	  return _dt;
    }

    public float getTimestep() {
	  DataEntry id0 =  (DataEntry) _imageData.getEntry( 0 );
	  DataEntry id1 =  (DataEntry) _imageData.getEntry( 1 );
	  try {
		float t0 = id0.time();
		float t1 = id1.time();
		return t1 - t0;
	  } catch ( NullPointerException e) {
		return Float.MAX_VALUE;
	  }
    }

    public Graphics2D createGraphics2D( Graphics g, BufferedImage bi, boolean reset_image ) {
        Graphics2D g2 = null;
        int width = getSize().width; 
        int height = getSize().height; 
        if ( width <= 0 || height <= 0) return null;

		if (_offImg == null || _offImg.getWidth() != width || _offImg.getHeight() != height) {
			_offImg = (BufferedImage) createImage(width, height);
		} 

		if( _smooth_image ) { 
		  _rh.put( RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON );
		  _rh.put( RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY );
//		  _rh.put( RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR );
		} else {
		  _rh.put( RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF );
		  _rh.put( RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED );
//		  _rh.put( RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR );
		}
			
		g2 = _offImg.createGraphics();
		g2.setTransform(_transform );
		g2.setRenderingHints( _rh ); 
		g2.setBackground( _background );

		if( _clear_canvas ) {
		  g2.clearRect(0, 0, width, height);
		  _clear_canvas = false;
		}
        return g2;
    }

    public void paint(Graphics g) {
	         
		renderImage(g);
		
        if ( _offImg != null && isShowing() )  {
            g.drawImage( _offImg, 0, 0, this );
        }
        
        if( _selectionAreaActive ) {
		  g.setColor( Color.white );
		  g.drawRect( _selX, _selY, _selW,  _selH );
		  _selectionAreaActive = _editMode;
		}
    }

	public void setSelectionArea( int x, int y, int w, int h, boolean editMode  ) {
		_selectionAreaActive = true;
		_selX = (int) ((_base_offset_x + x)*_scale_x);	  
		_selY = (int) ((_base_offset_y + y)*_scale_y);	  
		_selW = (int) (w*_scale_x);	  
		_selH = (int) (h*_scale_y);	
		_editMode = editMode;
		repaint();  
	}
	
    public synchronized void renderImage( Graphics g ) {
       BufferedImage bi = null;
       DataEntry id =   (DataEntry) _imageData.getEntry( _current_image );
	   if( id == null ) return;
	   SimIO.print( "Rendering image " + _current_image + " from data " + id + ": size( " 
		 + _imageData.size(0) + "," + _imageData.size(1) + "," + _imageData.size(2) + "),  colormap:"  + _colormapIndex );

        try {
		  bi = (BufferedImage) _images.elementAt( _current_image );
		} catch ( IndexOutOfBoundsException ab_ex ) {;} 
		
		if( bi == null ) {
		  bi = CreateImage( _current_image );
		  if( !_fix_scaling ) {
			if( id.min() < _data_min_value ) {
			  _data_min_value = id.min();
			}
			if( id.max() > _data_max_value ) {
			  _data_max_value = id.max();
			}
		  }
		}

		if( _ddl != null ) { 
		  _ddl.timeChanged( id.time(), _current_image ); 
		  _ddl.scaleChangedMM( _data_max_value,  _data_min_value ); 
		}

		if( id.hasData() && ( bi.getRaster() != null ) ) { 
		  boolean float_scaling = ( id.getData() == null );
		  boolean reset_image = SetImageDisplayOperations(id);		  
		  if( _imageData.dims() == 3 ) filterDataSlice( id, bi ); 
		  else {
			if( float_scaling ) filterFloatData( id, bi );
			else  filterData( id, bi );
		  }
		  try {
			Graphics2D g2 = createGraphics2D( g, bi, reset_image );
			if( g2 == null ) return;
			g2.drawImage( bi, null, _base_offset_x, _base_offset_y );
			g2.setColor(Color.lightGray);
			g2.dispose();
		  } catch (java.awt.image.ImagingOpException err) {
			SimIO.print( "In AnimationImage2D.renderImage: " + err.getMessage() );
			err.printStackTrace();
		  }	
		}		
    }

    public void filterFloatData( DataEntry de, BufferedImage dst )  {  // Assumes default RGB color model.
	   SimIO.print( "In filterFloatData: " + de.toString() );
       byte[] mask = _imageData.getActiveRegion();
        byte format = _imageData.format();
        float[] src_data = de.getScaledData();
					
        float pixVal;
        int r, g, b, index, mindex = -1;
        int rgb = (0xff << 24) | ((int)0);
		for (int y=0; y < _image_height; y++ ) {
			for (int x = 0; x < _image_width; x++ ) {
				index = x + y*_image_width;
				if( ( mask == null ) || ( mask[index] > 0 ) ) { 
				  if( format == 0 ) { mindex = index; }
				  else { mindex++; }
				  pixVal = src_data[mindex];
				  if( pixVal == -Float.MAX_VALUE ) {
					rgb =  (0xff << 24) | ( 0xff << 16) | ( 0xff << 8) | 0xff;
				  } else {
					if( _useLogScale ) {
					  pixVal =  (float) (_log_scaler * Math.log( _scale_z * pixVal +  _translate_z ));
					} else {
					  pixVal = (float) ( pixVal*_scale_z + _translate_z );
					}
					switch( _colormapIndex ) {
					  case Greyscale:       // greyscale
						r = g = b = (int) (255*pixVal);
						rgb =  (0xff << 24) | ( r << 16) | ( g << 8) | b;
					  break;
					  case Custom:       // use colormap widget
						rgb = _colormap.getRGB( pixVal );
					  break;
					  case Rainbow:      // rainbow
						r = (int) (255*pixVal);
						g = (int) (( pixVal >= 0.5f ) ?  511*(1-pixVal) : 511*pixVal );
						b = (int) (255*(1-pixVal));
						rgb =  (0xff << 24) | ( r << 16) | ( g << 8) | b;
					  break;
					  default:
						rgb = (0xff << 24) | ((int)0);
					  break;
					}
				  }
				} else {
				  if( _colormapIndex == Greyscale ) {
					rgb = (0xff << 24) | ((int)100);
				  } else {
					rgb = (0xff << 24) | ((int)0);
				  }
				}
				dst.setRGB( x, y, rgb );
			}
		}		
    }		
    public void filterData( DataEntry de, BufferedImage dst )  {  // Assumes default RGB color model.
		SimIO.print( "In filterData: " + de.toString() );
        byte[] mask = _imageData.getActiveRegion();
        byte format = _imageData.format();
        short[] src_data = de.getData();
		int  max_src_raster_val = 256*256;
					
        int pixVal, r, g, b, index, mindex = -1;
        int rgb = (0xff << 24) | ((int)0);
		for (int y=0; y < _image_height; y++ ) {
			for (int x = 0; x < _image_width; x++ ) {
				index = x + y*_image_width;
				if( ( mask == null ) || ( mask[index] > 0 ) ) { 
				  if( format == 0 ) { mindex = index; }
				  else { mindex++; }
				  pixVal = src_data[mindex];
				  if( pixVal == 0 ) {
					rgb =  (0xff << 24) | ( 0xff << 16) | ( 0xff << 8) | 0xff;
				  } else {
					pixVal = ( pixVal < 0 ) ? pixVal + max_src_raster_val : pixVal;
					if( _useLogScale ) {
					  pixVal = (int) ( _log_scaler * Math.log( _scale_z * (pixVal-1) +  _translate_z ));
					} else {
					  pixVal = (int) ( (pixVal-1)*_scale_z + _translate_z );
					}
					pixVal = ( pixVal  < 0 ) ? 0 : pixVal;
					pixVal = ( pixVal  > 255 ) ? 255 : pixVal;
					switch( _colormapIndex ) {
					  case Greyscale:       // greyscale
						r = g = b = 255 - pixVal;
						rgb =  (0xff << 24) | ( r << 16) | ( g << 8) | b;
					  break;
					  case Custom:       // use colormap widget
						rgb = _colormap.getRGB( (pixVal)/(255f) );
					  break;
					  case Rainbow:      // rainbow
						r = pixVal;
						g = ( pixVal >= 128 ) ? ( 511 - 2*pixVal) : 2*pixVal;
						b = 255 - pixVal;
						rgb =  (0xff << 24) | ( r << 16) | ( g << 8) | b;
					  break;
					  default:
						rgb = (0xff << 24) | ((int)0);
					  break;
					}
				  }
				} else {
				  if( _colormapIndex == Greyscale ) {
					rgb = (0xff << 24) | ((int)100);
				  } else {
					rgb = (0xff << 24) | ((int)0);
				  }
				}
				dst.setRGB( x, y, rgb );
			}
		}		
    }		

	public void writeData( byte format,  String output_directory, String suffix ) {  
	
	  _output_directory = output_directory;
	  _write_format = format; 
	  _write_suffix = suffix;
	   
	  for( int i=0; i< _imageData.size(); i++ ) {
		writeData( i );
	  }
	}

   public void writeData(  int data_index )  {  

	  SimulationData sd = _imageData.getSimulationData();
	  int group_index = sd.simIndex();
	  String sim_name = sd.toString();
	  String name = _imageData.toString();
	  byte data_format = _imageData.format();
	  short background_value = 0;
	  boolean debug = false;
		  
	  String filename = sim_name + "_" + group_index + "." + name + "_" + data_index + _write_suffix;
	  File path = new File( _output_directory, filename );
	  FileOutputStream os = null;
	  try {
		os = new FileOutputStream( path );
	  } catch ( Exception e ) {
		SimIO.print( "Error opening file stream: " + filename ); 
		return;
	  }
	  DataOutputStream dos = null;
	  PrintStream pos = null;
	  if( debug ) {
		pos = new PrintStream(os);
	  } else {
		dos = new DataOutputStream(os);
	  }

	  DataEntry de = _imageData.getEntry( data_index );
	  byte[] mask = ( data_format == 0 ) ? null : _imageData.getActiveRegion();
	  int sx = _imageData.size(0);
	  int sy = _imageData.size(1);
	  int sz = _imageData.size(2);
	  int[][][] offsets = getOffsetArray( mask, _imageData.size(0), _imageData.size(1), _imageData.size(2) );
	  short[] src_data = de.getData();
	  short pixVal; int index, aindex;
	  try {
		for (int y=0; y < sy; y++ ) {
			for (int x = 0; x < sx; x++ ) {
			  for (int z = 0; z < sz; z++ ) {
				index = x + y*sx;
				if( ( mask == null ) || ((data_format==1)&&( mask[index] > z )) || ((data_format==2)&&( mask[index] > 0 ))  ) { 
				  aindex = ( _offsets == null ) ? index + x*sx*sy : _offsets[x][y][z];
				  try {				  
					pixVal = src_data[ aindex ];					
				  } catch ( ArrayIndexOutOfBoundsException err ) {
					SimIO.print("Data index out of bounds: " + aindex + ", image index = " + index + ", ( " + x + " , " + y + " ) "  );
					pixVal = 0;
				  }
				} else {
				  pixVal = background_value;
				}
				if( debug ) {
				  if( z == data_index ) {
					pos.print( "\n( " + x + " , " + y + " ) -> " + pixVal  );
				  }
				} else {
				  dos.writeShort( pixVal );
				}
			  }
			}
		}	
		if( dos != null ) { dos.close(); }	
		if( pos != null ) { pos.close(); }	
	  } catch ( java.io.IOException err ) {
		  SimIO.print(" IO Error writing grid data to " + filename + " :\n " + err.getMessage() );
	  }
    }
    
    public void filterDataSlice( DataEntry de, BufferedImage dst )  {  // Assumes default RGB color model.
		boolean local_debug = false;
        byte format = _imageData.format();
        byte[] mask = ( format == 0 ) ? null : _imageData.getActiveRegion();
        int[][][] offsets = getOffsetArray( mask, _imageData.size(0), _imageData.size(1), _imageData.size(2) );
        short[] src_data = de.getData();
		int  max_src_raster_val = 256*256;  
        int pixVal, rgb, r, g, b, index, aindex;
        int xc, yc, zc;
		for (int y=0; y < _image_height; y++ ) {
			for (int x = 0; x < _image_width; x++ ) {
				switch( _slice ) {
				  case SLICE_X:
					xc = ( _layer_offset < _imageData.size(0) ) ? _layer_offset : -1;
					yc = ( x < _imageData.size(1) ) ? x : -1;
					zc = ( y < _imageData.size(2) ) ? y : -1;
				  break;
				  case SLICE_Y:
					xc = ( x < _imageData.size(0) ) ? x : -1;
					yc = ( _layer_offset < _imageData.size(1) ) ? _layer_offset : -1;
					zc = ( y < _imageData.size(2) ) ? y : -1;
				  break;
				  case SLICE_Z:
					xc = ( x < _imageData.size(0) ) ? x : -1;
					yc = ( y < _imageData.size(1) ) ? y : -1;
					zc = ( _layer_offset < _imageData.size(2) ) ? _layer_offset : -1;
				  break;
				  default:
					xc = ( x < _imageData.size(0) ) ? x : -1;
					yc = ( y < _imageData.size(1) ) ? y : -1;
					zc = ( _layer_offset < _imageData.size(2) ) ? _layer_offset : -1;
				  break;
				}
				index = xc + yc*_imageData.size(0);
				if( (xc>=0) && (yc>=0) && (zc>=0) && (( mask == null ) || ((format==1)&&( mask[index] > zc )) || ((format==2)&&( mask[index] > 0 )) ) ) { 
				  aindex = ( _offsets == null ) ? index : _offsets[xc][yc][zc];
				  try {
					pixVal = src_data[ aindex ];
					if ( local_debug ) {
					  if( (x == 33) && ( y == 33 ) ) {
						SimIO.print("filter Data: " + aindex + ", image index = " + index + ", ( " + xc + " , " + yc + " , " + zc + " ) : val = " + pixVal );
					  }
					}
				  } catch ( ArrayIndexOutOfBoundsException err ) {
					SimIO.print("Data index out of bounds: " + aindex + ", image index = " + index + ", ( " + xc + " , " + yc + " ) "  );
					pixVal = 0;
				  }
				  if( pixVal == 0 ) {
					rgb =  (0xff << 24) | ( 0xff << 16) | ( 0xff << 8) | 0xff;
				  } else {
					pixVal = ( pixVal < 0 ) ? pixVal + max_src_raster_val : pixVal;
					if( _useLogScale ) {
					  pixVal = (int) ( _log_scaler * Math.log( _scale_z * (pixVal-1) +  _translate_z ));
					} else {
					  pixVal = (int) ( (pixVal-1)*_scale_z + _translate_z );
					}
					pixVal = ( pixVal  < 0 ) ? 0 : pixVal;
					pixVal = ( pixVal  > 255 ) ? 255 : pixVal;
					switch( _colormapIndex ) {
					  case Greyscale:       // greyscale
						r = g = b = 255 - pixVal;
						rgb =  (0xff << 24) | ( r << 16) | ( g << 8) | b;
					  break;
					  case Custom:       // use colormap widget
						rgb = _colormap.getRGB( (pixVal)/(255f) );
					  break;
					  default:      // rainbow
						r = pixVal;
						g = ( pixVal >= 128 ) ? ( 511 - 2*pixVal) : 2*pixVal;
						b = 255 - pixVal;
						rgb =  (0xff << 24) | ( r << 16) | ( g << 8) | b;
					  break;
					}
				  }
				} else {
				  if( _colormapIndex == Greyscale ) {
					rgb = (0xff << 24) | ((int)100);
				  } else {
					rgb = (0xff << 24) | ((int)0);
				  }
				}
				dst.setRGB( x, y, rgb );
			}
		}		
    }

    public void paintComponent(Graphics g) {
		g.setColor(_background);
		g.fillRect(0,0,getWidth(),getHeight());
    }

	void CalculateScaling( DataEntry id ) {
	  float data_range = _max_uns_raster_val - 1;
	  double ds = _data_max_value - _data_min_value;
	  boolean float_scaling = ( id.getData() == null );
	  if( _useLogScale ) {
		if( _uniform_scale ) {
		  if( ds > 0.0 ) {
			if( float_scaling ) {
			  _log_scaler = 1f / Math.log( 1 + ds );
			  _translate_z = 1 + (id.min() - _data_min_value);
			  _scale_z =  (id.max() - id.min()) / ds;
			} else {
			  _log_scaler = 255 / Math.log( 1 + ds );
			  _translate_z = 1 + (id.min() - _data_min_value);
			  _scale_z =  (id.max() - id.min()) / data_range;
			}
		  } else {
			_log_scaler = 128;
			_scale_z = 0.0f;
			_translate_z = Math.E;
		  }
		} else {
		  _log_scaler = 255 / Math.log( 1 + ds );
		  _translate_z = 1;
		  _scale_z =  ds / data_range;
		}
	  } else {
		if( _uniform_scale ) {
			if( ds > 0.0 ) {
			  if( float_scaling ) {
				_scale_z = ( 1 / ds );
				_translate_z =  -1 * _data_min_value  * _scale_z;
			  } else {
				_scale_z = ( (id.max() - id.min()) / ds ) * ( 255 / data_range );
				_translate_z = ( id.min() - _data_min_value ) * ( 255 / ds );
			  }
			} else {
			  _scale_z = 0.0f;
			  _translate_z = float_scaling ? 0.5f : 1f;
			}
		} else {
		  if( float_scaling ) {
			_scale_z =  1f / (id.max() - id.min());
			_translate_z =  -1 * id.min()  * _scale_z;;
		  } else {
			_translate_z = 0f;
			_scale_z =  255 / data_range;
		  }
		}
	  }
	  if( _debug ) { 
		SimIO.print("Calc scaling-> log:" + _useLogScale + ", uniform: " + _uniform_scale + "; ref( " + _data_max_value + " , " + _data_min_value + " ) : cur( " + id.max() + " , " + id.min() + " ) -> s: " + _scale_z + " , o: " + _translate_z + "; Mag -> x: " + _scale_x + " , y: " + _scale_y  );
	  }
	}

	public void SetAutoscale( boolean sb ) {
	  _uniform_scale = sb;
	  _fix_scaling = sb;
	  _reset_scaling = true;
	  if( sb ) {
		DataEntry id =  (DataEntry) _imageData.getEntry( _current_image );
		if( id == null ) return;
		_data_min_value = id.min();
		_data_max_value = id.max();
	  } 
	  repaint();
	}
	
	public int SetScaling( float max, float min ) {
	  _uniform_scale = true;
	  _fix_scaling = true;
	  _reset_scaling = true;
	  _data_min_value = min;
	  _data_max_value = max;
	  repaint();
	  return 0;
	}

	public float getMin( ) {
	  return _data_min_value;
	}
	public float getMax( ) {
	  return _data_max_value;
	}
	
	public void setSmoothing( boolean b ) {
	  _smooth_image = b;
	  _clear_canvas = true;
	  repaint();
	}
	
	public int SetMagnification( double mag ) {
	  if( mag < 1 ) mag = 1;
	  if( ( _scale_x != mag ) || ( _scale_y != mag ) ) {
		mag = ( mag > 10 ) ? 10 : mag;
		_scale_x = ( _int_mag ) ? (int)mag : mag;
		_scale_y = ( _int_mag ) ? (int)mag : mag;
		_reset_transform = true;
		if( _debug ) {
		  SimIO.print("Setting magnification: " + mag + ", scale = ( " + _scale_x + "," + _scale_y + ")" );
		}
		return 1;
	  } else return 0;
	}

	public int SetMagnification( double mag_x, double mag_y ) {
	  if( mag_x < 1 ) mag_x = 1;
	  if( mag_y < 1 ) mag_y = 1;
	  if( ( _scale_x != mag_x ) || ( _scale_y != mag_y ) ) {
		mag_x = ( mag_x > 10 ) ? 10 : mag_x;
		mag_y = ( mag_y > 10 ) ? 10 : mag_y;
		_scale_x = ( _int_mag ) ? (int)mag_x : mag_x;
		_scale_y = ( _int_mag ) ? (int)mag_y : mag_y;
		_reset_transform = true;
		if( _debug ) {
		  SimIO.print("Setting magnification: ( " + mag_x + "," + mag_y + "), scale = ( " + _scale_x + "," + _scale_y + ")" );
		}
		return 1;
	  } else return 0;
	}


	public int SetTranslation( float translate_x, float translate_y ) {
	  if( ( translate_x != _translate_x ) || ( translate_y != _translate_y ) ) {
		_translate_x = translate_x;
		_translate_y = translate_y;
		_reset_transform = true;
		return 1;
	  } else return 0;
	}

	public int SetTransformation( float scale_x, float scale_y, float translate_x, float translate_y ) {
	  if( ( translate_x != _translate_x ) || ( translate_y != _translate_y ) || ( _scale_x != scale_x ) || ( _scale_y != scale_y )) {
		scale_x = ( scale_x > 5 ) ? 5 : scale_x;
		scale_y = ( scale_y > 5 ) ? 5 : scale_y;
		scale_x = ( scale_x < 1 ) ? 1 : scale_x;
		scale_y = ( scale_y < 1 ) ? 1 : scale_y;
		_scale_x = scale_x;
		_scale_y = scale_y;
		_translate_x = translate_x;
		_translate_y = translate_y;
		_reset_transform = true;
		if( _debug ) {
		  SimIO.print("Setting magnification:  scale = ( " + _scale_x + "," + _scale_y + ")" );
		}
		return 1;
	  } else return 0;
	}
  	
	boolean SetImageDisplayOperations( DataEntry id ) {
	  boolean reset_image = false;
	  if( _reset_scaling ) {
		CalculateScaling(id); 
		if( !_uniform_scale ) _reset_scaling = false;
	  }
	  if( _reset_transform ) { 
        _transform = new AffineTransform( _scale_x, 0, 0, _scale_y, _translate_x, _translate_y ); 
        _transformOp = new AffineTransformOp( _transform, _rh );
		_reset_transform = false;
		reset_image = true;
	  }
	  return reset_image;
	}
		
    public IndexColorModel CreateColorModel() {
        int bits = 8;
        int ms = 255;
		byte colourData[][] = new byte[3][ms+1];
        double arcdeg = 3.1415926535897931D / ms;
        for(int i = 1; i <= ms; i++)
        {
            colourData[0][i] = (byte)i;
            colourData[1][i] = (byte)(int)(ms * Math.sin(i * arcdeg));
            colourData[2][i] = (byte)(ms - i);
        }

        colourData[0][0] = 0;
        colourData[1][0] = 0;
        colourData[2][0] = 0;
        return new IndexColorModel(bits, ms+1, colourData[0], colourData[1], colourData[2]);
//        return new ComponentColorModel (ColorSpace colorSpace,  int[] bits,  false,  false,  1);
    }

    public void update(Graphics g) {
            paint(g);
    }

	public void SaveAnimationJPEG( String path, String basename ) throws java.io.IOException {
		  
	  for( int i=0; i<_images.size(); i++ ) {
		SaveImageJPEG( i, path, basename );
	  }
	}
    
    public void SaveImageJPEG( int image_index, String dir, String basename ) throws java.io.IOException {
		if( image_index < 0 ) image_index = _current_image;	
		BufferedImage bi = null;	
		try {		
		  bi = (BufferedImage) _images.elementAt( image_index );
		  if( bi == null ) { throw new IndexOutOfBoundsException(); }
		} catch ( IndexOutOfBoundsException ab_ex ) { return; }
		
		String filename = basename + image_index + ".jpeg";
		File path = new File(dir,filename);
		FileOutputStream os = null;
		try {
		  os = new FileOutputStream( path );
		} catch ( Exception e ) {
		  SimIO.print( "Error opening file stream: " + filename ); 
		  return;
		}		
		SimIO.print( "Saving JPEG image: " + filename ); 
		JPEGEncodeParam parms = null;
		JPEGImageEncoder jie = JPEGCodec.createJPEGEncoder( os );		
		parms = JPEGCodec.getDefaultJPEGEncodeParam(bi);
		jie.encode(bi,parms);
		os.close();				
	}
	
	public void SaveAnimationPPM( String path, String basename ) throws java.io.IOException {
		  
	  for( int i=0; i<_images.size(); i++ ) {
		SaveImagePPM( i, path, basename );
	  }
	}
	
	private void writePixel( DataOutputStream dos, int val, boolean doBinary ) throws java.io.IOException {
		if( doBinary ) {
		  dos.writeByte( val );
		  dos.writeByte( val );
		  dos.writeByte( val );
		} else {
		  dos.writeBytes( "   " + val );   				
		  dos.writeBytes( " " + val );   				
		  dos.writeBytes( " " + val );   							  
		}
   }
	
    public void SaveImagePPM( int image_index, String dir, String basename ) throws java.io.IOException {
		if( image_index < 0 ) image_index = _current_image;
		BufferedImage bi = null;
        try {
		  bi = (BufferedImage) _images.elementAt( image_index );
		} catch ( IndexOutOfBoundsException ab_ex ) { 
		  SimIO.print( "attempt to save null image: " + image_index ); 
		}
		if( bi == null ) return;
		boolean doBinary = true;

		DataEntry id =  (DataEntry) _imageData.getEntry( image_index );
		float  time =  id.time(), t0 = time;		
		int[] ts_digits = new int[8];
		int itmp, factor = 100000;
		for( int i=0; i<6; i++ ) {
		   itmp = (int) (time/factor);
		   ts_digits[i] = ( (t0 >= factor) || (i==5) ) ? ( itmp % 10 ) : 11;
		   if( time > factor ) {   time -= itmp*factor;   } 
		   factor /= 10;
		}
		ts_digits[6] = 10;
		ts_digits[7] = (int) time*10;
		
		
		String filename = basename + image_index + ".ppm";
		File path = new File(dir,filename);
//		if( !path.canWrite() ) {  throw new java.io.IOException( "Can't write to file " + path ); }
		FileOutputStream os = null;
		DataOutputStream dos = null;
		try {
		  os = new FileOutputStream( path );
		  dos = new DataOutputStream(os);
		} catch ( Exception e ) {
		  SimIO.print( "Error opening file stream: " + filename ); 
		  return;
		}
		WritableRaster wr = (WritableRaster) bi.getData();
		int w = wr.getWidth();
		int h = wr.getHeight();
		int hight_with_ts = ( ts_digits != null ) ? (h+7) : h;
		int i, j, k, rgb;
//		DataBufferByte db = (DataBufferByte)wr.getDataBuffer();
//		byte[] data = db.getData();
		String head = (doBinary) ? "P6" : "P3";
		dos.writeBytes(head);
		dos.writeBytes( "\n" + w );   				// width
		dos.writeBytes( "\n" + hight_with_ts );     // height 
		dos.writeBytes( "\n" + 255 + "\n" );   				
		byte bval; float fval;
		boolean isBackground = false;
		int index, r, g, b;
		for( i=0; i<h; i++ ) {
		  for( j=0; j<w; j++ ) {
			index = j + i*w;
			if( _imageData.getActiveRegion()  != null ) {
			  isBackground = ( _imageData.getActiveRegion() [index] == 0 ); 
			}
			if( isBackground ) {
			  r = g = b = 0;
			} else {
			  rgb = bi.getRGB(j,i);
//			  r = (bval<0) ? 256 + bval : bval; 
//			  g = (r > 127) ? ( 511-2*r ) : ( 2*r );
//			  b = 255 - r;
			  r = (byte) (rgb >> 16);
			  g = (byte) (rgb >> 8);
			  b = (byte) rgb;
			}
			if( doBinary ) {
			  dos.writeByte( r );
			  dos.writeByte( g );
			  dos.writeByte( b );
			} else {
			  dos.writeBytes( "   " + r );   				
			  dos.writeBytes( " " + g );   				
			  dos.writeBytes( " " + b );   							  
			}
		  }
		  if( !doBinary ) dos.writeBytes( "\n" );    
		}
		
		// write timestamp.
		
		if( ts_digits != null ) try {
		  int black = 0, white = 255;
		  int ndigits = Math.min( ts_digits.length, w/4 );
		  int start = ts_digits.length - ndigits;
		  for( j=0; j<w; j++ ) {
			writePixel( dos, black, doBinary ); 
		  }
		  if( !doBinary ) dos.writeBytes( "\n" );    

		  for( i=0; i<5; i++ ) {	
			int cnt = 0;		  	
			for( j=start; j< ts_digits.length; j++ ) {
			  writePixel( dos, black, doBinary ); 
			  cnt++;
			  int digit = ts_digits[j];
			  for( k=0; k<3; k++ ) {
				cnt++;
				if( nfont_data[digit][i][k] > 0 ) {
				  writePixel( dos, white, doBinary ); 
				} else {
				  writePixel( dos, black, doBinary ); 
				}
			  }
			}
			while( cnt++ < w ) {
			  writePixel( dos, black, doBinary ); 
			}
			if( !doBinary ) dos.writeBytes( "\n" );    
		  }		
		  for( j=0; j<w; j++ ) {
			writePixel( dos, black, doBinary ); 
		  }
		  if( !doBinary ) dos.writeBytes( "\n" );    
		} catch ( Exception err ) {;}
		 
		os.close();
	}
	
     public void setBounds(int x, int y, int width, int height) {
		double mag_w = ( width - 2 * _base_offset_x )/_image_width;
		double mag_h = ( height - 2 * _base_offset_y )/_image_height;
		SetMagnification( ( mag_w < mag_h ) ? mag_w : mag_h );
		super.setBounds( x, y, width, height);
    }

	public void stop() {
	  if( _animThread != null ) { 
		_anim_control_mode = ANIM_EXIT;
		_animThread = null;
	  }
	}
	   
    public void run() {
        while ( _anim_control_mode != ANIM_EXIT ) {
            try {  Thread.sleep(200L);   }
            catch (InterruptedException e0) {  return;  }
            
            switch ( _anim_control_mode ) {
                case ANIM_PAUSE: 
					continue;
                case ANIM_STEP:
                    if( ++_current_image == _imageData.size()) _current_image = 0;
                    repaint();
                    _anim_control_mode= ANIM_PAUSE; 
                    continue;
                case ANIM_RUN:
					if( ++_current_image == _imageData.size()) _current_image = 0;
					repaint();
					continue;
                case ANIM_WAIT:
					if( _imageData.size() > _images.size() ) { _current_image = _images.size(); }
					repaint();
					continue;
            }
        }
    } 
      	
	public float GetValue( int row, int col ) {
		float value = 0f;
		DataEntry id =  (DataEntry) _imageData.getEntry( _current_image );

		if( id != null ) {
		  if( _imageData.dims() == 2 ) {
			value = _imageData.getValue( row,  col, id );
		  } else {
			int sindex = getSliceDataOffset(row,col);
			if( sindex >= 0 ) {
			  value = id.getValue(sindex);
			}
		  }
		} 
		return value;
	}

	public float GetSourceValue( int row, int col ) {
		float value = 0f;
		DataEntry id =  (DataEntry) _imageData.getEntry( _current_image );

		if( id != null ) {
		  if( _imageData.dims() == 2 ) {
			value = _imageData.getSourceValue( row,  col, id );
		  } else {
			int sindex = getSliceDataOffset(row,col);
			if( sindex >= 0 ) {
			  value = id.getSourceValue(sindex);
			}
		  }
		} 
		return value;
	}

	int getSliceDataOffset( int row, int col ) {
	  int rv = -1;
	  byte format = _imageData.format();
	  byte[] mask = ( format == 0 ) ? null : _imageData.getActiveRegion();
	  int xc, yc, zc;
	  switch( _slice ) {
		case SLICE_X:
		  xc = ( _layer_offset < _imageData.size(0) ) ? _layer_offset : -1;
		  yc = ( col < _imageData.size(1) ) ? col : -1;
		  zc = ( row < _imageData.size(2) ) ? row : -1;
		break;
		case SLICE_Y:
		  xc = ( col < _imageData.size(0) ) ? col : -1;
		  yc = ( _layer_offset < _imageData.size(1) ) ? _layer_offset : -1;
		  zc = ( row < _imageData.size(2) ) ? row : -1;
		break;
		case SLICE_Z:
		  xc = ( col < _imageData.size(0) ) ? col : -1;
		  yc = ( row < _imageData.size(1) ) ? row : -1;
		  zc = ( _layer_offset < _imageData.size(2) ) ? _layer_offset : -1;
		break;
		default:
		  xc = ( col < _imageData.size(0) ) ? col : -1;
		  yc = ( row < _imageData.size(1) ) ? row : -1;
		  zc = ( _layer_offset < _imageData.size(2) ) ? _layer_offset : -1;
		break;
	  }
	  int index = xc + yc*_imageData.size(0);
	  if( (xc>=0) && (yc>=0) && (zc>=0) && (( mask == null ) || ((format==1)&&( mask[index] > zc )) || ((format==2)&&( mask[index] > 0 )) ) ) { 
		rv =  ( _offsets == null ) ? index : _offsets[xc][yc][zc];
	  }
	  return rv;
	}
		
    public void mouseClicked(MouseEvent e0)
    {
		int c = e0.getX();
		int r = e0.getY();
        int col = (int) ((c/_scale_x) - _base_offset_x);
        int row = (int) ((r/_scale_y) - _base_offset_y);  
        if( _ddl != null ) {
		  _ddl.pointSelected( row, col, GetValue( row, col )  );
		  if( e0.isShiftDown() ) { _ddl.pointTimeseriesSelected( row, col ); }	
        }
		if( _debug ) {
		  SimIO.print( "Registering mouse click at ( " + row + " , " + col + " ):( " + r + " , " + c + " ): src_val = " + GetSourceValue( row, col ) );
		}
    }

    public void mousePressed(MouseEvent e)
    {
//        _drag_anchor = e;
    }

    public void mouseReleased(MouseEvent e)  {
//        if((_drag_anchor.getX() != e.getX() || _drag_anchor.getY() != e.getY()) && notifyRegionSelected(_drag_anchor, e))
//            notifyScrollScaleChanged();
//        _mouse_drag = false;
    }

    public void mouseEntered(MouseEvent mouseevent)
    {
    }

    public void mouseExited(MouseEvent mouseevent)
    {
    }

    public void mouseDragged(MouseEvent e)   {
/*        if(_do_crop) {
            _mouse_drag = true;
            _selection.width = e.getX() - _drag_anchor.getX();
            _selection.height = e.getY() - _drag_anchor.getY();
            _do_clear = true;
            repaint();
        }
*/
    }

    public void mouseMoved(MouseEvent mouseevent)
    {
    }    	
/*        
    public static void main(String s[]) {
        WindowListener l = new WindowAdapter() {
            public void windowClosing(WindowEvent e) {System.exit(0);}
            public void windowClosed(WindowEvent e) {System.exit(0);}
        };
        Frame f = new Frame("AnimationImage2D test");
        f.addWindowListener(l);
		int width = 150;
		int height = 100;
		int max_images = 5;	
		       
        AnimationImage2D a2D = new AnimationImage2D( width, height, null );
        
        f.add("Center", a2D );
        f.pack();
        f.setSize( new Dimension(750,600) );
        f.show();
		   
		float max_value = Float.MIN_VALUE;
		for( int i=0; i<max_images; i++ ) {
		  max_value = Float.MIN_VALUE;
		  short[] data = new short[height*width];
		  for( int i1 = 0; i1<height; i1++ ) {
			for( int i2 = 0; i2<width; i2++ ) {
			  int index = i2 + i1*width;
			  int a = max_images - i;
			  int b = i+1;
			  int value = ((i2*i2)/a) + ((i1*i1)/b);
			  max_value = (value > max_value) ? value : max_value;
			  data[index] = (short)value;
			}
		  }
//		  a2D.CreateImage( data );
		}
		float scale = 255/max_value;
		a2D.SetScaling( scale, 0 );

		a2D.SetMagnification( 4, 4 );
		  
		for( int i=0; i<max_images; i++ ) {
		  a2D.setCurrentImage( i );
		}
		
	  }
//                itmp = itmp < 0 ? 256 + itmp : itmp;
*/
}

