package miiee.dataview;  

import javax.swing.*;
import javax.swing.border.*;
import java.io.File;
import java.util.Vector;
import java.awt.image.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.applet.Applet;
import javax.swing.table.*;
import miiee.util.*;
import javax.help.*;
import miiee.TGraph.TimeGraph;

public class AnimationViewer extends Object implements AnimationController, IOController, DisposableListDataListener, ItemListener, TableModelListener
{
    /** Animation. */
    protected AnimationImage2D       _animation;	  
    protected AnimationControlPanel _controlPanel;
    protected DataTable _dataTable;
    protected JFrame _frame;
    protected String _name;
    protected String _sim_name;
    protected int _group_index = 0;
    protected boolean _browse;
    protected boolean _write = false;
    protected boolean _edit;
    protected int scol = -1;
    protected int srow = -1;
    
    protected AttributeValuePair _time;
    protected AttributeValuePair _value;
    protected AttributeValuePair _scale;
    protected int _width;
    protected int _height;
    protected int _dims;
    protected String _helpText;
    protected SaveFileControlPanel _saveControlPanel;
    protected AttributeValuePair _rescale_max;
    protected AttributeValuePair _rescale_min;
	protected AttributeValuePair _layer_offset;
	protected JComboBox _currentImage;
    protected String _empty = new String("empty");
    protected TimeGraph _pointTimeseries;


   /**
      * Constructs a new instance of AnimationViewer.
      */
/*	
    public AnimationViewer( int width, int height, String name, byte region_map[] ) {
		_animation = new AnimationImage2D(width,height,region_map);
		_animation.setBorder( BorderFactory.createLoweredBevelBorder() );
		_height = height;
		_width = width;
		_name = name;
		generateHelpText();
    }
*/    
    public AnimationViewer( DataSet d ) {
		_animation = new AnimationImage2D( d );
		_animation.setBorder( BorderFactory.createLoweredBevelBorder() );
		_height = d.size(0);
		_width = d.size(1);
		_dims = d.dims();
		_name = d.toString();
		generateHelpText();
		_browse = ( d.browse() > 0 );
		_edit = d.edit();
    }

    public AnimationViewer( DataSet d, int group_index, String sim_name ) {
		_animation = new AnimationImage2D( d );
		_animation.setBorder( BorderFactory.createLoweredBevelBorder() );
		_height = d.size(0);
		_width = d.size(1);
		_name = d.toString();
		_sim_name = sim_name;
		_group_index = group_index;
		_dims = d.dims();
		generateHelpText();
		_browse = ( d.browse() > 0 );
		_edit = d.edit();
    }		  

	public synchronized JFrame show( String name ) {
	  _animation.getDataSet().addEntryDataListener(this);
	  _frame = new JFrame(name);
	  WindowListener l = new WindowAdapter() {
		  public void windowClosing(WindowEvent e) { if( !_browse ) destroy(); }
	  };
	  _frame.addWindowListener( l );
	  JPanel viewer_panel = (JPanel)_frame.getContentPane();	
      
      if( _edit ) {  
 		viewer_panel.add( "Center", constructEditor() ); 
     } else {    
		viewer_panel.add( "Center", _animation );
		viewer_panel.add( "South", constructOptionsPanel());
	  }
	  _animation.setSmoothing(false);

	  _animation.AddAnimationController(this);

	  if( !_browse ) {
		if( _controlPanel == null ) {
		  _controlPanel = AnimationControlPanel.GetControlPanel( _group_index, _sim_name );
		  _controlPanel.addAnimation(_animation);
		}
		_controlPanel.showPanel();
	  }
	  _animation.start();
	  if( _edit ) {
		_animation.setSelectionArea( 0, 0, 18, 18, true  );
	  } 
 
	  _frame.setJMenuBar( constructMenuBar() );
	  _frame.setBackground(Color.lightGray);
	  if( _edit ) {    _frame.setSize(950,550); }
	  else        {    _frame.setSize(400,400); }
	  
	  Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
	  int x = (screenDim.width - _frame.getSize().width) / 4;
	  int y = (screenDim.height - _frame.getSize().height) / 4;
	  _frame.setLocation(x, y);	   

	  _frame.setVisible(true);
	  return _frame;
	}
	
	public void addTableModelListener(TableModelListener l) {
		_dataTable.addTableModelListener(l);  
	}  
	
	private JPanel constructEditor() {
	  JPanel    editorPanel = new JPanel(false);
	  EmptyBorder eb3 = new EmptyBorder( 3, 3, 3, 3 );
	  BoxLayout bl = new BoxLayout(editorPanel, BoxLayout.X_AXIS );	  editorPanel.setLayout( bl ); 	   

	  if( _dataTable == null ) {
		_dataTable = DataTable.getTablePanel( _animation.getDataSet(), this, true );
		_dataTable.addTableModelListener(this);    
	  }
	  Border bb = BorderFactory.createCompoundBorder( new BevelBorder(BevelBorder.LOWERED), eb3 );  	
	  _dataTable.setBorder( bb );
	  _dataTable.setMaximumSize(new Dimension(Short.MAX_VALUE,  Short.MAX_VALUE)); 
	  editorPanel.add(_dataTable);

	  JPanel pV1  = new JPanel(true);
	  pV1.setLayout(new BorderLayout());
	  pV1.add( "Center", _animation );
	  pV1.add( "South", constructOptionsPanel());
	  bb = BorderFactory.createCompoundBorder( new BevelBorder(BevelBorder.LOWERED), eb3 );   pV1.setBorder( bb );
	  pV1.setMaximumSize(new Dimension(Short.MAX_VALUE,  Short.MAX_VALUE)); 
	  editorPanel.add(pV1);

	  return editorPanel;
	}

    /** Constructs a JPanel containing check boxes for the different
      * options that tree supports. */
  private JPanel constructOptionsPanel() {
	JCheckBox               aCheckbox;
	JPanel           buttonPanel = new JPanel(false);
	JPanel           borderPane = new JPanel(false);  
	JButton aButton;
	buttonPanel.setLayout(new FlowLayout());

	if( _browse ) {

	  borderPane.setLayout(new GridLayout( ( _dims == 3 ) ? 4 : 3, 1 ));
	  borderPane.add(buttonPanel);	  

	  JLabel label = new JLabel("Displaying: ");
	  buttonPanel.add( label );
	  _currentImage  = new JComboBox();
	  _currentImage.addItemListener(this);
	  int ds_size = getDataSet().size();
	  if( ds_size > 0 ) {
		setBrowserImage( ds_size-1 );
	  }
	  buttonPanel.add( _currentImage );
	  
	  buttonPanel = new JPanel(false);
	  buttonPanel.setLayout(new FlowLayout());
	  borderPane.add(buttonPanel);

	  _scale = AttributeValuePair.New( "scale", false, 16 );
	  buttonPanel.add(_scale);
	  
	  if( _edit ) { 
		aCheckbox = new JCheckBox("log");
		aCheckbox.setSelected(false);
		aCheckbox.addChangeListener(new LogScaleChangeListener());
		buttonPanel.add(aCheckbox);
	  } 
		  
	} else {

	  borderPane.setLayout(new GridLayout( ( _dims == 3 ) ? 3 : 2, 1 ));
	  borderPane.add(buttonPanel);

	  _scale = AttributeValuePair.New( "scale", false, 16 );
	  buttonPanel.add(_scale);

	  aButton = new JButton("rescale");
	  aButton.addActionListener( new ScaleAction() );
	  buttonPanel.add( aButton );
	}


	if( !_edit ) {  
	  JPanel   infoPanel = new JPanel(false);
	  infoPanel.setLayout(new FlowLayout());
	  borderPane.add(infoPanel);

	  _value = AttributeValuePair.New( "value:", false, 16 );
	  infoPanel.add(_value);
	  
	  aCheckbox = new JCheckBox("smooth");
	  aCheckbox.setSelected(false);
	  aCheckbox.addChangeListener(new SmoothImagesChangeListener());
	  infoPanel.add(aCheckbox);
	  
	  aCheckbox = new JCheckBox("log");
	  aCheckbox.setSelected(false);
	  aCheckbox.addChangeListener(new LogScaleChangeListener());
	  infoPanel.add(aCheckbox);
	}
		

    if( _dims == 3 ) {
	  JPanel   slicePanel = new JPanel(false);
	  slicePanel.setLayout(new FlowLayout());
	  borderPane.add(slicePanel);

	  _layer_offset = AttributeValuePair.New( "Layer Offset:", false, 8 );
	  _layer_offset.setValue( Integer.toString(0) );
	  slicePanel.add(_layer_offset);

	  aButton = new JButton("+");
	  aButton.addActionListener( new SliceMoveAction(true) );
	  slicePanel.add( aButton );

	  aButton = new JButton("-");
	  aButton.addActionListener( new SliceMoveAction(false) );
	  slicePanel.add( aButton );
	}		
	return borderPane;
    }

    /** Construct a menu. */

    private JMenuBar constructMenuBar() {
	JMenu            menu;
	JMenuBar         menuBar = new JMenuBar();
	JMenuItem        menuItem;

	menu = new JMenu("File");
	menu.setBackground(Color.lightGray);
	menuBar.add(menu);

	menuItem = menu.add(new JMenuItem("Save"));
	menuItem.addActionListener(new SaveAction(this));

	menuItem = menu.add(new JMenuItem("Quit"));
	menuItem.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		   _frame.dispose();
	    }});

	menu = new JMenu("View");
	menuBar.add(menu);

	menuItem = menu.add(new JMenuItem("Manual rescale"));
	menuItem.addActionListener(new ManualScaleAction());

	JMenu cmenu = new JMenu("Colormap");
	menuItem = menu.add(cmenu);
	
	menuItem = cmenu.add(new JMenuItem("GreyScale"));
	menuItem.addActionListener( new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		   _animation.setColormapType( AnimationImage2D.Greyscale ); 
	    }});

	menuItem = cmenu.add(new JMenuItem("Rainbow"));
	menuItem.addActionListener( new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		   _animation.setColormapType( AnimationImage2D.Rainbow ); 
	    }});

	menuItem = cmenu.add(new JMenuItem("Custom"));
	menuItem.addActionListener( new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		   _animation.setColormapType( AnimationImage2D.Custom ); 
	    }});

	if( ! _edit ) {
	  menuItem = menu.add(new JMenuItem("Attach new DataViewer"));
	  menuItem.addActionListener(new AttachDataViewerAction(this));

	  menuItem = menu.add(new JMenuItem("Attach new Data Editor"));
	  menuItem.addActionListener(new AttachDataEditorAction(this));
	}
	menuItem = menu.add(new JMenuItem("Print Legend"));
	menuItem.addActionListener(new PrintLegendAction());

	menu.addSeparator();
	if( _dims == 3 ) {
       menu.add( new SlicePlaneChanger() );        
	}
	menuItem = menu.add(new JMenuItem("2"));
//	menuItem.addActionListener(new RemoveAction());

/*	if( _browse ) { 
	  _browseMenu = new JMenu("Image");
	  menuBar.add(_browseMenu);	

	  int size = _animation.getDataSet().size();
	  for( int i=0; i<size; i++ ) {
		DataEntry de = setBrowserImage( i );
		if( de != null ) { 
		  menuItem = _browseMenu.add( new JMenuItem( de.toString() ) );
		  menuItem.addActionListener( new SetDataSetAction(i) );
		}
	  }
	}
*/
	menu = new JMenu("Help");
	menuBar.add(menu);

	try {
	  menuItem = menu.add(new JMenuItem("AnimationViewer help"));
	  HelpBroker hb = SimIO.getHelpBroker( "SME", "Vanim2D"  );
	  menuItem.addActionListener( new CSH.DisplayHelpFromSource(hb)  );
	} catch( Exception err ) {;}

	_time = AttributeValuePair.New( "Image index", false, 3 );
	menuBar.add(_time);

	return menuBar;
    }

    public void itemStateChanged(ItemEvent e) {
	  int state = e.getStateChange();
	  if( state == ItemEvent.SELECTED ) {
		int index = _currentImage.getSelectedIndex();
		_animation.setAnimationIndex( index );
		_animation.SetAutoscale(true);
		_animation.getDataSet().setSelection( index );
//		if( _dataTable != null ) { _dataTable.setIndex( index ); }
	  } 
    }

	void setBrowserImage( int index ) {
	  SimIO.print("setBrowserImage: " + index );
	  _frame.setVisible(true);
	  DataSet ds = _animation.getDataSet();
	  DataEntry de = null;
	  if( index >= ds.size() ) return;
	  int nItems = 	_currentImage.getItemCount();
	  for( int i = nItems; i < ds.size(); i++ ) {
		de = ds.getEntry(i);
		if( de != null ) { 
		  _currentImage.addItem(de);
		} else {
		  _currentImage.addItem(_empty);
		}
	  } 
	  _currentImage.setSelectedIndex(index);
	}

     class SliceMoveAction extends Object implements ActionListener {
	  boolean _direction;
	  public SliceMoveAction( boolean direction ) { super(); _direction = direction; }
	  public void actionPerformed(ActionEvent e) {
		int layer_offset = _animation.moveSlice( _direction ); 
		_layer_offset.setValue( Integer.toString(layer_offset) );
	  }
    } 
    
   class SaveAction extends Object implements ActionListener {
	  IOController _ac;
	  public SaveAction( IOController ac ) { super(); _ac = ac; }
	  public void actionPerformed(ActionEvent e) {
		SimulationData sd = DataSet.getCurrentSimulation();
		_saveControlPanel = SaveFileControlPanel.showControlPanel( _ac, _name, sd.getProjPath(), null );
	  }
    } 
    
    class ManualScaleAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) {
		 float max = _animation.getMax( ); 
		 float min = _animation.getMin( );
		 open_manual_scale_panel( max, min );
	  }
    } 
    class AttachDataViewerAction extends Object implements ActionListener {
	  AnimationViewer _av;
	  AttachDataViewerAction( AnimationViewer av ) { _av = av; }
	  public void actionPerformed(ActionEvent e) {
		if( _dataTable == null ) {
		  _dataTable = DataTable.getTable( _animation.getDataSet(), _av, false );
		}
	  }
    } 

    class AttachDataEditorAction extends Object implements ActionListener {
	  AnimationViewer _av;
	  AttachDataEditorAction( AnimationViewer av ) { _av = av; }
	  public void actionPerformed(ActionEvent e) {
		if( _dataTable == null ) {
		  _dataTable = DataTable.getTable( _animation.getDataSet(), _av, true );
		}
	  }
    } 
    
   class SlicePlaneChanger extends JMenu implements ItemListener {
       JRadioButtonMenuItem XY_Rb, XZ_Rb, YZ_Rb;

       public SlicePlaneChanger() {
           super("Set Slice Plane");

           ButtonGroup tabGroup = new ButtonGroup();

           XY_Rb = (JRadioButtonMenuItem)add(new JRadioButtonMenuItem("XY"));
           XY_Rb.setSelected(true);
           XY_Rb.addItemListener(this);
           tabGroup.add(XY_Rb);
        
           XZ_Rb = (JRadioButtonMenuItem)add(new JRadioButtonMenuItem("XZ"));
           XZ_Rb.addItemListener(this);
           tabGroup.add(XZ_Rb);

           YZ_Rb = (JRadioButtonMenuItem)add(new JRadioButtonMenuItem("YZ"));
           YZ_Rb.addItemListener(this);
           tabGroup.add(YZ_Rb);
        }

	public void itemStateChanged(ItemEvent e) {
	    JRadioButtonMenuItem rb = (JRadioButtonMenuItem) e.getSource();
            if (rb.isSelected()) {
                String selected = rb.getText();
                if (selected.equals("XY")) {
                    _animation.setSliceAxis( AnimationImage2D.SLICE_Z );
                    _layer_offset.setValue( Integer.toString(0) );
                } else if (selected.equals("XZ")) {
					_animation.setSliceAxis( AnimationImage2D.SLICE_Y );
					_layer_offset.setValue( Integer.toString(0) );
                } else if (selected.equals("YZ")) {
                    _animation.setSliceAxis( AnimationImage2D.SLICE_X );
                    _layer_offset.setValue( Integer.toString(0) );
                } else {
                    _animation.setSliceAxis( AnimationImage2D.SLICE_Z );
                    _layer_offset.setValue( Integer.toString(0) );
                }
            }
        }
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (!enabled) {
                XY_Rb.setSelected(true);
            } else {
                int slice_plane = _animation.getSliceAxis();
                switch(slice_plane) {
                  case AnimationImage2D.SLICE_Z:
                      XY_Rb.setSelected(true);
                      break;
                  case AnimationImage2D.SLICE_Y:
                      XZ_Rb.setSelected(true);
                      break;
                  case AnimationImage2D.SLICE_X:
                      YZ_Rb.setSelected(true);
                      break;
                  default:
                }
            }
        }
    }
                    
    class PrintLegendAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) {
		_animation.printLegend();
	  }
    } 

    class ScaleAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) {
		_animation.SetAutoscale(true);
	  }
    } 
    
    class ManualScaleSetAction extends Object implements ActionListener {
	  JFrame _frame;
	  ManualScaleSetAction(JFrame frame) { _frame = frame; }
	  public void actionPerformed(ActionEvent e) {
		try {
		   String max =  _rescale_max.getValue();
		   Float fmax = Float.valueOf(max);
		   String min =  _rescale_min.getValue();	
		   Float fmin = Float.valueOf(min);
		  _animation.SetScaling( fmax.floatValue(), fmin.floatValue() );
		  _frame.setVisible(false);
		  _frame.dispose();
		} catch ( NumberFormatException ex ) { SimIO.print(" NumberFormatException in ManualScaleSetAction "); }
	  }
    } 
    
    class ManualScaleCancelAction extends Object implements ActionListener {
	  JFrame _frame;
	  ManualScaleCancelAction(JFrame frame) { _frame = frame; }
	  public void actionPerformed(ActionEvent e) {
		_frame.setVisible(false);
		_frame.dispose();
	  }
    } 
    
    public void invalidate_dataTable() { _dataTable = null; }
    public float getTime() { return _animation.getTime(); }
    
	void generateHelpText() {
	  _helpText = 
		"  To View Animations: \n"
	  + "  1. Use buttons to move forward or backward through images, \n"
	  + "  2. Click on the image to display point coordinates and value, \n"
	  + "  3. Shift-Click on the image to create a point timeseries, \n"
	  + "  4. Press the 'Rescale' button to rescale whole animation to max/min of current image. \n"
	  + "  Save animations using the File menu.  ";
	}

   /**
      * SmmothImagesChangeListener implements the ChangeListener interface
      * to toggle the state of showing the handles in the tree.
      */
    class SmoothImagesChangeListener extends Object implements ChangeListener {
	  public void stateChanged(ChangeEvent e) {
		  _animation.setSmoothing(((JCheckBox)e.getSource()).isSelected());
	  }
    } 

    class LogScaleChangeListener extends Object implements ChangeListener {
	  public void stateChanged(ChangeEvent e) {
		  _animation.enableLogScale(((JCheckBox)e.getSource()).isSelected());
	  }
    }
    
    public void timeChanged( float time, int index ) {
   	  UpdateTimeAction timeUpdate = new UpdateTimeAction(time,index);
	  timeUpdate.executeOnEventDispatchTread();
	}

	class UpdateTimeAction extends QueuedExecutable  {
	  float _timeval; int _index; 
	  UpdateTimeAction( float time, int index ) { _timeval = time; _index = index; }
	  public void execute() {
		try { 
		  _time.setValue( Integer.toString(_index) );
		  if( _dataTable != null ) { 
			_dataTable.setIndex( _index );
		  }
		} catch ( NullPointerException err ) { ; }
	  }
    } 
    
    public  synchronized void pointSelected( int row, int col, float value ){
   	  PointSelectedAction selUpdate = new PointSelectedAction(row,col,value);
	  selUpdate.executeOnEventDispatchTread();
	}
 
 	class PointSelectedAction extends QueuedExecutable  {
	  int _row; int _col; float _val; 
	  PointSelectedAction( int row, int col, float value  ) { _row = row; _col = col; _val = value; }
	  public void execute() {
		FormattedFloat fval = new FormattedFloat(_val);
		String val = "(" + Integer.toString(_row) + "," + Integer.toString(_col) + "): " + fval.toJavaFormatString(4);
		if( _value != null ) { _value.setValue(val); }
		if( _dataTable != null ) { 
		  _dataTable.setOffsets( _col, _row );
		  _animation.setSelectionArea( _col, _row, _dataTable.getColumnCount(), _dataTable.getRowCount(), _edit  ); 
		}
		SimIO.print("Setting point value to " + val );
	  }
    } 
  
	private int _pts_index=0;
	public  void pointTimeseriesSelected( int row, int col ) {
	  if( _pointTimeseries == null || ( _pts_index >= 8 ) ) {
		_pointTimeseries = new TimeGraph();
		_pts_index = 0;
	  }
	  DataSet ds = _animation.getDataSet();
	  SimIO.print("Adding timegraph, " + ds.size() + " data entries. " );
	  _pointTimeseries.addComponent( _pts_index++, ds, row, col );
	  _pointTimeseries.addDataEntries( ds, row, col );
	  _pointTimeseries.show( "Point timeseries" );
	}
	
    public void regionSelected( int row0, int col0, int row1, int col1 ) {;}

    public void scaleChangedSO( float scale, float offset ) {
	  FormattedFloat fscale = new FormattedFloat(scale);
	  FormattedFloat foffset = new FormattedFloat(offset);
	  String val = "s: " + fscale.toJavaFormatString(4) + ", o: " + foffset.toJavaFormatString(4);
   	  ScaleChangedAction scaleUpdate = new ScaleChangedAction(val);
	  scaleUpdate.executeOnEventDispatchTread();
    }

    public void scaleChangedMM( float max, float min ) {
	  FormattedFloat fmax = new FormattedFloat(max);
	  FormattedFloat fmin = new FormattedFloat(min);
	  String val = "max: " + fmax.toJavaFormatString(4) + ", min: " + fmin.toJavaFormatString(4);  
   	  ScaleChangedAction scaleUpdate = new ScaleChangedAction(val);
	  scaleUpdate.executeOnEventDispatchTread();
    }

 	class ScaleChangedAction extends QueuedExecutable  {
	  String _scale_value;
	  ScaleChangedAction( String scale  ) { _scale_value = scale; }
	  public void execute() {
		_scale.setValue(_scale_value);
 	  }
    } 

	public void initDemo() {
/*
		int max_images = 10;   
		float scale[] = { 0.0f, 1.0f };
		
		for( int i=0; i<max_images; i++ ) {
		  short[] data = new short[_height*_width];
		  for( int i1 = 0; i1<_height; i1++ ) {
			for( int i2 = 0; i2<_width; i2++ ) {
			  int index = i2 + i1*_width;
			  float a = max_images - i;
			  float b = i+3;
			  short value = (short) ( 50000 * ( 2 + Math.sin((a*i1)/_height) + Math.cos((b*i2)/_width) ));
			  data[index] = value;
			}
		  }
		  CreateImage( data, "", scale, i );
		}
*/
	}
	    
	void print(String msg) {
	  System.out.print("\nJAVA: " + msg);
	}
    
    public void destroy() { 
	  if( _animation != null ) {
		_animation.stop(); 
		if( _controlPanel != null ) {
		  int na = _controlPanel.closeAnimation(_animation); 
		  if( na == 0 ) {
			AnimationControlPanel.closeControlPanel( _group_index );
			_controlPanel = null;
		  }
		}
		_animation = null;
	  }
	  if( _saveControlPanel != null ) { 
		_saveControlPanel.dispose(); 
		_saveControlPanel = null; 
	  }
	  if( _dataTable != null ) {
		  _dataTable. setVisible(false);
		  _dataTable.dispose();
		  _dataTable = null;
	  }
	}
	
    public void dispose() {  
	  if( _frame != null )  {
		_frame.setVisible(false);
		_frame.dispose();
	  }
	}
	
    public void intervalAdded(ListDataEvent e) {
	  if( _browse ) {
		setBrowserImage( e.getIndex1() );
	  }
	  if( _write ) {
		_animation.writeData( e.getIndex1() );
	  }
	} 
	 	 
    public void intervalRemoved(ListDataEvent e){;}
    public void contentsChanged(ListDataEvent e){;}

   public void saveData( String dir, String baseName, SimulationData data ) {;} 

   public void saveData( String dir, String baseName, int format, boolean saveAllFrames ) {
	 try {
	   if( saveAllFrames ) {
		 switch( format ) {
		   case 0: _animation.SaveAnimationPPM(dir,baseName); break;
		   case 2: _animation.SaveAnimationJPEG(dir,baseName); break;
		 }
	   }
	   else {
		 switch( format ) {
		   case 0: _animation.SaveImagePPM(-1,dir,baseName); break;
		   case 2: _animation.SaveImageJPEG(-1,dir,baseName); break;
		 }
	   }
	  } catch ( java.io.IOException err ) {
		SimIO.print( "File write exception: " + err.getMessage() );
	  }
   } 

	public DataSet getDataSet() { return _animation.getDataSet(); }
   
   	void open_manual_scale_panel(float max, float min) {
		int infolen = 12;
		JPanel  panel = new JPanel(true);
		JFrame frame = new JFrame("Manual ReScale");
		frame.getContentPane().add("Center", panel);
		panel.setLayout( new GridLayout(0,1) );

		frame.addWindowListener( 
			new WindowAdapter() {
			  public void windowClosing(WindowEvent e) { ; }
			}
		);

		if( _rescale_max == null ) {
		  _rescale_max = AttributeValuePair.New( "Max value:", true, infolen );
		}
		_rescale_max.setValue( Float.toString(max) );
		panel.add(_rescale_max);

		if( _rescale_min == null ) {
		  _rescale_min = AttributeValuePair.New( "Min value:", true, infolen );
		}
		_rescale_min.setValue( Float.toString(min) );
		panel.add(_rescale_min);

		JPanel  buttonPanel = new JPanel(false);
		buttonPanel.setLayout(new FlowLayout());
		panel.add(buttonPanel);

		JButton aButton;
		aButton = new JButton("Set");
		aButton.addActionListener( new ManualScaleSetAction(frame) );
		buttonPanel.add( aButton );

		aButton = new JButton("Cancel");
		aButton.addActionListener( new ManualScaleCancelAction(frame) );
		buttonPanel.add( aButton );

		frame.pack();
		frame.show();
	}

	public void writeData( byte format,  String output_directory, String suffix ) {
	  _write = true;
	  _animation.writeData( format,  output_directory, suffix ); 
	}	

	public void tableChanged(TableModelEvent e) {
	  int type = e.getType();
	  if( type == TableModelEvent.UPDATE ) {
		DataTableModel tm = (DataTableModel) e.getSource();
		DataTable dt = tm.getDataTable();
		int col0 = dt.getOffset(0);
		int row0 = dt.getOffset(1);	
		if( ( col0 != scol ) || ( row0 != srow ) ) {
		  _animation.setSelectionArea( col0, row0, dt.getColumnCount(), dt.getRowCount(), true  ); 
		  scol = col0; srow = row0;
		} else  if( e.getColumn() >= 0 ) { _animation.repaint(); }
 	  } 
	}
/*
   public void tableChanged(TableModelEvent e) {
	 try {
	   int row = e.getFirstRow();
	   DataEntry de = (DataEntry) tm.getValueAt( row, 1 );
	   Variable v = (Variable) _parameter_map.get(de);
	   float fval = de.getValue(0);
	   _sme_interface.getClient().sme_set_scalar( v.getModule().toString(), v.toString(), fval ); 
	   v.setValue(fval);
	 } catch ( SNPException err ) {
	   SimIO.print("Error setting value: " + err );
	 }
   }
*/
}
