package miiee.dataview;

import javax.swing.*;
import java.net.InetAddress;
import java.awt.event.*;
import java.awt.GridLayout;
import java.awt.Component;
import java.awt.image.*;
import java.awt.Frame;
import java.security.*;
import java.io.*;
import java.net.*;
import java.util.*;
import miiee.TGraph.TimeGraph;

import miiee.util.*;


public class DataSocket   implements Runnable, AppletController {

	boolean _debug = false;
	
    public DataSocket(int port) {
        super();
        _byte_buffer = new byte[1000];
        _float_buffer = new float[10];
        _scale = new float[2];
        _byte_format = 1;
        _viewers = new Vector(70, 10);
        _graphs = new Vector(70, 10);
        _port = port;
        _viewers.setSize(70);
        _graphs.setSize(70);
        _p2_array_offset = 30;
        initialize_p2_array(50);
    }

    public int setViewserverControlPanel( ViewserverControlPanel net_control ) {
		_view_control = net_control;
		return 0;
    }

    public boolean init() {
		int cnt = 0;
        if( _use_control_panel ) { open_control_panel(); }
        while( cnt++ < 50 ) {
		  try 	  {
			  _data_server = new ServerSocket(_port);
			  SimIO.print("Starting socket listener on port " + _port);
			  _server_open = true;
			  return true;
		  }
		  catch( IOException ioex )  {
			  SimIO.print("Problem opening socket listener on port " + _port + " : " + ioex.getMessage());
			  _server_open = false;
			  _port++;
		  }
		}
        return false;
    }	
    
	void open_control_panel() {
		int infolen = 12;
		JPanel  panel = new JPanel(true);
		JFrame frame = new JFrame("Socket Control Panel");
		frame.getContentPane().add("Center", panel);
		panel.setLayout( new GridLayout(0,1) );

		frame.addWindowListener( 
			new WindowAdapter() {
			  public void windowClosing(WindowEvent e) {
				try {
				  shutdown();
				} catch ( java.io.IOException ioex ) { SimIO.print( ioex.toString() ); }
				System.exit(0);
			  }
			}
		);

		AttributeValuePair _inet_addr = AttributeValuePair.New( "host:", false, infolen );
		panel.add(_inet_addr);

		AttributeValuePair port = AttributeValuePair.New( "port:", false, infolen );
		port.setValue( Integer.toString(_port) );
		panel.add(port);

		_status = AttributeValuePair.New( "status:", false, infolen );
		panel.add(_status);
		
		JButton  aButton = new JButton("shutdown");
		aButton.addActionListener( new ShutdownAction() );
		panel.add( aButton );

		frame.pack();
		set_inet_addr();
		frame.show();
		_control_panel_frame = frame;
	}
	
    class ShutdownAction extends Object implements ActionListener  {
	  public void actionPerformed(ActionEvent e) {
		try {
		  shutdown();
		} catch ( java.io.IOException ioex ) { SimIO.print( ioex.toString() ); }
		System.exit(0);
	  }
    } 
	
	void set_status( String status ) {
	 if( _view_control != null ) {
		_view_control.set_status(status);
	  } else {	  
		try {
		  _status.setValue( status );
		  _control_panel_frame.repaint();
		} catch ( NullPointerException err ) { ; }
	  }
	}
	
	void set_inet_addr() {
	  String s = getInetAddress();
	  SimIO.print(  " Setting INet addr to " + s );
	  if( _view_control != null ) {
		_view_control.set_inet_addr( s );
	  } else {
		try {
		  _inet_addr.setValue( s ); 
		  _control_panel_frame.repaint();
		} catch ( NullPointerException err ) { return; }
	  }
	}

	public String getInetAddress() {
	  try {
		if( _socket_open ) {
		  InetAddress addr = _socket.getInetAddress();
		  return addr.toString();
		} else {
		  return " (no connection) ";
		}
	  } catch ( NullPointerException err ) { return " (error) "; }
	}
	
	public int getPort() { 
	  return _port; 
	}
	
    public void run() {
        while(_server_open) {
			SimIO.print("Listening...");
			set_status( "Listening..." );
			
			try {
			  _socket = _data_server.accept();
			  _istream = new DataInputStream(_socket.getInputStream());
			  _ostream = _socket.getOutputStream();
			  _socket_open = true;
			  set_inet_addr();
			} catch( IOException ioex )  {
				SimIO.print("Problem getting socket connection: " + ioex.getMessage());
				_socket_open = false;
			}

/*
            try  {
				SocketPermission sp = new SocketPermission("*:"+_port,"accept,listen");
				AccessController.checkPermission(sp);
				AccessController.doPrivileged( new PrivilegedAction() {
				   public Object run() {
					  try {
						_socket = _data_server.accept();
						_istream = new DataInputStream(_socket.getInputStream());
						_ostream = _socket.getOutputStream();
						_socket_open = true;
						set_inet_addr();
 					  } catch( IOException ioex )  {
						  SimIO.print("Problem getting socket connection: " + ioex.getMessage());
						  _socket_open = false;
					  }
					  return null; // nothing to return
				   }
				});               
           }
             catch( SecurityException se )  {
                SimIO.print("Problem getting socket permission: " + se.getMessage());
                _socket_open = false;
                break;
            }
*/
			SimIO.print("Got connection on port " + _port);
			set_status("Connected");

            try  {
                while(_socket_open)    {
                    int dv;
                    do
                        dv = _istream.read();
                    while(processCode(dv) >= 0);
                    try {
                        Thread.sleep(100L);
                    }
                    catch(InterruptedException ex) {}
                }

            }
            catch(IOException ioex)
            {
                SimIO.print("Problem reading socket input stream: " + ioex.getMessage());
                break;
            }
        }
		set_status( "Server Shutdown" );
        System.exit(0);
    }

    public void closeSocket()
        throws IOException
    {
	  if( _socket_open ) {
		_socket_open = false;
		_istream.close();
        _socket.close();
		set_inet_addr();
	  }
    }

    public void closeServer()
        throws IOException
    {
	  if( _server_open ) {
        _server_open = false;
		try {
		  _data_server.close();
		} catch ( NullPointerException err ) {;}
		_data_server = null;
	  }
    }

    public void start()
    {
        _dsThread = new Thread(this);
        _dsThread.start();
    }

    public void stop()
    {
        _socket_open = false;
        _server_open = false;
    }

	public void shutdown()  throws IOException {
	  closeSocket();
	  closeServer();
	}

    public void initSimulation( String proj_name, String model_name, String proj_path ) { 
	  SimIO.print( "Initializing simulation, project: " + proj_name + ",  Model: " +  model_name + ",  projpath: " + proj_path); 
	  DataSet.initSimulation(proj_name,model_name,proj_path);
	}

    public int processCode(int byteCode)
        throws IOException
    {
        int rv = 1;
        SimIO.print(" Processing byteCode: " + Integer.toString(byteCode) );
        switch(byteCode)  {
        
        default:
            break;

        case -1: {
              closeSocket();
			  rv = -1;
            } break;

        case 101:{
			  shutdown();
			  rv = -1;
            } break;
/*
        case 2: {
            int width = readInt();
            int height = readInt();
            byte animatorType = readByte();
            byte namelen = readByte();
            byte dsetIndex = readByte();
            byte hasRegionMap = readByte();
            String name = readString(namelen);
            int map_size = width * height;
            byte region_map[] = null;
            if( hasRegionMap > 0 ) {
			  region_map = new byte[map_size];
			  readBytesIntoBuffer(region_map, map_size, 100);
			}
            create2DAnimator(width, height, name, dsetIndex, region_map);
            } break;

        case 3: {
            byte index = readByte();
            byte series_index = readByte();
//            byte autoscale = readByte();
            int buff_size = readInt();
            int info_size = readByte();
            String info = ( info_size > 0 ) ? readString(info_size) : " ";
            _scale[0] = readFloat();
			_scale[1] = readFloat();
			_time = readFloat();
			
			short buffer[] = new short[buff_size];
			for(int i = 0; i < buff_size; i++) buffer[i] = readShort();
			add2DAnimatorDataArray(index, series_index, buffer, buff_size, info, _scale, _time);
            } break;
*/
        case 4: {
            int t0 = readInt();
            int tf = readInt();
            float dt = readFloat();
            float ymin = readFloat();
            float ymax = readFloat();
            byte units = readByte();
            byte namelen = readByte();
            byte dsetIndex = readByte();
            byte overwrite = readByte();
            String name = readString(namelen);
            createGraph(t0, tf, dt, ymin, ymax, name, dsetIndex, units, (overwrite != 0) );
            } break;

        case 5:{
            byte namelen = readByte();
            String color = readString(5);
            byte graph_index = readByte();
            byte component_index = readByte();
            String name = readString(namelen);
            addGraphComponent(graph_index, component_index, color, name);
            } break;

        case 6: {
	    byte graph_index = readByte();
            byte component_index = readByte();
            int start_index = readInt();
            int npoints = readInt();
            resizeFloatBuffer(npoints);
            for(int i = 0; i < npoints; i++)
                _float_buffer[i] = readFloat();

            setGraphDataFromBuffer(graph_index, component_index, start_index, npoints);
           } break;

        case 8: case 9: case 10: case 11: {
            int dsetIndex = readShort();
            int namelen = readShort();
            int catslen = readShort();
            byte dims = readByte();
			byte  adim = readByte();
            byte format = readByte();
            byte hasRegionMap = readByte();
            int L0 = readInt();
            int L1 = readInt();
            int L2 = readInt();
            String name = readString(namelen);
            String cats = readString(catslen);
            int map_size = L0 * L1;
            byte region_map[] = null;
            if( hasRegionMap > 0 ) {
			  region_map = new byte[map_size];
			  readBytesIntoBuffer(region_map, map_size, 100);
			}
			byte mode = (byte)(11 - byteCode);
            createDataset( dsetIndex, L0, L1, L2, dims, adim, name, cats, region_map, format, mode );
            } break;

        case 12: {
            byte format = readByte();
            int dsetIndex = readShort();
            int info_size = readShort();
            int buff_size = readInt();
            String info = ( info_size > 0 ) ? readString(info_size) : " ";
            float max = readFloat();
			float min = readFloat();
			float time = readFloat();
			float dt = readFloat();
			
			short buffer[] = new short[buff_size];
			for(int i = 0; i < buff_size; i++) buffer[i] = readShort();
			
			addDataEntry( dsetIndex, buffer, buff_size, info, max, min, time, dt, format );
			
            } break;

        case 13:{
            byte namelen = readByte();
            String proj_name = readString(namelen);
			namelen = readByte();
            String model_name = readString(namelen);
			namelen = readByte();
            String proj_path = readString(namelen);
            initSimulation( proj_name, model_name, proj_path );
            } break;

        case 100: {
            byte bf = readByte();
			_byte_format = bf;
			
/*
            if(bf > 0)
            {
                byte rb = 0;
                _byte_format = 2;
                int itest = readInt();
                float ftest = readFloat();
                if(itest == -12345 && ftest == -12345D)
                    rb = 1;
                else
                    _byte_format = 1;
                writeByte(rb);
                _istream = new DataInputStream(_socket.getInputStream());
            }
            else  {
                _byte_format = bf;
            }
*/
            } break;

        }
        return rv;
    }

    public int readBytesIntoBuffer(byte buffer[], int num_bytes, int timeout)
        throws IOException
    {
        int bytes_read = 0;
        int cnt = 0;
        do
        {
            int new_bytes = _istream.read(buffer, bytes_read, num_bytes - bytes_read);
            if(new_bytes > 0)
                bytes_read += new_bytes;
            if(bytes_read == num_bytes)
                break;
            try
            {
                Thread.sleep(1000L);
            }
            catch(InterruptedException ex) {}
            if(cnt++ != timeout)
                continue;
            SimIO.print("Timeout in readBytesIntoBuffer:");
            SimIO.print("Incomplete buffer: got " + bytes_read + " of " + num_bytes);
            break;
        }
        while(true);
        if( _debug ) {
		  System.out.println( "\n readBytesIntoBuffer dump: " );
		  for( int i=0; i<20; i++ ) {
			System.out.print( " " + buffer[i] );
		  }
        }
        return bytes_read;
    }

    public int readBytesIntoIntBuffer(int buffer[], int num_bytes, int timeout)
        throws IOException
    {
        int i;
        for(i = 0; i < num_bytes;)
        {
            int val = _istream.read();
            if(val < 0)
            {
                for(int cnt = 0; cnt++ < timeout || timeout < 0;)
                {
                    try
                    {
                        Thread.sleep(1000L);
                    }
                    catch(InterruptedException ex) {}
                    val = _istream.read();
                    if(val > 0)
                        break;
                }

            }
            buffer[i++] = val;
        }

        return i;
    }
/*
    public void create2DAnimator(int width, int height, String name, byte index, byte region_map[])  {
        AnimationViewer mv = (AnimationViewer)_viewers.elementAt(index);
        if(mv == null) {
		  mv = new AnimationViewer( width, height, name, region_map );
		  AppContainer ac = new AppContainer(name, mv, this);
		  ac.setVisible(true);
		  if( index >= _viewers.size() ) { _viewers.setSize(index+16); }
		  _viewers.setElementAt(mv, index);
		  SimIO.print("Created 2D Animator " + name + ", index = " + index);
		}
    }
*/
    public void createDataset( int dsetIndex, int L0, int L1, int L2, byte dims, byte adim, String name, String cats, byte region_map[], byte format, byte mode )  {
		DataSet.create( dsetIndex, L0, L1, L2, dims, adim, name, cats, region_map, format, mode );
    }

   public void addDataEntry( int dsetIndex, short[] data, int buff_size, String info, float max, float min, float time, float dt, byte format ) {
		DataSet ds = (DataSet) DataSet.getDataSet( dsetIndex );
        if(ds == null) {
 		  SimIO.print( "Attempt to add data to null dataset: " + info + ", index = " + dsetIndex );       
		} else {
		  if( ds.setDataSize(buff_size) ) {
			DataEntry de = new DataEntry( data, info, max, min, time, dt );
			de.setFormat(format);
			ds.addEntry(de);
			SimIO.print( "Adding entry to dataSet " + ds.toString() + ", bounds(" + min + "," + max + "), ( index = " + dsetIndex + " ), ( size = " +  
						  buff_size + " ), ( format = " +  format + " ): " + info + ", ival[0] = " + data[0] + ", fval[0] = " + de.getValue(0) ); 
			test_data_entry(data,info);      
		  } else {
			SimIO.print( "Inconsistent or Illegal DataEntry size:" + ds.toString() + ", size = " + buff_size + ", format = " + format  + ", index = " + dsetIndex );
		  }
		}
		if(  _view_control != null  ) {
		  if( ( ds.browse() > 0 ) && ( ds.browse() < 3 ) ) {
			_view_control.browse( ds );
			SimIO.print( "Add browse data entry " + dsetIndex + ", " + info + ":  val = " + data[0] );
		  }
		} 
    }

	void test_data_entry( short[] data, String info ) {
	  int max= -1, min = -1, max_uns_short = 256*256, ival = -999, raster_val;
	  for( int i=0; i<data.length; i++ ) {
		raster_val = data[i];
		ival = ( raster_val < 0 ) ? max_uns_short + raster_val : raster_val;
		if( (min < 0) || (ival < min) ) min =  ival;
		if( (max < 0) || (ival > max) ) max =  ival;
	  }
	  SimIO.print( "Got data entry " + info + ":  max = " + max + " , min = " + min + ", ival = " + ival );
	}
		
    public void createGraph(int t0, int tf, float dt, float ymin, float ymax, String name, byte index,  byte units, boolean overwrite ) {
        TimeGraph tg = (TimeGraph)_graphs.elementAt(index);
        if( (tg != null) && overwrite ) {
			tg.dispose();  tg = null;
		}
		if( tg == null ) {
		  tg = new TimeGraph(t0, tf, dt, ymin, ymax, units, this);
		  if( index >= _graphs.size() ) { _graphs.setSize(index+16); }
		  _graphs.setElementAt(tg, index);
		  SimIO.print("Created Graph " + name + ", index = " + index);
		} else {
		  tg.Enlarge( t0, tf, dt, ymin, ymax, units );
		}
		tg.show( name );
    }

    public void addGraphComponent(int graph_index, int component_index, String color, String name)
    {
        TimeGraph tg = (TimeGraph)_graphs.elementAt(graph_index);
        if(tg == null)
        {
            SimIO.print("Warning; Can't create graph component: Unavailable Graph.");
            return;
        }
        else
        {
            tg.addComponent(component_index, color, name);
            return;
        }
    }

    public void setGraphDataFromBuffer(int graph_index, int component_index, int start_index, int npoints)
    {
        TimeGraph tg = (TimeGraph)_graphs.elementAt(graph_index);
        if(tg == null)
        {
            SimIO.print("Warning: Attempt to send data to unavailable Graph.");
            return;
        }
        else
        {
            tg.setDataValues(component_index, start_index, npoints, _float_buffer);
            return;
        }
    }

    public static void main(String args[])
    {
        int port = 10776;

        if(args.length == 0)
            SimIO.print("Usage: miiee.dataview.DataSocket <port>");
        else
            try
            {
                port = Integer.parseInt(args[0]);
            }
            catch(NumberFormatException ex)
            {
                SimIO.print("Port argument must be an integer.");
            }
        DataSocket mv = new DataSocket(port);
        if( mv.init() ) mv.start();
    }

    private final void resizeBuffer(int size)
    {
        if(_byte_buffer.length < size)
            _byte_buffer = new byte[size];
    }

    private final void resizeFloatBuffer(int size)
    {
        if(_float_buffer.length < size)
            _float_buffer = new float[size];
    }

    private final String readString(int size)
        throws IOException
    {
		if( size == 0 ) return null;
        resizeBuffer(size);
        readBytesIntoBuffer(_byte_buffer, size, 100);
        return new String(_byte_buffer, 0, size);
    }

    public final void printBytes(byte val)
    {
        for(int i = 7; i >= 0; i--)
            if((val >> i & 0x1) == 1)
                SimIO.print("1");
            else
                SimIO.print("0");

    }

    public final void printBytes(int val)
    {
        for(int i = 7; i >= 0; i--)
            if((val >> i & 0x1) == 1)
                SimIO.print("1");
            else
                SimIO.print("0");

    }

    public final short readShort()
        throws IOException
    {
        int br = readBytesIntoIntBuffer(_tmp_buff, 2, 100);
        if(br < 2)
            throw new EOFException("Timed out waiting for data send");
        if(_byte_format > 0)
            return (short)((_tmp_buff[0] << 8) + (_tmp_buff[1] << 0));
        else
            return (short)((_tmp_buff[1] << 8) + (_tmp_buff[0] << 0));
    }

    public final int readInt()
        throws IOException
    {
        int br = readBytesIntoIntBuffer(_tmp_buff, 4, 100);
        if(br < 4)
            throw new EOFException("Timed out waiting for data send");
        if(_byte_format > 0)
            return (_tmp_buff[0] << 24) + (_tmp_buff[1] << 16) + (_tmp_buff[2] << 8) + (_tmp_buff[3] << 0);
        else
            return (_tmp_buff[3] << 24) + (_tmp_buff[2] << 16) + (_tmp_buff[1] << 8) + (_tmp_buff[0] << 0);
    }

    private void initialize_p2_array(int size)
    {
        _p2_array = new float[size];
        float val = (float)Math.pow(2D, -_p2_array_offset);
        for(int i = 0; i < size; i++)
        {
            _p2_array[i] = val;
            val = (float)(val * 2D);
        }

    }

    public final float readFloat()
        throws IOException
    {
        float rv;
        if(_byte_format < 2)
        {
            short s0 = readShort();
            short s1 = readShort();
            try {
                rv = s0 * _p2_array[s1 + _p2_array_offset];
            }
            catch(ArrayIndexOutOfBoundsException ex)
            {
                rv = (float)(s0 * Math.pow(2D, s1));
            }
        }
        else  {
            rv = Float.intBitsToFloat(readInt());
        }
        return rv;
    }

    public final byte readByte()
        throws IOException
    {
        return _istream.readByte();
    }

    public final void writeByte(byte b)
        throws IOException
    {
        _ostream.write(b);
    }

    public void notifyDisposed(Frame frame)
    {
    }

    public void notifyHidden(Frame frame)
    {
    }

    public void notifyDestroyed(DisposableListDataListener app)
    {
        int index = _viewers.indexOf(app);
        if(index >= 0)  {
			if( index >= _viewers.size() ) { _viewers.setSize(index+16); }
            _viewers.setElementAt(null, index);
			SimIO.print("Removed viewer at index " + index);
        }
        else
        {
            index = _graphs.indexOf(app);
            if(index >= 0) {
                _graphs.setElementAt(null, index);
				SimIO.print("Removed Graph at index " + index);
			}
        }
    }

    protected static final int _maxNViewers = 70;
    protected ServerSocket _data_server;
    protected Socket _socket;
    protected Thread _dsThread;
    protected DataInputStream _istream;
    protected AttributeValuePair _inet_addr;
    protected AttributeValuePair _status;
    protected OutputStream _ostream;
    protected byte _byte_buffer[];
    protected static int _tmp_buff[] = new int[8];
    protected float _float_buffer[];
    protected float _p2_array[];
    protected float _scale[];
	protected float _time;
    protected int _p2_array_offset;
    protected byte _byte_format;
    protected Vector _viewers;
    protected Vector _graphs;
    protected int _port;
    protected ViewserverControlPanel _view_control;
    protected JFrame _control_panel_frame;
    protected boolean _socket_open;
    protected boolean _server_open;
    protected boolean _use_control_panel = false;
    private static final byte BYTES = 1;
    private static final byte SHORTS = 2;
    private static final byte INTS = 3;
    private static final byte FLOATS = 4;

}
