package miiee.dataview;  

import javax.swing.*;
import java.io.File;
import javax.swing.table.*;
import java.util.Vector;
import java.awt.image.*;
import java.awt.Rectangle;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.event.*;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.*;
import java.applet.Applet;
import miiee.util.*;
import miiee.mml.*;
import miiee.client.*;

public class DataTableModel extends AbstractTableModel {
	private DataSet _data;
	private DataTable _dt;
	boolean _isEditable = false;
	String[] _headers = null;
	int _rows;
	int _cols;
	
	DataTableModel( int rows, int cols, DataSet ds, DataTable dt ) {
	  super();
	  _dt = dt;
	  _data = ds;
	  _rows = rows;
	  _cols = cols;
	}
	
	public void setEditable( boolean editable )  { _isEditable = editable; }
			
	public String getColumnName(int column) {
	  int adim = _data.getArrayDimension();
	  int dim = _data.dims();
	  if( adim > 0 ) { 
		if( _headers == null ) {
		  _headers = getArrayArgList( _data.toString(), 0, _data.size(0) );
		}
		if( column == 0 ) { return "Time"; }
		else if( column > _headers.length ) { return ""; }
		else { return _headers[ column - 1 ]; }
	  } if( dim < 2 ) { 
		return ( ( column % 2 ) == 0 ) ? "Time" : "Value";
	  } else {
		if( column == 0 ) { return " "; }
		else { return Integer.toString( _dt.offset(0) + column - 1 ); }
	  }
	}
	
    String[] getArrayArgList( String vname, int dim_index, int dim_size ) {
	  String[] rv = new String[dim_size];
	  Variable v = null;
	  String aname = null;
	  try {
		SNPClient sc = SMEInterface.getClient();
		v = sc.getVariable( vname );
		aname = v.getArray( dim_index );
		MMLConfigCommand mcc = v.getArrayConfig( aname );
		for( int i=0; i<dim_size; i++ ) {
		  MMLConfigArg mca = mcc.getArg(i+1);
		  rv[i] = mca.getValue();
		}
	  } catch ( Exception err ) {
		System.out.println("Can't get array declaration, vname:" + vname + ", var: " + v + ", array_name: " + aname );
		err.printStackTrace();
		for( int i=0; i<dim_size; i++ ) {
		  rv[i] = Integer.toString(i);
		}
	  } 
	  return rv; 
    }    
    
	public int getColumnCount() { 
		return _cols; 
	}
	public int getRowCount() { 
		return _rows;
	}
	public Object getValueAt(int row, int col) { 
	  return _dt.getDataValue( row, col );
	}

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
	  String sval = aValue.toString();
	  try { 
		float fval = Float.valueOf(sval).floatValue();
		_dt.setDataValue( rowIndex, columnIndex, fval );
		fireTableCellUpdated(rowIndex,columnIndex);
	  } catch ( NumberFormatException err ) { SimIO.print("Number format exception: " + sval); }
    }
	
    public boolean isCellEditable(int rowIndex, int columnIndex) {
	  return ( columnIndex > 0 ) && _isEditable;
    }
	

	public Class getColumnClass(int columnIndex) {
	  if( ( _data.dims() >= 2 ) && (columnIndex == 0) ) { 
		return Integer.class;
	  } else {
		return FormattedFloat.class;
	  }
	}
	
	public DataSet getDataSet() { return _data; }
	public DataTable getDataTable() { return _dt; }
	
}
