package miiee.dataview;

import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import javax.swing.border.*;
import java.util.*;
import java.text.SimpleDateFormat;
import javax.swing.tree.*;
import java.awt.event.*;
import miiee.util.*;
import miiee.TGraph.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.filechooser.*;
import miiee.dataview.*;
import miiee.mml.MMLException;
import miiee.mml.SimulationRun;
import javax.help.*;
import miiee.wizard.DirectoryChooser;


public class ViewserverControlPanel extends JPanel implements ItemListener, IOController {

	private static DataSocket _DataSocket;

    protected AttributeValuePair _inet_addr;
    protected AttributeValuePair _status;
//    protected JList _datasetList;
	protected JButton  _creationButton;
	protected JButton  _closeButton;
	protected int _port;
	protected String  _proj_name;
	protected String _model_name;
	protected String _scenario_name;
	protected String _proj_path;
	protected JTree _simtree;
    protected String _helpText;
    protected JFrame _frame;
    protected Vector _browsers = new Vector(16,16);
    protected Vector _open_viewers = new Vector(16,16);
    protected static ExternalClassStub _visad_interface;
    protected static ExternalClassStub _python_interface;
	protected TableModelListener _tableListener;
    protected String _output_directory;
    protected JTabbedPane _tabbedPane;
    protected boolean _initialized = false;
    protected int _mode;
    
    public static final int kStandAlone = 0;
    public static final int kPortalTab = 1;
    public static final int kShellTab = 2;
    public static final int kAuxComponent = 3;
    

	public ViewserverControlPanel(int mode) {
	  super();
	  _mode = mode;
	  generateHelpText();
	  try {
		_output_directory =  System.getProperty("user.home");
	  } catch ( Exception err ) {
		_output_directory =  "";
	  }
	}
 
 	public  void  startSocketListener() {
		if( _DataSocket == null ) {
		  _DataSocket = new DataSocket( _port );
		  _DataSocket.setViewserverControlPanel( this );
		}
		if( _DataSocket.init() ) {
		  _DataSocket.start();
		}
	}
	
 	public  static ExternalClassStub  getVisADInterface() throws MMLException {
	  if( _visad_interface == null ) {
		_visad_interface = new ExternalClassStub("miiee.visad.stub_interface");
		_visad_interface.addMethod("3dViewer", "create3dViewer( java.util.Vector )" );
		_visad_interface.addMethod("python", "createPythonEditor( java.lang.String )" );
	  } 
	  return _visad_interface;
	}

 	public  static ExternalClassStub  getJava3DInterface() throws MMLException {
	  if( _visad_interface == null ) {
		_visad_interface = new ExternalClassStub("miiee.landscape.stub_interface");
		_visad_interface.addMethod("3dViewer", "create3dViewer( java.util.Vector )" );
	  } 
	  return _visad_interface;
	}

 	public  void  shutdownSocketListener() {
		if( _DataSocket != null ) {
		  try {
			_DataSocket.shutdown();
		  } catch( IOException ioex )  {
			  SimIO.print("Problem shutting down DataSocket connection: " + ioex.getMessage());
		  }
		}
	}
	
	public void setTabbedPane ( JTabbedPane pane ) { _tabbedPane = pane; }
	public void setScenarioName ( String scenario_name ) { 
	  SimIO.print("ViewServer:setScenarioName " + scenario_name);
	  _scenario_name = scenario_name; 
	}
	
	public void dispose() {
	  shutdownSocketListener();
	  for( int i=0; i<_browsers.size(); i++ ) {
		DisposableListDataListener ddl = (DisposableListDataListener) _browsers.get(i);
		ddl.destroy();
		ddl.dispose();
	  }
	  for( int i=0; i<_open_viewers.size(); i++ ) {
		DisposableListDataListener ddl = (DisposableListDataListener) _open_viewers.get(i);
		ddl.destroy();
		ddl.dispose();
	  }
	  if( _frame != null ) {
		_frame.setVisible(false);
		_frame.dispose();
		_frame = null;
	  }
	}
	
	public void shutdown() {
	  shutdownSocketListener();
	  if( _frame == null ) {
		System.exit(0);
	  }
	}
		
	public void init( int port ) {
		_port = port;
		if( _initialized ) return;
		_initialized = true;
		setLayout( new BorderLayout() );
/*
		JPanel info_panel = new JPanel(true);
		Border bb = new SoftBevelBorder(SoftBevelBorder.LOWERED);  	info_panel.setBorder( bb );
		add(info_panel,"North");
*/

		JPanel status_panel = new JPanel(true);
		SoftBevelBorder bb = new SoftBevelBorder(SoftBevelBorder.LOWERED);  	
		status_panel.setBorder( bb );
		add(status_panel, "South" );

		_status = AttributeValuePair.New( "status:", false, 10 );
		_status.setValue( " (no socket) " );
		status_panel.add(_status);
		
		_inet_addr = AttributeValuePair.New( "host:", false, 18 );
		_inet_addr.setValue( " (no data) " );
		status_panel.add(_inet_addr);

		AttributeValuePair aport = AttributeValuePair.New( "port:", false, 6 );
		aport.setValue( Integer.toString(_port) );
		status_panel.add(aport);

/*		
		JButton  aButton = new JButton("shutdown");
		aButton.addActionListener( new ShutdownAction() );  
		status_panel.add( aButton );

		aButton = new JButton("help");
		aButton.addActionListener( new HelpAction() );
		status_panel.add( aButton );
*/		
		add( create_data_panel(), "Center" );
		setBorder( BorderFactory.createEtchedBorder() );
		
		if( _frame != null ) {
		  _frame.setJMenuBar( constructMenuBar() );
		}

	} 
	
	public void setFrame( JFrame f ) { _frame = f; }
	
	JPanel create_data_panel() {

	  EmptyBorder eb7 = new EmptyBorder( 7, 7, 7, 7 );	
	  EmptyBorder eb3 = new EmptyBorder( 3, 3, 3, 3 );	
	  JPanel pH  = new JPanel(false);
	  BoxLayout bl = new BoxLayout(pH, BoxLayout.X_AXIS );	  pH.setLayout( bl ); 	   
//	  Border mbb = BorderFactory.createCompoundBorder( new MotifFrameBorder(pH), eb3 );      pH.setBorder( mbb );

	  JPanel pV0  = new JPanel(false);
	  bl = new BoxLayout(pV0, BoxLayout.Y_AXIS );  pV0.setLayout( bl ); 	   
	  Border bb = BorderFactory.createCompoundBorder( new BevelBorder(BevelBorder.LOWERED), eb3 );  	pV0.setBorder( bb );
	  pV0.setMaximumSize(new Dimension(Short.MAX_VALUE,  Short.MAX_VALUE)); 
	  pH.add(pV0);

	  JPanel pV1  = new JPanel(false);
	  bl = new BoxLayout(pV1, BoxLayout.Y_AXIS );  pV1.setLayout( bl ); 	   
	  bb = BorderFactory.createCompoundBorder( new BevelBorder(BevelBorder.LOWERED), eb3 );   pV1.setBorder( bb );
	  pV1.setMaximumSize(new Dimension( 250,  Short.MAX_VALUE ) ); 
	  pH.add(pV1);
	  	  
	  JLabel title = new JLabel("Available Datasets");
	  title.setBorder(eb7);
	  title.setAlignmentX(Component.CENTER_ALIGNMENT);
	  pV0.add(title);
	  
	  JScrollPane scrollPane = new JScrollPane();
	  _simtree = DataSet.getTree();
	  _simtree.setBorder( BorderFactory.createEtchedBorder()  );
	  _simtree.addTreeSelectionListener(
		new TreeSelectionListener() {
		   public void valueChanged(TreeSelectionEvent e) { treeValueChanged(); }
	   });
	  scrollPane.getViewport().setView(_simtree);
	  scrollPane.setBorder( eb7 );
	  scrollPane.setMaximumSize( new Dimension( Short.MAX_VALUE, 600 ) );
	  pV0.add(scrollPane);

	  JPanel buttonPanel  = new JPanel(false);
	  bl = new BoxLayout(buttonPanel, BoxLayout.X_AXIS );  buttonPanel.setLayout( bl ); 
	    
	  JButton openButton = new JButton("Open");
	  openButton.addActionListener( new OpenAction(this) );
	  openButton.setMaximumSize( new Dimension( Short.MAX_VALUE, openButton.getMaximumSize().height ) );
	  buttonPanel.add( openButton );

	  JButton saveButton = new JButton("Save");
	  saveButton.addActionListener( new SaveAction(this ) );
	  saveButton.setMaximumSize( new Dimension( Short.MAX_VALUE, saveButton.getMaximumSize().height ) );
	  buttonPanel.add( saveButton );

	  JButton deleteButton = new JButton("Delete");
	  deleteButton.addActionListener( new DeleteDataSetAction( pV0 ) );
	  deleteButton.setMaximumSize( new Dimension( Short.MAX_VALUE, deleteButton.getMaximumSize().height ) );
	  buttonPanel.add( deleteButton );
/*
	  JButton exportButton = new JButton("Export");
	  exportButton.addActionListener( new ExportAction() );
	  exportButton.setMaximumSize( new Dimension( Short.MAX_VALUE, exportButton.getMaximumSize().height ) );
	  buttonPanel.add( exportButton );
*/
	  if( _mode == kShellTab ) {
		JButton pythonButton = new JButton("Choose");
		pythonButton.addActionListener( new PythonChooseAction(this) );
		pythonButton.setMaximumSize( new Dimension( Short.MAX_VALUE, pythonButton.getMaximumSize().height ) );
		buttonPanel.add( pythonButton );
	  } else {
		JButton pythonButton = new JButton("Python");
		pythonButton.addActionListener( new PythonAction(this) );
		pythonButton.setMaximumSize( new Dimension( Short.MAX_VALUE, pythonButton.getMaximumSize().height ) );
		buttonPanel.add( pythonButton );
	  }
	  
	  buttonPanel.setMaximumSize( new Dimension( Short.MAX_VALUE, buttonPanel.getMaximumSize().height ) );
	  pV0.add( buttonPanel );

	  title = new JLabel("Available Viewers");
	  title.setBorder(eb7);
	  title.setAlignmentX( Component.CENTER_ALIGNMENT );
	  pV1.add(title);

	  JPanel p = ViewerData.NewViewerData( "Animation2D", false, false, true, true, this );
	  ViewerData.NewViewerData( "Animation3D", false, false, true, false, this  );
	  ViewerData.NewViewerData( "ImmersaDesk", false, false, true, true, this  );
	  ViewerData.NewViewerData( "TimeseriesGraph", false, true, false, false, this  );
	  ViewerData.NewViewerData( "DataSpreadsheet", true, true, true, true, this  );
	  ViewerData.NewViewerData( "ImageSpreadsheet", false, false, true, true, this  );
	  ViewerData.NewViewerData( "ParameterViewer", true, true, false, false, this  );
	  ViewerData.NewViewerData( "ContourPlot", false, false, false, true, this  );
	  p.setAlignmentX(Component.CENTER_ALIGNMENT);
	  pV1.add( p );
	  
	  Component g = Box.createVerticalGlue();
	  pV1.add(g);
	  
	  buttonPanel  = new JPanel( new FlowLayout() );
	  _creationButton = new JButton("Create");
	  _creationButton.addActionListener( new CreateViewerAction(this) );
	  _creationButton.setMaximumSize( new Dimension( Short.MAX_VALUE, _creationButton.getMaximumSize().height ) );
	  _creationButton.setEnabled(false);
	  buttonPanel.add( _creationButton );

	  _closeButton = new JButton("Close");
	  _closeButton.addActionListener( new CloseViewersAction() );
	  _closeButton.setMaximumSize( new Dimension( Short.MAX_VALUE, _closeButton.getMaximumSize().height ) );
	  _closeButton.setEnabled(false);
	  buttonPanel.add( _closeButton );
	  buttonPanel.setMaximumSize( new Dimension( Short.MAX_VALUE, _creationButton.getMaximumSize().height ) );
	  pV1.add( buttonPanel );
	  
	  return pH;
	}

    public void itemStateChanged(ItemEvent e) {
	  _creationButton.setEnabled( ViewerData.getSelectionIndex() >= 0 );
	  _closeButton.setEnabled( ViewerData.getSelectionIndex() >= 0 );
    }
    
	public static void  addTreeModelListener(TreeModelListener l) {
	   DataSet.addTreeModelListener(l);
     }
     
	public void treeValueChanged() {
	  boolean[] has_data = { false, false, false, false };
	  int nSelections = _simtree.getSelectionCount();
	  TreePath[] tps = _simtree.getSelectionPaths(); 
	  for( int i=0; i<nSelections; i++ ) {
		TreePath tp = tps[i]; 
		DefaultMutableTreeNode tn = (DefaultMutableTreeNode)tp.getLastPathComponent();
		if( tp.getPathCount() == 3 ) { 
		  DataSet d = (DataSet) tn.getUserObject();
		  has_data[ d.dims() ] = true;
		} else if ( tp.getPathCount() == 2 ) {  // List and add components;
		  int cc = tn.getChildCount();
		  for( int j=0; j<cc ; j++ ) {
			DefaultMutableTreeNode tnc = (DefaultMutableTreeNode)tn.getChildAt(j);
			DataSet d = (DataSet) tnc.getUserObject();
			has_data[ d.dims() ] = true;
		  }
		}
	  }
	  ViewerData.setActivation( has_data );
	}
	
	public int getPort() { return _DataSocket.getPort(); }
	public static RepairedMutableTreeNode getRoot() { return DataSet.getRoot(); }
	
	class ShutdownAction extends Object implements ActionListener  {
	  public void actionPerformed(ActionEvent e) {
		  shutdownSocketListener();
		  System.exit(0);
	  }
    } 

	class CloseAction extends Object implements ActionListener  {
	  public void actionPerformed(ActionEvent e) {
		  dispose();		
	  }
    } 

	class DisconnectAction  extends Object implements ActionListener  {
	  public void actionPerformed(ActionEvent e) {
		  shutdownSocketListener();
	  }
    } 


	class DeleteDataSetAction extends Object implements ActionListener  {
	  Component _parent;
	  DeleteDataSetAction(Component parent) { parent = _parent; }
	  public void actionPerformed(ActionEvent e) {
		if( SimIO.show_confirm2( _parent, "Are you sure you want to delete the selected DataSet(s)?"  ) > 0 ) {
		  DataSet.deleteTreeSelection();
		}
	  }
    } 

    class SaveAction extends Object implements ActionListener {
	  IOController _ac;
	  SimulationData _saveBuffer;
	  int _simIndex;
	  public SaveAction( IOController ac ) { super(); _ac = ac; }
	  public void actionPerformed(ActionEvent e) {
		int nSelections = _simtree.getSelectionCount();
		if( nSelections <= 0 ) return;
		TreePath[] tps = _simtree.getSelectionPaths(); 
		for( int i=0; i<nSelections; i++ ) {
		  TreePath tp = tps[i]; 
		  if( tp.getPathCount() == 3 ) { 
			DefaultMutableTreeNode tn = (DefaultMutableTreeNode)tp.getLastPathComponent();
			addToSaveBuffer(tn);
		  } else if ( tp.getPathCount() == 2 ) {  // List and add components;
			DefaultMutableTreeNode tn = (DefaultMutableTreeNode)tp.getLastPathComponent();
			int cc = tn.getChildCount();
			for( int j=0; j<cc ; j++ ) {
			  DefaultMutableTreeNode tnc = (DefaultMutableTreeNode)tn.getChildAt(j);
			  addToSaveBuffer(tnc);
			}
		  }
		}
		if( _saveBuffer == null ) {
		  SimIO.print("No DataSets selected.");
		  return;
		} else {
		  SimIO.print("DataSets selected for save: " + _saveBuffer.size() );
		}
		String model_name = _saveBuffer.getModelName();
		String basename =  model_name + SimIO.dateString();
		String path = _saveBuffer.getProjPath() + "/" + model_name + "/" + _scenario_name;
		File df = new File(path);
		if( df.isDirectory() || df.mkdirs() ) {
		  _saveBuffer.setSimName( basename );
		  SaveFileControlPanel.showControlPanel( _ac, basename, path, _saveBuffer );
		} else {
		  SimIO.show_warning(null, "Cant make direcory: " + path );
		}
	  }

	  
	  void addToSaveBuffer(DefaultMutableTreeNode tn) {
	  	boolean doSave = true;
		DataSet d = (DataSet) tn.getUserObject();
		SimulationData sd = d.getSimulationData();
		if( _saveBuffer == null ) {
		  _saveBuffer = new SimulationData(sd);
		  _simIndex = sd.simIndex();
		} else if( _simIndex != sd.simIndex() ) {
		  SimIO.print( "All Datasets in a single archive file must be from the same simulation.");
		  doSave = false;
		}
		if( doSave ) { _saveBuffer.addElement( d ); }
	  }
    } 

    class ExportAction extends Object implements ActionListener {  
	  public void actionPerformed(ActionEvent e) { displayInFrame(); }
	}

  public  static ExternalClassStub  getPythonInterface() throws MMLException {
	  if( _python_interface == null ) {
		_python_interface = new ExternalClassStub( "miiee.python.SPyStubs" );
		_python_interface.addMethod("choose", "set_choosen_object( java.lang.Object )" );
	  } 
	  return _python_interface;
  }
  
    class PythonAction extends Object implements ActionListener {  
	  ViewserverControlPanel _p;
	  public PythonAction( ViewserverControlPanel p ) { _p = p; }
	  public void actionPerformed(ActionEvent e) { 
		try {
		  ExternalClassStub  visad = getVisADInterface();
		  visad.execMethod("python", new Object[] { _p }  );
		} catch ( MMLException err ) {
		  SimIO.show_error( null, "Must have VisAD properly installed to use this feature.", err );
		}
	  }
	}
    class PythonChooseAction extends Object implements ActionListener {  
	  ViewserverControlPanel _p;
	  public PythonChooseAction( ViewserverControlPanel p ) { _p = p; }
	  public void actionPerformed(ActionEvent e) { 
		try {
		  ExternalClassStub  python = getPythonInterface();
		  RepairedMutableTreeNode c = (RepairedMutableTreeNode) DataSet.getTree().getLastSelectedPathComponent();
		  python.execMethod("choose", new Object[] { c.getUserObject() }  );
		} catch ( MMLException err ) {
		  SimIO.show_error( null, "Must have VisAD properly installed to use this feature.", err );
		}
	  }
	}

	class OpenAction extends Object implements ActionListener  {
	  Component _parent;
	  OpenAction(Component parent) { _parent = parent;}
	  public void actionPerformed(ActionEvent e) {
		SimulationData sd = DataSet.getCurrentSimulation();
		JFileChooser chooser = null;
		try {
		  FileSystemView fsv = FileSystemView.getFileSystemView();
		  String root_dir = (sd==null) ? System.getProperty("LIBDIR") : sd.getProjPath();
		  File f = fsv.createFileObject( root_dir );
		  chooser = new JFileChooser( f, fsv ); 
		} catch( Exception err ) {
		  SimIO.show_error( _parent, " Error opening file chooser: ", err );
		  return;
		}
		ExtensionFileFilter filter = new ExtensionFileFilter("serial","saved DataSets"); 
		chooser.setFileFilter(filter); 
		int returnVal = chooser.showOpenDialog(_parent); 
		if(returnVal == JFileChooser.APPROVE_OPTION) {
		  File f = chooser.getSelectedFile();
//		  String fname = f.getName();
		  importSimulationDataFromFile(f);
		}
	  }
    } 
    
    public void importSimulationDataFromFile(File f) {
	  SimulationData sd = (SimulationData) readData( f ); 
	  DataSet.addSimulation(sd); 
    }
    
    public void importSimulationDataFromStream( InputStream is ) {
	  try {
		SimulationData sd = SimulationRun.readSimulationData( is );
		DataSet.addSimulation(sd); 
	  } catch( Exception err ) {
		  SimIO.show_error( null, " Error reading simulation data: ", err );
	  }
    }
    
	class CloseViewersAction extends Object implements ActionListener  {
	  public void actionPerformed(ActionEvent e) {
		  int viewer_index = ViewerData.getSelectionIndex();
		  Vector ds = new Vector(16,16);
		  int nSelections = DataSet.getTreeDataSetSelections( ds, viewer_index );
		  if( nSelections <= 0 ) { SimIO.beep(); return; }
		  for( int i=0; i < ds.size(); i++ ) {
			DataSet d = (DataSet) ds.elementAt(i);
			d.destroyDataListeners();
		  }
	  }
    } 
    
	class CreateViewerAction  extends QueuedExecutable {
	  ViewserverControlPanel _vcp;
	  public CreateViewerAction( ViewserverControlPanel cp ) {	_vcp = cp; }
	  public void execute() {		  
		  int viewer_index = ViewerData.getSelectionIndex();
		  Vector ds = new Vector(16,16);
		  int nSelections = DataSet.getTreeDataSetSelections( ds, viewer_index );
		  if( nSelections <= 0 ) { SimIO.beep(); return; }
		  switch(viewer_index) {
			case 0: {
			  for( int i=0; i < ds.size(); i++ ) {
				DataSet d = (DataSet) ds.elementAt(i);
				SimulationData sd = d.getSimulationData();
				AnimationViewer mv = new AnimationViewer( d, sd.simIndex(), sd.toString() );
				d.addEntryDataListener(mv);
				_open_viewers.add(mv);
				mv.show( d.toString() );
			  }
			} break;
			case 1: {
			  SimIO.print("Creating 3D viewers, " + ds.size() + " data entries. " );
			  Object[] options = { "Java3D", "VisAD" };      
			  int response = JOptionPane.showOptionDialog(null, "Please choose viewer type:", "3D Viewer Selection", 
				JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE,
				null, options, options[0]);		

			  if( response == 0 ) {
				  ViewserverControlPanel.showVisADViewer(ds);
			  } else {
				  ViewserverControlPanel.showVisADViewer(ds);
			  }
			} break;
			case 2: {  // Immersadesk
			  DirectoryChooser dc = DirectoryChooser.create( _output_directory );
			  dc.addActionListener( new UpdateOutputDirectoryAction() );
			  dc.show(true);
			  for( int i=0; i < ds.size(); i++ ) {
				DataSet d = (DataSet) ds.elementAt(i);
				SimulationData sd = d.getSimulationData();
				AnimationViewer mv = new AnimationViewer( d, sd.simIndex(), sd.toString() );
				d.addEntryDataListener(mv);
				_open_viewers.add(mv);
				mv.writeData( (byte)0, _output_directory, ".idesk" );
			  }
			} break;
  			case 3: {
			  TimeGraph tg = new TimeGraph();
			  SimulationData sd = null;
			  SimIO.print("Adding timegraph, " + ds.size() + " data entries. " );
			  for( int i=0; i<ds.size(); i++ ) {
				DataSet d = (DataSet) ds.elementAt(i);
				if( sd == null ) { sd = d.getSimulationData(); }
				tg.addComponent(i,d);
				tg.addDataEntries(d);
				_open_viewers.add(tg);
				d.addEntryDataListener(tg);
			  }
			  tg.show( " SME timeseries " );
			} break;
			case 4: {
			  for( int i=0; i < ds.size(); i++ ) {
				DataSet d = (DataSet) ds.elementAt(i);
				DataTable dt = DataTable.getTable( d, false, false, true );
				_open_viewers.add(dt);
			  }
			} break;
			case 5: {
			  ImageTable iT = new ImageTable();
			  SimulationData sd = null;
			  for( int i=0; i < ds.size(); i++ ) {
				DataSet d = (DataSet) ds.elementAt(i);
				if( sd == null ) { sd = d.getSimulationData(); }
				iT.addDataSet(d);
			  }
			  _open_viewers.add(iT);
			  JFrame frame = iT.show( sd.toString() + " Image Table " );
			} break;
			case 6: {
			  for( int i=0; i < ds.size(); i++ ) {
				DataSet d = (DataSet) ds.elementAt(i);
				ParameterViewer P = new ParameterViewer( d, 100 );
				P.showTable();	 
				_open_viewers.add(P);
			  } 			
			} break;
			case 7: {  // Contour plot
			
			} break;
		  }
	  }
    }   

   public static void showVisADViewer( Vector dataSets ) {  
		try {
		  ExternalClassStub  visad = getVisADInterface();
		  visad.execMethod("3dViewer", new Object[] { dataSets } );
		} catch ( MMLException err ) {
		  SimIO.show_error( null, "Must have VisAD properly installed to use this viewer:", err );
		}
	}

   public static void showJava3DViewer( Vector dataSets ) {  
		try {
		  ExternalClassStub  j3d = getJava3DInterface();
		  j3d.execMethod("3dViewer", new Object[] { dataSets } );
		} catch ( MMLException err ) {
		  SimIO.show_error( null, "Must have Java3D properly installed to use this viewer:", err );
		}
	}

	class UpdateOutputDirectoryAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) {
		 _output_directory = e.getActionCommand();
		 System.out.println("Got Output directory: " + _output_directory );
	   }
	} 
	
    public void browse( DataSet ds ) { browse(ds,null); }

    public void browse( DataSet ds, DataEntry de ) {
	  DisposableListDataListener viewer = null;
	  for( int i=0; i<_browsers.size(); i++ ) {
		DisposableListDataListener ddl = (DisposableListDataListener) _browsers.get(i);
		if( ddl.getDataSet() == ds ) { viewer = ddl; break; }
	  }
	  switch( ds.dims() ) {
		case 0: 
		case 1: 
		  if( viewer == null ) { 				
			ParameterViewer P = new ParameterViewer( ds, 100 );
			P.showTable();	  
			_browsers.add(P);
		  }
		break;
		case 2:
		  if( viewer == null ) { 				
			SimulationData sd = ds.getSimulationData();
			AnimationViewer mv = new AnimationViewer( ds, sd.simIndex(), sd.toString() );
			mv.show( ds.toString() );
			_browsers.add(mv);
			if( _tableListener != null ) { mv.addTableModelListener( _tableListener ); }
		  } else if( de != null ) {
			try {
			  AnimationViewer mv = (AnimationViewer)viewer;
			  mv.setBrowserImage( ds.getEntryIndex(de) );
			} catch ( Exception err ) {
			   System.out.println("AnimationViewer Error: " + err.getMessage() );
			}
		  }
		  break;
		case 3: break;
	  }
    }
    
    public void setTableModelListener(TableModelListener l) {
	  _tableListener = l;
    }
	
	public void set_status( String status ) {
	  try {
		_status.setValue( status );
	  } catch ( NullPointerException err ) { return; }
	  repaint();
	}
	
	public  void  set_inet_addr( String inet_addr ) {
	  try {
		_inet_addr.setValue( inet_addr );
	  } catch ( NullPointerException err ) { return; }
	  repaint();
	}

	
	public static void main(String args[])  {
	
	  int port = 17726;
	  
	  if(args.length == 0) {
		  SimIO.print("Using default port: 17726");
	  } else {
		  try {
			  port = Integer.parseInt(args[0]);
			  SimIO.print("Setting port: " + port);
		  }
		  catch(NumberFormatException ex)   {
			  SimIO.print("Port argument must be an integer.");
		  }
	  }
	    
	  if ( port == 0 ) {
		int width = 75, height = 60;
		int max_images = 3;
		DataSet ds = DataSet.create2DDemo( max_images, height, width );	
	  }

	  ViewserverControlPanel cp = ViewserverControlPanel.create( port ); 
	  cp.showFrame();
	}

	public static ViewserverControlPanel create( int port )  { return create( port, kStandAlone ); }

	public static ViewserverControlPanel create( int port, int mode )  {
	  ViewserverControlPanel cp = new ViewserverControlPanel(mode);	
	  JFrame frame  = new JFrame("Viewserver Control Panel");
	  frame.setBackground(Color.lightGray);
	  cp.setFrame(frame);	  
	  cp.init( port );
	  if( port > 0 ) {
		cp.startSocketListener();
	  }
	  frame.setContentPane( cp );		
	  frame.setSize(700,500);
	  return cp;
	}
	
	public void showFrame() {
	  if( _frame != null ) {
		_frame.setVisible(true);
	  }
	}

	public static ViewserverControlPanel getInstance( int port, int mode ) {
	  ViewserverControlPanel cp = new ViewserverControlPanel(mode);		  
	  cp.init( port );
	  CSH.setHelpIDString( cp, "ViewPanel" );
	  cp.startSocketListener();
	  return cp;		
	}
	
	public JFrame displayInFrame() {
	
	  if( _frame != null ) return _frame;
	  
	  if( _tabbedPane != null ) {
		int tab_index = _tabbedPane.indexOfComponent(this);	  
		_tabbedPane.removeTabAt(tab_index);	
		 SimIO.print("Removing  ViewServer from tabbed Frame at index " + tab_index);
		_tabbedPane = null;
	  }
	  
	  SimIO.print("Displaying ViewServer in seperate Frame.");
	  JFrame frame  = new JFrame("Viewserver Control Panel");
	  frame.setBackground(Color.lightGray);
	  
	  this.setFrame(frame);	  
	  frame.setContentPane( this );
	  frame.setJMenuBar( constructMenuBar() );
		
	  frame.setSize(550,500);
	  Dimension         paneSize = frame.getSize();
	  Dimension         screenSize = frame.getToolkit().getScreenSize();
	  frame.setLocation((screenSize.width - paneSize.width) / 4,
				  (screenSize.height - paneSize.height) / 4);
	  frame.setVisible(true);
	  return frame;		
	}

 	
    private JMenuBar constructMenuBar() {
	  JMenu            menu;
	  JMenuBar         menuBar = new JMenuBar();
	  JMenuItem        menuItem;

	  menu = new JMenu("File");
	  menu.setBackground(Color.lightGray);
	  menuBar.add(menu);

	  menuItem = menu.add(new JMenuItem("Open"));
	  menuItem.addActionListener(new OpenAction(this));

	  menuItem = menu.add(new JMenuItem("Save"));
	  menuItem.addActionListener(new SaveAction(this));

	  menuItem = menu.add(new JMenuItem("Disconnect"));
	  menuItem.addActionListener(new DisconnectAction());
	
	  if( _mode == kStandAlone ) {
		menuItem = menu.add(new JMenuItem("Quit"));
		menuItem.addActionListener( new ShutdownAction() );
	  } else {
		menuItem = menu.add(new JMenuItem("Close"));
		menuItem.addActionListener( new CloseAction() );
	  }
/*
	  menu = new JMenu("View");
	  menuBar.add(menu);

	  menuItem = menu.add(new JMenuItem("1"));
  //	menuItem.addActionListener(new InsertAction());

	  menuItem = menu.add(new JMenuItem("2"));
  //	menuItem.addActionListener(new ReloadAction());

	  menuItem = menu.add(new JMenuItem("3"));
  //	menuItem.addActionListener(new RemoveAction());
*/
	  menu = new JMenu("Help");
	  menuBar.add(menu);

	  try {		   
		menuItem = menu.add(new JMenuItem("Show help page"));
		HelpBroker hb = SimIO.getHelpBroker( "SME", "ViewPanel"  );
		menuItem.addActionListener( new CSH.DisplayHelpFromSource(hb)  );
	  } catch ( Exception err ) {; }

	  return menuBar;
    }
	
	void generateHelpText() {
	  _helpText = 
		"  To generate Viewers: \n"
	  + "  1. Select the dataSet(s) to be viewed, \n"
	  + "  2. Select a Viewer Type, \n"
	  + "  3. Press the 'Create' button. \n"
	  + "  This will create viewer(s) for all relevant selected dataSets.  \n"
	  + "  A dataSet is relevant if can be displayed by the selected Viewer type. \n"
	  + "  Viewer Types will be enabled if there are dataSets selected that are relevant for that type.  \n"
	  + "  Selecting a simulation node will select all dataSets in that simulation. \n"				
	  + "  Double-click on a dataSet node to view the data objects in that set. \n\n"			
	  + "  Press the 'Close' button to close all viewers of the selected Viewer type associated with the selected dataSets.";				
	}
	
	public Object readData( File path ) { 
	  FileInputStream os = null;
	  ObjectInputStream ois = null;
	  Object ro = null;
	  try {
		os = new FileInputStream( path );
		ois = new ObjectInputStream(os);
		ro = ois.readObject();
		ois.close();
	  } catch ( Exception e ) {
		SimIO.print( "Error reading file file: " + path.getPath()  + " : " + e.getMessage() ); 
	  }
	  return ro;
   }
  
   public void saveData( String dir, String baseName, int format, boolean saveAll ) {;} 

	public void saveData( String dir, String baseName, SimulationData saveBuffer ) {	
		String filename = baseName + ".serial";
//		SimIO.show_info( null, "Saving dataset to file: " + filename );
		File path = new File(dir,filename);
		FileOutputStream os = null;
		ObjectOutputStream oos = null;
		try {
		  os = new FileOutputStream( path );
		  oos = new ObjectOutputStream(os);
		  oos.writeObject( saveBuffer );
		  oos.close();
		} catch ( Exception e ) {
		  SimIO.print( "Error writing file file " + filename + ":" ); 
		  e.printStackTrace();
		}
	}

}
