package miiee.globus;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.Vector;
import java.util.HashMap;
import javax.swing.border.*;
import miiee.util.*;
import java.io.*;
import java.util.StringTokenizer;
import miiee.client.*;

// import org.globus.gram.*;
// import org.globus.common.RSLAttributes;

//---- GramExecutable ---------------------------------------------------------



class GramExecutable extends Object implements Runnable {

	String _script;
	String[] _envp;
	SMEGram _smegram;
	int _debug = 3;
	
	public GramExecutable( SMEGram smegram ) { super(); _smegram = smegram;  }
	
	public void execute( String s, String envp[] ) {
	   _script = s;
	   _envp = envp; 
        Thread t = new Thread(this);
        t.start();
	}
		
	public void run() {
	  try {
		if( _debug > 0 ) {
		  System.out.println( " Executing script: " + _script );
		}
		StringTokenizer st = new StringTokenizer(_script, ";");
		
		while( st.hasMoreTokens() ) {
		
		  String current_script = st.nextToken();
		  Process p = Runtime.getRuntime().exec( current_script, _envp );
		  InputStream stdout = p.getInputStream();
		  InputStream stderr = p.getErrorStream();

		  _smegram.setStdout( stdout );  
		  _smegram.setStderr( stderr ); 
		   
		  try {
			p.waitFor();
		  } catch ( InterruptedException err ) { 
			SimIO.show_error( null, "Interrupted while waiting for script execution!\n" + err.getMessage()   );
			return; 
		  }
		  if( _debug > 2 ) { System.out.println( "Done executing script: " +  current_script ); }

		  if( _smegram.executionCallback( p.exitValue(), false ) ) {  break; }
		}	
			
		_smegram.executionCallback( 0, true );
		
	  } catch ( IOException err ) {
		 SimIO.show_error( null, "Script execution error: " + err.getMessage() );
	  }	
	}

}

public class SMEGram extends JFrame implements /* GramJobListener, */ ItemListener {

  JTextArea _outputArea;
  JTextArea _errOutputArea;
  JButton _submitButton;
  JButton _shutdownButton;
  JComboBox _rmContactSelector = new JComboBox();
  Vector _rmContacts = new Vector();
  Vector _exePaths = new Vector();
  String[] _envp;
  String _my_hostname;
  String _project;
  String _model;
  int _command_id = TEST_CMD;
  InputStream _stdout;
  InputStream _stderr;
  boolean _running = true;
  GramExecutable _executable;

  Integer sync;

  public static final int TEST_CMD	= 0;
  public static final int SME_PROJECT_CMD	= 1;
  public static final int SME_BUILD_CMD	= 2;
  public static final int SME_RUN_CMD = 3;

  public static void main(String args[]) {
	if(args.length == 0) {
		SimIO.print("Usage: miiee.globus.SMEGram <my_hostname>");
	} else {
	  SMEGram test = new SMEGram( args[0],"CBAY","cbay" );
	  test.run(TEST_CMD);
	}
  }

  public SMEGram( String my_hostname, String project, String model ) {
	_my_hostname = my_hostname;
	_project = project;
	_model = model;
    sync = new Integer(5);
	EmptyBorder eb3 = new EmptyBorder( 3, 3, 3, 3 );
	Border bb = BorderFactory.createCompoundBorder( new BevelBorder(BevelBorder.LOWERED), eb3 );  	

	JPanel top_panel = (JPanel)this.getContentPane();	

	JPanel  buttonPanel = new JPanel(false);
	buttonPanel.setLayout(new FlowLayout());
	buttonPanel.setBorder( bb );
	top_panel.add( "South", buttonPanel );
      
	JPanel  chooserPanel = new JPanel(false);
	BoxLayout bl = new BoxLayout(chooserPanel, BoxLayout.Y_AXIS );  
	chooserPanel.setLayout( bl ); 	   
	chooserPanel.setBorder( bb );
	chooserPanel.add( _rmContactSelector );
	_rmContactSelector.addItemListener(this);
//	pV0.setMaximumSize(new Dimension(Short.MAX_VALUE,  Short.MAX_VALUE)); 
	top_panel.add( "North", chooserPanel );

	JPanel  outputPanel = new JPanel(false);
	BoxLayout bl1 = new BoxLayout(outputPanel, BoxLayout.Y_AXIS );  
	outputPanel.setLayout( bl1 ); 	   
	
    _outputArea = new JTextArea(10,40);
    JScrollPane scrollPane = new JScrollPane(_outputArea);
    scrollPane.setPreferredSize(new Dimension(300,100));
	outputPanel.add( scrollPane );

    _errOutputArea = new JTextArea(10,40);
    JScrollPane scrollPane1 = new JScrollPane(_errOutputArea);
    scrollPane1.setPreferredSize(new Dimension(300,100));
 	outputPanel.add( scrollPane1 );   
    
	top_panel.add( "Center", outputPanel );

    _submitButton = new JButton("Submit");
    _submitButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { handleSubmit(); }
    });
    buttonPanel.add(_submitButton);

    _shutdownButton = new JButton("Cancel");
    _shutdownButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { close(); }
    });
    buttonPanel.add(_shutdownButton);

    _shutdownButton = new JButton("Shutdown");
    _shutdownButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) { handleShutdown(); }
    });
    buttonPanel.add(_shutdownButton);

    Dimension me = this.getSize();
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    this.setLocation(screenSize.width/2 - me.width/2,
		     screenSize.height/2 - me.height/2);
		     
	addRmContact( "modi4.ncsa.uiuc.edu-fork",  "modi4.ncsa.uiuc.edu:4001:/C=US/O=Globus/O=The University of Illinois Urbana-Champaign/OU=The National Center for Supercomputing Applications/CN=modi4.ncsa.uiuc.edu-fork", "/scratch-res4/maxwell/bin/" );
	addRmContact( "modi4.ncsa.uiuc.edu-lsf",  "modi4.ncsa.uiuc.edu:4002:/C=US/O=Globus/O=The University of Illinois Urbana-Champaign/OU=The National Center for Supercomputing Applications/CN=modi4.ncsa.uiuc.edu-lsf", "/scratch-res4/maxwell/bin/" );
	addRmContact( "pitcairn.mcs.anl.gov-fork", "pitcairn.mcs.anl.gov:8713:/C=US/O=Globus/O=Argonne National Laboratory/OU=Mathematics and Computer Science Division/CN=pitcairn.mcs.anl.gov-fork", "~/bin/" );
  }

  public void run( int command_id ) { 

	 _executable = new  GramExecutable(this);
	 _command_id = command_id; 
	 
  	  pack();
	  setVisible(true);
	  
	  while( _running ) {
	  
		collectStdout();
		collectStderr();
		
	  }
 
    /*
    while(true) {
      synchronized(sync) {
	try {
	  sync.wait();
	} catch (InterruptedException e) {}
      }
      GramJob job = submitJob();
    }
    */
  }
  
  public void close() {
	  setVisible(false);
	  _running = false;
	  _executable = null;
	  dispose();
  }

  void collectStdout() {
	if( _stdout == null ) { return; }
	int ch = '\n';
	StringBuffer s = new StringBuffer();
	try {
	  while ( (ch = _stdout.read()) > -1 ) {
		s.append((char)ch);
		if( ch == '\n' ) {
		  _outputArea.append( s.toString() );	
		  s.setLength(0);
		}  
	  }
	} catch ( IOException err ) {;}
	_outputArea.append(s.toString());
  }	
  

  void collectStderr() {
	if( _stderr == null ) { return; }
	int ch = '\n';
	StringBuffer s = new StringBuffer();
	try {
	  while ( (ch = _stderr.read()) > -1 ) {
		s.append((char)ch);
		if( ch == '\n' ) {
		  _errOutputArea.append( s.toString() );	
		  s.setLength(0);
		}  
	  }
	} catch ( IOException err ) {;}
	_errOutputArea.append(s.toString());	
  }
  
  public void setStdout( InputStream stdout ) { _stdout = stdout; }
  public void setStderr( InputStream stderr ) { _stderr = stderr; }

  public boolean executionCallback( int returnValue, boolean finished ) {
	if( finished ) { 
	  _executable = null;
	  _running = false; return true;  
	}
	if( returnValue != 0 ) {
	  SimIO.show_error( null, "Script registered error " + returnValue  );
	  return true;
	}
	return false;	
  }

  public void addRmContact( String label, String rmContact, String exePath ) {
	  _rmContacts.addElement(rmContact);
	  _rmContactSelector.addItem(label);
	  _exePaths.addElement(exePath);
  }

  public void itemStateChanged(ItemEvent e) {
	  int state = e.getStateChange();
	  if( state == ItemEvent.SELECTED ) { 
//		handleSelection(); 
	  } 
  }
	  
  private void handleSubmit() {
    _outputArea.append("submitting job\n");
	 
	submitJob(  _command_id );
    			  
    /*
    synchronized(sync) {
      try {
	sync.notify();
      } catch (IllegalMonitorStateException e) {}
    }
    */
    _outputArea.append("  job submitted\n");
  }

  public void handleShutdown() {
    System.exit(0);
  }


  private void submitJob( int commandID ) {  
    try {
      Thread.sleep(5000);
    } catch (InterruptedException e) {}
    
	int index = _rmContactSelector.getSelectedIndex();    
	String rmContact_label = (String) _rmContactSelector.getSelectedItem();
	String exeDir = (String) _exePaths.get(index);
	String exe_script = null;
	String args = "";
		
	switch(commandID) {
	  case TEST_CMD:        
		exe_script = " test-ls ";
	  break;
	  case SME_PROJECT_CMD: 
		exe_script = " project ";
	  break;
	  case SME_BUILD_CMD:   
		exe_script = " build ";
	  break;
	  case SME_RUN_CMD:  {   
		exe_script = " run ";
//		SMEExecutable sme_ex = new SMEExecutable( SME_RUN_CMD, rmContact_label );
		String rm_host = rmContact_label.substring( 0, rmContact_label.indexOf('-') );
		String sme_script = "startup_client -h " + rm_host + " xxx  ";
		System.out.println( "Starting up client: " + sme_script );
		try {
		  Process p = Runtime.getRuntime().exec( sme_script, null );
		} catch ( IOException err ) {
		   SimIO.show_error( null, "Script execution error: " + err.getMessage() );
		}	
//		sme_ex.start();
	  } break;
	}
	
	String run_script =  "sme_gram " + rmContact_label +  exe_script + _my_hostname + " " + _project + " " + _model;
	_executable.execute(run_script, _envp);

/*	
	switch(commandID) {
	  case TEST_CMD:        
		exe_script = "ls";
		args = "-l";
	  break;
	  case SME_PROJECT_CMD: 
		exe_script = "SME";
		args =  "project " + _project;
	  break;
	  case SME_BUILD_CMD:   
		exe_script = "SME";
		args =  "build " + _project;
	  break;
	  case SME_RUN_CMD:     
		exe_script = "SME";
		args =  "-p -java " + _my_hostname + " run " + _model;
	  break;
	}
	
    RSLAttributes attribs = new RSLAttributes();
    attribs.add("resourceManagerContact",rmContact);
    //attribs.add("jobtype","mpi");
    attribs.add("directory",exeDir);
    attribs.add("executable",exe_script);
	attribs.add("arguments",args);
//    attribs.add("count","2");
    attribs.add("stdout","~/gram.stdout");

	System.out.println("Requesting Gram resourceManager Contact: " + rmContact );
    GramJob job = null;
    try {
      job = new GramJob();
    } catch (GramException e) {
      System.err.println("Error creating GramJob: "+e.getErrorMessage());
      System.exit(1);
    }
    job.addListener(this);
    try {
      job.request(attribs.toRSL());
    } catch (GramException e) {
      System.out.println("Error submitting gram job: "+e.getErrorMessage());
      return null;
    }
    return job;
*/

  }

  class  SMEExecutable implements Runnable {
	  private Thread _cmdThread;
	  int _cmd_index;
	  String _rmContact_label;

	  SMEExecutable( int cmd_index, String rmContact_label ) { 
		  _rmContact_label = rmContact_label;
		  _cmd_index = cmd_index; 
	  }

	  public void run() {
		boolean getMessages = false;
		switch( _cmd_index ) {
		  case SMEGram.SME_RUN_CMD: {
			 String rm_host = _rmContact_label.substring( 0, _rmContact_label.indexOf('-') );
			 System.out.println( " startupClient: " + rm_host );
			 SMEClient.startupClient( null, rm_host, null, "def", false, getMessages, false, SMEInterface.kRun, SMEInterface.kGUI );
		  } break;
		}
	  }

	  public void start() {
		  _cmdThread= new Thread(((Runnable)this)); 
		  _cmdThread.start(); 
	  }

  }

/*
  public void stateChanged(GramJob job) {
    _outputArea.append("Job state change\n");
    _outputArea.append("  job: "+job.getID()+"\n");
    _outputArea.append("  state: "+job.getStateAsString()+"\n");
  }
*/

}
