package miiee.landscape;  

import javax.swing.*;
import java.io.File;
import java.awt.image.*;
import java.util.Vector;
import javax.swing.event.*;
import javax.swing.border.*;
import java.awt.event.*;
import java.awt.*;
import java.applet.Applet;
import javax.help.*;
import miiee.util.*;

public class AnimationViewer3D extends Object implements AnimationController, IOController, DisposableListDataListener
{
    /** Animation. */
    protected RenderRaster _animation;
    protected AnimationControlPanel _controlPanel;
    protected JFrame _frame;
    protected String _name;
    protected String _sim_name;
    protected int _group_index = 0;
    
    protected AttributeValuePair _time;
    protected AttributeValuePair _value;
    protected AttributeValuePair _scale;
    protected int _width;
    protected int _height;
    protected String _helpText;
    protected DataSet _colorSet;
    private static AnimationViewer3D _current_viewer;
    private SaveFileControlPanel _saveControlPanel;
    private static JFrame _DataSetSelectionDialogFrame;
	
   /**
      * Constructs a new instance of AnimationViewer.
      */
	
    public AnimationViewer3D( int width, int height, String name, byte region_map[] ) {
		_animation = new RenderRaster( width, height, region_map, RenderRaster.SWITCHED );
		_animation.setBorder( BorderFactory.createLoweredBevelBorder() );
		_height = height;
		_width = width;
		_name = name;
		generateHelpText();
    }
    
    public AnimationViewer3D( DataSet d, DataSet cd  ) {
		_animation = new RenderRaster( d, cd, RenderRaster.SWITCHED );
		_animation.setBorder( BorderFactory.createLoweredBevelBorder() );
		_height = d.size(0);
		_width = d.size(1);
		_name = d.toString();
		generateHelpText();
    }

    public AnimationViewer3D( DataSet d, DataSet cd, int group_index, String sim_name ) {
		_animation = new RenderRaster( d, cd, RenderRaster.SWITCHED );
		_animation.setBorder( BorderFactory.createLoweredBevelBorder() );
		_height = d.size(0);
		_width = d.size(1);
		_name = d.toString();
		_sim_name = sim_name;
		_group_index = group_index;
		generateHelpText();
    }
	
    public void addColorSet( DataSet d ) {
	  _colorSet = d;
    }

	public synchronized JFrame show( String name ) {
            
		if( _current_viewer != null ) {
		  _current_viewer.dispose();
		  System.gc();                      // reclaim resources to avoid memory overflow
		}
		_current_viewer = this;
		  		
		_frame = new JFrame( " 3D viewer " );
		WindowListener l = new WindowAdapter() {
			public void windowClosing(WindowEvent e) { destroy(); }
		};	  
		_frame.addWindowListener( l );
		
		JPanel viewer_panel = (JPanel)_frame.getContentPane();	
		viewer_panel.add( "Center", _animation );
		viewer_panel.add( "South", constructOptionsPanel());
		
		if( _controlPanel == null ) {
		  _controlPanel = AnimationControlPanel.GetControlPanel( _group_index, _sim_name );
		  _controlPanel.addAnimation(_animation);
		}
		_controlPanel.showPanel();
		_animation.addAnimationController(this);
		_animation.createUniverse();
 
		_frame.setJMenuBar( constructMenuBar() );
		_frame.setBackground(Color.lightGray);	
		_frame.setSize(400,400);
		_frame.setVisible(true);
		return _frame;
	}
	
	public static void create3dViewer( Vector dataSets ) {
	  if( dataSets.size() == 0 ) { SimIO.beep(); return; }
	  DataSet d = (DataSet) dataSets.elementAt(0);
	  SimulationData sd = d.getSimulationData();
	  if( dataSets.size() == 1 ) {
		AnimationViewer3D mv = new AnimationViewer3D( d, null, sd.simIndex(), sd.toString() );
		d.addEntryDataListener(mv);
		mv.show( d.toString() );
	  } else {
		showDataSetSelectionDialog( dataSets );
	  }
	}

    /** Constructs a JPanel containing check boxes for the different
      * options that tree supports. */
  private JPanel constructOptionsPanel() {
	JCheckBox               aCheckbox;
	JPanel           buttonPanel = new JPanel(false);
	JPanel           borderPane = new JPanel(false);  

	borderPane.setLayout(new GridLayout(2,1));
	buttonPanel.setLayout(new FlowLayout());
	borderPane.add(buttonPanel);

	_scale = AttributeValuePair.New( "scale", false, 16 );
	buttonPanel.add(_scale);

	JButton aButton;

	aButton = new JButton("rescale");
	aButton.addActionListener( new ScaleAction() );
	buttonPanel.add( aButton );


	JPanel   infoPanel = new JPanel(false);
	infoPanel.setLayout(new FlowLayout());
	borderPane.add(infoPanel);

	_value = AttributeValuePair.New( "value:", false, 16 );
	infoPanel.add(_value);

	aCheckbox = new JCheckBox("smooth");
	aCheckbox.setSelected(true);
	aCheckbox.addChangeListener(new SmoothImagesChangeListener());
	infoPanel.add(aCheckbox);
		
	return borderPane;
    }

    /** Construct a menu. */

    private JMenuBar constructMenuBar() {
	JMenu            menu;
	JMenuBar         menuBar = new JMenuBar();
	JMenuItem        menuItem;

	menu = new JMenu("File");
	menu.setBackground(Color.lightGray);
	menuBar.add(menu);

	menuItem = menu.add(new JMenuItem("Save"));
	menuItem.addActionListener(new SaveAction(this));

	menuItem = menu.add(new JMenuItem("Quit"));
	menuItem.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		   _frame.dispose();
	    }});

	menu = new JMenu("View");
	menuBar.add(menu);

	menuItem = menu.add(new JMenuItem("1"));
//	menuItem.addActionListener(new InsertAction());

	menuItem = menu.add(new JMenuItem("2"));
//	menuItem.addActionListener(new ReloadAction());

	menuItem = menu.add(new JMenuItem("3"));
//	menuItem.addActionListener(new RemoveAction());

	menu = new JMenu("Help");
	menuBar.add(menu);

	try {
	  menuItem = menu.add(new JMenuItem("Show AnimationViewer help doc"));
	  HelpBroker hb = SimIO.getHelpBroker( "SME", "Vanim3D"    );
	  menuItem.addActionListener( new CSH.DisplayHelpFromSource(hb)  );
	} catch( Exception err ) {;}


	_time = AttributeValuePair.New( "Image index", false, 3 );
	menuBar.add(_time);

	return menuBar;
    }

    /**
      * SaveAction is used to add a new item after the selected item.
      */
    class SaveAction extends Object implements ActionListener {
	  IOController _ac;
	  public SaveAction( IOController ac ) { super(); _ac = ac; }
	  public void actionPerformed(ActionEvent e) {
		_saveControlPanel = SaveFileControlPanel.showControlPanel( _ac, _name, null, null );
	  }
    } // End of SaveAction

    class ScaleAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) {
		_animation.rescale();
	  }
    } 

	void generateHelpText() {
	  _helpText = 
		"  To View Animations: \n"
	  + "  1. Use buttons to move forward or backward through images. \n"
	  + "  2. To rotate image:  left-click and slowly drag edge of image.\n"
	  + "  3. To zoom/pan: middle click on surface and slowly drag up (pan) or down (zoom). \n"
	  + "  4. To translate image: right-click on surface and slowly drag. \n"
	  + "  5. Click on the image to display point coordinates and value. \n"
	  + "  The number of images that can be displayed is limited by java 3D memory requirements. \n"
	  + "  Save animations using the File menu.  ";
	}

   /**
      * SmmothImagesChangeListener implements the ChangeListener interface
      * to toggle the state of showing the handles in the tree.
      */
    class SmoothImagesChangeListener extends Object implements ChangeListener {
	  public void stateChanged(ChangeEvent e) {
//		  _animation.setSmoothing(((JCheckBox)e.getSource()).isSelected());
	  }
    } 

    public  synchronized void timeChanged( float time, int index ) {
	  try { 
		_time.setValue( Integer.toString(index) );
	  } catch ( NullPointerException err ) { ; }
	}

    public  synchronized void pointSelected( int row, int col, float value ){
	  FormattedFloat fval = new FormattedFloat(value);
	  String val = "(" + Integer.toString(row) + "," + Integer.toString(col) + "): " + fval.toJavaFormatString(4);
	  _value.setValue(val);
	  SimIO.print("Setting point value to " + val );
   }

    public void pointTimeseriesSelected( int row, int col ) {;}

    public  synchronized void regionSelected( int row0, int col0, int row1, int col1 ) {;}

    public synchronized void scaleChangedSO( float scale, float offset ) {
	  FormattedFloat fscale = new FormattedFloat(scale);
	  FormattedFloat foffset = new FormattedFloat(offset);
	  String val = "s: " + fscale.toJavaFormatString(4) + ", o: " + foffset.toJavaFormatString(4);
	  _scale.setValue(val);
    }

    public synchronized void scaleChangedMM( float max, float min ) {
	  FormattedFloat fmax = new FormattedFloat(max);
	  FormattedFloat fmin = new FormattedFloat(min);
	  String val = "max: " + fmax.toJavaFormatString(4) + ", min: " + fmin.toJavaFormatString(4);  
	  _scale.setValue(val);
    }

	void print(String msg) {
	  System.out.print("\nJAVA: " + msg);
	}
    
    public void destroy() { 
		if( _controlPanel != null ) {
		  int na = _controlPanel.closeAnimation(_animation); 
		  if( na == 0 ) {
			AnimationControlPanel.closeControlPanel( _group_index );
			_controlPanel = null;
		  }
		}
	  _animation = null;
	  if( _saveControlPanel != null ) { 
		_saveControlPanel.dispose(); 
		_saveControlPanel = null; 
	  }
	}
	
    public void dispose() {  
	  if( _frame != null )  {
		_frame.setVisible(false);
		_frame.dispose();
	  }
	}

	public DataSet getDataSet() { return _animation.getDataSet(); }
		
    synchronized public void intervalAdded(ListDataEvent e) {;}   

    public void intervalRemoved(ListDataEvent e){;}
    public void contentsChanged(ListDataEvent e){;}

   public void saveData( String dir, String baseName, SimulationData data ) {;}
   public void saveData( String dir, String baseName, int format, boolean saveAllFrames ) {
/*
	 try {
	   switch (format) {
		 case 0:
		   if( saveAllFrames ) _animation.SaveAnimationPPM(dir,baseName);
		   else _animation.SaveImagePPM(-1,dir,baseName);
		 break;
	   }
	  } catch ( java.io.IOException err ) {
		SimIO.print( "File write exception: " + err.getMessage() );
	  }
*/
   } 

	private static synchronized void showDataSetSelectionDialog( Vector datSets ) {

	  EmptyBorder eb7 = new EmptyBorder( 7, 7, 7, 7 );	
	  EmptyBorder eb3 = new EmptyBorder( 3, 3, 3, 3 );
	  
	  _DataSetSelectionDialogFrame = new JFrame( " Select DataSets for 3D viewer " );
	  JPanel dialog_panel = (JPanel)_DataSetSelectionDialogFrame.getContentPane();	

	  JPanel button_panel = new JPanel(true);
	  Border bb = new SoftBevelBorder(SoftBevelBorder.LOWERED);  	button_panel.setBorder( bb );
	  dialog_panel.add(button_panel, "South" );
		
	  JPanel pH  = new JPanel(true);
	  BoxLayout bl = new BoxLayout(pH, BoxLayout.X_AXIS );	  pH.setLayout( bl ); 	   
	  dialog_panel.add( pH, "Center" );

	  JPanel pV0  = new JPanel(true);
	  bl = new BoxLayout(pV0, BoxLayout.Y_AXIS );  pV0.setLayout( bl ); 	   
	  bb = BorderFactory.createCompoundBorder( new BevelBorder(BevelBorder.LOWERED), eb3 );  	pV0.setBorder( bb );
	  pV0.setMaximumSize(new Dimension(Short.MAX_VALUE,  Short.MAX_VALUE)); 
	  pH.add(pV0);

	  JPanel pV1  = new JPanel(true);
	  bl = new BoxLayout(pV1, BoxLayout.Y_AXIS );  pV1.setLayout( bl ); 	   
	  bb = BorderFactory.createCompoundBorder( new BevelBorder(BevelBorder.LOWERED), eb3 );   pV1.setBorder( bb );
	  pV1.setMaximumSize(new Dimension(Short.MAX_VALUE,  Short.MAX_VALUE)); 
	  pH.add(pV1);
	  	  
	  JLabel title = new JLabel("Altitude DataSet:");
	  title.setAlignmentX( Component.CENTER_ALIGNMENT );
	  pV0.add(title);
	  
	  JList altitudeList =  new JList( datSets );
	  altitudeList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION); 
	  altitudeList.setBorder( BorderFactory.createEtchedBorder() );
	  JScrollPane scrollPane = new JScrollPane();
	  scrollPane.getViewport().setView(altitudeList);
	  scrollPane.setBorder( eb7 );
 	  pV0.add(scrollPane);

	  title = new JLabel("Color DataSet:");
	  title.setAlignmentX( Component.CENTER_ALIGNMENT );
	  pV1.add(title);

	  JList colorList =  new JList( datSets );
	  colorList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION); 
	  colorList.setBorder( BorderFactory.createEtchedBorder() );
	  scrollPane = new JScrollPane();
	  scrollPane.getViewport().setView(colorList);
	  scrollPane.setBorder( eb7 );
 	  pV1.add(scrollPane);

	  if( _DataSetSelectionDialogFrame != null ) {
		_DataSetSelectionDialogFrame.setVisible(false);
//		_DataSetSelectionDialogFrame.dispose();
	  }
 	  
	  JButton  button = new JButton("Cancel");
	  button.addActionListener( new DataSetSelectionCancelAction( _DataSetSelectionDialogFrame ) );
	  button.setMaximumSize( new Dimension( Short.MAX_VALUE, button.getMaximumSize().height ) );
	  button.setAlignmentX( Component.CENTER_ALIGNMENT );
	  button_panel.add( button );

	  button = new JButton("Create Viewer");
	  button.addActionListener( new DataSetSelectionCreateAction( _DataSetSelectionDialogFrame, altitudeList, colorList ) );
	  button.setMaximumSize( new Dimension( Short.MAX_VALUE, button.getMaximumSize().height ) );
	  button.setAlignmentX( Component.CENTER_ALIGNMENT );
	  button_panel.add( button );

	  WindowListener l = new WindowAdapter() {
		  public void windowClosing(WindowEvent e) {
			_DataSetSelectionDialogFrame.dispose(); 
			SimIO.print(" dispose _DataSetSelectionDialogFrame");
			_DataSetSelectionDialogFrame = null; 
		  }
	  };
	  _DataSetSelectionDialogFrame.addWindowListener( l );           
	  _DataSetSelectionDialogFrame.setSize( 400, 300 );
	  _DataSetSelectionDialogFrame.setVisible(true);
		
	}

}


class DataSetSelectionCreateAction extends Object implements ActionListener {
  JFrame _frame;
  JList _altitudeList;
  JList _colorList;
  
  public DataSetSelectionCreateAction( JFrame frame, JList altitudeList, JList colorList ) {
	_frame = frame;
	_altitudeList = altitudeList;
	_colorList = colorList;
  }
  
  public void actionPerformed(ActionEvent e) {
	  DataSet alt_ds =  (DataSet) _altitudeList.getSelectedValue(); 
	  DataSet color_ds =  (DataSet) _colorList.getSelectedValue(); 
	  if( alt_ds == null ) { SimIO.beep(); return ; }
	  SimulationData sd = alt_ds.getSimulationData();
	  AnimationViewer3D mv = new AnimationViewer3D( alt_ds, color_ds, sd.simIndex(), sd.toString() );
	  alt_ds.addEntryDataListener(mv);
	  color_ds.addEntryDataListener(mv);
	  mv.show( "3D Viewer, altitude: " + alt_ds.toString() + (( color_ds == null ) ? " " : ( " color: " + color_ds.toString())) );		  
	  _frame.setVisible(false);
//	  _frame.dispose();
	  _frame = null; 
  }
} 

class DataSetSelectionCancelAction extends Object implements ActionListener {
  JFrame _frame;
  
  public DataSetSelectionCancelAction( JFrame frame ) {
	_frame = frame;
  }
  
  public void actionPerformed(ActionEvent e) {
	  _frame.setVisible(false);
//	  _frame.dispose();
	  _frame = null; 
  }
} 
