package miiee.landscape;

import javax.swing.*;
import java.awt.image.*;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.event.*;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.applet.Applet;
import miiee.util.*;

public class ContourViewer extends JPanel implements AppletKernel
{
    /** Animation. */
//    protected ContourImage3D       _animation;
    protected JFrame _frame;
    protected DataSet _dataset;
    
    protected AttributeValuePair _time;
    protected AttributeValuePair _value;
    protected int _x;
    protected int _y;
    protected int _z;
    protected int _maxImages;


    /**
      * Constructs a new instance of ContourViewer.
      */

    public ContourViewer( int length0, int length1, int length2, int max_images ) {
	
//		_animation.setBorder( BorderFactory.createLoweredBevelBorder() );
		_x = length0; _y = length1; _z = length2; _maxImages = max_images;
    }

    public ContourViewer( int length0, int length1, int max_images ) {
	
//		_animation.setBorder( BorderFactory.createLoweredBevelBorder() );
		_x = length0; _y = length1; _z = 1; _maxImages = max_images;
    }

    public void init() {
		if( _frame == null ) { print("No frame declared for AnimationViewer"); }
		else {
		  JMenuBar         menuBar = constructMenuBar();
  //		_frame.setJMenuBar(menuBar);
		  _frame.setBackground(Color.lightGray);	
		  _frame.setSize(400,400);
		  _frame.show();
		}		
		setLayout(new BorderLayout());
//		add( "Center", _animation );
		add( "South", constructOptionsPanel());
		
//		_animation.AddAnimationController(this);
    }
    
    public void start() {
//		_animation.start();
    }

    /** Constructs a JPanel containing check boxes for the different
      * options that tree supports. */
    private JPanel constructOptionsPanel() {
	JCheckBox               aCheckbox;
	JPanel           buttonPanel = new JPanel(false);
	JPanel           borderPane = new JPanel(false);

	borderPane.setLayout(new BorderLayout());
	buttonPanel.setLayout(new FlowLayout());

	JButton aButton;
	
	aButton = new JButton("step");
	aButton.addActionListener( new StepAction() );
	buttonPanel.add( aButton );

	aButton = new JButton("stop");
	aButton.addActionListener( new StopAction() );
	buttonPanel.add( aButton );

	aButton = new JButton("run");
	aButton.addActionListener( new RunAction() );
	buttonPanel.add( aButton );

	aButton = new JButton("rescale");
	aButton.addActionListener( new ScaleAction() );
	buttonPanel.add( aButton );

	aCheckbox = new JCheckBox("smooth");
	aCheckbox.setSelected(true);
	aCheckbox.addChangeListener(new SmoothImagesChangeListener());
	buttonPanel.add(aCheckbox);

	borderPane.add(buttonPanel, "North");

	JPanel   infoPanel = new JPanel(false);
	infoPanel.setLayout(new FlowLayout());

	_time = AttributeValuePair.New( "time", false, 8 );
	infoPanel.add(_time);

	JSlider clevel = new JSlider( JSlider.HORIZONTAL, 0, 100, 50 );
	clevel.addChangeListener(new CLevelChangeListener());
	infoPanel.add(clevel);

	borderPane.add(infoPanel, "South");
	return borderPane;
    }

    /** Construct a menu. */

    private JMenuBar constructMenuBar() {
	JMenu            menu;
	JMenuBar         menuBar = new JMenuBar();
	JMenuItem        menuItem;

	menu = new JMenu("File");
	menu.setBackground(Color.lightGray);
	menuBar.add(menu);

	menuItem = menu.add(new JMenuItem("Save"));
	menuItem.addActionListener(new SaveAction());

	menuItem = menu.add(new JMenuItem("Quit"));
	menuItem.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		   _frame.dispose();
	    }});

	menu = new JMenu("View");
	menuBar.add(menu);

	menuItem = menu.add(new JMenuItem("1"));
//	menuItem.addActionListener(new InsertAction());

	menuItem = menu.add(new JMenuItem("2"));
//	menuItem.addActionListener(new ReloadAction());

	menuItem = menu.add(new JMenuItem("3"));
//	menuItem.addActionListener(new RemoveAction());

	_value = AttributeValuePair.New( "value:", false, 15 );
	menuBar.add(_value);

	return menuBar;
    }

    /**
      * SaveAction is used to add a new item after the selected item.
      */
    class SaveAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) {
//		try {
//			_animation.SaveJPEG();
//		} catch( java.io.IOException ioex ) { SimIO.print( "Error saving jpeg file: " + ioex); } 
	  }
    } // End of SaveAction


    class StepAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) {
//		  _animation.StepAnimation();
	  }
    } 
    class StopAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) {
//		  _animation.PauseAnimation();
	  }
    } 
    class RunAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) {
//		  _animation.RunAnimation();
	  }
    } 
    class ScaleAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) {
//		_animation.SetAutoscale(true);
	  }
    } 

    class SmoothImagesChangeListener extends Object implements ChangeListener {
	  public void stateChanged(ChangeEvent e) {
//		  _animation.setSmoothing(((JCheckBox)e.getSource()).isSelected());
	  }
    } 

    class CLevelChangeListener extends Object implements ChangeListener {
	  public void stateChanged(ChangeEvent e) {
//		  _animation.setContourLevelProportional( clevel );
	  }
    } 
	
    public  synchronized void timeChanged( float time, int index ) { 
	  _time.setValue( Float.toString(time) );
	  _time.refreshImmediately();
	}

    public  synchronized void pointSelected( int row, int col, float value ){
	  FormattedFloat fval = new FormattedFloat(value);
	  String val = "(" + Integer.toString(row) + "," + Integer.toString(col) + "): " + fval.toJavaFormatString(4);
	  _value.setValue(val);
   }

    public void initDemo() {			
		int length1 = _x;
		int length2 = _y;
		int length3 = _z;

		int a = 2, b = 5, c = 3;
		float pi = (float)Math.PI;
		float l1 = length1, l2 = length2, l3 = length3;

		for( int i=0; i<_maxImages; i++ ) {	    
		  int index = 0; 
		  float min_value = Float.MAX_VALUE, max_value = Float.MIN_VALUE;
		  float[] data = new float[length1*length2*length3];
		  for( int i3 = 0; i3<length3; i3++ ) {
			for( int i2 = 0; i2<length2; i2++ ) {
			  for( int i1 = 0; i1<length1; i1++ ) {
				float value = (float) ( Math.sin((i1/l1)*a*pi) + Math.sin((i2/l2)*b*pi) + Math.sin((i3/l3)*c*pi) );
				min_value = (value < min_value) ? value : min_value;
				max_value = (value > max_value) ? value : max_value;
				data[index++] = value;
			  }
			}
		  }
		  addDataArray( data, min_value, max_value, " ", i );
		  a++; b++; c++;
		}
	  }

    static public void main(String args[]) {
		int ndim = 3;		
		int length1 = 16;
		int length2 = 16;
		int length3 = (ndim==3) ? 16 : 1;
		int max_images = 3;

	  // create JFrame (i.e., a window) for display and slider
		ContourViewer av = new ContourViewer(length1,length2,length3,max_images);
		AppContainer ac = new AppContainer("test animator", av, null);
		ac.setVisible(true);

		int a = 2, b = 5, c = 3;
		float pi = (float)Math.PI;
		float l1 = length1, l2 = length2, l3 = length3;

		for( int i=0; i<max_images; i++ ) {	    
		  int index = 0; 
		  float min_value = Float.MAX_VALUE, max_value = Float.MIN_VALUE;
		  float[] data = new float[length1*length2*length3];
		  for( int i3 = 0; i3<length3; i3++ ) {
			for( int i2 = 0; i2<length2; i2++ ) {
			  for( int i1 = 0; i1<length1; i1++ ) {
				float value = (float) ( Math.sin((i1/l1)*a*pi) + Math.sin((i2/l2)*b*pi) + Math.sin((i3/l3)*c*pi) );
				min_value = (value < min_value) ? value : min_value;
				max_value = (value > max_value) ? value : max_value;
				data[index++] = value;
			  }
			}
		  }
		  av.addDataArray( data, min_value, max_value, " ", i );
		  a++; b++; c++;
		}
    }
    
    public synchronized int addDataArray( float[] data, float min_value, float max_value, String info, float time )
    {		
	//  add data here.		
        return 0; 
    }
    
    public void stop() { 
//	  if( _animation != null ) {
//		_animation.stop();  
//	  }
	}
    
    public void destroy() {  
//	  _animation = null;
	}
	
    public void dispose() {  
	  if( _frame != null )  {
		_frame.setVisible(false);
		_frame.dispose();
	  }
	}

	public  DataSet getDataSet() { return null; }

	void print(String msg) {
	  System.out.print("\nJAVA: " + msg);
	}
  
  public void setFrame(JFrame f) {  _frame = f; }
  public Container getContentPane() { return this; }

  synchronized public void intervalAdded(ListDataEvent e) {
//	DataSet d = (DataSet) e.getSource();
//	int index_added = e.getIndex1();

//	for( int i= _animation.Size(); i <= index_added; i++ ) { 
//	  DataEntry de = d.getEntry(i);
//		if( de != null ) { CreateImage( de ); }
//	}

  }   

    public void intervalRemoved(ListDataEvent e){;}
    public void contentsChanged(ListDataEvent e){;}

}
