package miiee.landscape;

import java.awt.*;
import javax.swing.JPanel;
import com.sun.j3d.utils.behaviors.mouse.*;
import com.sun.j3d.utils.picking.behaviors.*; 
import javax.swing.JComponent;
import javax.swing.JViewport;
//import java.awt.image.*;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.io.FileOutputStream;
import java.io.File;
import java.awt.geom.AffineTransform;
import java.awt.font.TextLayout;
import java.util.Vector;
import miiee.util.*;
import java.io.DataOutputStream;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.event.*;
import java.awt.GraphicsConfiguration;
import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.universe.*;
import javax.media.j3d.*;
import javax.vecmath.*;
import java.util.Enumeration;

class TVector extends Vector {
  
  public TVector() { super(16,16); }
  
  public synchronized void setElementAt(Object obj, int index) {
	  if( elementCount > index ) { elementCount = index; }
	  ensureCapacity(index+1);
	  elementData[ index ] = obj;
	  elementCount = index+1;
  }
}

public class RenderRaster extends JPanel implements AnimationStepper {

	public static final int WRITABLE = 0;
	public static final int SWITCHED = 1;
	public static final int MORPHED = 2;

	private Vector _imageData = new Vector(16,16);
	private Raster _raster;
	private DataSet _altitude_dataSet;
	private DataSet _color_dataSet;
	private int _current_image;
	private int _data_width;
	private int _data_height;
	private Shape3D _surface;
	private byte[] _activation_map;
	private Switch _surfaceSwitch;
	private long _delay = 200L;
	private int _sceneGraphType;
	private int _total_verts = 0;
	private byte _data_format = 0;
	private boolean _debug = false;
	private float _dt = 1.0f;
	private int _anim_control_mode = ANIM_PAUSE;
	private Canvas3D _canvas;
	protected AnimationController _ddl;
	private int[] _vertexData;
	private Point3f[] _points;
	private Point3d[] _baseQuad = new Point3d[4];
	private Color3f[] _colors;
	private int _vertexCount;
	private int _numStrips;
	private int _currentPickedImage = -1;
	private int[] _indexData;

    public static final int ANIM_EXIT	= 0;
    public static final int ANIM_RUN	= 1;
    public static final int ANIM_PAUSE	= 2;
    public static final int ANIM_STEP	= 3;

	class RenderCanvas3D extends Canvas3D {
	
	  RenderCanvas3D() { super(null); }

	  public void postRender() {
		  super.postRender();
		  updateFrames();
		  System.out.print(".");
	  }
	}

	public RenderRaster(  int width, int height, byte region_map[], int sceneGraphType ) {
		_data_width = width;
		_data_height =  height;
		setLayout(new BorderLayout());
		_sceneGraphType = sceneGraphType;
		_activation_map = region_map;
		_canvas = new RenderCanvas3D();
		add("Center",_canvas);
	}
	

	public RenderRaster( DataSet d, DataSet cd,  int sceneGraphType ) {
		_data_width = d.size(0);
		_data_height =  d.size(1);
		_data_format = d.format();
		SimIO.print("Creating 3D Raster Viewer, dims: ( " + _data_width + " , "  + _data_width + " ) " );
		_activation_map = d.getActiveRegion();
		setLayout(new BorderLayout());
		_sceneGraphType = sceneGraphType;
		addDataEntries( d, cd );		
		_canvas = new RenderCanvas3D();
		add("Center",_canvas);
		_altitude_dataSet = d;
		_color_dataSet = cd;
	}
	
    public void addAnimationController(AnimationController ddl) {
		_ddl = ddl;    
    }
	
	private void addDataEntries( DataSet d, DataSet cd  ) {
		float gmax = -Float.MAX_VALUE, gmin = Float.MAX_VALUE;
		float cmax = -Float.MAX_VALUE, cmin = Float.MAX_VALUE;
		for( int i= 0; i <= d.size(); i++ ) { 
		  DataEntry de = d.getEntry(i);
		  DataEntry dec = null;
		  if( ( cd != null ) && ( i < cd.size() ) ) {
			dec = cd.getEntry(i);
		  }
		  if( de != null ) { 
			if( de.max() > gmax ) gmax = de.max();
			if( de.min() < gmin ) gmin = de.min();
			_dt = de.dt();
		  }
		  if( dec != null ) { 
			if( dec.max() > cmax ) cmax = dec.max();
			if( dec.min() < cmin ) cmin = dec.min();
		  }
		}		
		for( int i= 0; i <= d.size(); i++ ) { 
		  DataEntry de = d.getEntry(i);
		  DataEntry dec = null;
		  if( ( cd != null ) && ( i < cd.size() ) ) {
			dec = cd.getEntry(i);
		  }
		  if( de != null ) { 
			createSurface( de, dec, gmax, gmin, cmax, cmin, de.time() ); 
		  }
		}
	}
	
	private BranchGroup createSceneGraphSwitched( ) {
		// Create the root of the branch graph
		BranchGroup  objRoot = new BranchGroup();
				
		Transform3D t = new Transform3D();
		Transform3D temp = new Transform3D();
		Vector3f tr = new Vector3f( 0.0f, -0.2f, 0.0f );
		t.set (tr);
 
		temp.rotX( - Math.PI/4.0d );
		t.mul(temp);
		
		// Shrink the objects so we don't have to be too far away to
		// see them all.
		t.setScale( 0.65 );

		TransformGroup newTrans = new TransformGroup(t);
		newTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		newTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		newTrans.setCapability(TransformGroup.ENABLE_PICK_REPORTING);

		TransformGroup spinTg = new TransformGroup();
		spinTg.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		spinTg.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		spinTg.setCapability(TransformGroup.ENABLE_PICK_REPORTING);

		_surfaceSwitch = new Switch(0);

		// Set the capability bits
		_surfaceSwitch.setCapability(Switch.ALLOW_SWITCH_READ);
		_surfaceSwitch.setCapability(Switch.ALLOW_SWITCH_WRITE);

		for( int i=0; i<_imageData.size(); i++) {		
		  Shape3D surface = new Shape3D();
		  surface.setAppearance(new Appearance());
		  surface.setGeometry( getGeometry(i) );	
		  surface.setCapability(Shape3D.ALLOW_APPEARANCE_READ);
		  surface.setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
		  surface.setCapability(Shape3D.ENABLE_PICK_REPORTING);
		  _surfaceSwitch.addChild(surface);
		}
		
		spinTg.addChild( _surfaceSwitch );
		newTrans.addChild( spinTg );
		objRoot.addChild(newTrans);
		
			// Have Java 3D perform optimizations on this scene graph.
		BoundingSphere bounds =  new BoundingSphere(new Point3d(0.0,0.0,0.0), 100.0);
/*
		// Now create the Alpha object that controls the speed of the
		// morphing operation.
		Alpha morphAlpha = new Alpha(-1, Alpha.INCREASING_ENABLE |
					 Alpha.DECREASING_ENABLE,
					 0, 0,
					 4000, 1000, 500,
					 4000, 1000, 500);

		// Finally, create the morphing behavior
		MorphingBehavior mBeh = new MorphingBehavior(morphAlpha, morph);  
		mBeh.setSchedulingBounds(bounds);
		objRoot.addChild(mBeh);
*/

		PickRotateBehavior behavior = new PickRotateBehavior(objRoot, _canvas, bounds );
		objRoot.addChild(behavior);
		PickZoomBehavior behavior2 = new PickZoomBehavior(objRoot, _canvas, bounds );
		objRoot.addChild(behavior2);
		PickTranslateBehavior behavior3 = new PickTranslateBehavior(objRoot, _canvas, bounds );
		objRoot.addChild(behavior3);
/*
		PickVertexBehavior behavior4 = new PickVertexBehavior(objRoot, _canvas, bounds );
		objRoot.addChild(behavior4);
*/
		objRoot.compile();
		return objRoot;
	}

	private BranchGroup createSceneGraphWritable( ) {
		// Create the root of the branch graph
		BranchGroup objRoot = new BranchGroup();
				
		Transform3D t = new Transform3D();
		Transform3D temp = new Transform3D();
		Vector3f tr = new Vector3f( 0.0f, -0.2f, 0.0f );
		t.set (tr);
 
		temp.rotX( - Math.PI/4.0d );
		t.mul(temp);
		
		// Shrink the objects so we don't have to be too far away to
		// see them all.
		t.setScale( 0.65 );

		TransformGroup newTrans = new TransformGroup(t);
		newTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		newTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		newTrans.setCapability(TransformGroup.ENABLE_PICK_REPORTING);

		TransformGroup spinTg = new TransformGroup();
		spinTg.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
		spinTg.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
		spinTg.setCapability(TransformGroup.ENABLE_PICK_REPORTING);

		_surface = new Shape3D();
		_surface.setAppearance(new Appearance());
		_surface.setGeometry( getGeometry(-1) );
		_surface.setCapability(Shape3D.ALLOW_GEOMETRY_WRITE);	
		_surface.setCapability(Shape3D.ALLOW_APPEARANCE_READ);
		_surface.setCapability(Shape3D.ALLOW_APPEARANCE_WRITE);
		_surface.setCapability(Shape3D.ENABLE_PICK_REPORTING);
		
		spinTg.addChild( _surface );
		newTrans.addChild( spinTg );
		objRoot.addChild(newTrans);
		
			// Have Java 3D perform optimizations on this scene graph.
		BoundingSphere bounds =  new BoundingSphere(new Point3d(0.0,0.0,0.0), 100.0);
/*
		// Now create the Alpha object that controls the speed of the
		// morphing operation.
		Alpha morphAlpha = new Alpha(-1, Alpha.INCREASING_ENABLE |
					 Alpha.DECREASING_ENABLE,
					 0, 0,
					 4000, 1000, 500,
					 4000, 1000, 500);

		// Finally, create the morphing behavior
		MorphingBehavior mBeh = new MorphingBehavior(morphAlpha, morph);  
		mBeh.setSchedulingBounds(bounds);
		objRoot.addChild(mBeh);
*/
		PickRotateBehavior behavior = new PickRotateBehavior(objRoot, _canvas, bounds );
		objRoot.addChild(behavior);
		PickZoomBehavior behavior2 = new PickZoomBehavior(objRoot, _canvas, bounds );
		objRoot.addChild(behavior2);
		PickTranslateBehavior behavior3 = new PickTranslateBehavior(objRoot, _canvas, bounds );
		objRoot.addChild(behavior3);
/*
		PickVertexBehavior behavior4 = new PickVertexBehavior(objRoot, _canvas, bounds );
		objRoot.addChild(behavior4);
*/
		objRoot.compile();
		return objRoot;
	}

	private BranchGroup createSceneGraphMorphed( ) {
		BranchGroup objRoot = new BranchGroup();
		objRoot.compile();
		return objRoot;
	}
	
	public void createUniverse() {

		// Create a simple scene and attach it to the virtual universe
  		SimpleUniverse  u = new SimpleUniverse(_canvas);

		BranchGroup objRoot = null;		
		switch( _sceneGraphType ) {
		  case SWITCHED: objRoot = createSceneGraphSwitched(); break;
		  case WRITABLE: objRoot = createSceneGraphWritable(); break;
		  case MORPHED:  objRoot = createSceneGraphMorphed(); break;		  
		}
			// This will move the ViewPlatform back a bit so the
			// objects in the scene can be viewed.
		u.getViewingPlatform().setNominalViewingTransform();
		u.addBranchGraph( objRoot );	
	}  

	private void setCurrentImage( int index ) {
	  if( index < 0 ) { index = _current_image; }
	  else { _current_image = index; }
	  switch( _sceneGraphType ) {
		case SWITCHED: _surfaceSwitch.setWhichChild(index);	break;
		case WRITABLE: _surface.setGeometry( getGeometry(index) );	break;  
		case MORPHED: break;
	  }
	  repaint();
	  if( _ddl != null ) {
		_ddl.timeChanged(  _current_image * _dt, _current_image );
	  }
	}		
  
	public void stepAnimation() { 
	  SimIO.print("Stepping animation.");
	  _anim_control_mode = ANIM_STEP;
	}

	public void pauseAnimation() { 
	  _anim_control_mode = ANIM_PAUSE;
	}

	public void runAnimation() { 
	  _anim_control_mode = ANIM_RUN;
	}

	private GeometryArray getGeometry( int index ) {
		if( index < 0 ) index = _current_image;
		GeometryArray ga = null;
		try {
		  ga = (GeometryArray) _imageData.get(index);
		} catch( ArrayIndexOutOfBoundsException err ) {;}
		return ga;
	}
		
    public int setAnimationTime1( float time, boolean forward ) {  
	  int max_index = _imageData.size() - 1;
	  int index = Math.round(time/_dt);
	  index = ( index > max_index ) ? max_index : index;
	  setAnimationIndex( index );
	  return ( index == max_index ) ? 2 : 0;
    }

   public int setAnimationTime( float time, boolean forward ) { 
	  if( time == 0.0f  ) {
		if( _current_image > 0 ) { setAnimationIndex( 0 ); } 
		return 0;
	  }
	  DataEntry id =  (DataEntry) _altitude_dataSet.getEntry( _current_image );
	  int max_index = _altitude_dataSet.size() - 1;
	  if( id == null ) { return 2; }
	  float  tcur = id.time();
	  if( !forward ) {            // backwards stepping  
		if( time > tcur ) { return 0; }
		if( _current_image == 0 ) { return 0; }
		DataEntry id1 =  (DataEntry) _altitude_dataSet.getEntry( _current_image-1 );
		float tnext = id1.time();
		if( ( time < tnext ) || ( ( (time-tnext)/(tcur-tnext) ) < 0.5f ) ) { 
		  setAnimationIndex( _current_image-1 ); 
		  return 1;
		} 
	  } else {                // forward stepping  
		if( _current_image == max_index ) { return 3; }
		DataEntry id1 =  (DataEntry) _altitude_dataSet.getEntry( _current_image+1 );
		float tnext = id1.time();
		if( ( time > tnext ) || ( ( (tnext-time)/(tnext-tcur) ) < 0.5f ) ) { 
		  setAnimationIndex( _current_image+1 ); 
		  if( _current_image == max_index ) { return 2; }
		  else { return 0; }
		} 
	  }
	  return 0;
    }

    public void setAnimationIndex( int index ) {
	  _anim_control_mode = ANIM_PAUSE;
	  setCurrentImage( index );
    }

    public void updateFrames() {
        if ( _anim_control_mode != ANIM_EXIT ) {
            try {  Thread.sleep( _delay );   }
            catch (InterruptedException e0) {  return;  }
            
            switch ( _anim_control_mode ) {
                case ANIM_PAUSE: 
					return;
                case ANIM_STEP:
                    if( ++_current_image == _imageData.size()) _current_image = 0;
                    setCurrentImage( _current_image );
                    _anim_control_mode= ANIM_PAUSE; 
                   return;
                case ANIM_RUN:
					if( ++_current_image == _imageData.size()) _current_image = 0;
					setCurrentImage( _current_image );
					return;
            }
        }
    } 

    public float getTime() {
	  return _current_image * _dt;
    }
    
    public float getBaseTimestep() {
	  return _dt;
    }
 		
	public  DataSet getDataSet() { return _altitude_dataSet; }
   
	public float getTimestep() {
	  DataEntry id0 =  (DataEntry) _altitude_dataSet.getEntry( 0 );
	  DataEntry id1 =  (DataEntry) _altitude_dataSet.getEntry( 1 );
	  try {
		float t0 = id0.time();
		float t1 = id1.time();
		return t1 - t0;
	  } catch ( NullPointerException e) {
		return Float.MAX_VALUE;
	  }
    }
    
    public void rescale() {
	  DataSet ds = _altitude_dataSet;
	  DataSet cds = ( _color_dataSet == null ) ? ds : _color_dataSet;
	  DataEntry id =  (DataEntry) ds.getEntry( _current_image );
	  DataEntry cd =  (DataEntry) cds.getEntry( _current_image );	  	  
	  float gmax = id.max();
	  float gmin = id.min();
	  float cmax = cd.max();
	  float cmin = cd.min();
	  SimIO.print("Rescaling animation: gmax/min= ( " + gmax + ", " + gmin + " ), cmax/min= ( " + cmax + ", " + cmin + " ) " );
	  _imageData.clear();
	  for( int i= 0; i <= ds.size(); i++ ) { 
		  DataEntry de = cds.getEntry(i);
		  DataEntry dec = ds.getEntry(i);
		  if( de != null ) { 
			createSurface( de, dec, gmax, gmin, cmax, cmin, de.time() ); 
		  }
	  }
    }

	 private  void  createPointArray(DataEntry de, DataEntry dec, float gmax, float gmin, float cmax, float cmin) {	
		float x, y, z, cz;
		boolean isBackground = false;
		Point3f[] tpoint = new Point3f[3]; 
		Color3f[] tcolor = new Color3f[3]; 
		TVector point_data = new TVector();
		TVector color_data = new TVector();
		TVector strip_data = new TVector();
		TVector index_data = new TVector();
		Point3f p = null;
		Color3f c = null;
		boolean in_strip = false;
		int strip_index=0, strip_offset=0;
		float ioff = _data_height/2.0f, joff =_data_width/2.0f;
		float scale = (ioff + joff)/2.0f;			
		int cnt = 0, index0, index1, mindex = 0, mi0 = 0;
		for(int i=0; i<_data_height-1; i++ ) {
		  for(int j=0; j<_data_width; j++ ) {
		  
			index0 = j + i*_data_width;
			if( _activation_map != null ) {
			  isBackground = ( _activation_map[index0] == 0 );
			}
			
			if( isBackground ) { 
			  if( in_strip ) {
				in_strip = false; 
				if( strip_index > 2 ) { 
				  strip_data.add( new Integer(strip_index) ); 
				  strip_offset += strip_index;
				}
				strip_index = 0;
			  } 
			} else {
			  in_strip = true;
			  if( _data_format == 0 ) { mindex = index0; }
			  else { mindex = mi0++; }
			  x =  ( i-ioff )/scale;
			  y =  ( j-joff )/scale;
			  z = de.getNormalizedValue( mindex, gmax, gmin );
			  if( z == Float.MAX_VALUE ) {
				p = new Point3f(x,y,1f);
				c = new Color3f( 1f , 1f, 1f ); 
			  } else {
				cz = ( dec == null ) ? z : dec.getNormalizedValue( mindex, cmax, cmin );
				p = new Point3f(x,y,z);
				c = new Color3f( cz, ( cz < 0.5f ) ? 2.0f * cz : 2.0f - 2.0f * cz, 1.0f-cz ); 
			  }
			  
			  int vindex = strip_offset + strip_index;
			  point_data.setElementAt(p,vindex);
			  color_data.setElementAt(c,vindex);
			  index_data.setElementAt( new Integer(mindex), vindex );
			  strip_index++;
			}

			index1 = j + (i+1)*_data_width;
			if( _activation_map != null ) {
			  isBackground = ( _activation_map[index1] == 0 );
			}
						
			if( isBackground ) { 
			  if( in_strip ) {
				in_strip = false; 
				if( strip_index > 2 ) { 
				  strip_data.add( new Integer(strip_index) ); 
				  strip_offset += strip_index;
				}
				strip_index = 0;
			  } 
			} else if(in_strip) {
			  if( _data_format == 0 ) { mindex = index1; }
			  else { 
				for(int k=index0+1; k<=index1; k++ ) { 
				  if( _activation_map[ k ] > 0 ) { mindex++; }
				}
			  }
			  x =  ( i+1-ioff )/scale;
			  y =  ( j-joff )/scale;
			  z = de.getNormalizedValue( mindex, gmax, gmin );
			  if( z == Float.MAX_VALUE ) {
				p = new Point3f(x,y,1f);
				c = new Color3f( 1f , 1f, 1f ); 
			  } else {
				cz = ( dec == null ) ? z : dec.getNormalizedValue( mindex, cmax, cmin );
				p = new Point3f(x,y,z);
				c = new Color3f( cz, ( cz < 0.5f ) ? 2.0f * cz : 2.0f - 2.0f * cz, 1.0f-cz ); 
			  }
			  
			  int vindex = strip_offset + strip_index;
			  point_data.setElementAt(p,vindex);
			  color_data.setElementAt(c,vindex);
			  index_data.setElementAt( new Integer(mindex), vindex );
			  strip_index++;
			}
		  }	
		  if( in_strip ) {
			in_strip = false; 
			if( strip_index > 2 ) { 
			  strip_data.add( new Integer(strip_index) ); 
			  strip_offset += strip_index;
			}
			strip_index = 0;
		  } 	  
		}
		
		float dy = joff/scale;
		float dx = ioff/scale;
		float dz = -0.01f;
		int vindex = strip_offset;
		Point3f tp;
		Color3f c0 = new Color3f( 0.1f, 0.1f, 0.1f ); 
		strip_data.add( new Integer(4) ); 
		
		_baseQuad[0] = new Point3d(-dx,dy,dz);
		tp = new Point3f(_baseQuad[0]);
		SimIO.print( " Setting base point " + vindex + ": " + tp );
		point_data.setElementAt(tp,vindex);
		color_data.setElementAt(c0,vindex++);

		_baseQuad[1] = new Point3d(-dx,-dy,dz);
		tp = new Point3f(_baseQuad[1]);
		SimIO.print( " Setting base point " + vindex + ": " + tp );
		point_data.setElementAt(tp,vindex);
		color_data.setElementAt(c0,vindex++);

		_baseQuad[3] = new Point3d(dx,dy,dz);
		tp = new Point3f(_baseQuad[3]);
		SimIO.print( " Setting base point " + vindex + ": " + tp );
		point_data.setElementAt(tp,vindex);
		color_data.setElementAt(c0,vindex++);

		_baseQuad[2] = new Point3d(dx,-dy,dz);
		tp = new Point3f(_baseQuad[2]);
		SimIO.print( " Setting base point " + vindex + ": " + tp );
		point_data.setElementAt(tp,vindex);
		color_data.setElementAt(c0,vindex++);

		_vertexCount = point_data.size();
		_numStrips = strip_data.size();
		_total_verts += _vertexCount;
		_vertexData = new int[ _numStrips ];
		for( int i=0; i<_numStrips; i++ ) {
		  Integer ival = (Integer)strip_data.get(i);
		  _vertexData[i] = ival.intValue();
		}
		int nindices = index_data.size();
		_indexData = new int[ nindices ];
		for( int i=0; i<nindices; i++ ) {
		  Integer ival = (Integer)index_data.get(i);
		  _indexData[i] = ival.intValue();
		}
		_points = new Point3f[_vertexCount];
		_points = (Point3f[])point_data.toArray(_points);
		_colors = new Color3f[_vertexCount];
		_colors = (Color3f[])color_data.toArray(_colors);
	}


	 private  void  fillPointArray(DataEntry de, DataEntry dec, float gmax, float gmin, float cmax, float cmin) {	
		float pt[] = new float[3];
		float z, cz;
		int mindex, nPoints = _vertexCount-4;
		for(int i=0; i<nPoints; i++ ) {
			mindex = _indexData[i];			
			z = de.getNormalizedValue( mindex, gmax, gmin );
			_points[i].get(pt);
			if( z == Float.MAX_VALUE ) {
			  pt[2] = 1f;
			  _points[i].set(pt);
			  _colors[i].set( 1.0f, 1.0f, 1.0f ); 	
			} else {
			  cz = ( dec == null ) ? z : dec.getNormalizedValue( mindex, cmax, cmin );
			  pt[2] = z;
			  _points[i].set(pt);
			  _colors[i].set( cz, ( cz < 0.5f ) ? 2.0f * cz : 2.0f - 2.0f * cz, 1.0f-cz ); 	
			}		  
		}
		_total_verts += _vertexCount;		
	}
		
	private  void createSurface( DataEntry de, DataEntry dec, float gmax, float gmin, float cmax, float cmin, float time ) {
		if( _total_verts > 800000 ) { 
		  SimIO.print("Freezing Animation size to avoid memory overflow. AddImage request ignored");
		  return; 
		}
		SimIO.print( "Creating geometry- triangle strip array..." );
		
		if( _points == null ) { createPointArray( de, dec, gmax, gmin, cmax, cmin );  System.gc(); }
		else { fillPointArray( de, dec, gmax, gmin, cmax, cmin ); }
		
		int vertexFormat = GeometryArray.COORDINATES | GeometryArray.COLOR_3;
		GeometryArray ga = new TriangleStripArray( _vertexCount, vertexFormat, _vertexData );
		ga.setCapability(Geometry.ALLOW_INTERSECT);
		ga.setCapability(GeometryArray.ALLOW_COORDINATE_READ);
		ga.setCapability(GeometryArray.ALLOW_COLOR_READ);
		ga.setCoordinates( 0, _points );
		ga.setColors( 0, _colors );	
		
		if( _debug ) {
		  Point3f dbg_coord = new Point3f();
		  Color3f dbg_color = new Color3f();
		  for( int i=0; i<6; i++ ) {
			ga.getCoordinate( i,  dbg_coord );
			ga.getColor( i,  dbg_color );
			System.out.print( "\nCoordinate(" + i + "): " + dbg_coord + ",     Color: " + dbg_color );
		  }
		}
		_imageData.addElement(ga);
		_current_image = _imageData.size()-1;
		System.out.print( "done, total verts: " + _total_verts);
	}
	
    public void processPickRay ( PickRay ray, int button ) {
/*    
	  double[] dist = new double[1];
	  if( Intersect.rayAndQuad( ray, _baseQuad,  0, dist ) ) {
		Point3d ray_origin = new Point3d();
		Vector3d ray_direction = new Vector3d();
		ray.get(ray_origin, ray_direction);
		SimIO.print( "ray origon: " + ray_origin + ", direction: " +  ray_direction + ", dist: " + dist[0] );
		ray_direction.scale(dist[0]);
		SimIO.print( "ray scaled: " + ray_direction );


	  GeometryStripArray ga = (GeometryStripArray) getGeometry( -1 );
	  if( ga == null ) return;
	  double cur_dist = Double.MAX_VALUE;
	  if( _currentPickedImage != _current_image ) {
		ga.getCoordinates(0,_points);
		_currentPickedImage = _current_image;
	  }
	  int current_strip=0, current_strip_size = (_vertexData[0]-2), strip_index=0;
	  int nvert = _vertexCount-2, intersect_index = -1;
	  for( int i=0; i<nvert; i++ ) { 
		if( strip_index++ == current_strip_size ) {
		  strip_index = 0;
		  current_strip_size = (_vertexData[ ++current_strip ]-2);
		  i+=2;
		}
		if( Intersect.rayAndTriangle( ray, _points, i, dist ) ) {
		  if( dist[0] < cur_dist ) {
			cur_dist = dist[0];
			intersect_index = i;
		  }
		}
	  }
	  if( intersect_index >= 0 ) {
		Point3d ray_origin = new Point3d();
		Vector3d ray_direction = new Vector3d();
		ray.get(ray_origin, ray_direction);
		ray_direction.normalize(); ray_direction.scale(dist[0]);
		Vector3f intersect  = new Vector3f(ray_direction);
		Point3f intersection = new Point3f(ray_origin);
		intersection.add(intersect);

		float dist_to_vertex, shortest_distance = Float.MAX_VALUE;
		int closest_vertex_index = 0;
		for( int i=0; i<3; i++ ) {
		   dist_to_vertex = _points[intersect_index+i].distanceSquared(intersection);
		   if( dist_to_vertex < shortest_distance ) {
			 shortest_distance = dist_to_vertex;
			 closest_vertex_index = i;
		   }
		}
		
		double[] fcoords = new double[3];
		ray_direction.get(fcoords);
		float x = (float) -fcoords[0];
		float y = (float) -fcoords[1];
//		float z = ( button == 2 ) ? fcolors[0] : fcoords[2];
		
		SimIO.print(" Got point: ( " + x + " , " + y +  " ) " );
		if( _ddl != null ) {
		  float ioff = _data_height/2.0f, joff =_data_width/2.0f;
		  float scale = (ioff + joff)/2.0f;			
		  int xs = (int) (x*scale + ioff);
		  int ys = (int) (y*scale + joff);
		  DataEntry de = null;
		  float val;
		  if( ( button == 2 ) && ( _color_dataSet != null )  ) {
			 de = _color_dataSet.getEntry( _current_image );
			 val = _color_dataSet.getValue( ys, xs, de );
		  } else {
			 de = _altitude_dataSet.getEntry( _current_image );
			 val = _altitude_dataSet.getValue( ys, xs, de );
		  }
		  _ddl.pointSelected( ys, xs, val );
        }
	  }
*/
    }
	
	private  void createSurface( Terrain t ) {
		if( _total_verts > 800000 ) { 
		  SimIO.print("Freezing Animation size to avoid memory overflow. AddImage request ignored");
		  return; 
		}
		SimIO.print( "Creating geometry- triangle strip array..." );
		int perStripVertexCount = 2*_data_width;
		int numStrips = _data_height - 1;
		_vertexCount = perStripVertexCount * numStrips;
		_total_verts += _vertexCount;
		int vertexFormat = GeometryArray.COORDINATES | GeometryArray.COLOR_3;
		_vertexData = new int[ numStrips ];
		for( int i=0; i<numStrips; i++ ) {
		  _vertexData[i] = perStripVertexCount;
		}
		GeometryArray ga = new TriangleStripArray( _vertexCount, vertexFormat, _vertexData );
		ga.setCapability(Geometry.ALLOW_INTERSECT);
		ga.setCapability(GeometryArray.ALLOW_COORDINATE_READ);
		ga.setCapability(GeometryArray.ALLOW_COLOR_READ);
		
		float x, y, z;
		Point3f point = new Point3f(); 
		float ioff = _data_height/2.0f, joff =_data_width/2.0f;
		float scale = (ioff + joff)/2.0f;			
		int cnt = 0;
		for(int i=0; i<_data_height-1; i++ ) {	
		  for(int j=0; j<_data_width; j++ ) {
			x =  ( i-ioff )/scale;
			y =  ( j-joff )/scale;
			z = (float) t.getAltitude ( (double)i, (double)j  );
			point.set(x,y,z);
			ga.setCoordinate( cnt, point );
			ga.setColor( cnt++, t.getCurrentColor() );	
			
			x =  ( i+1-ioff )/scale;
			y =  ( j-joff )/scale;
			z = (float) t.getAltitude ( (double)(i+1), (double)j  );
			point.set(x,y,z);
			ga.setCoordinate( cnt, point );
			ga.setColor( cnt++, t.getCurrentColor() );	
		  }		  
		}
		
		if( _debug ) {
		  Point3f dbg_coord = new Point3f();
		  Color3f dbg_color = new Color3f();
		  for( int i=0; i<6; i++ ) {
			ga.getCoordinate( i,  dbg_coord );
			ga.getColor( i,  dbg_color );
			System.out.print( "\nCoordinate(" + i + "): " + dbg_coord + ",     Color: " + dbg_color );
		  }
		}
		_imageData.addElement(ga);
		_current_image = _imageData.size()-1;
		System.out.print( "done, total verts: " + _total_verts);
	}
	
    //
    // The following allows ReadRaster to be run as an application
    // as well as an applet
    //
    public static void main(String[] args) {
		int width = 100;
		int height = 150;
		int nFrames = 5;
		
		RenderRaster r = new RenderRaster( width, height, null, RenderRaster.SWITCHED ); 
		
       WindowListener l = new WindowAdapter() {
            public void windowClosing(WindowEvent e) {System.exit(0);}
            public void windowClosed(WindowEvent e) {System.exit(0);}
        };
        Frame f = new Frame("AnimationImage2D test");
        f.addWindowListener(l);        
        f.add("Center", r );
        f.setSize( new Dimension(500,500) );
        f.show();
		
		for( int i=0; i<nFrames; i++ ) {
		  TranscendentalTerrain tt = new TranscendentalTerrain( ( 12.0 + 0.2*i )/width, (12.0 - 0.2*i)/height );		
//		  FractalTerrain tt = new FractalTerrain( 5 + i , 0.6 );		
		  r.createSurface( tt );
		}
		
		r.createUniverse();
		r.runAnimation();
/*		
		for( int i=0; i<nFrames; i++ ) {
		  TranscendentalTerrain tt = new TranscendentalTerrain( (12.0 + nFrames + i)/width, (12.0 - nFrames - i)/height );		
		  r.createSurface( tt );
		}
*/
    }
 
}

/* 
	TransformGroup createRotator( BranchGroup objRoot ) {   
    		// Ceate the transform greup node and initialize it to the
		// identity.  Enable the TRANSFORM_WRITE capability so that
		// our behavior code can modify it at runtime.  Add it to the
		// root of the subgraph.
		TransformGroup newTrans = new TransformGroup();
		newTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);

		TransformGroup cubeScale = new TransformGroup();
		Transform3D t3d = new Transform3D();
		t3d.setTranslation(new Vector3d(-0.5, 0.5, 0.0));
		cubeScale.setTransform(t3d);

		cubeScale.addChild(newTrans);
		objRoot.addChild(cubeScale);

		// Create a simple shape leaf node, add it to the scene graph.
		newTrans.addChild(new ColorCube(0.3));

		// Create a new Behavior object that will perform the desired
		// operation on the specified transform object and add it into
		// the scene graph.
		Transform3D yAxis = new Transform3D();
		Alpha rotationAlpha = new Alpha(-1, Alpha.INCREASING_ENABLE,
						0, 0,
						4000, 0, 0,
						0, 0, 0);
		myRotationInterpolator rotator =
			new myRotationInterpolator(drawRaster, readRaster,
						 rotationAlpha, newTrans, yAxis,
						 0.0f, (float) Math.PI*2.0f);
		BoundingSphere bounds =
			new BoundingSphere(new Point3d(0.0,0.0,0.0), 100.0);
		rotator.setSchedulingBounds(bounds);
		newTrans.addChild(rotator);
		return newTrans;
	}
*/	

/*
class myRotationInterpolator extends RotationInterpolator {
    Point3f wPos = new Point3f(0.025f, -0.025f, 0.0f);
    Raster drawRaster;
    Raster readRaster;

    public myRotationInterpolator(Raster drawRaster, Raster readRaster,
				Alpha alpha,
				TransformGroup target,
				Transform3D axisOfRotation,
				float minimumAngle,
				float maximumAngle) {

	  super(alpha, target, axisOfRotation, minimumAngle, maximumAngle); 
		  this.drawRaster = drawRaster;
		  this.readRaster = readRaster;
    }

    public void processStimulus(Enumeration criteria) {

        ImageComponent2D newImageComponent = new ImageComponent2D(
		ImageComponent.FORMAT_RGB, readRaster.getImage().getImage());

		drawRaster.setImage(newImageComponent);
		super.processStimulus(criteria);
    }
}
*/

 /*
		  TransformGroup newTrans = null;
		  if(has_rotation) {
			newTrans = new TransformGroup();
			newTrans.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
			objRoot.addChild(newTrans);

			Transform3D yAxis = new Transform3D();
			Alpha rotationAlpha = new Alpha(-1, Alpha.INCREASING_ENABLE, 0, 0, 4000, 0, 0, 0, 0, 0);
			RotationInterpolator rotator = new RotationInterpolator(rotationAlpha, newTrans, yAxis, 0.0f, (float) Math.PI*2.0f);
			BoundingSphere bounds = new BoundingSphere(new Point3d(0.0,0.0,0.0), 100.0);
			rotator.setSchedulingBounds(bounds);
		  } else {
			Transform3D t3d = new Transform3D();
			newTrans = new TransformGroup(t3d);
		  }
		

class MorphingBehavior extends Behavior {

    Alpha alpha;
    Morph morph;
    double weights[];

    WakeupOnElapsedFrames w = new WakeupOnElapsedFrames(0);

    // Override Behavior's initialize method to setup wakeup criteria
    public void initialize() {
	alpha.setStartTime(System.currentTimeMillis());

	// Establish initial wakeup criteria
	wakeupOn(w);
    }

    // Override Behavior's stimulus method to handle the event
    public void processStimulus(Enumeration criteria) {

	// NOTE: This assumes 3 objects.  It should be generalized to
	// "n" objects.

	double val = alpha.value();
	if (val < 0.5) {
	    double a = val * 2.0;
	    weights[0] = 1.0 - a;
	    weights[1] = a;
	    weights[2] = 0.0;
	}
	else {
	    double a = (val - 0.5) * 2.0;
	    weights[0] = 0.0;
	    weights[1] = 1.0f - a;
	    weights[2] = a;
	}

	morph.setWeights(weights);

	// Set wakeup criteria for next time
	wakeupOn(w);
    }

    public MorphingBehavior(Alpha a, Morph m) {
	alpha = a;
	morph = m;
	weights = morph.getWeights();
    }
    
}


class PickVertexBehavior extends PickMouseBehavior {
  int pickMode = PickObject.USE_GEOMETRY;
  RenderRaster _raster = null;

  public PickVertexBehavior(BranchGroup root, Canvas3D canvas, Bounds bounds, RenderRaster r ){
    super(canvas, root, bounds);
    this.setSchedulingBounds(bounds);
    this.pickMode = pickMode;
    _raster = r;
  }

  public void updateScene( int xpos, int ypos ) {
    if ( mevent.isShiftDown() ) {
		PickRay ray = (PickRay) pickScene.generatePickRay( xpos, ypos );
		int button = 0;
		if( mevent.isAltDown() ) button = 1;
		else if ( mevent.isMetaDown() ) button = 2;
		_raster.processPickRay( ray, button );  
	}          
  }
}
*/
