package miiee.landscape;
import javax.vecmath.Color3f;

public class TranscendentalTerrain implements Terrain {
  private double alpha, beta;
  private double f1 = 0.0, f2 = 0.0;
  private Color3f color = new Color3f();

  public TranscendentalTerrain (double alpha, double beta) {
    this.alpha = alpha;
    this.beta = beta;
  }
  
  public double getAltitude (double i, double j) {
	f1 = Math.sin (i * alpha);
	f2 = Math.cos (j * beta);
    return .5 + .5 * f1 * f2;
  }

  public Color3f getCurrentColor() {
	color.set( (float) (.5 + .5 * f1), (float) (.5f - .5f * f2), 0.0f );
	return color;
  }

  public Color3f getColor (double i, double j) {
	color.set( (float) (.5 + .5 * Math.sin (i * alpha)), (float) (.5 - .5 * Math.cos (j * beta)), 0.0f);
	return color;
  }
}
