package miiee.mml;

import miiee.xml.*;
import miiee.util.*;
import javax.swing.*;
import org.xml.sax.Attributes;
import java.util.Vector;
import java.io.IOException;
import java.io.BufferedWriter;

public class  Atom extends MMLContainer {  
  boolean _isInput;

  public  Atom( Attributes atts )  {
	 super(atts);
	 Port p = new Port( "out", Port.kOutput ); 
	 addPort( p );	 	 
  } 
  
  public  Atom( Attributes atts, XMLContainer parent ) throws XMLException {
	 super(atts,parent);
	 Port p = new Port( "out", Port.kOutput ); 	 
	 addPort( p );	 	 
  } 
  
  public  Atom( String name )  {
	 super(name);
	 Port p = new Port( "out", Port.kOutput ); 	 
	 addPort( p );	 	 
  } 

   public String getElementType( int format ) {  return "atom"; }


  public boolean processAttribute( String name, String value, String type ) {
	boolean rv = super.processAttribute( name, value, type );
	if( name.equals("mode") ) {
	  if( value.equals("input") ) { _isInput = true; }
	  return true;
	}
	return rv;
  }

  public boolean isInput() { return _isInput; }

  public boolean isLeaf() { return _isInput; }

  public Icon getIcon() {
	if( _icon == null ) {
	  String iname = null;
	  String type = (String) getProperty("type");
	  if( _isInput ) {
		iname = "Input.gif";
	  } else if( type != null ) {
		if( type.equals("aux") ) { iname = "auxvar.gif"; }
		else if( type.equals("flux") ) { iname = "flux.gif"; }
		else if( type.equals("state") ) { iname = "statevar.gif"; }
	  }
	  if( iname == null ) { iname = "Atom.gif"; }
	  _icon  = SimIO.loadIcon( iname );
	}
	return _icon;
  } 
}
