package miiee.mml;

import miiee.xml.*;
import miiee.util.SimIO;
import javax.swing.*;
import org.xml.sax.Attributes;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import java.util.Map;

public class  Compound extends MMLContainer  {

  public  Compound( Attributes atts )  {
	 super(atts);
  }	 

  public  Compound( Attributes atts, XMLContainer parent ) throws XMLException {
	 super(atts,parent);
  }	 
  
  public  Compound( String name )  {
	 super(name);
  }	 
  
   public String getElementType( int format ) {  return "compound"; }
  
  public void writeSpecificXML( BufferedWriter out, int format )  throws IOException {  
	if( format == DECLARATION ) {
	  if( _ports != null ) {
		for( int i=0; i<_ports.size(); i++ ) {
		   Port obj = (Port) _ports.get(i);
		   obj.writeXML( out, format ); 
		}
	  }	
	} else {
	  Iterator iter = childIterator();
	  String dtd_file =  "mml";
	  while( iter.hasNext() ) {
		 XMLComponent obj = (XMLComponent) iter.next();
		 if( obj.isVisible() ) {
		   String loc = obj.getLocation();
		   if( loc != null ) {
			 String xml_file = null;
			 int li = loc.lastIndexOf('/');
			 if( li == -1 ) {
				obj.setNamespace(_namespace);
				xml_file = loc;	  
			 } else {
				obj.setNamespace( loc.substring(0,li+1) );
				xml_file =  loc.substring(li+1);
			 }
			 obj.writeXML( xml_file, dtd_file, format ); 
			 obj.writeXML( out, DECLARATION );
		   } else { 
			 obj.writeXML( out, format ); 
		   }
		 }
	  }
	  if( _links != null ) {
		for( int i=0; i<_links.size(); i++ ) {
		   Link obj = (Link) _links.get(i);
		   obj.writeXML( out, format ); 
		}
	  }
	}
  }
  
  public Link createLink( Port local_port, Port remote_port ) throws XMLException {
	SimIO.print("Creating Link: local: " + local_port + ", remote: " + remote_port );
	Atom remote_atom = null, local_atom = null;
	String remote_name = null, local_name = null;
	Compound remote_compound = null, local_compound = null;
	Link rv = null;
	try {
	  remote_atom = (Atom)remote_port.getParent();
	  remote_compound = (Compound)remote_atom.getParent();
	  remote_name = remote_atom.ID();
	} catch( ClassCastException err ) {
	  try {
		remote_compound = (Compound)remote_port.getParent();
		remote_name = remote_compound.ID();
	  } catch( ClassCastException err1 ) {
		throw new XMLException("Problem getting Container for port: " +  remote_port ); 
	  }
	}
	try {
	  local_atom = (Atom)local_port.getParent();
	  local_compound = (Compound)local_atom.getParent();
	  local_name = local_atom.ID();
	} catch( ClassCastException err ) {
	  try {
		local_compound = (Compound)local_port.getParent();
		local_name = local_compound.ID();
	  } catch( ClassCastException err1 ) {
		throw new XMLException("Problem getting Container for port: " +  remote_port ); 
	  }
	}
	if( local_port.getMode() == Port.kInput ) {
	  if( remote_port.getMode() != Port.kOutput ) {
		throw new XMLException("Must link input port to output port: " + local_port + " -> " +  remote_port ); 
	  }
	  if( remote_compound == this ) {
		rv = createInternalLink( remote_port, local_port );
	  } else {
		Port dp = getConnectedGatewayPort( local_port, remote_name );
		Port sp = remote_compound.getConnectedGatewayPort( remote_port, remote_name );
		rv = ((Compound)getParent()).createInternalLink(sp,dp);
	  }
	} else {
	  if( remote_port.getMode() != Port.kInput ) {
		throw new XMLException("Must link input port to output port: " + local_port + " -> " +  remote_port ); 
	  }
	  if( remote_compound == this ) {
		rv = createInternalLink( local_port, remote_port );
	  } else {
		Port sp = getConnectedGatewayPort( local_port, local_name );
		Port dp = remote_compound.getConnectedGatewayPort( remote_port, local_name );
		rv = ((Compound)getParent()).createInternalLink(sp,dp);
	  }
	}
	return rv;
  }
 
  public Port getConnectedGatewayPort( Port internal_port, String name ) throws XMLException {
	Atom a = null; 
	try {
	  a =  (Atom) internal_port.getParent();
	  if( a.getParent() != this ) {
		throw new XMLException("In getConnectedGatewayPort: Atom " + a + " not internal to Compound: " +  toString(), this ); 
	  }
	} catch ( ClassCastException err ) {
	  throw new XMLException("Unknown internal Port: " + internal_port + " in Compound: " +  toString(), this ); 
	} catch ( NullPointerException err ) {
	  throw new XMLException("Unknown internal Port: " + internal_port + ", parent: " + a + " in Compound: " +  toString(), this ); 
	}	
  	if( _ports != null ) {
	  for( int i=0; i<_ports.size(); i++ ) {
		 Port port = (Port) _ports.get(i);
		 if( (port != null) && (port.getMode() == internal_port.getMode()) ) {
		   if( port.getMode() == Port.kOutput ) {
			   if( port.getConnectedPort(0) == internal_port ) { return port; }
		   } else {
			 for( int iL=0; iL<port.getNOutLinks(); iL++ ) {
			   if( port.getConnectedPort(iL) == internal_port ) { return port; }
			 }
		   }
		 }
	  }
	}
	 Port gateway_port = new Port( name, internal_port.getMode() ) ;
	 addPort( gateway_port );	 	 
	 if( internal_port.getMode() == Port.kInput ) {
	   createInternalLink( gateway_port, internal_port );
	 } else {
	   createInternalLink( internal_port, gateway_port );
	 }
	 return gateway_port;
  }

  public Link createInternalLink( Port source, Port destination ) throws XMLException {
	Link link = new Link( source, destination );
	addLink(link);
	return link;
  }  
  
  public Icon getIcon() {
	if( _icon == null ) {
		_icon  = SimIO.loadIcon( "Compound.gif" );
	}
	return _icon;
  }
 
}
