package miiee.mml;

import java.awt.*;
import javax.swing.*;
import miiee.xml.*;
import miiee.util.*;
import java.io.*;
import java.util.*;
import miiee.wizard.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.util.ListIterator;
import javax.swing.border.*;
import java.awt.event.*;
import org.xml.sax.*;


public class ConfigurationHandler extends XMLHandler {

	protected static Icon _clistIcon  = null;
	protected static Icon _commandIcon  = null;
	protected static Icon _argIcon  = null;

    protected  XMLTree _configDataTree; 
    protected XMLComponent _root; 
    protected CommandList _modelList, _moduleList, _variableList;
	protected  JDialog _dialog;
	private  boolean _debug = false;
	protected XMLComponent _current_command;
    protected  Toolkit _toolkit = Toolkit.getDefaultToolkit();
	protected HashMap	_commandMap = new HashMap();

	
	public static final int kModelL = 0; 
	public static final int kModuleL = 1; 
	public static final int kVariableL = 2; 
	
	protected static final char _LevelID[] = { 'M', 'm', 'v' };

	static {
		_argIcon      = SimIO.loadIcon( "argument.gif" );
		_commandIcon      = SimIO.loadIcon( "update.gif" );
		_clistIcon      = SimIO.loadIcon( "project.gif" );
	}

	public char getCommndPrefix( int iLevel ) { return _LevelID[iLevel]; }
	
	class Command extends XMLData {	

	  public Command( String name ) { 
		super( name ); 
		_icon = _commandIcon; 
		_commandMap.put(name,this); 
	  }
	  
	  public Command( Attributes atts, XMLComponent parent )  {  
		super( atts, parent ); 
		_icon = _commandIcon; 
		_commandMap.put( this.ID(), this ); 
	  } 
	  
	  public boolean isLeaf() { return (getDataCount()==0); }
	}

	class Argument extends XMLData {	

	  public Argument( String name ) { 
		super( name ); 
		_icon = _argIcon; 
	  }
	  
	  public Argument( Attributes atts, XMLComponent parent )  {  
		super( atts, parent ); 
		_icon = _argIcon; 
	  } 
	  
	  public boolean isLeaf() { return true; }
	}

	class CommandList extends XMLData {

	  public CommandList( String name ) { super( name ); _icon = _clistIcon; }
	  public CommandList( Attributes atts, XMLComponent parent )  {  super( atts, parent );  _icon = _clistIcon;  } 
	}
    
    public ConfigurationHandler() { 
	  super(); 
	  _configDataTree = new XMLTree( getTreeRoot(), XMLTree.kIsDataTree );
	}

	public XMLTreeModel getTreeModel() { return (XMLTreeModel)  _configDataTree.getModel(); }
	
	public XMLComponent getSelectedCommand() { return _current_command; }
	public  String selectedCommand() { return _current_command.toString(); }
	
	public XMLComponent getCommand( int level, String name ) { 
	  return (XMLComponent) _commandMap.get(  getCommandID( name ) + '.' + getCommndPrefix( level ) );
	}

	public String getCommandID( String name ) {
	  int loc = name.indexOf('.'); 
	  return ( loc > 0 ) ? name.substring(0,loc) : name;
	}
			  
   private  void destroy() { ; }

   private  void dispose() { 
	 if( _dialog != null ) { _dialog.setVisible(false); _dialog.dispose(); }
	  _dialog = null; 
   }

   public  boolean showTreeView( int level, boolean isModal ) {
	  dispose(); 
	  _current_command = null;
	  JFrame frame = new JFrame("Configurations Handler");
	  _dialog = new JDialog( frame, "Configurations Handler", isModal );
	
	  WindowListener l = new WindowAdapter() {
		  public void windowClosing(WindowEvent e) { destroy(); }
		  public void windowOpened(WindowEvent e) { _configDataTree.expandAll(); }
	  };
	  _dialog.addWindowListener(l);
	  Border loweredBorder = BorderFactory.createLoweredBevelBorder();
	  
	  JPanel c = new JPanel();
	  _dialog.setContentPane( c );
	  c.setLayout(new BorderLayout());
	  Box main_panel = Box.createVerticalBox();

	  JTextArea ta = new JTextArea(100,150);
	  ta.setMargin( new Insets( 4, 4, 4, 4 ) ); 
	  ta.setWrapStyleWord(true);
	  ta.setLineWrap(true);
	  ta.setBackground( new Color(0, 0, 200) );
	  ta.setForeground( Color.yellow );
	  
	  JScrollPane scrollpane1 = new JScrollPane();
	  scrollpane1.getViewport().setView(ta);
	  scrollpane1.setPreferredSize(new Dimension( 300, 100 ));
	  scrollpane1.setBorder( loweredBorder );
	  main_panel.add(scrollpane1);

	  switch(level) {
		case kVariableL: 
		  if( _variableList != null ) _configDataTree.setRoot( _variableList ); 
		break;
		case kModuleL: 
		  if( _moduleList != null ) _configDataTree.setRoot( _moduleList ); 
		break;
		case kModelL: 
		  if( _modelList != null ) _configDataTree.setRoot( _modelList ); 
		break;
		case -1: 
		  _configDataTree.setRoot( getTreeRoot() ); 		
		break; 
	  }
	  _configDataTree.addTreeSelectionListener( new ConfigDocListener(ta) );	  
	  main_panel.add( _configDataTree.getDisplayPanel() );

	  JToolBar toolbar = new JToolBar();
	  c.add( "North", toolbar );				
	  c.add( "Center", main_panel );
	  
	  AbstractAction selectAction = new AbstractAction( null, getIcon("select.gif") ) {
		public void actionPerformed(ActionEvent e) {
		  XMLComponent comp = _configDataTree.getSelectedNode(); 
		  if( comp != null && Command.class.isInstance(comp) ) {
			System.out.println("Selected node: " + comp.ID() );
			_current_command = comp;
			dispose();
		  } else {
			XMLException.show_error( _dialog, "Must select a Command." );
		  }
		}
	  }; 
	  
	  AbstractAction closeAction = new AbstractAction() {
		public void actionPerformed(ActionEvent e) {
		  if( XMLException.show_confirm( _dialog, "Are you sure you want to close the Configuration Manager?" ) ) {
			dispose();
		  }
		}
	  }; 

	  toolbar.add ( createToolbarButton( "select.gif", "Select a Command", "select", selectAction )); 
	  toolbar.add ( createToolbarButton( "close.gif", "Close Configuration Manager", "close", closeAction ));
	  
	  if( isModal ) {
		  JPanel   buttonsPanel = new JPanel(false);
		  buttonsPanel.setLayout(new FlowLayout());
		  JButton aButton;

		  aButton = new JButton("select");
		  aButton.addActionListener( selectAction );
		  buttonsPanel.add( aButton );

		  aButton = new JButton("close");
		  aButton.addActionListener( closeAction );
		  buttonsPanel.add( aButton );	  
		  main_panel.add(buttonsPanel);
	  }

	  _dialog.setJMenuBar( constructMenuBar() );
	  _dialog.setSize(550,650);
	  
	  Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
	  int x = (screenDim.width - _dialog.getSize().width) / 2;
	  int y = (screenDim.height - _dialog.getSize().height) / 2;
	  _dialog.setLocation(x, y);	   
	  _dialog.setVisible(true);
	  return (_current_command != null);
   }
   
    private  JMenuBar constructMenuBar() {
	  JMenu            menu;
	  JMenuBar         menuBar = new JMenuBar();
	  JMenuItem        menuItem;

	  menu = new JMenu("File");
	  menuBar.add(menu);

	  menuItem = menu.add(new JMenuItem("read"));
	  menuItem = menu.add(new JMenuItem("write"));
	  menuItem = menu.add(new JMenuItem("close"));

	  menu = new JMenu("Help");
	  menuBar.add(menu);

	  menuItem = menu.add(new JMenuItem("Help Browser"));
	  menuItem.addActionListener( new ActionListener() {
		public void actionPerformed(ActionEvent e) {;}
	  }  );

	  return menuBar;
    }
 
     protected JButton createToolbarButton( String icon, String tooltip, String actionCommand, Action a ) {
		JButton b = new JButton( getIcon(icon) ) {
				public float getAlignmentY() { return 0.5f; }
		};
		b.setRequestFocusEnabled(false);
		b.setMargin(new Insets(1,1,1,1));
		b.setToolTipText(tooltip);
		b.setActionCommand(actionCommand);
		b.addActionListener(a);
        return b;
    }  
     
  public XMLComponent getComponentFromName( String name, Attributes atts, XMLComponent parent, boolean create ) {
	XMLData rv = null;
	if( name.equals("command-list") ) {
	  rv = new CommandList( atts, parent );
	  rv.unresolve();
	  String type = (String) rv.getProperty("type");
	  if( type != null ) {
		if( type.equals("model") ) {
		  if( _modelList == null ) { _modelList = (CommandList)rv; }
		} else if ( type.equals("module") ) {
		  if( _moduleList == null ) { _moduleList = (CommandList)rv; }
		} else if ( type.equals("variable") ) {
		  if( _variableList == null ) { _variableList = (CommandList)rv; }
		}
	  }
	}
	else if( name.equals("command") ) {
	  rv = new Command( atts, parent );
	}
	else if( name.equals("argument") ) {
	  rv = new Argument( atts, parent );
	}
	if( _debug ) { System.out.println( " getComponentFromName: " + name + " -> " + rv ); }
	if( rv != null ) { 
	  rv.stampComponent(); 
	}
	return rv; 
  }


     
  public void readXML( String list_name ) { 
	String path = SimIO.getXMLUsrDirectory();
	String defaults_file = path + list_name + ".config.xml";
	String resource = "workspace/config/" + list_name + ".config.xml"; 
	System.out.println("Reading configuations file: " + defaults_file + ", resource = " + resource );
	read( defaults_file, null, null, XMLComponent.DEFINITION, null, resource  );
  }
  
  public void readRemoteXML( String location ) { 
	System.out.println("Reading workspace file: " + location  );
	read( location, null, null, XMLComponent.DEFINITION, null );
  }
	
  public void writeXML( String name ) { 
 	String xml_file =  name + ".config";	    
 	String dtd_file = "config";
 	getTreeRoot().writeXML( xml_file, dtd_file, XMLComponent.DEFINITION );	  
  }
 
   public static void main(String args[]) {
   
	  if (args.length < 1) {
		  System.err.println ("Usage: miiee.mml.ConfigurationHandler <config-list_name>");
		  System.exit (1);
	  }
	  
	  ConfigurationHandler ph = new ConfigurationHandler();
	  ph.readXML( args[0] );
	  ph.showTreeView(-1,false);
  }
 
}

class ConfigDocListener extends Object implements TreeSelectionListener {
  JTextArea _text;
  ConfigDocListener( JTextArea ta ) {
	_text = ta;
  }
  public void valueChanged(TreeSelectionEvent e) {
	try {
	  XMLComponent doc = (XMLComponent)e.getPath().getLastPathComponent();
	  _text.setText( (String) doc.getProperty("doc") );
	} catch ( ClassCastException err ) { 
	  _text.setText("");
	} 
  }
  
}
