package miiee.mml;

import miiee.xml.*;
import miiee.util.AttributeValuePair;
import miiee.util.SimIO;
import javax.swing.border.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*; 
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
import java.io.BufferedWriter;
import java.io.IOException;
import org.xml.sax.Attributes;
import miiee.util.SimIO;

public class  Dynamic extends XMLComponent {
   
  public  Dynamic( Attributes atts )  {
	 super(atts);
  }

  public  Dynamic( Attributes atts, XMLContainer parent ) throws XMLException {
	 super(atts,parent);
  }
  
  public  Dynamic( String name )  {
	 super(name);
  }
  
   public String getElementType( int format ) {  return "dynamic"; }

  public String toString() {
	return (String) _properties.get( "event" );
  } 

  public String ID() {
	return (String) _properties.get( "event" );
  } 
    
  public boolean isLeaf() { return true; }

  public Icon getIcon() {
	if( _icon == null ) {
		_icon  = SimIO.loadIcon( "Dynamic.gif" );
	}
	return _icon;
  }
  
  public void edit( Component parent_component, XMLContainer root ) {
	EquationEditor ee = new EquationEditor( "Equation Editor: " + ID(), this, root );
	ee.display(parent_component);
  }	
  
  public void setCode( String new_code ) {
	try {
	  setProperty( "code", new_code );
	  System.out.println("Setting New Code: " + new_code );
	} catch ( XMLException err ) {
	  SimIO.show_error( null, "Dynamic::setCode:", err ) ;
	}
  } 
  
  public String getCode() {
	return (String) _properties.get( "code" );
  } 
}

class EquationEditor {

  JDialog _dialog;
  String _result;
  Dynamic _dynamic;
  XMLContainer _root;
  JTextPane _textPane = new JTextPane();
  PropertyTable _ports = PropertyTable.getTablePanel( 150, 325 );
  
  public static final KeyStroke INSERT_PORT_KS = KeyStroke.getKeyStroke( KeyEvent.VK_P, InputEvent.CTRL_MASK );
  public static final KeyStroke DELETE_PORT_KS = KeyStroke.getKeyStroke( KeyEvent.VK_K, InputEvent.CTRL_MASK );
  public static final KeyStroke ADD_PORT_KS = KeyStroke.getKeyStroke( KeyEvent.VK_N, InputEvent.CTRL_MASK );
	
  public EquationEditor( String title, Dynamic d, XMLContainer root ) {
	_dialog = new JDialog( (Frame)null, title, false );
	_dynamic = d;
	_root = root;
  }

  
  String getResult() { return _result; }

  class InsertSelectedPortAction  extends AbstractAction   {
	public InsertSelectedPortAction() { super("Insert in code",null); }
	public void actionPerformed( ActionEvent e ) { insertSelectedPort(); }
  } 

  class DeleteSelectedPortAction  extends AbstractAction   {
	public DeleteSelectedPortAction() { super("Delete",null); }
	public void actionPerformed( ActionEvent e ) { deleteSelectedPort(); }
  } 

  class AddPortAction  extends AbstractAction   {
	public AddPortAction() { super("Add",null); }
	public void actionPerformed( ActionEvent e ) { addPort(); }
  } 
  
  public void display( Component parent ) {
	_result = _dynamic.getCode();
	Container c = _dialog.getContentPane();     

	JPanel   buttonsPanel = new JPanel(false);
	buttonsPanel.setLayout(new FlowLayout());
	JButton aButton;

	aButton = new JButton("set");
	aButton.addActionListener( new ActionListener() {
		public void actionPerformed(ActionEvent e) { 
		  _result = _textPane.getText(); 
		  _dynamic.setCode( _result );
		  _dialog.dispose();
		}
	});
	buttonsPanel.add( aButton );

	aButton = new JButton("revert");
	aButton.addActionListener( new ActionListener() {
	  public void actionPerformed(ActionEvent e) { 
		if( _result != null ) {
		  _textPane.setText(_result); 
		}
	  }
	}  );
	buttonsPanel.add( aButton );

	aButton = new JButton("clear");
	aButton.addActionListener( new ActionListener() {
	  public void actionPerformed(ActionEvent e) { 
		_textPane.setText(""); 
	  }
	}  );
	buttonsPanel.add( aButton );

	aButton = new JButton("edit doc");
	aButton.addActionListener( new ActionListener() {
	  public void actionPerformed(ActionEvent e) { 
		_dynamic.editProperty("doc");
	  }
	}  );
	buttonsPanel.add( aButton );
	
	aButton = new JButton("cancel");
	aButton.addActionListener( new ActionListener() {
	  public void actionPerformed(ActionEvent e) { _dialog.dispose(); }
	}  );
	buttonsPanel.add( aButton );

	if( _result != null ) {
	  _textPane.setText(_result);
	}

	Keymap eqn_km = JTextComponent.addKeymap( "equation_km", _textPane.getKeymap() );
	_textPane.setKeymap(eqn_km);
	
	eqn_km.addActionForKeyStroke(  INSERT_PORT_KS, 
								   new InsertSelectedPortAction()	 );  

	EmptyBorder eb5 = new EmptyBorder( 5, 5, 5, 5 );
	Border bb = BorderFactory.createCompoundBorder( eb5, BorderFactory.createLoweredBevelBorder() );
	JScrollPane scrollpane1 = new JScrollPane();
	scrollpane1.getViewport().setView(_textPane);
	scrollpane1.setMinimumSize(new Dimension(200, 200 )); 
	scrollpane1.setPreferredSize(new Dimension(500, 200 )); 
	scrollpane1.setBorder( bb );

	_ports.setHeaders("Ports","Links");	
	JScrollPane scrollpane2 = new JScrollPane();
	scrollpane2.getViewport().setView(_ports);
	scrollpane2.setMinimumSize(new Dimension(200, 80 )); 
	scrollpane2.setPreferredSize(new Dimension(500, 120 )); 
	scrollpane2.setBorder( bb );
//	_ports.addMouseListener(this);
//	_ports.addKeyListener(this);

	MMLContainer atom = getMMLContainer();
	if( atom != null ) {
	  Vector ports = atom.getPortStrings( true, false, Port.kInput );
	  Vector links = atom.getPortStrings( false, true, Port.kInput );
	  _ports.setProperties( ports, links );
	}
	
	c.add( "North", buttonsPanel );				
	c.add( "Center", scrollpane1 );
	c.add( "South", scrollpane2 );
	_dialog.setJMenuBar( constructMenuBar() );
	
	_dialog.pack();
	_dialog.setLocationRelativeTo(c);
	_dialog.show();	  	  
  }
  
  public MMLContainer getMMLContainer() { return (MMLContainer) ((_dynamic == null ) ? null : _dynamic.getParent()); }
    
  public void addPort() {
	  PortFinder pf = new PortFinder( _root, _dynamic );
	  Port p = pf.display( _dialog.getContentPane() );
	  if( p != null ) {
		SimIO.print(" Got port " + p  );
		MMLContainer atom = getMMLContainer();
		if( atom != null ) {
		  SimIO.print("Adding port to Atom " + atom );
		  atom.addPort(p);
		  _ports.addProperty( p.ID(), p.getConnectedPortString( true ), true );
		} else {
		  SimIO.beep();
		}
	  }
  }
/*  
  public void mouseClicked(MouseEvent e) {
	if( e.getClickCount() > 1 ) { SimIO.print(" Got mouse click. "  ); insertSelectedPort(); }
  }
  public void mousePressed(MouseEvent e) {;}
  public void mouseReleased(MouseEvent e) {;}
  public void mouseEntered(MouseEvent e) {;}
  public void mouseExited(MouseEvent e) {;}

  public void keyTyped(KeyEvent e) {
	  char kc = e.getKeyChar();
	  if(kc == 'i' && e.isControlDown() ) { SimIO.print(" <Ctrl>-i "  ); insertSelectedPort(); }
  }

  public void keyPressed(KeyEvent keyevent) {;}
  public void keyReleased(KeyEvent keyevent) {;}
*/  

   private JMenuBar constructMenuBar() {
	JMenu            menu;
	JMenuBar         menuBar = new JMenuBar();
	JMenuItem        menuItem;

	menu = new JMenu("Ports");
	menu.setBackground(Color.lightGray);
	menuBar.add(menu);
	
	menuItem = menu.add(new JMenuItem("add"));
	menuItem.addActionListener( new AddPortAction() );
	menuItem.setAccelerator( ADD_PORT_KS );

	menuItem = menu.add(new JMenuItem("delete"));
	menuItem.addActionListener( new DeleteSelectedPortAction() );
	menuItem.setAccelerator( DELETE_PORT_KS );

	menuItem = menu.add(new JMenuItem("insert in code"));
	menuItem.addActionListener( new InsertSelectedPortAction() );
	menuItem.setAccelerator( INSERT_PORT_KS );
	    
	return menuBar;
  }
  
  void insertSelectedPort() {
	String port = (String) _ports.getSelectedObject( 0 );
	SimIO.print(" Inserting port: "  + port ); 
	if( (port == null) || port.equals("") ) {
	   SimIO.show_warning( _dialog.getContentPane(), "Must select a Port from the Port/Link table." );
	} else {
	  _textPane.replaceSelection(port);
	}
  }
  
  void deleteSelectedPort() {
	String port = _ports.deleteSelectedProperty();
	MMLContainer c = getMMLContainer();
	Port p = c.removePort(port); 
	if( p != null ) {
	  SimIO.print(" Deleting port: "  + port ); 
	} else {
	  SimIO.show_warning( null, " Can't find port: "  + port ); 
	}
  }
}


class PortFinder extends XMLTree implements TreeSelectionListener {

  JDialog _dialog = new JDialog( (Frame)null, "Add Port", true );
  Dynamic _dynamic; 
  AttributeValuePair _port_name =  AttributeValuePair.New( "Port Name", true, 50 );
  boolean _node_selected = false;
  Port _port;

  public PortFinder( XMLContainer root, Dynamic d ) { 
	super( root ); 
	addTreeSelectionListener(this);
	_dynamic = d;
  }

  public void dispose() {;}
  
  public void getSelection() {
	try {
	  Atom origin = null;
	  if( _node_selected ) {
		try {
		  origin = (Atom) getSelectedComponent();
		} catch ( ClassCastException err ) {
		  SimIO.show_error(null,"Must Select an Atom:\n",err);
		}
		if( origin != null ) {
		// Connect port.
		  Atom atom = (Atom) _dynamic.getParent();
		  Compound c = (Compound) atom.getParent();
		  _port = new Port( _port_name.getValue(), Port.kInput );
		  atom.addPort(_port);
		  c.createLink( _port, origin.getOutputPort() );
		}
	  }
	} catch ( XMLException err ) {
	  SimIO.show_error(null,"Error Linking Ports:\n",err);
	}
  }
  
  public void valueChanged(TreeSelectionEvent e) {
	try {
	  XMLComponent c = (XMLComponent)(e.getPath().getLastPathComponent());
	  _port_name.setValue( c.ID() );
	  _node_selected = true;
	} catch ( ClassCastException err ) { SimIO.beep(); clearSelection(); } 
  }
  
  public Port display( Container parent ) {
	WindowListener l = new WindowAdapter() {
		public void windowClosing(WindowEvent e) { dispose(); }
	};
	_dialog.addWindowListener(l);

	Container c = _dialog.getContentPane();     
	c.setLayout(new BorderLayout());

	JPanel   buttonsPanel = new JPanel(false);
	buttonsPanel.setLayout(new FlowLayout());

	JButton aButton = new JButton("create");
	aButton.addActionListener( new ActionListener() {
		public void actionPerformed(ActionEvent e) { 
		  getSelection();  
		  _dialog.dispose(); 
		}
	});
	buttonsPanel.add( aButton );

	aButton = new JButton("cancel");
	aButton.addActionListener( new ActionListener() {
	  public void actionPerformed(ActionEvent e) {  
		 _dialog.dispose(); 
	  }
	}  );
	buttonsPanel.add( aButton );

	JPanel pV0  = new JPanel(true);
	BoxLayout bl = new BoxLayout(pV0, BoxLayout.Y_AXIS );  pV0.setLayout( bl ); 	   

	JPanel pV  = getDisplayPanel();
	pV.setPreferredSize(new Dimension(400,400)); 
	pV0.add(pV);	
	pV0.add(_port_name);

	c.add( "North", buttonsPanel );				
	c.add( "Center", pV0 );
	expandRow(1);
	
	_dialog.pack();
	_dialog.setLocationRelativeTo(parent);
	_dialog.show();	
	return _port;  
 }
}
