package miiee.mml;

import miiee.xml.*;
import java.util.HashMap;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;

public class  DynamicList extends Object {

  HashMap _dynamics = new HashMap(11);

  public  DynamicList(  )  { super(); }	

  public boolean add( String eventName, Dynamic d  ) {
	if( _dynamics.containsKey(eventName) ) return false; 
	synchronized ( _dynamics ) { _dynamics.put( eventName, d ); }
	return true;
  }

  public boolean add( Dynamic d ) throws XMLException {
	String eventName = (String) d.getProperty("event");
	if( eventName == null ) {
	  String name = (String) d.getProperty("name");
	  if( name == null ) name = "(nameless)";
	  throw new XMLException( "Event undefined for Dynamic: " + name );
	}
	return add( eventName, d );
  }
 
  public Dynamic get( String eventName ) {
	return (Dynamic) _dynamics.get(eventName);
  }

  public Iterator iterator() { return _dynamics.values().iterator(); }
  public int size() { return _dynamics.size(); } 

  public Iterator entryIterator() { 
	Iterator iter;
	synchronized ( _dynamics ) { iter = _dynamics.entrySet().iterator(); }
	return iter; 
  }
  
  public void writeXML( BufferedWriter out, int format )  throws IOException {
	  Iterator iter = iterator();
	  while( iter.hasNext() ) {
		Dynamic d = (Dynamic) iter.next();
		d.writeXML( out, format );
	  }  
  }
 
}
