package miiee.mml;
import java.beans.beancontext.BeanContextChildSupport;
import miiee.xml.*;
import java.io.BufferedWriter;
import java.io.IOException;
import org.xml.sax.Attributes;

public class  Link  extends XMLComponent {

  Port _source;
  Port _destination;
  
  public  Link( Attributes atts )  {
	 super(atts);
  }

  public  Link( Port source, Port destination, String id  ) throws XMLException  {
	 super(id);
	 setOrigin(source);
	 setDestination(destination);
  }

  public  Link( Port source, Port destination ) throws XMLException  {
	 super();
	 setOrigin(source);
	 setDestination(destination);
  }

   public String getElementType( int format ) {  return "link"; }
 
  public void writeXML( BufferedWriter out, int format )  throws IOException { 
	out.newLine(); 
	out.write("\t\t<link ");
	_properties.writeXML( out, PropertyList.kAttributes );
	out.write(" />");
  }

  public String toString() {
	String id = (String) _properties.get( "name" );
	if( id == null ) { 
	  String origin = (String) _properties.get( "origin" ); 
	  String destination = (String) _properties.get( "destination" ); 
	  id = origin + "->" + destination; 
	  try { setProperty( "id" , id ); } 
	  catch ( XMLException err ) { ;}
	}
	return id;
  } 
  
  public String ID() { return toString(); }
  
  public Port getOrigin() { return _source; }
  public Port getDestination() { return _destination; }

  public void setOrigin( Port obj ) { 
	_source = obj; 
	obj.addOutLink(this);
	try {
	  setProperty( "origin" , obj.name() );
	} catch(XMLException err) { ; } 
  }
  
  public void setDestination( Port obj ) throws XMLException { 
	_destination = obj;  
	obj.setInLink(this); 
	try {
	  setProperty( "destination" , obj.name() ); 
	} catch(XMLException err) { ; } 
  }
  
  public boolean connected() { return ((_source != null) && (_destination != null)); } 
	  
}
