package miiee.mml;
import miiee.xml.*;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Vector;
import java.util.Comparator;
import org.xml.sax.Attributes;


//---- MMLComponent ---------------------------------------------------------

public class MMLComponent extends XMLComponent {
 
  protected Vector _data;
  protected MMLComponent _peer;
  protected int _mode = -1;

  public  MMLComponent( String id )  {
	 super(id);
  }	 

  public  MMLComponent( String property, String value )  {
	 super(property,value);
  }	 

  public  MMLComponent( Attributes atts )  {
	 super(atts);
  }	 

  public  MMLComponent( Attributes atts, MMLComponent peer )  {
	 super(atts);
	 _peer = peer;
  }	

  public void setPeer( MMLComponent peer ) { _peer = peer; }
    
  public int getMode() { return _mode; }
     
  public void writeXML( BufferedWriter out, int format )  throws IOException { 
  
	if( getElementType( format ) == null ) {
	
	  writeSpecificXML( out, format );
  
	} else {
	  out.newLine(); 
	  out.write("\t\t<" + getElementType(format) );
	  _properties.writeXML( out, PropertyList.kAttributes );
	  out.write(" >");
	  out.newLine();
	  _properties.writeXML( out, PropertyList.kProperties );

	  writeSpecificXML( out, format );	
	  out.newLine();

	  if( _data != null ) {
		for( int i=0; i<_data.size(); i++ ) {
		   Data obj = (Data) _data.get(i);
		   obj.writeXML( out, format ); 
		}
	  }
	  out.newLine();
	  out.write("\t\t</" + getElementType(format) + "> ");
	}
  }
  
  public void writeSpecificXML( BufferedWriter out, int format )  throws IOException {;}
  
}
