package miiee.mml;

import miiee.xml.*;
import miiee.util.*;
import org.xml.sax.Attributes;
import java.util.Vector;
import java.io.IOException;
import java.util.Set;
import java.util.Map;
import java.util.TreeMap;
import java.util.Iterator;
import java.io.BufferedWriter;
import java.util.StringTokenizer;
import java.util.NoSuchElementException;

public class  MMLContainer extends XMLContainer {
  protected Vector _ports;
  protected Vector _links;
  protected MMLContainer _peer;
  private int _debug = 0;

  public static final int kOrigin = 0;
  public static final int kDestination = 1;

  public  MMLContainer( Attributes atts )  {
	 super(atts);
  }  
  public  MMLContainer( Attributes atts, XMLContainer parent ) throws XMLException {
	 super(atts,parent);
  }  

  public  MMLContainer( String id )  {
	 super(id);
  }  
  
  public void setPeer( MMLContainer peer ) { _peer = peer; }
  
  public void addPort( Port port ) {
	if( port.getMode() < 0 ) {
	  System.out.println("Attempt to add port " + port + " of undefined type to Container " + toString() );
	  System.exit(1);;
	}
	if( _ports == null ) { _ports = new Vector(8,8); }
	try {
	  getLocalPort( port.ID(), port.getMode() );
	} catch ( XMLException err ) {   
	  _ports.add(port);
	  port.setParent(this);
	}
  }

  public Vector getPortStrings(  boolean useID, boolean getConnections ) { 
	return getPortStrings(  useID, getConnections, -1 ); 
  }

  public Vector getPortStrings(  boolean useID, boolean getConnections, int type ) {
	Vector rv = null;
  	if( _ports != null ) {
	  rv = new Vector( _ports.size() );
	  for( int i=0; i<_ports.size(); i++ ) {
		 Port port = (Port) _ports.get(i);
		 if( ( type < 0 ) || ( port.getMode() == type ) )  { 
		   if( port == null ) rv.add("");
		   else if( getConnections ) { rv.add( port.getConnectedPortString(useID) ); }
		   else {
			 rv.add( useID ? port.ID() : port.toString() );
		   }
		 }
	  }
	}
	return rv;
  }

  public Vector getPorts( boolean useID ) { return _ports; }

  public void dumpPorts() {
	System.out.print( "\nPort dump for " + toString() + ":" ); 
  	if( _ports != null ) {
	  for( int i=0; i<_ports.size(); i++ ) {
		 Port port = (Port) _ports.get(i);
		 if( port != null ) {
		   String type = (port.getMode() == Port.kInput) ? "input" : "output";
		   System.out.print( "\n\t\t" + type + " " + port.ID() + " type = " + port.getMode() );
		 }
	  }
	}
  }
    
  public Port getPort( String identifier, int type ) throws XMLException {
	StringTokenizer st = new StringTokenizer(identifier, "." );
	String container_id=null, port_id=null;
 	try {
		container_id = st.nextToken();
		port_id = st.nextToken();
	} catch( NoSuchElementException err ) {
	  throw new XMLException("Missing spec in Link identifier: " + identifier ); 
	}
	Port p = null;
	switch( type ) {
	  case kOrigin: {
		if( container_id.equals("this") || container_id.equals(ID()) ) {
		  p = getLocalPort( port_id, Port.kInput );
		} else {
		  p = getLocalPort( container_id, port_id, Port.kOutput );
		}
	  } break;
	  case kDestination: 
		if( container_id.equals("this") || container_id.equals(ID()) ) {
		  p = getLocalPort( port_id, Port.kOutput );
		} else {
		  p = getLocalPort( container_id, port_id, Port.kInput );
		}
	  break;
	  default:
		throw new XMLException("Unknown Port type in " + toString()  + " .etPort(): " +  type ); 
	}	  
	return p;
  }

   
  public Port getLocalPort( String port_id, int mode ) throws XMLException {  	
  	if( _ports != null ) {
	  for( int i=0; i<_ports.size(); i++ ) {
		 Port port = (Port) _ports.get(i);
		 if( (port != null) && (port.getMode() == mode) ) {
		   if( port.ID().equals( port_id ) ) { return port; }
		 }
	  }
	}

	if( mode == Port.kInput ) {
	  throw new XMLException("Unknown input Port: " + port_id + " in Container: " +  toString(), this ); 
	} else {
	  throw new XMLException("Unknown output Port: " + port_id + " in Container: " +  toString(), this ); 
	}
  }

  public Port getOutputPort() { 
	Port rv = null; 	
  	if( _ports != null ) {
	  for( int i=0; i<_ports.size(); i++ ) {
		 Port port = (Port) _ports.get(i);
		 if( (port != null) && (port.getMode() ==  Port.kOutput ) ) { 
		   if( rv == null ) {
			 rv = port; 
		   } else {
			 SimIO.print("Multiple output ports found in getOutputPort for " + ID() );
		   }
		 }
	  }
	}
	return rv;
  }
  
  public Port getLocalPort( Port p ) throws  XMLException {  	
  	if( (_ports != null) && ( p != null ) ) { 
	  for( int i=0; i<_ports.size(); i++ ) {
		 Port port = (Port) _ports.get(i);
		 if( port == p ) { return port; }
	  }
	}
	String port_id = (p==null) ? "null" : p.ID();
	throw new XMLException("Unknown Port: " + port_id + " in Container: " +  toString(), this ); 
  }

  public Port removePort( String port_id  ) { 
  	if( _ports != null ) {
	  for( int i=0; i<_ports.size(); i++ ) {
		 Port port = (Port) _ports.get(i);
		 if( port.ID().equals( port_id ) ) { 
		   _ports.remove(i);
		   return port;
		 }
	  }
	}
	return null;
  }

  public Port getLocalPort( String container_id, String port_id, int mode ) throws XMLException {
	MMLContainer container =  (MMLContainer) getChild( container_id );
	if( container == null ) {
	  throw new XMLException("Unknown Child: " + container_id + " in Container: " +  toString() ); 
	}
	return container.getLocalPort( port_id, mode );
  }

  public void addLink( Link obj ) throws XMLException {
	if( _links == null ) { _links = new Vector(8,8); }
	else if( _links.contains(obj) ) { 
	  throw new XMLException("Link object " + obj.toString() + " already exists in Compound " + toString() ); 
	}
	_links.add(obj);
	obj.setParent(this);
	if( resolved() ) { resolveLink(obj); }
  }
  

  public void resolve() {  
	super.resolve();
	resolveLinks();
  }
  
  public void resolveLinks() {
	if( _links != null ) {
	  if( _debug > 0 ) {
		System.out.println("Resolving links for " + toString()  );
	  }
	  for( int i=0; i<_links.size(); i++ ) {
		resolveLink( (Link)_links.get(i) );
	  }
	}
  }

  public boolean resolveLink( Link link ) {
	if( link.connected() ) return false;
	String origin = (String) link.getProperty("origin");
	String destination = (String) link.getProperty("destination");
	try {
	  Port p0 = getPort(origin, MMLContainer.kOrigin);
	  Port p1 = getPort(destination, MMLContainer.kDestination);
	  if( _debug > 0 ) {
		System.out.println("\t\t" + p0 + " -> " + p1 );
	  }
	  link.setOrigin( p0  );
	  link.setDestination( p1  );
	} catch ( XMLException err ) {
	  System.out.println( err.getMessage() );
	  if( err.getComponent() != null ) { ((MMLContainer)(err.getComponent())).dumpPorts(); }
	  System.exit(1);
	  return false;
	}
	return true;
  }
      
  public Vector getLinks() { return _links; }  
  public Iterator getLinkIterator() { return _links.iterator(); }
     
  public void writeSpecificXML( BufferedWriter out, int format )  throws IOException {  
  	if( _ports != null ) {
	  for( int i=0; i<_ports.size(); i++ ) {
		 Port obj = (Port) _ports.get(i);
		 obj.writeXML( out, format ); 
	  }
	}
	super.writeSpecificXML( out,format );
  }
  
}
