package miiee.mml;

import java.util.*;
import java.io.*;

//---- MMLExecutableFactory ---------------------------------------------------------

public class MMLExecutableFactory extends Object {

	StringBuffer _sbuff = new StringBuffer();
	byte[] _display_buff = new byte[201];
	static Runtime _runtime;
	String _classDir = "/tmp/";
	static String _buildExScript;
	ExecutableClassLoader _classLoader = new ExecutableClassLoader(_classDir);
	InputStream _stdout;
	InputStream _stderr;
	boolean _debug = true;
	
	static {
        _runtime =  Runtime.getRuntime();
        _buildExScript = System.getProperty("LIBDIR") + "/../../bin/build_executable ";
	}

	public MMLExecutableFactory() { ; }
	
	public MMLExecutable createExecutable( String name, String source ) {

	  String src_file = _classDir + name + ".java";
	  if( _debug ) {	
		System.out.println( "Writing to src file: "  + src_file );
	  }
	  try {  
		FileOutputStream os =  new FileOutputStream( src_file ); 
		BufferedWriter out = new BufferedWriter(new OutputStreamWriter(os));
		out.write("import miiee.mml.*;" ); out.newLine(); 
		out.write("import miiee.util.*;" ); out.newLine(); 
		out.write("import java.util.*;" ); out.newLine(); 
		out.newLine(); 
		out.write("public class " + name + " extends MMLExecutable {" ); out.newLine(); 
		out.write("\t\tpublic int execute( Vector args ) { "); out.newLine(); 
		out.write( source ); out.newLine(); 
		out.write("\t\t\treturn 0;\n\t\t}"); out.newLine(); 
		out.write("}");     out.newLine();
		out.close();	
	  } catch ( Exception err ) {
		  System.out.print( "Unable to write to src file " + src_file + " : " + err.getMessage() );
		  return null;
	  }  
	 
	  Process p = null;
	  MMLExecutable rv = null;
	  try {
		 p = _runtime.exec( _buildExScript + name ); 
		 _stdout = p. getInputStream();
		 _stderr = p. getErrorStream();
		 p.waitFor();
	  } catch ( Exception err ) { 
		System.out.println( "Error running java compilation script: "  + err.getMessage() );
	  }	  
	  if( p == null ) { return null; }
	  displayStream(_stdout);
	  displayStream(_stderr);

	  int ev = p.exitValue();
	  
	  if( ev == 0 ) {
	  
		if( _debug ) {	
		   System.out.println("Compiled class file  " + name + ".class" );
		}
		
		try {
		  Class c = _classLoader.loadClass( name );
		  rv = (MMLExecutable) c.newInstance();
		  rv.setEquation(source);
		}
		catch( Exception err ) {
		  System.out.println( "Class Load error: " + err.getMessage() );
		}				
	  } else {	  
		System.out.println( "Code Compilation generated error " + ev );		
	  }	
	  return rv;
	}
	
	void displayStream( InputStream s ) {
	  int rbuff;
	  try {
		while ( (rbuff = s.available()) > 0 ) {
		  rbuff = ( rbuff > 200 ) ? 200 : rbuff;
		  int bytes_read = s.read(_display_buff,0,rbuff);
		  System.out.write(_display_buff,0,bytes_read);
		}
		s.close();	
	  } catch ( IOException err ) {
		return;
	  }
	}
	
	class ExecutableClassLoader extends ClassLoader {
	
	  String _classDir;
	  Hashtable _loadedClasses = new Hashtable();
	  
	  public ExecutableClassLoader( String classDir ) { _classDir = classDir; }
	  
	  public synchronized Class loadClass ( String className ) throws ClassNotFoundException {
		 Class newClass = (Class) _loadedClasses.get(className);
		 if( newClass != null ) {
			resolveClass(newClass);
			return newClass;
		 }
		 try {
			byte[] classData = getClassData(className);
			newClass = defineClass( className, classData, 0, classData.length );
		 } catch( IOException err ) {
			try {
			  newClass = findSystemClass( className );
			  return newClass;
			} catch ( Exception any ) {
			  throw new ClassNotFoundException( className );
			}
		 }	   
		 _loadedClasses.put(className,newClass);
		 resolveClass(newClass);
		 return newClass;
	  }
	  
	  protected byte[] getClassData( String className ) throws IOException {
		  File classFile = new File( _classDir, className + ".class" );
		  byte[] classData = new byte[ (int)classFile.length()  ];
		  FileInputStream istream = new FileInputStream(classFile);
		  int length = istream.read(classData);
		  if( _debug ) {	
			 System.out.println("Read " + length + " bytes from file " + className + ".class" );
		  }
		  istream.close();
		  return classData;
	  }
	}
	
	public static void main(String args[]) {
	    
        MMLExecutableFactory f = new MMLExecutableFactory();  
        MMLExecutable ex = f.createExecutable( "test_executable", " System.out.println( (String) args.get(0)  ); " );
        
        if( ex != null ) {
		  int rv = ex.execute( args ); 
		  System.out.println("\nExecuted equation \"" + ex.getEquation() + "\" with arg " + args[0] + ", return value: " + rv  ); 
		}     
    }

}
