package miiee.mml;

import miiee.xml.*;
import org.xml.sax.*;
import java.io.*;

public class MMLHandler extends XMLHandler {
	 
  public MMLHandler( XMLParser parser ) { super(); setParser( parser ); }
  public MMLHandler() { super(); }
  private boolean _debug = false;

  protected void createTreeRoot() { _tree_root = new MMLContainer("MML_root"); }
 
  public XMLComponent getComponentFromName( String name, Attributes atts, XMLComponent parent, boolean create ) {
	XMLComponent rv = null;
	try {
	  if( name.equals("compound") ) { rv = new Compound(atts,(XMLContainer)parent); rv.unresolve(); return rv; }
	  if( name.equals("atom") )  { rv =  new Atom(atts,(XMLContainer)parent); rv.unresolve(); return rv; }
	  if( name.equals("dynamic") )  { return (rv =  new Dynamic(atts,(XMLContainer)parent));  }
	  
	  if( name.equals("link") )  {
		rv = new Link(atts); 
		if( parent != null ) { 
		  ((MMLContainer)parent).addLink((Link)rv); 
		  if( _debug ) { System.out.println( "Adding link in getComponentFromName: " + rv.ID() + ", parent: " + parent.ID() ); }
		}
		return rv;
	  }
	  if( name.equals("port") )  {
		rv = new Port( atts ); 
		if( parent != null ) { 
		  ((MMLContainer)parent).addPort((Port)rv); 
		  if( _debug ) { System.out.println( "Adding port in getComponentFromName: " + rv.ID() + ", parent: " + parent.ID() ); }
		}
		return rv;
	  }
	  if( name.equals("lut") || name.equals("array") )  {
		rv = new Data(atts,name); 
		if( parent != null ) { parent.addData((Data)rv); }
		return rv;
	  }
	} catch ( XMLException err ) {
	  System.out.print(err);
	  return rv;
	}
	return null;
  }

  
	public static void main(String args[]) {
	
	  if (args.length != 1) {
		  System.err.println ("Usage: cmd <filename>");
		  System.exit (1);
	  }
	  
	  XMLParser p = null;
	  try {
		p = XMLParser.getParser( null, new MMLHandler() );
	  } catch ( XMLException err ) {
		System.out.println( err.getMessage() );
		return;
	  }
	  p.parse( args[0] );

	  MMLTree mtree = new MMLTree( p.getHandler().getSourceRoot(), (XMLContainer) p.getRootComponent() );
	  mtree.setStandAlone( true );
	  mtree.display();	  
	}

	public void showBrowser( String  mml_file ) { showBrowser( mml_file, null ); }
	
	public void showBrowser( String  mml_file, String resource ) {
		  
	  System.out.println(" Generating object tree from module markup file: " + mml_file );
	  XMLParser p = null;
	  try {
		p = XMLParser.getParser( null, this );
	  } catch ( XMLException err ) {
		System.out.println( err.getMessage() );
		return;
	  }
	  p.parse( mml_file, null, resource );

	  MMLTree mtree = new MMLTree( mml_file, (XMLContainer) p.getRootComponent() );
	  mtree.display();
	}

	
	public void showBrowser( StringReader sr ) {		  
	  XMLParser p = null;
	  try {
		p = XMLParser.getParser( null, this );
	  } catch ( XMLException err ) {
		System.out.println( err.getMessage() );
		return;
	  }
	  p.parse( sr );
	  MMLTree mtree = new MMLTree( null, (XMLContainer) p.getRootComponent() );
	  mtree.display();
	}
 
 	public void showBrowser( XMLContainer root ) {		  
	  MMLTree mtree = new MMLTree( null, root );
	  mtree.display();
	}
	
	public void browseArchiveFiles( XMLComponent archive ) {	
	  XMLParser p = null;
	  try {
		p = XMLParser.getParser( null, this );
	  } catch ( XMLException err ) {
		System.out.println( err.getMessage() );
		return;
	  }
	  p.parseArchive( archive );
	  MMLTree mtree = new MMLTree( null, (XMLContainer) p.getRootComponent() );
	  mtree.display();
	}

}
