package miiee.mml;

import miiee.xml.*;
import miiee.util.SimIO;
import miiee.wizard.Wizard;
import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import javax.swing.border.*;
import java.awt.*;
import java.beans.*;
import java.awt.event.*;
import java.util.*;
import miiee.wizard.DirectoryChooser;

public class MMLTree extends XMLTree  {

  protected JFrame _frame;
  boolean _standAlone = false;
  boolean _changesMade = false;
  JTextArea _DocText = new JTextArea(100,70);
  String _root_path = SimIO.getXMLSysDirectory();
  String _root_name = "";
  
  public static final int kCompound = 0;
  public static final int kAtom = 1;
  public static final int kDynamic = 2;

  public MMLTree( String root_file_name, XMLContainer root ) { 
	super( root ); 
	setRootName(root_file_name); 
  }

  public void dispose() { if(_standAlone) System.exit(0); }
  
  public void editSelection() {
	XMLComponent c = getSelectedComponent();
	trackPropertyChanges( c );
	c.addPropertyChangeListener( new DocPropListener(_DocText) );
	try {
	  ((Dynamic)c).edit( _frame.getContentPane(), (XMLContainer) getRoot() );	  
	} catch( ClassCastException err ) {	
	  c.editProperty("doc");
	} 
	_changesMade = true;
  }

  public void linkSelection() { _changesMade = true; }
 
  public void addElementToSelection( int type ) {
	XMLComponent c = getSelectedComponent();
	Container parent = _frame.getContentPane();
	XMLTreeModel model = (XMLTreeModel)getModel();
	if( c != null ) {
	  switch( type ) {
		case kDynamic:
		  try {
			Atom a = ((Atom)c);
			String name = JOptionPane.showInputDialog("Please specify a name for the new Dynamic:"); 
			if( name != null ) {
			  Dynamic d = new Dynamic(name);			  
			  String[] possibleValues = { "update", "init", "integrate" };
			  String dtype = (String) JOptionPane.showInputDialog(null, "Please specify the type of the new Dynamic:", 
					  "Dynamic Type Specification",  JOptionPane.INFORMATION_MESSAGE, null, possibleValues, possibleValues[0]);
			  if( dtype != null ) {
				String atom_type = (String) a.getProperty("type");
				if( (atom_type.equals("state") && dtype.equals("update")) || (!atom_type.equals("state") && !dtype.equals("update")) ) {
				  SimIO.show_warning( parent, "Can't add a Dynamic of type " + dtype + " to an Atom of type " + atom_type); 
				  return; 
				}
				d.addAttribute("event",dtype);
				model.addChild( a, d );
			  }
			}
		  } catch( ClassCastException cerr0 ) {
			SimIO.show_warning( parent, "Can't add a Dynamic to a this type of Component." );  
		  }
		break;
		case kAtom:
		  try {
			Compound cp = ((Compound)c);
			String name = JOptionPane.showInputDialog("Please specify a name for the new Atom:"); 
			if( name != null ) {
			  String[] possibleValues = { "aux", "flux", "state" };
			  String atype = (String) JOptionPane.showInputDialog(null, "Please specify the type of the new Atom:", 
					  "Atom Type Specification",  JOptionPane.INFORMATION_MESSAGE, null, possibleValues, possibleValues[0]);
			  if( atype != null ) {
				Atom a = new Atom(name);
				a.addAttribute("type",atype);
				model.addChild( cp, a );
			  }
			}
		  } catch( ClassCastException cerr1 ) {
			SimIO.show_warning( parent, "Can't add an Atom to a this type of Component." );  
		  }
		break;
		case kCompound:
		  try {
			Compound cp = ((Compound)c);
			String name = JOptionPane.showInputDialog("Please specify a name for the new Compound:"); 
			if( name != null ) {
			  Compound child = new Compound(name);
			  model.addChild( cp, child );
			}
		  } catch( ClassCastException cerr2 ) {
			SimIO.show_warning( parent, "Can't add a Compound to a this type of Component." );  
		  }
		break;
	  }
	} else {
	   SimIO.show_warning( parent, "Must select a parent component to add a child." );  
	}
  }
  
  public class DynamicGenerator extends ScriptExecutable {
	Dynamic _dynamic;
	
	public void executionCallback( String stdout, String stderr, XMLComponent executer ) {
	  String name = (String) executer.getDataProperty( "Dynamic.name", "value" );
	  String type = (String) executer.getDataProperty( "Dynamic.type", "value" );
	  String doc = (String) executer.getDataProperty( "Dynamic.doc", "value" );
	  System.out.println("Creating new " + type + " Dynamic: " +  name );
	  _dynamic = new Dynamic(name);
	  _dynamic.addProperty( "doc", doc );
	  _dynamic.addAttribute("event",type);
	}
	
	Dynamic getDynamic() { return _dynamic; }
  }
  
  public Dynamic getNewDynamic() {
	Wizard w = Wizard.getWizard( "Dynamic.create", null );
	Container parent = _frame.getContentPane();
	if( w == null ) { 
	  XMLException.show_error( parent, "Can't find Wizard: Dynamic.create" );
	  return null;
	}
	DynamicGenerator dg = new DynamicGenerator();	
	w.show( true ,dg );
	return dg.getDynamic();
  }

  public MMLContainer getNewContainer() {
	System.out.println("Creating new Container " );
	return null;
  }
  
  public void deleteSelection() {
	XMLComponent c = getSelectedComponent();
	Container parent = _frame.getContentPane();
	if( c != null ) {
	  if( XMLException.show_confirm( parent, "Are you sure you want to remove this Component?" ) ) {
		  System.out.println("Removong selected component " );
		  removeCurrentNode( );
		  _changesMade = true;
	  } 
	} else {
	   SimIO.show_warning( parent, "Must select a component to delete." );  
	}
  }
  
  public void setStandAlone( boolean sa ) { _standAlone = sa; }

  public void display() {
	_frame = new JFrame("MML Tree");
	WindowListener l = new WindowAdapter() {
		public void windowClosing(WindowEvent e) { dispose(); }
	};
	_frame.addWindowListener(l);
	Border loweredBorder = BorderFactory.createLoweredBevelBorder();

	Container c = _frame.getContentPane(); 
	BoxLayout blx = new BoxLayout(c, BoxLayout.Y_AXIS );	c.setLayout( blx ); 	       

	_DocText.setMargin( new Insets( 4, 4, 4, 4 ) ); 
	_DocText.setWrapStyleWord(true);
	_DocText.setLineWrap(true);
	_DocText.setBackground( new Color(0, 0, 200) );
	_DocText.setForeground( Color.yellow );

	JScrollPane sp1 = new JScrollPane();
	sp1.getViewport().setView(_DocText);
	sp1.setPreferredSize(new Dimension( 300, 50 ));
	sp1.setBorder( loweredBorder );

	addTreeSelectionListener( new DocListener(_DocText) );	  

	c.add( sp1 );				

	JPanel   buttonsPanel = new JPanel(false);
	BoxLayout bly = new BoxLayout(buttonsPanel, BoxLayout.X_AXIS );  
	buttonsPanel.setLayout( bly ); 	   
	JButton aButton;
	Insets bi = new Insets(1,1,1,1);

	Icon icon = SimIO.loadIcon( "Compound.gif" );
	aButton = new JButton(icon); aButton.setMargin(bi);
	aButton.setToolTipText("add child Compound");
	aButton.addActionListener( new ActionListener() {
	  public void actionPerformed(ActionEvent e) { addElementToSelection(kCompound); }
	}  );
	buttonsPanel.add( aButton );

	icon  = SimIO.loadIcon( "Atom.gif" );
	aButton = new JButton(icon); aButton.setMargin(bi);
	aButton.setToolTipText("add child Atom");
	aButton.addActionListener( new ActionListener() {
	  public void actionPerformed(ActionEvent e) { addElementToSelection(kAtom); }
	}  );
	buttonsPanel.add( aButton );

	icon  = SimIO.loadIcon( "Dynamic.gif" );
	aButton = new JButton(icon); aButton.setMargin(bi);
	aButton.setToolTipText("add child Dynamic");
	aButton.addActionListener( new ActionListener() {
	  public void actionPerformed(ActionEvent e) { addElementToSelection(kDynamic); }
	}  );
	buttonsPanel.add( aButton );
	
	buttonsPanel.add( Box.createHorizontalStrut(12) ); 

	icon  = SimIO.loadIcon( "edit.gif" );
	aButton = new JButton(icon); aButton.setMargin(bi);
	aButton.setToolTipText("configure element");
	aButton.addActionListener( new ActionListener() {
		public void actionPerformed(ActionEvent e) { editSelection(); }
	});
	buttonsPanel.add( aButton );

	icon  = SimIO.loadIcon( "link.gif" );
	aButton = new JButton(icon); aButton.setMargin(bi);
	aButton.setToolTipText("Link elements");
	aButton.addActionListener( new ActionListener() {
		public void actionPerformed(ActionEvent e) { linkSelection(); }
	});
	buttonsPanel.add( aButton );

	icon  = SimIO.loadIcon( "delete.gif" );
	aButton = new JButton(icon); aButton.setMargin(bi);
	aButton.setToolTipText("delete element");
	aButton.addActionListener( new ActionListener() {
	  public void actionPerformed(ActionEvent e) { deleteSelection(); }
	});
	buttonsPanel.add( aButton );

	icon  = SimIO.loadIcon( "close.gif" );
	aButton = new JButton(icon); aButton.setMargin(bi);
	aButton.setToolTipText("close tool");
	aButton.addActionListener( new QuitAction() );
	buttonsPanel.add( aButton );
	buttonsPanel.add( Box.createHorizontalGlue() ); 
	
	c.add(buttonsPanel);

	JPanel pV  = getDisplayPanel();
	pV.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE )); 
	c.add(pV);

	PropertyTable pt1 = PropertyTable.getTablePanel( 160, 600 );
	pt1.setHeaders("Ports","Links");	
	JScrollPane scrollpane2 = new JScrollPane();
	scrollpane2.getViewport().setView(pt1);
	scrollpane2.setMaximumSize(new Dimension(Short.MAX_VALUE, 100 )); 
	scrollpane2.setPreferredSize(new Dimension(Short.MAX_VALUE, 100 )); 
	scrollpane2.setBorder( BorderFactory.createLoweredBevelBorder() );
	addTreeSelectionListener( new LinkListener(pt1) );	
	
	c.add(scrollpane2);
	
	XMLComponent firstProject = (XMLComponent) ((XMLContainer)getRoot()).getChild( 0 );
	if( firstProject != null ) { expandPath( getPath( firstProject ) ); }

	_frame.setJMenuBar( constructMenuBar() );
	_frame.setSize(500,600);

	Dimension         paneSize = _frame.getSize();
	Dimension         screenSize = _frame.getToolkit().getScreenSize();
	_frame.setLocation((screenSize.width - paneSize.width) / 2,
				(screenSize.height - paneSize.height) / 2);

	_frame.setVisible(true);	  
 }
 
  private  JMenuBar constructMenuBar() {
	JMenu            menu;
	JMenuBar         menuBar = new JMenuBar();
	JMenuItem        menuItem;

	menu = new JMenu("File");
	menu.setBackground(Color.lightGray);
	menuBar.add(menu);

	menuItem = menu.add(new JMenuItem("Open"));
	menuItem.addActionListener(new OpenAction());

	menuItem = menu.add(new JMenuItem("Close"));
	menuItem.addActionListener(new CloseAction());

	menu.addSeparator();
	
	menuItem = menu.add(new JMenuItem("Save as..."));
	menuItem.addActionListener(new CopyAction());

	menuItem = menu.add(new JMenuItem("Save"));
	menuItem.addActionListener(new SaveAction());

	menu.addSeparator();
	
	menuItem = menu.add(new JMenuItem("Quit"));
	menuItem.addActionListener(new QuitAction());

	menu = new JMenu("Help");
	menuBar.add(menu);

	menuItem = menu.add(new JMenuItem("Show selector help doc"));
	menuItem.addActionListener( new ActionListener() {
	  public void actionPerformed(ActionEvent e) {;}
	}  );

	return menuBar;
  }
  
  public void setRootName( String root_name ) {
	if( root_name == null ) return;
	if( root_name.startsWith("file:") ) {
	  root_name = root_name.substring(5);
	}
 	int li = root_name.lastIndexOf('/');
 	if( li == -1 ) {
	  _root_name = root_name;
	  _root_path =  System.getProperty("user.dir");	  
	} else {
	  _root_name =  root_name.substring(li+1);
	  _root_path =  root_name.substring(0,li+1);
	}
	System.out.println("Setting root name: " + _root_name + ", location = " + _root_path);
  }
  
  public void save(String new_path) {
	XMLComponent c = getRoot();
	if(c == null ) return;
 	String dtd_file = "mml";
 	String path = ( new_path == null )?  _root_path : new_path;
	c.setNamespace(path);
	System.out.println("Writing xml: " + _root_name + ", location: " + path);
	c.writeXML(  _root_name, dtd_file, XMLComponent.DEFINITION );
	_changesMade = false;	  
  }
  
  class OpenAction implements ActionListener {
	public void actionPerformed(ActionEvent e) {
	  JFileChooser chooser = new JFileChooser(_root_path);
	  int returnVal = chooser.showDialog( _frame.getContentPane(), "select" );
	  if(returnVal == JFileChooser.APPROVE_OPTION) {
		String path = chooser.getSelectedFile().getAbsolutePath();
		XMLParser p = null;
		try {
		  p = XMLParser.getParser( null, new MMLHandler() );
		} catch ( XMLException err ) {
		  System.out.println( err.getMessage() );
		  return;
		}
		p.parse(path);
		setRoot( (XMLContainer) p.getRootComponent() );
		setRootName( path );
	  }
	}
  } 
  
  class CloseAction implements ActionListener {
	public void actionPerformed(ActionEvent e) {
	  if( _changesMade ) {
		int rv = JOptionPane.showConfirmDialog( _frame.getContentPane(), 
			"Save changes before closing?", "JST confirm", JOptionPane.YES_NO_CANCEL_OPTION, JOptionPane.QUESTION_MESSAGE );
		SimIO.print("Got response: " + rv );
		if( rv == 0 ) { save(null); }
		if( rv < 2 ) { clear(); }
	  } else {
		int rv = JOptionPane.showConfirmDialog( _frame.getContentPane(), 
			"Are youe sure you want to close this model?", "JST confirm", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE );
		SimIO.print("Got response: " + rv );
		if( rv == 0 ) { clear(); }
	  }
	}
  } 
  class SaveAction implements ActionListener {
	public void actionPerformed(ActionEvent e) {
	  save(null);
	}
  } 
  class CopyAction implements ActionListener {
	public void actionPerformed(ActionEvent e) {
	  DirectoryChooser dc = DirectoryChooser.create( _root_path );
	  dc.addActionListener( new UpdateDirectoryAction() );
	  dc.show(true);
	}
  } 
  class UpdateDirectoryAction extends Object implements ActionListener {
	public void actionPerformed(ActionEvent e) {
	   String dir = e.getActionCommand();
	   save(dir);
	 }
  } 

  class QuitAction implements ActionListener {
	public void actionPerformed(ActionEvent e) {
	  if( _changesMade ) {
		int rv = JOptionPane.showConfirmDialog( _frame.getContentPane(), 
			"Save changes before quitting?", "JST confirm", JOptionPane.YES_NO_CANCEL_OPTION, JOptionPane.QUESTION_MESSAGE );
		if( rv == 0 ) { save(null); }
		if( rv < 2 ) { 
		  _frame.dispose(); 
		}
	  } else if( _standAlone ){
		int rv = JOptionPane.showConfirmDialog( _frame.getContentPane(), 
			"Are you sure you want to quit?", "JST confirm", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE );
		if( rv == 0 ) { _frame.dispose(); }
	  } else {
		_frame.dispose();
	  }
	}
  }   
}

class LinkListener extends Object implements TreeSelectionListener {
  PropertyTable _table;
  LinkListener( PropertyTable ta ) {
	_table = ta;
  }
  public void valueChanged(TreeSelectionEvent e) {
	try {
	  MMLContainer n =  (MMLContainer) e.getPath().getLastPathComponent();
	  Vector ports = n.getPortStrings( true, false  );
	  Vector links = n.getPortStrings( false, true );
	  _table.setProperties( ports, links );
	} catch ( ClassCastException err ) { 
	  _table.setProperties((PropertyList)null);
	} catch ( NullPointerException err ) { 
	  _table.setProperties((PropertyList)null);
	}
  }
}

class DocListener extends Object implements TreeSelectionListener {
  JTextArea _text;
  DocListener( JTextArea ta ) {
	_text = ta;
  }
  public void valueChanged(TreeSelectionEvent e) {
	try {
	  XMLComponent doc = (XMLComponent)e.getPath().getLastPathComponent();
	  _text.setText( (String) doc.getProperty("doc") );
	} catch ( ClassCastException err ) { 
	  _text.setText("");
	} 
  } 
}

class DocPropListener extends Object implements PropertyChangeListener {
  JTextArea _text;
  DocPropListener( JTextArea ta ) {
	_text = ta;
  }
  public void propertyChange( PropertyChangeEvent evt ) {
   String prop = evt.getPropertyName();
   if( prop.equals("doc") ) {
	  try {
		XMLComponent doc = (XMLComponent)evt.getSource();
		_text.setText( (String) doc.getProperty("doc") );
	  } catch ( ClassCastException err ) { 
		_text.setText("");
	  } 
	}
  } 
}

