package miiee.mml;
import java.beans.beancontext.BeanContextChildSupport;
import java.io.BufferedWriter;
import miiee.xml.*;
import miiee.util.SimIO;
import java.io.IOException;
import java.util.Vector;
import org.xml.sax.Attributes;

public class  Port  extends XMLComponent {
  Vector _outlinks = null;
  Link _inlink;
  int _mode = -1;
  static final boolean _debug = false;

  public static final int kInput = 0;
  public static final int kOutput = 1;
    
  public  Port( Attributes atts )  {
	 super();
	 _properties.importAttributes( atts ); 
  }

  public  Port( String name, int mode )  {
	 super();
	 _mode = mode;
	 addAttribute( "name", name ); 
	 String type = ( mode == kInput ) ? "input" : "output";
	 addAttribute( "type", type ); 
  }

  public int getMode() { return _mode; }
  
   public String getElementType( int format ) {  return "port"; }

  public boolean processAttribute( String name, String value, String type ) {
	if( name.equals("type") ) {
	  if( value.equals("output") ) {
		_mode = kOutput;
	  } else {
		_mode = kInput;
	  }
	  return true;
	}
	return true;
  }
 
  public String toString() { return name(); }

  public String name() {
	String id = (String) _properties.get( "name" );
	if( id == null ) { id = "unknown"; }
	XMLComponent p = getParent();
	if( p == null ) { return "unknown" + "." + id; }
	return p.ID() + "." + id;
  }
   
  public String ID() { 
	String id = (String) _properties.get( "name" );
	if( id == null ) { id = "unknown"; }
	return id;
  }
  
  public boolean setInLink( Link link ) throws XMLException {
	if( _inlink != null ) {
	  if( !_inlink.equals(link) ) { 
		throw new XMLException("InLink Collision: " + _inlink + " vs " + link + " on Port " + toString() ); 
	  } 
	  return false; 
	}
	if( _debug ) {
	  System.out.println("setInLink, port: " + this + ", Link: " + link + ", origin: " +  link.getOrigin() ); 
	}
	_inlink = link; 
	return true;
  }	
    
  public boolean addOutLink( Link link ) { 
	if( _outlinks == null ) { _outlinks = new Vector(8,8); }
	else if( _outlinks.contains(link) ) return false;
	_outlinks.add(link); 
	return true;
  }	
    
  public Link getInLink() { return _inlink; }

  public int nOutLinks() {
	if( _outlinks == null ) return 0;
	return _outlinks.size();
  }

  public Link getOutLink(int i) {
	if( _outlinks == null ) return null;
	return (Link) _outlinks.get(i);
  }

  public int getNOutLinks() {
	if( _outlinks == null ) return 0;
	return _outlinks.size();
  }
  
  public Port getConnectedPort( int index  ) {
	if( _mode == kInput ) {
	  if( _debug ) {
		System.out.println("getConnectedPort, port: " + this + ", inlink: " + _inlink + 
		  ", origin: " + (( _inlink == null ) ? "null" : _inlink.getOrigin().toString() ) ); 
	  }
	  if( _inlink == null ) return null;
	  return _inlink.getOrigin(); 
	} else {
	  if( _outlinks == null ) return null;	
	  return ((Link)_outlinks.get(index)).getDestination();
	}
  }	
  
  public Port getRemoteSourcePort() {
	Port source = null, destination = this;
	String etype = null;
	int cnt = 0;
	if( _mode == kInput ) {
	  try {
		while( cnt++ < 100 ) {
		  Link inlink = destination.getInLink();
		  source = inlink.getOrigin(); 
		  XMLComponent xv = source.getParent();
		  etype = xv.getElementType( 0 );
		  if( etype.equals("atom") || etype.equals("variable") ) {  break; }
		  xv.waitUntilResolved();
		  destination = source;
		}
	  } catch( NullPointerException err ) { 
		if( _debug ) {
		  SimIO.print("getRemoteSourcePort error: source = " + source + ", destination = " 
			  + destination + ", iter = " + cnt  + ", etype = " + etype  );
		  err.printStackTrace(); 
		}
	  }
    }
    return source;
  }
  
  public String getConnectedPortString( boolean useID ) {
	String rv = "";
	if( _mode == kInput ) {
	  if( _inlink == null ) {
		SimIO.print("getConnectedPortString: Null inlink in imput port " + ID()  );
		return rv;
	  }
	  Port p =  _inlink.getOrigin();
	  if( p != null ) { rv =  (useID) ? p.ID() : p.name(); }
	} else {
	  if( _outlinks == null ) {
		SimIO.print("getConnectedPortString: Null outlinks in output port " + ID()  );
		return rv;
	  }
	  for( int i=0; i< _outlinks.size(); i++ ) {	
		Port p =  ((Link)_outlinks.get(i)).getDestination();
		if( p != null ) { rv =  rv + " " + ((useID) ? p.ID() : p.name()); }
	  }
	}
	return rv;
  }	
  
  public void writeXML( BufferedWriter out, int format )  throws IOException { 
	out.newLine(); 
	out.write("\t\t\t<port ");
	_properties.writeXML( out, PropertyList.kAttributes );
	out.write(" />");
  }
  
}
