package miiee.mml;

import java.util.*;
import javax.swing.*;
import miiee.xml.*;
import org.xml.sax.*;
import miiee.util.*;


public class  Project extends XMLContainer implements LocalizedObject {
  
  public  Project( Attributes atts )  {
	 super(atts);
  }  

  public  Project( String id )  {
	 super(id);
  }  

  public  Project( Attributes atts, XMLContainer parent ) throws XMLException {
	 super(atts,parent);
  }

  public String getElementType( int format ) { return "project"; }

  public Icon getIcon() {
	if( _icon == null ) {
		_icon   = SimIO.loadIcon(  "project.gif" );	
	}
	return _icon;
  } 
/*    
  public boolean addScenarios() {
	 String pdir = getDirectory();
	 boolean rv = false;
	 if( pdir != null ) {
	   Iterator iter = childIterator();
	   while( iter.hasNext() ) {
		  XMLComponent xc = (XMLComponent) iter.next();
		  try {
			Model m = (Model)xc;
			if( m.addScenarios(pdir) ) { rv = true; }
		  } catch ( Exception err ) {
			SimIO.print("Project::addScenarios: " + err.getMessage() );
			err.printStackTrace();
		  }
	   }
	 }
	 return rv;
  }
*/  

  public void setDirectory( String dir ) { 
	try {
	  setProperty( "directory", dir );
	  System.out.println("Setting directory for Project " + ID() + ":" + dir );
	} catch ( XMLException err ) {
	  SimIO.show_error( null, "Project::setDirectory:", err ) ;
	}
  }

  public String getDirectory() {
	return (String) getProperty( "directory" );
/*
	String pdir = null;
	try {
	   WorkSpace ws = (WorkSpace) getParent();
	   pdir = ws.getDirectory() + "/" + ID() + "/";
   } catch( Exception err ) {
	 SimIO.print( "Error getting project dir: " + err.getMessage() );
   }
   return pdir;
*/
  }
}
