package miiee.mml;

import java.util.*;
import javax.swing.*;
import javax.swing.filechooser.*;
import miiee.xml.*;
import miiee.dataview.*;
import miiee.servlet.*;
import miiee.client.SMEInterface;
import miiee.client.SMEClient;
import miiee.client.VariableConfigPanel;
import miiee.client.SNPException;
import java.io.*;
import miiee.wizard.Wizard;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.awt.*;
import java.util.zip.*;
import javax.swing.border.*;
import java.awt.event.*;
import org.xml.sax.*;
import miiee.util.*;
import java.net.URL;
import java.security.*;
import javax.help.*;
import miiee.wizard.DirectoryChooser;

public class ProjectHandler extends XMLHandler {

	public static final int LOCAL_MODE	= 0;
	public static final int GLOBUS_MODE	= 1;
	public static final int PORTAL_MODE	= 2;
	public static final int APPLET_MODE	= 3;
	public static final int WORKBENCH_MODE = 4;

	public static final int MODEL	= 0;
	public static final int SCENARIO	= 1;

    protected  XMLTree _projDataTree;
	protected  JDialog _dialog;
	protected  Model _selectedModel;
	protected  Project _selectedProject;
	protected String _workbench_name;
	protected String _root_directory;
	protected String _local_host;
	protected int _interaction_mode = LOCAL_MODE;
	protected  boolean _modelSelected = false;
	protected  boolean _hasModels = false;
	private   boolean _debug = true;
	private   boolean _error_flag = false;
	protected  boolean  _getModelsFromServlet = false;
	protected WorkSpace _current_workspace;
	protected Project _current_project;
	protected ViewserverControlPanel _dataViewer;
	protected SMEInterface _sme_interface; 
	protected UserRegister _user_manager;
	protected User _current_user;
	protected boolean _filter_workspaces = false;
    protected  Toolkit _toolkit = Toolkit.getDefaultToolkit();
    protected boolean _changes_made = false;
    protected Stack _project_stack = new Stack();

    
    public ProjectHandler( WorkSpaceRoot root, int int_mode ) { 
	  super(); 
	  _interaction_mode = int_mode;
	  _workbench_name = root.ID();
	  _tree_root = root;
	}

    public ProjectHandler(String workbench_name, int int_mode ) { 
	  super(); 
	  _interaction_mode = int_mode;
	  _workbench_name = workbench_name; 
	  SMEInterface.setProperty("workbench.name", _workbench_name );
	  try {
		createTreeRoot( null ); 
	  } catch ( XMLException err ) {
		err.show( null, "Error adding Child to root: " );
	  }
	}
	
	public void reload() {
	  XMLTreeModel tm = (XMLTreeModel) _projDataTree.getModel();
	   tm.reload();
	  _projDataTree.expandAll();
	}
	
	public String getWorkBenchName() { 	return _workbench_name; }
	public XMLTreeModel getTreeModel() { return (XMLTreeModel) ((_projDataTree == null) ? null : _projDataTree.getModel()); }

	protected void createTreeRoot( XMLContainer top_container ) throws XMLException { 
	  _tree_root = new WorkSpaceRoot( _workbench_name ); 
	  if( top_container != null ) {
		_tree_root.addChild(top_container);
	  }
	}
	
	boolean addChildToContainer( XMLContainer parent, XMLComponent child ) {
	  XMLTreeModel tm = getTreeModel();
	  if( parent == null ) { parent = getTreeRoot(); }
	  if( parent.getChildIndex( child ) >= 0 ) return false;
	  if( tm != null ) {
		tm.addChild(parent,child);
		if( _debug ) { System.out.println("Added child node: " + child + " to parent: " +  parent); }
		_projDataTree.expandPath( child );
	  } else  if( parent != null )  { 
		 try {
		   parent.addChild( child );
		   child.setParent( parent ); 
		   if( _debug ) { System.out.println("Added child node: " + child + " directly to parent: " +  parent); }
		} catch ( miiee.xml.XMLException err ) {  err.show( null, "Error adding Child: " );  }
	  } else {
		   if( _debug ) { System.out.println("Null root node"); }
	  }
	  return true;
	}

	public  WorkSpace addWorkSpace(  String id, String name, String doc, String owner, boolean is_public  ) {
		  String dir = _root_directory + "/workspace/";
		  String WS_file_name = id + ".workspace.xml";
		  File ws_file = new File(dir,WS_file_name);
		  if( ws_file.canRead() ) {
			  SimIO.show_error( null, "Workspace already exists: " + ws_file );
			  return null;
		  }
		  WorkSpace w = new WorkSpace( id );
		  w.addAttribute( "name", name );

//		w.setDirectory( dir );
//		w.setNamespace( dir );

		w.addAttribute( "location", WS_file_name );
		w.setLocation(  WS_file_name );
		w.addProperty( "doc", doc );
		addWorkSpace(  w  );
		if( (owner != null) && (owner.length() != 0) ) { 
		  try { w.setProperty( "owner", owner ); }
		  catch( Exception err ) {;}
		}
		return w;
	}

	public  WorkSpace addWorkSpace(  WorkSpace w  ) {
		XMLContainer parent = getTreeRoot();
		addChildToContainer(parent,w);
		if( _debug ) { System.out.println("Added WorkSpace " + w  ); }
		w.stampComponent(); 
		return w;
	}

	public  WorkSpace getWorkSpace(  String id ) {
		XMLContainer parent = getTreeRoot();
		return (parent == null ) ? null : (WorkSpace) parent.getChild( id );
	}
	  
	public  Project addProject( XMLContainer parent, String id, String name, String proj_directory, String doc ) {
		Project p = new Project( id );
		if( _debug ) { System.out.println("Adding Project " + p + ", parent: " + parent  ); }
		p.addAttribute( "name", name );
		p.addProperty( "doc", doc );
		addChildToContainer(parent,p);
		_current_project = p;
		p.stampComponent(); 
		p.setDirectory( proj_directory );
		addModels( p );
       return p;
	}
	
	public void addModels( Project p ) {
	  File modelDirs = new File( p.getDirectory()  + "/Models/" );
	  if( _debug ) { System.out.println("Adding Models to Project " + p + ", dir: " + modelDirs  ); }
	  try {
		  File[] subdirs = modelDirs.listFiles();
		  if( subdirs == null ) { 
			  return;
		  }
		  for( int i=0; i<subdirs.length; i++ ) {
			  File model_dir = subdirs[i];
			  if( model_dir.isDirectory() ) {
				  String model_name = model_dir.getName();
				  File model_config_file = new File( p.getDirectory() + "/Config/" + model_name + ".conf" );
				  if( model_config_file.canRead() ) {
					  addModel( p, model_name, model_name, "Imported Model" );
				  }
			  }
		  }
	  } catch ( java.security.AccessControlException err ) {
	  	ServletClient sc = ServletClient.getInstance();
		WorkSpace ws = (WorkSpace) p.getParent();
		if( sc != null ) {
		  Vector modelList = (Vector) sc.getModelList( ws.ID(), p.ID() );
		  if( modelList != null ) {
			  for( int i=0; i<modelList.size(); i++ ) {
				  String model_name = (String) modelList.get(i);
				  addModel( p, model_name, model_name, "Imported Model" );
			  }
		  }
		}
	  }
	}

	public  XMLContainer addModel( Project parent, String id, String name, String doc ) {
		id = parent.ID() + "." + id;
		Model m = null;
		m = new Model( id );
		m.addAttribute( "name", name );
		m.addAttribute( "base_id", name, XMLComponent.kStatic );
		m.addProperty( "doc", doc );
		if( addChildToContainer(parent,m) ) {
			SimIO.print("Adding Model: " + id );
			_changes_made = true;
		} else {
			try {
			  m = (Model) parent.getChild(id);
			} catch( Exception err1 ) {
			   SimIO.print( "Error adding Scenario: " + err1.getMessage() );
			}
		}
		if( m != null ) {
			importModelSpecs( parent, m );
			addScenarios( parent, m );
			m.stampComponent(); 
		}
		return m;
	}
	
	public void addScenarios( Project p, Model m ) {
		String model_name = (String) m.getProperty("name");
		String project_dir = p.getDirectory();
		String scenario_path = project_dir + "/DriverOutput/" + model_name + "/";
		File scen_file = new File(scenario_path);
		SimIO.print("Adding Scenarios: " + scenario_path);
		try {
		  File[] scenario_dirs = scen_file.listFiles();
		  if( scenario_dirs != null ) {
		   for( int i=0; i<scenario_dirs.length; i++ ) {
			  File scenario_dir = scenario_dirs[i];
			  String id = scenario_dir.getName(); 
			  addScenario( m, id, "Imported Scenario", scenario_dir );
			  importScenarioSpecs( p, m, id );
		   }
		 } else {
		   SimIO.print("Scenario directory does not exist: " + scenario_path);
		 }
	  } catch ( java.security.AccessControlException err ) {
	  	ServletClient sc = ServletClient.getInstance();
		WorkSpace ws = (WorkSpace) p.getParent();
		if( sc != null ) {
		  Vector scenarioList = (Vector) sc.getScenarioList( ws.ID(), p.ID(), model_name );
		  for( int i=0; i<scenarioList.size(); i++ ) {
			  File scenario_dir = (File) scenarioList.get(i);
			  String id = scenario_dir.getName(); 
			  addScenario( m, id, "Imported Scenario", scenario_dir );
		  }
		}
	  }	catch ( Exception err ) {
		 SimIO.print( " Can't read files in " + scenario_path + " : " + err.getMessage() );
	   }
	}
		
 	public Scenario addScenario( Model parent, String name, String doc, File scenario_dir ) {
	  String id = parent.ID() + "." + name;
	  Scenario  s = new Scenario(id);
	  s.addAttribute( "name", name );
	  s.addAttribute( "base_id", name, XMLComponent.kStatic );
	  s.addProperty( "doc", doc );
	  if( addChildToContainer(parent,s) ) {
		SimIO.print("Adding Scenario: " + id );
		_changes_made = true;
	  } else {
		try {
		  s = (Scenario) parent.getChild(id);
		} catch( Exception err1 ) {
		   SimIO.print( "Error adding Scenario: " + err1.getMessage() );
		}
	  }
	  if( s != null ) {
		addDataSets(s,scenario_dir);
		s.stampComponent(); 
	  } 
	  return s;
	}
	
  public void addDataSets(Scenario s, File scenario_dir) {
	try {
		File[] dfiles = scenario_dir.listFiles( new FileSuffixFilter(".serial") );
		SimIO.print("addDataSets-> dir: " + scenario_dir.getPath() + ", nfiles = " + ((dfiles==null) ? 0 : dfiles.length));
		if( (dfiles != null) && (dfiles.length > 0) ) {
		  for( int i=0; i<dfiles.length; i++ ) {
			 File data_file = dfiles[i];
			 String ds_id = data_file.getName();
			 try {
			   SimulationRun sr = new SimulationRun( ds_id );
			   sr.setDataFile(data_file);
			   if( addChildToContainer(s,sr) ) {
				  SimIO.print("Adding DataSet: " + ds_id );
				  _changes_made = true;
				  importSimulationRun( sr );
			   } 
			 } catch ( XMLException err ) {
			   SimIO.print("Error adding dataSet: " + err.getMessage() );
			 }
		  }
		} 
	  } catch ( java.security.AccessControlException err ) {
	  	ServletClient sc = ServletClient.getInstance();
	  	Model m = (Model) s.getParent();
	  	Project p = (Project) m.getParent();
		WorkSpace ws = (WorkSpace) p.getParent();
		String model_name = (String) m.getProperty("name");
		String project_dir = p.getDirectory();
		if( sc != null ) {
		  Vector dataList = (Vector) sc.getDataList( ws.ID(), p.ID(), model_name, s.ID() );
		  for( int i=0; i<dataList.size(); i++ ) {
			 File data_file = (File) dataList.get(i);
			 String ds_id = data_file.getName();
			 try {
			   SimulationRun sr = new SimulationRun( ds_id );
			   sr.setDataFile(data_file);
			   if( addChildToContainer(s,sr) ) {
				  SimIO.print("Adding DataSet: " + ds_id );
				  _changes_made = true;
			   } 
			 } catch ( Exception err1 ) {
			   SimIO.print("Error adding dataSet: " + err1.getMessage() );
			 }
		  }
		}
	  }
   }
   		  
   private  void destroy() { 
	 if( _user_manager != null ) {
	   SimIO.print("Saving user data");
	   _user_manager.save();
	 }
	 save();
   }

   public  void dispose() { 
	 if( _user_manager != null ) {
	   SimIO.print("Saving user data");
	   _user_manager.save();
	 }
	 save();
	 clear();
	 if( _dialog != null ) { _dialog.setVisible(false); _dialog.dispose(); }
	  _dialog = null; 
	  _projDataTree = null;
	  if( _sme_interface != null ) {
		_sme_interface.shutdown(true);
		_sme_interface = null;
	  }
   }
   
   public  boolean showTreeView() {
	 return showTreeView( false );
   }

   JPanel createPanels() { 
   	  XMLComponent root = getTreeRoot();
   	  if( root == null ) { root = new XMLComponent("root"); }
	  _projDataTree = new XMLTree( root );

	  Border loweredBorder = BorderFactory.createLoweredBevelBorder();
	  
	  JPanel c = new JPanel();
	  c.setLayout(new BorderLayout());
	  c.setBorder( loweredBorder );
	  Box main_panel = Box.createVerticalBox();

	  JTextArea ta = new JTextArea(100,70);
	  ta.setMargin( new Insets( 4, 4, 4, 4 ) ); 
	  ta.setWrapStyleWord(true);
	  ta.setLineWrap(true);
	  ta.setBackground( new Color(0, 0, 200) );
	  ta.setForeground( Color.yellow );
	  
	  JScrollPane scrollpane1 = new JScrollPane();
	  scrollpane1.getViewport().setView(ta);
	  scrollpane1.setPreferredSize(new Dimension( 300, 50 ));
	  scrollpane1.setBorder( loweredBorder );
	  main_panel.add(scrollpane1);

	  _projDataTree.addTreeSelectionListener( new ProjDocListener(ta) );	  
	  main_panel.add( _projDataTree.getDisplayPanel() );
	  c.add( "Center", main_panel );
	  reload();
	  return c;
   }
   
   public void setModelsFromServlet ( boolean  getModelsFromServlet ) { _getModelsFromServlet = getModelsFromServlet; }
   
   public JPanel createContentPane() {
 	  JPanel c = createPanels();
	  JToolBar toolbar = new JToolBar();	  
	  c.add( "North", toolbar );	
	  			
	  JButton aButton = toolbar.add ( 
		new AbstractAction( null, getIcon("glasses_no_border.gif") ) {
		  public void actionPerformed(ActionEvent e) { view_selected_object(); } 
		} 
	  ); 
	  aButton.setToolTipText( "view object" );
	  aButton.setAlignmentY(0.5f);
	  
	  toolbar.add ( createToolbarButton( "close.gif", "Close Workspace Manager", "close", new AbstractAction() {
		public void actionPerformed(ActionEvent e) {
		  if( XMLException.show_confirm( _dialog, "Are you sure you want to close the Workspace Manager?" ) ) {
			destroy();
			System.exit(0);
		  }
		}
	  } ));
/*	  
	  toolbar.add( Box.createHorizontalGlue() );

	  aButton = toolbar.add ( 
		new AbstractAction( null, getIcon("question.gif") ) {
		  public void actionPerformed(ActionEvent e) { ; } 
		} 
	  ); 
	  aButton.setToolTipText( "help" );
	  HelpBroker hb = SimIO.getHelpBroker( "SME"  );
	  hb.enableHelpOnButton( aButton, "WSManager", null );	 
*/ 
	  return c;
   }
    
    public  boolean showTreeView( boolean modal ) { return showTreeView( modal, true ); }
  
   public  boolean showTreeView( boolean modal, boolean show_users ) {
	  _modelSelected = false;
	  JFrame frame = new JFrame("Project Handler");
	  _dialog = new JDialog( frame, "Project Handler", modal ); // Modal
	
	  WindowListener wL = new WindowAdapter() {
		  public void windowClosing(WindowEvent e) { destroy(); }
	  };
	  _dialog.addWindowListener(wL);  
	  JPanel top = new JPanel();
	  BoxLayout bl = new BoxLayout(top, BoxLayout.X_AXIS );	  top.setLayout( bl ); 	   
	  
	  JPanel c = createContentPane();
	  JToolBar toolbar = new JToolBar();	  
	  c.add( "North", toolbar );
	  
	  top.add(c);	
	  if( show_users ) {
		if( _user_manager == null ) {
		  _user_manager = new UserRegister( this );
		}
		JPanel user_panel = _user_manager.createContentPane();
		top.add(user_panel);
	  }	

	  JButton aButton = toolbar.add ( 
		new QueuedExecutable( null, getIcon("glasses_no_border.gif") ) {
		  public void execute() { view_selected_object(); } 
		} 
	  ); 
	  aButton.setToolTipText( "view object" );
	  aButton.setAlignmentY(0.5f);
	  			
	  aButton = toolbar.add ( new QueuedExecutable( null, getIcon("edit.gif") ) {
		public void execute() {
		  TreePath spath = _projDataTree.getSelectionPath();
		  XMLComponent c1 = (XMLComponent) spath.getLastPathComponent();
		  if( c1 != null ) {
			System.out.println("Editing node: " + c1.ID() );
			if( c1.editDocumentation() ) {
			  _projDataTree.reload();
			  _projDataTree.setSelectionPath(spath);
			  _changes_made = true;
			}
		  } else {
			XMLException.show_error( _dialog, "Must select something." );
		  }
		}
	  } ); 
	  aButton.setToolTipText( "edit component properties" );
	  aButton.setAlignmentY(0.5f);

	  toolbar.add ( createToolbarButton( "delete.gif", "Remove object", "delete", new QueuedExecutable() {
		public void execute() {
		  XMLComponent c1 = _projDataTree.getSelectedNode();
		  if( c1 != null ) {
			if( c1.isOwner() ) {
			  if( XMLException.show_confirm( _dialog, "Are you sure you want to remove this Component?" ) ) {
				System.out.println("Removing component " + c1.ID() );
				_projDataTree.removeCurrentNode();
				_changes_made = true;
			  }
			} else {
			  XMLException.show_error( _dialog, "Can't remove a component that you don't own." );
			}
		  } else {
			XMLException.show_error( _dialog, "Must select something." );
		  }
		}
	  } ));

	  toolbar.add ( createToolbarButton( "close.gif", "Close Workspace Manager", "close", new QueuedExecutable() {
		public void execute() {
		  if( XMLException.show_confirm( _dialog, "Are you sure you want to close the Workspace Manager?" ) ) {
			destroy();
			System.exit(0);
		  }
		}
	  } ));

	  if( modal ) { 
		aButton = toolbar.add ( new QueuedExecutable( null, getIcon("select.gif") ) {
		  public void execute() {
			XMLComponent comp = _projDataTree.getSelectedNode(null,3); 
			if( comp != null ) {
			  System.out.println("Selected node: " + comp.ID() );
			  _selectedModel = (Model)comp;
			  _selectedProject = (Project)comp.getParent();
			  _modelSelected = true;
			  dispose();
			} else {
			  XMLException.show_error( _dialog, "Must select a Model." );
			}
		  }
		} ); 
		aButton.setToolTipText( "select model" );
		aButton.setAlignmentY(0.5f);
	  }
	  
	  toolbar.add( new JLabel( "  Project Manager" ) );
/*
	  toolbar.add( Box.createHorizontalGlue());

	  aButton = toolbar.add ( 
		new AbstractAction( null, getIcon("question.gif")  ) {
		  public void actionPerformed(ActionEvent e) { ; } 
		} 
	  ); 
	  aButton.setToolTipText( "help" );
	  aButton.setAlignmentY( Component.TOP_ALIGNMENT );
	  HelpBroker hb = SimIO.getHelpBroker( "SME"  );
	  hb.enableHelpOnButton( aButton, "WSManager", null );
*/	  
	  _dialog.setContentPane( top );
	  _dialog.setJMenuBar( constructMenuBar() );
	  _dialog.setSize(800,650);
	  
	  Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
	  int x = (screenDim.width - _dialog.getSize().width) / 2;
	  int y = (screenDim.height - _dialog.getSize().height) / 2;
	  _dialog.setLocation(x, y);	   
	  _dialog.setVisible(true);
	  return _modelSelected;
   }

    private  JMenuBar constructMenuBar() {
	  JMenu            menu;
	  JMenuBar         menuBar = new JMenuBar();
	  JMenuItem        menuItem;


	  menu = new JMenu("Workspace");
	  menuBar.add(menu);

	  menuItem = menu.add(new JMenuItem("New"));
	  menuItem.addActionListener( new NewWSAction() ); 
	   
	  menuItem = menu.add(new JMenuItem("Open"));
	  menuItem.addActionListener( new OpenWSAction() );  
/*
	  menuItem = menu.add(new JMenuItem("AddUser"));
	  menuItem.addActionListener( new AddUserToWSAction() );  
*/
	  menuItem = menu.add(new JMenuItem("Remove"));
	  menuItem.addActionListener( new RemoveWSAction() );

	  menuItem = menu.add(new JMenuItem("Update Portal"));
	  menuItem.addActionListener( new UpdatePortalAction() );

	  menuItem = menu.add(new JMenuItem("Save"));
	  menuItem.addActionListener( new SaveWSAction() );  

	  menuItem = menu.add(new JMenuItem("Quit"));
	  menuItem.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) { destroy(); System.exit(0); }
	  });

	  menu = new JMenu("Project");
	  menuBar.add(menu);

	  if( _interaction_mode != PORTAL_MODE ) {
		menuItem = menu.add(new JMenuItem("New"));
		menuItem.addActionListener( new AddProjectAction() );
	  }
	  
	  menuItem = menu.add(new JMenuItem("Add"));
	  menuItem.addActionListener( new ImportProjectAction() );
/*	  
	  menuItem = importMenu.add(new JMenuItem("personal copy"));
	  menuItem.addActionListener( new ImportProjectAction(true) );
	  
	  menuItem = importMenu.add(new JMenuItem("shared link"));
	  menuItem.addActionListener( new ImportProjectAction(false) );
*/	  
	  
	  menuItem = menu.add(new JMenuItem("Duplicate"));
	  menuItem.addActionListener( new CopyProjectAction() );
	  menuItem = menu.add(new JMenuItem("Update"));
	  menuItem.addActionListener( new UpdateProjectAction() );
	  menuItem = menu.add(new JMenuItem("Remove"));
	  menuItem.addActionListener( new DeleteProjectAction() );

	  menu = new JMenu("Model");
	  menuBar.add(menu);

 	  menuItem = menu.add(new JMenuItem("Add"));
	  menuItem.addActionListener( new AddModelAction() );

	  JMenu importMenu = new JMenu("Import");
	  menu.add(importMenu);
	  
 	  menuItem = importMenu.add(new JMenuItem("STELLA eqn file"));
	  menuItem.addActionListener( new ImportModelAction() );
	  
	  menuItem = menu.add(new JMenuItem("Edit"));
	  menuItem.addActionListener( new BrowseModelAction() );
	  menuItem = menu.add(new JMenuItem("Configure"));
	  menuItem.addActionListener( new ConfigureModelAction(MODEL) );
	  menuItem = menu.add(new JMenuItem("Delete"));
	  menuItem.addActionListener( new DeleteModelAction() );

	  menu = new JMenu("Scenario");
	  menuBar.add(menu);
	  menuItem = menu.add(new JMenuItem("Configure"));
	  menuItem.addActionListener( new ConfigureModelAction(SCENARIO) );
	  menuItem = menu.add(new JMenuItem("Build"));
	  menuItem.addActionListener( new BuildModelAction() );
	  
	  JMenu run_menu = new JMenu("Run");
	  menu.add(run_menu);
	  menuItem = run_menu.add(new JMenuItem("standard"));
	  menuItem.addActionListener( new RunModelAction(false) );
	  menuItem = run_menu.add(new JMenuItem("java debug"));
	  menuItem.addActionListener( new RunModelAction(true) );
	  
	  menuItem = menu.add(new JMenuItem("Delete"));
	  menuItem.addActionListener( new DeleteModelAction() );

	  menu = new JMenu("Data");
	  menuBar.add(menu);
	  menuItem = menu.add(new JMenuItem("View"));
	  menuItem.addActionListener( new ViewDataAction() );
	  menuItem = menu.add(new JMenuItem("Delete"));
	  menuItem.addActionListener( new DeleteDataAction() );

	  menu = new JMenu("Help");
	  menuBar.add(menu);
	  
	  try {
		HelpBroker hb = SimIO.getHelpBroker( "SME", "ProjectHandler" );
		menuItem = menu.add(new JMenuItem("SME Help"));
		menuItem.addActionListener(  new CSH.DisplayHelpFromSource(hb)  );
		CSH.setHelpIDString(menuItem, "top" );

		menuItem = menu.add(new JMenuItem("WorkSpace Manager Help"));
		menuItem.addActionListener( new CSH.DisplayHelpFromSource(hb)  );
		CSH.setHelpIDString(menuItem, "WSManager" );

		menuItem = menu.add(new JMenuItem("User Manager Help"));
		menuItem.addActionListener( new CSH.DisplayHelpFromSource(hb)  );
		CSH.setHelpIDString(menuItem, "UserManager" );
	  } catch ( Exception err ) {
		SimIO.show_error(null,"Error loading helpset");
	  }

	  return menuBar;
    }
 
     protected JButton createToolbarButton( String icon, String tooltip, String actionCommand, Action a ) {
		JButton b = new JButton( getIcon(icon) ) {
				public float getAlignmentY() { return 0.5f; }
		};
		b.setRequestFocusEnabled(false);
		b.setMargin(new Insets(1,1,1,1));
		b.setToolTipText(tooltip);
		b.setActionCommand(actionCommand);
		b.addActionListener(a);
        return b;
    }  
     
	public  Model selectedModel() { return _selectedModel; }
	public  Project selectedProject() { return _selectedProject; }
    
	class OpenWSAction extends QueuedExecutable  {
	  public void execute()  {
		JFileChooser chooser = new JFileChooser( _root_directory + "/workspace/" );
		ExtensionFileFilter filter = new ExtensionFileFilter("xml","WorkSpace specifications"); 
		chooser.setFileFilter(filter);		  
		int returnVal = chooser.showDialog( _dialog.getContentPane(), "select" );
		if(returnVal == JFileChooser.APPROVE_OPTION) {
			String path = chooser.getSelectedFile().getAbsolutePath();
			readXML( path, null ); 
			_changes_made = true;
		}
	  }
    } 

	class NewWSAction extends QueuedExecutable  {
	  public void execute()  {
		Wizard w = Wizard.getWizard( "WorkSpace.open", null );
		if( w == null ) {
		  XMLException.show_error( _dialog, "Can't open wizard:  WorkSpace.open" );
		} else {
		  w.addAttribute( "Workbench.name", _workbench_name );
		  String username  = System.getProperty("user.name");
		  w.addAttribute( "user.name", username );
		  w.show( true, new ScriptExecutable(false) {
			public void executionCallback( String stdout, String stderr, XMLComponent executer ) {
			  String name = (String) executer.getDataProperty( "WorkSpace.name", "value" );
			  String id = (String) executer.getDataProperty( "WorkSpace.id", "value" );
			  String doc = (String) executer.getDataProperty( "WorkSpace.doc", "value" );
			  String owner = (String) executer.getDataProperty( "WorkSpace.owner", "value" );
			  String public_mode = (String) executer.getDataProperty( "WorkSpace.mode", "value" );
			  if( _debug ) { System.out.println("Adding Workspace: " + name + "; " + id + " (" + doc + ") " ); }
			  WorkSpace ws = addWorkSpace(  id, name, doc, owner, Boolean.valueOf(public_mode).booleanValue() );
			  if( ws != null ) {
//				ws.unresolve();
				_changes_made = true;
			  }
			}
		  } );
		}
	  }
    } 

	class RemoveWSAction extends QueuedExecutable  {
	  public void execute() {
		XMLComponent c = _projDataTree.getSelectedNode( 2 ) ;
		if( c != null ) {
		  if( XMLException.show_confirm( _dialog, "Are you sure you want to remove this Workspace?" ) ) {
			System.out.println("Removing node: " + c.ID() );
			_projDataTree.removeCurrentNode();
			_changes_made = true;
		  }
		} else {
		  XMLException.show_error( _dialog, "Must select a WorkSpace" );
		}
	  }
    } 

	class AddProjectAction extends QueuedExecutable {  
	  public void execute() {
		_current_workspace = (WorkSpace) _projDataTree.getSelectedNode( 2 ) ;
		if( _current_workspace != null ) {
		  String[] args = { getWSDirectory(_current_workspace) };
		  Wizard w = Wizard.getWizard( "Project.open", args );
		  if( w == null ) { 
			XMLException.show_error( _dialog, "Can't find Wizard: Project.open" );
			return;
		  }
		  w.addAttribute( "Workbench.name", _workbench_name );
		  w.show( true , new ScriptExecutable(false) {
			public void executionCallback( String stdout, String stderr, XMLComponent executer ) {
			  String name = (String) executer.getDataProperty( "Project.name", "value" );
			  String id = (String) executer.getDataProperty( "Project.id", "value" );
			  String doc = (String) executer.getDataProperty( "Project.doc", "value" );
			  String pdir =  _root_directory + "/workspace/" + id;
			  addProject( _current_workspace, id, name, pdir, doc );
			  _changes_made = true;
			}
		  } );
		} else {
		  XMLException.show_error( _dialog, "Must select a WorkSpace" );
		}
	  }
    } 
    
    public String getWSDirectory(WorkSpace ws) {
		return _root_directory + "/" + ws.ID();
    }
    
	class DirectoryFilter extends javax.swing.filechooser.FileFilter {
	  public boolean accept(File pathname) {
		  return pathname.isDirectory();
	  } 
	  public String getDescription() { return "Project directories"; }
	}

	class STELLAFileFilter extends javax.swing.filechooser.FileFilter {
	  public boolean accept(File pathname) {
		  String fname = pathname.getName();
		  return fname.endsWith(".eqns");
	  } 
	  public String getDescription() { return "STELLA eqn file (*.eqns)"; }
	}

	class AllFileFilter extends javax.swing.filechooser.FileFilter {
	  public boolean accept(File pathname) {
		  return true;
	  } 
	  public String getDescription() { return "All Files"; }
	}

	class ImportProjectAction extends QueuedExecutable {
	  public void execute() {
		_current_workspace = (WorkSpace) _projDataTree.getSelectedNode( 2 ) ;
		if( _current_workspace != null ) {
			ImportProjectIntoWorkspace( _current_workspace );
		} else {
		  XMLException.show_error( _dialog, "Must select a WorkSpace" );
		}
	  }
	}
    
    void ImportProjectIntoWorkspace( WorkSpace ws ) {
	  _current_workspace = ws;
	  String ws_dir = getWSDirectory(ws);
	  SimIO.print("Importing project into WorkSpace " + ws.ID() + ", dir= " + ws_dir );
	  JFileChooser chooser = new JFileChooser(ws_dir);
	  chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
	  chooser.setFileFilter( new DirectoryFilter() );
	  int returnVal = chooser.showDialog( _dialog.getContentPane(), "select" );
	  if(returnVal == JFileChooser.APPROVE_OPTION) {
		String path = chooser.getSelectedFile().getAbsolutePath();
		CreateImportedProject( path, ws_dir );
		_changes_made = true;
	  }
	}
	
	void importModelSpecs( Project p, Model m ) {
	   ScriptExecutable ex = new ScriptExecutable( false ) {
		  public void errorCallback( int returnValue, String stdout, String stderr ) {
			if( returnValue != 0 ) { 
				_error_flag = true; 
				super.errorCallback( returnValue, stdout, stderr );
				SimIO.show_error(null,"Error importing Model Specs!"); 
			}	
		  }   
		  public void executionCallback( String stdout, String stderr, XMLComponent executer ) {
			   super.executionCallback( stdout, stderr, executer );
		  }
	   };
	   File modelDir = new File( p.getDirectory()  + "/Models/" + m.getName() );
	   if( _debug ) { System.out.println("Adding Model Specs to Project " + p + ", dir: " + modelDir  ); }
	   if( ! modelDir.canRead() ) {
		  XMLException.show_error( _dialog, "Error acccessing model dir: " + modelDir );
		  return;
	   }
	   String ws_mdir = _root_directory + "/workspace/projects/" + p.ID() + "/";
	   File ws_model_dir = new File(ws_mdir);
	   if( ws_model_dir.isDirectory() || ws_model_dir.mkdirs() ) {
		 String script = "cp -r " + modelDir + " " + ws_mdir;
		 ex.execute( script, null);
	   } else {
		  XMLException.show_error( _dialog, "Cant create ws model dir: " + ws_mdir );
	   }
	}
	
 	void importScenarioSpecs( Project p, Model m, String scen_id ) {
/*
	   ScriptExecutable ex = new ScriptExecutable( false ) {
		  public void errorCallback( int returnValue, String stdout, String stderr ) {
			if( returnValue != 0 ) { 
				_error_flag = true; 
				super.errorCallback( returnValue, stdout, stderr );
				SimIO.show_error(null,"Error importing Scenario Specs!"); 
			}	
		  }   
		  public void executionCallback( String stdout, String stderr, XMLComponent executer ) {
			   super.executionCallback( stdout, stderr, executer );
		  }
	   };
	   File scenDir = new File( p.getDirectory()  + "/Models/" + m.getName() + "/" + scen_id + "/"  );
	   if( ! scenDir.canRead() ) { return; }
	   if( _debug ) { System.out.println("\nAdding Scenario Specs to Project " + p + ", dir: " + scenDir  ); }
	   String ws_sdir = _root_directory + "/workspace/projects/" + p.ID() + "/" + m.getName() + "/" ;
	   File ws_model_dir = new File(ws_sdir);
	   if( ws_model_dir.isDirectory() || ws_model_dir.mkdirs() ) {
		 String script = "cp -r " + scenDir + " " + ws_sdir;
		 ex.execute( script, null);
	   } else {
		  XMLException.show_error( _dialog, "Cant create ws model dir: " + ws_sdir );
	   }
*/
	}
 	  public void importSimulationRun(SimulationRun sr ) {
		File data_file = sr.getDataFile();
		Scenario s = (Scenario) sr.getParent();
		String data_file_path = data_file.getPath();
		if( ! data_file.canRead() ) {
		  XMLException.show_error( _dialog, "Error acccessing data file: " + data_file_path );
		  return;
		}
		ScriptExecutable ex = new ScriptExecutable( false ) {
			public void errorCallback( int returnValue, String stdout, String stderr ) {
			  if( returnValue != 0 ) { 
				  _error_flag = true; 
				  super.errorCallback( returnValue, stdout, stderr );
				  SimIO.show_error(null,"Error importing Simulation Run!"); 
			  }	
			}   
			public void executionCallback( String stdout, String stderr, XMLComponent executer ) {
				 super.executionCallback( stdout, stderr, executer );
			}
		};
	  	Model m = (Model) s.getParent();
	  	Project p = (Project) m.getParent();
		String model_name = (String) m.getProperty("name");
		if( _debug ) { System.out.println("Adding Simulation Run to Model " + m.ID() + ", dfile: " + data_file_path  ); }
		String ws_sdir = _root_directory + "/workspace/data/" + s.ID() + "/";
		File ws_scen_dir = new File(ws_sdir);
		if( ws_scen_dir.isDirectory() || ws_scen_dir.mkdirs() ) {
		  String script = "cp " + data_file_path + " " + ws_sdir;
		  ex.execute( script, null);
		} else {
		  XMLException.show_error( _dialog, "Cant create ws scenario dir: " + ws_sdir );
		}
	}
   
	void CreateImportedProject( String proj_directory, String ws_dir )  {
		 File proj_dir_file = new File(proj_directory);
		 File[] proj_sub_dirs = proj_dir_file.listFiles();
		 boolean has_driver = false, has_models = false;
		 if( proj_sub_dirs != null ) {
		   for( int i=0; i<proj_sub_dirs.length; i++ ) {
			 String sub_file = proj_sub_dirs[i].getName();
			 if( sub_file.equals("Driver") ) { has_driver = true; }
			 else if( sub_file.equals("Models") ) { has_models = true; }
		   }
		 }
		 if( has_driver && has_models ) {
			String proj_name = proj_dir_file.getName();
			File project_parent_dir = proj_dir_file.getParentFile();
			System.out.println("Importing project " + proj_name + " from: " + proj_directory );
			Project p = (Project) addProject( _current_workspace, proj_name, proj_name, proj_directory, "Imported project" );
			_changes_made = true;			   
			
/*		 copy or link project into workspace 
			File ws_directory_file = new File( ws_dir );
	
			if( !project_parent_dir.equals(ws_directory_file) ) {
			} else {
			}
*/
		 } else {
		   XMLException.show_error( _dialog, "Not a valid project directory: " + proj_directory );
		 }
	} 
 
 
 	class UpdatePortalAction extends QueuedExecutable {
	  public void execute() {
		processScenarios();
		String run_script = " sme_portal_mgr jar ";
		System.out.println( "Updating portal with script: " + run_script );
		ScriptExecutable se = new ScriptExecutable(false);
		se.execute(run_script,null);
	  }
 	}
 	
 	class UpdateProjectAction extends QueuedExecutable {
	  public void execute() {
		_current_project = (Project) _projDataTree.getSelectedNode( 3 ) ;
		if( _current_project != null ) {
			addModels( _current_project );
		}
	  }
 	}
	  
	class AddModelAction extends QueuedExecutable {
	  public void execute() {
		_current_project = (Project) _projDataTree.getSelectedNode( 3 ) ;
		if( _current_project != null ) {
		  _current_workspace = (WorkSpace) _current_project.getParent();
		  String import_directory = (String) _current_project.getDirectory();
		  if( import_directory == null ) {
			String[] args = { getWSDirectory(_current_workspace), _current_project.ID(), _current_project.toString()  };
			Wizard w = Wizard.getWizard( "Model.open", args );
			if( w == null ) { 
			  XMLException.show_error( _dialog, "Can't find Wizard: Model.add" );
			  return;
			}
			w.addAttribute( "Workbench.name", _workbench_name );
			w.show( true , new ScriptExecutable(false) {
			  public void executionCallback( String stdout, String stderr, XMLComponent executer ) {
				String name = (String) executer.getDataProperty( "Model.name", "value" );
				String id = (String) executer.getDataProperty( "Model.id", "value" );
				String doc = (String) executer.getDataProperty( "Model.doc", "value" );
				addModel( _current_project, id, name, doc );
				_changes_made = true;
			  }
			} );
		  } else {
			DirectoryChooser dc = DirectoryChooser.create( import_directory + "/Models/" );
			dc.addActionListener( new CreateImportedModelAction() );
			dc.show(true);
		  }
		} else {
		  XMLException.show_error( _dialog, "Must select a Project" );
		}
	  }
    } 

	class CreateImportedModelAction extends Object implements ActionListener {
	  public void actionPerformed(ActionEvent e) {
		 String model_directory = e.getActionCommand();
		 File model_dir_file = new File(model_directory);
		 String model_name = model_dir_file.getName();
		 addModel( _current_project, model_name, model_name, "Imported Model" );
		 _changes_made = true;
	   }
	} 

	class CopyProjectAction extends QueuedExecutable  {
	  public void execute() {
		Project proj = (Project) _projDataTree.getSelectedNode( 3 );
		if( proj != null ) {
		  _current_workspace = (WorkSpace) proj.getParent();
		  String ws_dir =  getWSDirectory(_current_workspace);
		  String[] args = { proj.ID(), ws_dir, (String) proj.getProperty("name"), (String) proj.getProperty("id"), (String) proj.getProperty("doc") };
		  Wizard w = Wizard.getWizard( "Project.copy", args );
		  if( w == null ) { 
			XMLException.show_error( _dialog, "Can't find Wizard: Project.copy" );
			return;
		  }
		  w.setSaveData(false);
		  w.addAttribute( "Workbench.name", _workbench_name );
		  w.show( true , new ScriptExecutable(false) {
			public void executionCallback( String stdout, String stderr, XMLComponent executer ) {
			  String name = (String) executer.getDataProperty( "Project.name", "value" );
			  String id = (String) executer.getDataProperty( "Project.id", "value" );
			  String doc = (String) executer.getDataProperty( "Project.doc", "value" );
			  String pdir =  _root_directory + "/workspace/" + id;
			  addProject( _current_workspace, id, name, pdir, doc );
			  _changes_made = true;
			}
		  } );
		} else {
		  XMLException.show_error( _dialog, "Must select a Project" );
		}
	  }
    } 
    
	class DeleteProjectAction extends QueuedExecutable  {
	  public void execute() {
		Project proj = (Project) _projDataTree.getSelectedNode( 3 ) ;
		if( proj != null ) {
		  if( proj.isOwner() ) {
			if( XMLException.show_confirm( _dialog, "Are you sure you want to remove this Project?" ) ) {
			  System.out.println("Removong node: " + proj.ID() );
			  _projDataTree.removeCurrentNode();
			  _changes_made = true;
			  if( XMLException.show_confirm( _dialog, "Remove Project files from WorkSpace?" ) ) {
			   ScriptExecutable ex = new ScriptExecutable( false );
	  		   String proj_directory = (String) proj.getDirectory();
	  		   System.out.println("Removing project files: " + proj_directory );
			   String script = "rm -rf " + proj_directory;
			  }
			}
		  } else {
			XMLException.show_error( _dialog, "Can't remove a Project that you don't own." );
		  }
		} else {
		  XMLException.show_error( _dialog, "Must select a Project" );
		}
	  }
    } 

	class ViewDataAction extends QueuedExecutable  {
	  public void execute() {
		SimulationRun sr = (SimulationRun) _projDataTree.getSelectedNode( 6 ) ;
		if( sr != null ) {
		  if( _getModelsFromServlet ) { getSimulationDataFromServlet(sr); }
		  else { getSimulationDataFromDisk(sr); }
		} else {
		  XMLException.show_error( _dialog, "Must select a SimulationRun DataSet" );
		}
	  }
	}
	
	class DeleteDataAction extends QueuedExecutable  {
	  public void execute() {
		SimulationRun sr = (SimulationRun) _projDataTree.getSelectedNode( 6 ) ;
		Project p = (Project) _projDataTree.getSelectedNode( 3 ) ;
		if( sr != null ) {
		  if( p.isOwner() ) {
			if( XMLException.show_confirm( _dialog, "Are you sure you want to remove this DataSet?" ) ) {
			  System.out.println("Removong DataSet " + sr.ID() + " from project " + p.ID() );
			  _projDataTree.removeCurrentNode();
			  _changes_made = true;
			}
		  } else {
			XMLException.show_error( _dialog, "Can't remove a DataSet from a Project that you don't own." );
		  }
		} else {
		  XMLException.show_error( _dialog, "Must select a SimulationRun DataSet" );
		}
	  }
    } 

	class DeleteModelAction extends QueuedExecutable  {
	  public void execute() {
		Model model = (Model) _projDataTree.getSelectedNode( 4 ) ;
		if( model != null ) {
		  Project p = (Project) model.getParent();
		  if( p.isOwner() ) {
			if( XMLException.show_confirm( _dialog, "Are you sure you want to remove this Model?" ) ) {
			  System.out.println("Removong model " + model.ID() + " from project " + p.ID() );
			  _projDataTree.removeCurrentNode();
			  _changes_made = true;
			}
		  } else {
			XMLException.show_error( _dialog, "Can't remove a Model from a Project that you don't own." );
		  }
		} else {
		  XMLException.show_error( _dialog, "Must select a Model" );
		}
	  }
    } 

	class ConfigureModelAction extends QueuedExecutable  {
	  int _type;
	  ConfigureModelAction( int type ) { _type = type; }
	  public void execute() {
		TreePath selection_path = _projDataTree.getLeadSelectionPath();
		Model model = (Model) selection_path.getPathComponent(3);
		if( model != null ) {
		  Project proj = (Project) model.getParent();
		  _current_workspace = (WorkSpace) proj.getParent();
		  XMLHandler handler = model.getHandler();
		  String model_id = (String) model.getProperty("name"); 
//		  String setup_file = getWSDirectory(_current_workspace) + "/" + proj.ID() + "/Models/" + 
//		  												model_id + "/" + model_id + "_module.xml";
//		  System.out.println( "Configuring model " + model + ", model spec file: " + setup_file );
//		  XMLContainer root = handler.readTreeStructure( setup_file );
		  VariableConfigPanel vcp = new VariableConfigPanel( null, null );
		  String config_file = null;
		  if( _type == MODEL ) {
			config_file = getWSDirectory(_current_workspace) + "/" + proj.ID() + "/Config/" + 
																			model_id + ".conf";
		  } else {
			Scenario scen = (Scenario) selection_path.getPathComponent(4);
		    String scen_id = (String) scen.getProperty("name"); 
			if( scen == null ) {
			  XMLException.show_error( _dialog, "Must select a Scenario" );  
			} else {
			  config_file = getWSDirectory(_current_workspace) + "/" + proj.ID() + "/Config/" + 
			  												model_id + "." + scen_id + ".conf";
			}
		  }
		  boolean writable = proj.isOwner();
		  vcp.showConfigEditor(config_file,writable);
		} else {
		  XMLException.show_error( _dialog, "Must select a Model" );  
		}
	  }
    }

   public void view_selected_object() {
	 TreePath selection_path = _projDataTree.getLeadSelectionPath();
	 if( selection_path == null ) { 
		XMLException.show_error( _dialog, "Must select something." ); 
		return; 
	 }
	 try {
	   int depth = selection_path.getPathCount();
	   switch(depth) {
		 case 4:
			if( _getModelsFromServlet ) { getModelFromServlet( selection_path );}
			else { getModelFromXML( selection_path ); }
		 break;
		 case 5:
			startupSMEClient(selection_path);
		 break;
		 case 6:
			if( _getModelsFromServlet ) { getSimulationDataFromServlet((SimulationRun)selection_path.getLastPathComponent()); }
			else { getSimulationDataFromDisk((SimulationRun)selection_path.getLastPathComponent()); }
		 break;
	   }
	 } catch( Exception err ) {
	   SimIO.print("view_selected_object: " + err.getMessage() );
	   err.printStackTrace();
	 }
   }
 															  
   void startupSMEClient( TreePath selection_path ) {
	  Scenario s = (Scenario) selection_path.getPathComponent(4);
	  Model m = (Model) selection_path.getPathComponent(3);
	  Project p = (Project) selection_path.getPathComponent(2);
	  File proj_dir = new File(p.getDirectory());
	  WorkSpace ws = (WorkSpace) selection_path.getPathComponent(1);
	  ServletClient sc = ServletClient.getInstance();
	  String proj_directory = proj_dir.getParent();
	  try {
		String lhost = SimIO.getLocalHostAddress();
		String[] cdata;
		if( sc != null ) {
		  cdata = sc.startupSME( ws.ID(), p.ID(), m.getName(), s.toString(), lhost );
		} else {
		  cdata = SMEClient.startupSME( p.ID(), proj_directory, m.getName(), s.toString(), lhost, null );	  
		}
		if( cdata != null ) {
		  SimIO.print( "startup SME " + m.ID() + ", Scenario: " + s );
		  User u = _user_manager.getCurrentUser();
		  if( u == null ) {
			throw new Exception("Must choose a User");
		  }
		  SimIO.print( "User: " + u + ", run permission: " + u.canRunModels() );
		  String host = cdata[0];
		  String port = cdata[1];
		  SMEClient smeclient = null;
		  if( u.canRunModels() ) {
			smeclient = SMEClient.startupClient(port,host,m.ID(),s.toString(),false,true,false,SMEInterface.kRun,SMEInterface.kGUI);
		  } else {
			smeclient = SMEClient.startupClient(port,host,m.ID(),s.toString(),false,false,false,SMEInterface.kConfig,SMEInterface.kGUI);
		  }
		  if( smeclient != null ) {
			 _sme_interface = smeclient.getInterface();
		  }
		}
	  } catch ( Exception err ) {
		SimIO.show_error(null,"Error starting SME: ",err);
		err.printStackTrace();
	  }
  }
    
    void getModelFromServlet( TreePath selection_path ) {
	  Model model = (Model) selection_path.getPathComponent(3);
	  System.out.println( "getModelFromServlet: " + model.ID() );
	  Project proj = (Project) selection_path.getPathComponent(2);
	  WorkSpace ws = (WorkSpace) selection_path.getPathComponent(1);
	  String model_id = (String) model.getProperty("name");
	  MMLHandler handler = (MMLHandler) model.getHandler();
	  ServletClient sc = ServletClient.getInstance();
	  if( sc != null ) {
		XMLComponent c = (XMLComponent) sc.getModel(  ws.ID(), proj.ID(), model_id );
		System.out.println( "Browsing model " + proj + "." + model_id  + " in WorkSpace " + ws.ID() );
//			StringReader sr = new StringReader(mml_data);
		handler.browseArchiveFiles( c );
	  }
	  boolean writable = proj.isOwner();
    } 

    public WorkSpace getSelectedWorkSpace() {
		return (WorkSpace) _projDataTree.getSelectedNode( 2 ) ;
    } 

    void getModelFromXML( TreePath selection_path ) {
	  Model model = (Model) selection_path.getPathComponent(3);
	  Project proj = (Project) selection_path.getPathComponent(2);
	  WorkSpace ws = (WorkSpace) selection_path.getPathComponent(1);
	  XMLHandler handler = model.getHandler();
	  String model_id = (String) model.getProperty("name");
	  String proj_directory = (String) proj.getDirectory();
	  String setup_file = proj_directory + "/Models/" + model_id + "/" + model_id + "_module.xml";  
	  String resource = "workspace/projects/" + proj.ID() + "/" + model_id + "/" + model_id + "_module.xml";  
	  System.out.println( "Configuring model " + model + " with handler: " + handler + ", xml setup file: " + setup_file );
	  handler.showBrowser( setup_file, resource );
	  boolean writable = proj.isOwner();
    } 

    void getModelOutputFromServlet() {
		Model model = (Model) _projDataTree.getSelectedNode( 4 ) ;
		if( model != null ) {
		  Project proj = (Project) model.getParent();
		  String model_id = (String) model.getProperty("name");
		  WorkSpace ws = (WorkSpace) proj.getParent();
		  ServletClient sc = ServletClient.getInstance();
		  if( sc != null ) {
			int ndata = sc.getModelOutput(  ws.ID(), proj.ID(), model_id );
			System.out.println( "\ngetModelOutputFromServlet: Model: " + model_id + ", Project: " + proj.ID() + ",  ndata: " + ndata );
			if( ndata > 0 ) {
			  if( _dataViewer != null ) { _dataViewer.dispose(); }
			  _dataViewer = ViewserverControlPanel.create( -1, ViewserverControlPanel.kAuxComponent ) ;
			  _dataViewer.showFrame();
			} else {
			  SimIO.show_warning( null, "No simulation output for this model" );
			}
		  } else {
			SimIO.show_warning( null, "ServletClient not instantiated!" );
		  }
		  boolean writable = proj.isOwner();
		} else {
		  XMLException.show_error( null, "Must select a Model" );  
		}
    } 
    
    void getSimulationDataFromServlet( SimulationRun selection ) {
		String datapath = selection.getDataPath();
		ServletClient sc = ServletClient.getInstance();
		if( sc != null ) {
		  boolean has_data = sc.getSimulationData(  datapath );
		  if( has_data ) {
			System.out.println( "\ngetSimulationDataFromServlet, Path: " + datapath );
			if( _dataViewer == null ) { 
				_dataViewer = ViewserverControlPanel.create( -1, ViewserverControlPanel.kAuxComponent ) ;
			}
			_dataViewer.showFrame();
		  } else {
			SimIO.show_warning( null, "No simulation output for this model" );
		  }
		} else {
		  SimIO.show_warning( null, "ServletClient not instantiated!" );
		}
    } 
    
    String getResource( SimulationRun simrun ) {
	  Scenario s = (Scenario) simrun.getParent();
	  File df = simrun.getDataFile();
	  String resource = "workspace/data/" + s.ID() +"/" + df.getName();
	  return  resource;  
    }

    void getSimulationDataFromDisk( SimulationRun selection ) {  
	  String resource = getResource( selection );
	  LocalResolver lr = new LocalResolver();
	  InputStream ris = null;
	  File datafile = null;
	  if( resource != null ) {
		 ris = lr.loadResourceAsStream(resource);
		 if( _debug ) { System.out.println(" PH:: Loading resource: " + resource + " istream: " + ris ); }
	  }
	  if( ris == null ) {
		String datapath = selection.getDataPath();
		datafile = new File(datapath);
		System.out.println( "\ngetSimulationData, File: " + datapath );
	  } else {
		System.out.println( "\ngetSimulationData, Resource: " + resource );
	  }
	  if( _dataViewer == null ) { 
		  _dataViewer = ViewserverControlPanel.create( -1, ViewserverControlPanel.kAuxComponent ) ;
	  }
	  if(  ris != null ) {
		_dataViewer.importSimulationDataFromStream( ris );
	  } else if( (datafile != null) && datafile.canRead() ) {
		_dataViewer.importSimulationDataFromFile( datafile );
	  } else {
		SimIO.show_warning( null, "Can't read sim data: " + resource );
	  }
	  _dataViewer.showFrame();
  } 
	
	class BrowseModelAction extends QueuedExecutable  {
	  public void execute() { 
		 TreePath selection_path = _projDataTree.getLeadSelectionPath();
		 if( ( selection_path != null ) && ( selection_path.getPathCount() == 4 ) ){ 
		  getModelFromXML(selection_path); 
		} else {
		  XMLException.show_error( null, "Must select a Model" );  
		}	  
	  }
    } 

	class BuildModelAction extends QueuedExecutable  {
	  public void execute() {
		Scenario scen = (Scenario) _projDataTree.getSelectedNode( 5 ) ;
		if( scen != null ) {
		  Model model = (Model)  scen.getParent();
		  Project proj = (Project) model.getParent();
		  File proj_dir = new File(proj.getDirectory());
		  if( !proj_dir.canRead() ) {
			XMLException.show_error( _dialog, "Can't read project directory: " + proj_dir.getPath() );  
			return;
		  }
		  String model_id = (String) model.getProperty("name");
		  String scen_id = (String) scen.getProperty("name");
		  switch( _interaction_mode ) {
			case LOCAL_MODE: {
			  String run_script = " SME project " + proj.ID() + " " + proj_dir.getParent() + "; SME model " + model_id 
								  + "; SME scen " + scen_id + "; SME -nostop -xml build ";
			  System.out.println( "Building model " + model + " with run script: " + run_script );
			  ScriptExecutable se = new ScriptExecutable(false);
			  se.execute(run_script,model);
			} break;
			case GLOBUS_MODE: {
			  try {
				System.out.println( "Building model " + proj.ID() + " : " + model + " with globus "  );
				miiee.globus.SMEGram build_request = new miiee.globus.SMEGram( _local_host, proj.ID(), model_id );
				build_request.run(miiee.globus.SMEGram.SME_BUILD_CMD);
			  } catch( Exception err ) {
				SimIO.show_error( _dialog, "Globus error: ", err );
			  }
			} break;
		  }
		  boolean writable = proj.isOwner();
		} else {
		  XMLException.show_error( _dialog, "Must select a Scenario" );  
		}
	  }
    } 

	class ImportModelAction extends QueuedExecutable  {
	  public void execute() {
		Model model = (Model) _projDataTree.getSelectedNode( 4 ) ;
		if( model != null ) {
		  Project proj = (Project) model.getParent();
		  WorkSpace ws = (WorkSpace) proj.getParent();
		  File proj_dir = new File(proj.getDirectory());
		  if( !proj_dir.canRead() ) {
			XMLException.show_error( _dialog, "Can't read project directory: " + proj_dir.getPath() );  
			return;
		  }
		  String model_id = (String) model.getProperty("name");
		  String models_dir = proj.getDirectory() + "/Models/";
		  JFileChooser chooser = new JFileChooser( models_dir );
		  File model_dir = new File( models_dir );
		  chooser.addChoosableFileFilter( new STELLAFileFilter() );
		  chooser.addChoosableFileFilter( new AllFileFilter() );
		  chooser.setCurrentDirectory( model_dir );
		  int returnVal = chooser.showDialog( _dialog.getContentPane(), "Select STELLA Equation File" );
		  if(returnVal == JFileChooser.APPROVE_OPTION) {
			  String eqn_file_path = chooser.getSelectedFile().getAbsolutePath();
			  switch( _interaction_mode ) {
				case LOCAL_MODE: {
				  String run_script = " SME project " + proj.ID() + " " + proj_dir.getParent() + "; SME model " + model_id + ";  SME import " + eqn_file_path;
				  System.out.println( "Importing model " + model + " with run script: " + run_script );
				  ScriptExecutable se = new ScriptExecutable(false);
				  se.execute(run_script,model);
				} break;
				case GLOBUS_MODE: {
				  try {
					System.out.println( "Importing model " + proj.ID() + " : " + model + " with globus "  );
					miiee.globus.SMEGram build_request = new miiee.globus.SMEGram( _local_host, proj.ID(), model_id );
					build_request.run(miiee.globus.SMEGram.SME_BUILD_CMD);
				  } catch( Exception err ) {
					SimIO.show_error( _dialog, "Globus error: ", err );
				  }
				} break;
			  }
			  boolean writable = proj.isOwner();
		  }
		} else {
		  XMLException.show_error( _dialog, "Must select a Model" );  
		}
	  }
    } 

	class RunModelAction extends QueuedExecutable  {
	  boolean _debug;
	  public RunModelAction( boolean java_debug ) { _debug = java_debug; }
	  public void execute() {
		Scenario scen = (Scenario) _projDataTree.getSelectedNode( 5 ) ;
		if( scen != null ) {
		  Model model = (Model)  scen.getParent();
		  Project proj = (Project) model.getParent();
		  try {
			proj.setProperty( "uptodate", Boolean.FALSE );
		  } catch (XMLException err) {
			XMLException.show_error( _dialog, "Can't set uptodate property for " + proj.ID() );  
		  }
		  _project_stack.push(_current_project);
		  File proj_dir = new File(proj.getDirectory());
		  if( !proj_dir.canRead() ) {
			XMLException.show_error( _dialog, "Can't read project directory: " + proj_dir.getPath() );  
			return;
		  }
		  File proj_parent = proj_dir.getParentFile();
		  String model_id = (String) model.getProperty("name");
		  String scen_id = (String) scen.getProperty("name");
		  switch( _interaction_mode ) {
			case LOCAL_MODE: {
			  String run_script = " SME project " + proj.ID() + " " + proj_dir.getParent() + "; SME model " + model_id + "; SME scen " + scen_id;
			  if( _debug ) {
				 run_script += "; SME -CSdebug 1 -java local run ";
			  } else {
				 run_script += "; SME -java local run ";
			  }
			  System.out.println( "\nxx Running model " + model + " with run script: " + run_script );
			  ScriptExecutable se = new ScriptExecutable(false);
			  se.execute(run_script,model);
			} break;
			case GLOBUS_MODE: {
			  try {
				System.out.println( "Running model " + proj.ID() + " : " + model + " with globus "  );
				miiee.globus.SMEGram build_request = new miiee.globus.SMEGram( _local_host, proj.ID(), model_id );  
				build_request.run(miiee.globus.SMEGram.SME_RUN_CMD);  
			  } catch( Exception err ) {
				SimIO.show_error( _dialog, "Globus error: ", err );
			  }
			} break;
		  }
		  boolean writable = proj.isOwner();
		} else {
		  XMLException.show_error( _dialog, "Must select a Scenario" );  
		}
	  }
    } 
    
//    public static String getModelName( String model_id ) {
//	  StringTokenizer st = new StringTokenizer(model_id, ".");
//	  while( st.hasMoreTokens() ) { model_id = st.nextToken(); }
//	  return model_id;
//    }

	void processScenarios() {
	  if( _debug ) { System.out.print( " Processing Scenarios: " ); }
	  while( !_project_stack.empty() ) {
		Project p = (Project) _project_stack.pop();
		Object proj_status = p.getProperty( "uptodate" );
		try {
		  boolean uptodate =  (proj_status == null) ? false : Boolean.getBoolean( proj_status.toString() );
		  if( !uptodate ) {
			if( _debug ) { System.out.print( p.ID() + " " ); }
			addModels(p);
			try {
			  p.setProperty( "uptodate", Boolean.TRUE );
			} catch (XMLException err) {
			  XMLException.show_error( _dialog, "Can't set uptodate property for " + p.ID() );  
			}
		  }
		} catch ( Exception err ) {
		  System.out.println( "Error processing uptodate property for " + p.ID() + ", value = " + proj_status ); 
		}
	  }
	  if( _debug ) { System.out.println( "" ); }
	}
  
  public XMLComponent getComponentFromName( String name, Attributes atts, XMLComponent parent, boolean create ) {
	if( _debug ) { System.out.println( " getComponentFromName: " + name ); }
	XMLComponent rv = null;
	try {
	  if( name.equals("workspace_root") ) {
		_hasModels = false; 
		rv = _tree_root = new WorkSpaceRoot( atts );
	  }
	  else if( name.equals("workspace") ) {
		_hasModels = false; 
		rv = new WorkSpace( atts );
		rv.unresolve();
		if( _debug ) { System.out.println( " Unresolve " + name + " component: " + rv ); }
		if( _filter_workspaces ) {
		  User u = _current_user;
		  u.decodeWorkSpaces(null);
		  SimIO.print("Filtering WS " + rv.ID() + " for user " + u );
		  if( u != null ) { u.printWorkSpaces(); }
		  if( ( u == null ) || !u.hasWorkSpace( rv.ID() ) ) {
			return rv;
		  } else {
			addChildToContainer( (XMLContainer) parent, rv );
		  }
		} else {
		  addChildToContainer( (XMLContainer) parent, rv );
		}
/*
		String root = _rootSourceID;
		if( root.startsWith("file:") ) {
		  root = root.substring(5);
		}
		if( root.startsWith("//") ) {
		  root = root.substring(1);
		}
*/

	  }
	  else if( name.equals("project") ) {
		rv = new Project( atts, (XMLContainer)parent );
		_current_project = (Project) rv;
		_current_project.setProperty( "uptodate", Boolean.FALSE  );
		_project_stack.push(_current_project);
	  }
	  else if( name.equals("model") ) {
		_hasModels = true; 
		rv = new Model( atts, (XMLContainer)parent );
	  } 
	  else if( name.equals("scenario") ) {
		rv = new Scenario( atts, (XMLContainer)parent );
	  } 	  
	  else if( name.equals("simulation_run") ) {
		rv = new SimulationRun( atts, (XMLContainer)parent );
	  } 	  
	  if( rv != null ) { 
		rv.stampComponent(); 
	  }
	} catch ( Exception err ) {
	  System.out.println("GetComponentFromName Error: " );
	  err.printStackTrace();
	}
	return rv; 
  }

  public void readXML() throws SNPException { readXML( (WorkSpace)null ) ; }

  public void readXML( String user_name ) throws SNPException { 
	if( _user_manager == null ) {
	  _user_manager = new UserRegister( this );
	}
	User u = _user_manager.getUser(user_name);
	if( u == null ) {
	  SimIO.show_error( null, "User " + user_name + " not defined" ); 
	  return;
	}
	_current_user = u;
	if( _interaction_mode == PORTAL_MODE ) {
	  _filter_workspaces = true;
	  WorkSpace ws = u.getWebSpace();
	  readXML( ws );
	} else {
	  readXML();
	}
  }
  public void readXML( WorkSpace ws ) throws SNPException { 
	String ws_file_name = _workbench_name + ".xml";
	String ws_resource = "workspace/" + _workbench_name + ".xml";
	String ws_root = _root_directory + "/workspace/";
	File ws_file = new File(ws_root,ws_file_name);
	try {
		String  defaults_file = ws_root + "/" + ws_file_name;
		System.out.println("Reading workspace file " + defaults_file );
		read( defaults_file, null, null, XMLComponent.DEFINITION, null, ws_resource  );
	} catch (java.security.AccessControlException err ) {
		String error = "Access error in reading Workbench xml spec from server, Workbench root URI = " + ws_root;
		SimIO.print(error);	
		err.printStackTrace();
		try {
			File ws_dir = new File(ws_root);
			if( ws_dir.isDirectory() || ws_dir.mkdirs() ) {
			  ws = addWorkSpace(  "private", "Private Workspace", "", "Private Workspace for user " + 
											  System.getProperty("user.name"), false );
			  if( ws != null ) {
//				ws.unresolve();
				_changes_made = true;
			  } else throw new SecurityException("Can't create Workspace in: "  + ws_root );
			} else throw new SecurityException("Can't create directory: "  + ws_root );
		} catch ( SecurityException serr ) {
			SimIO.show_error( null, "Can't create Workspace directory", serr ); 
		}
	}	
  }
  
  public void readXML( String location, XMLComponent parse_root ) { 
	File ws_file = new File(location);
	if( ws_file.canRead() ) {
		System.out.println("Reading workspace file: " + location + ", setting Parse Root: " + parse_root );
		try {
		  read( location, null, null, XMLComponent.DEFINITION, parse_root );
		} catch( java.lang.Throwable err ) {
		  SimIO.print("Unable to read workspace file: " +  location );
		}
	} else {
		SimIO.show_warning( null, " Can't find WorkSpace file: "  + location ); 
	}
  }
	
  public void writeXML() { 
	String  xml_file =  _workbench_name;
 	String dtd_file = "workspace";
 	XMLContainer xc = getTreeRoot();
 	String ws_dir = _root_directory + "/workspace/";
	File file = new File(ws_dir);
	if( !file.isDirectory() ) {
	  if( !file.mkdirs() ) {
		SimIO.show_error( null, "Can't create WorkSpace directory: " + ws_dir );
		return;
	  } 
	}
 	SimIO.print("Writing workspace node " +  xc.ID() + " to " + ws_dir + ", file: " + xml_file + "\n" );
	xc.setNamespace(ws_dir);
 	xc.writeXML( xml_file, dtd_file, XMLComponent.DEFINITION );	  
  }

  public  boolean overrideCurrentProjectAcro( String proj_acro ) {
	Project p = _current_project;
	if( !p.ID().equals(proj_acro) ) {
	  System.out.println( "Warning, incorrect project acronym ignored: " + p.ID() + " in project " + proj_acro );
	  try {
		p.setProperty( "id", proj_acro );
	  } catch( XMLException err ) {
		System.out.println( err.getMessage() );
	  }
	  return true;
	}
	return false;
  }
  
  public  boolean  hasModels() { return _hasModels; }
  public void setLocalhost( String local_host ) { _local_host = local_host; }
 
   public void endDocument() throws SAXException { 
	  super.endDocument();
	  if( _interaction_mode == WORKBENCH_MODE ) { processScenarios(); }
   }
   
   public void  setRootDirectory( String dir ) { _root_directory = dir; }

  public static void main(String args[]) {
 	    
	  if (args.length < 1) {
		  System.err.println ("Usage: miiee.mml.ProjectHandler [ options ] <workbench_name>");
		  System.exit (1);
	  }

	int int_mode = LOCAL_MODE;
	boolean demo_mode = false;
	String workbench_name = "SME";
	String user_name = System.getProperty("user.name");
	String local_host = null;
	boolean show_users_panel = false;
	
	for( int i=0; i<args.length; i++ ) {
		String arg = args[i];
		System.out.println("Processing arg: " + arg + ":  " );
		
		if( arg.equals("-help") ) {
		  String id = null;
		  if( i <= ( args.length - 2 ) ) { id = args[i+1]; }
		  HelpBroker hb = SimIO.getHelpBroker( "SME", "ProjectHanlder" );
		  if( id != null ) { hb.setCurrentID(id); }
		  hb.setDisplayed(true);
		  return;
		}
		
		if( arg.equals("-wb") ) {
		  workbench_name = args[++i];
		}

		if( arg.equals("-wbm") ) {
		  int_mode = WORKBENCH_MODE;      
		}

		if( arg.equals("-u") ) {
		  user_name = args[++i];
		}

		if( arg.equals("-admin") ) {
		  show_users_panel = true;
		}
		
		if( arg.equals("-demo") ) {
		  demo_mode = true;
		}
		
		if( arg.equals("-globus") ) {
		  int_mode = GLOBUS_MODE;
		  local_host = args[++i];
		}
		
		if( arg.equals("-portal") ) {
		  int_mode = PORTAL_MODE;
		}
	}
	
	try {
	  if( int_mode == PORTAL_MODE ) {
		  String codebase = System.getProperty("portal.dir");
		  if( codebase == null ) {
			 SimIO.show_error(null,"No PORTAL_DIR found!");
			 System.exit (1);
		  }	  
		  SimIO.setWorkbenchDirectory( codebase );
	  } else {
		  String codebase = System.getProperty("ws.dir");
		  if( codebase == null ) {
			  if( demo_mode ) {
				  codebase = System.getProperty("user.home") + "/.sme/";
			  } else {
				  codebase = System.getProperty("user.home") + "/.sme/usr/";
			  }
		  }
		  SimIO.setWorkbenchDirectory( codebase );
	  } 
	} catch ( SecurityException err ) { SimIO.show_error( null, "Security Exception:", err ); }

	ProjectHandler ph = new ProjectHandler(workbench_name,int_mode);
	ph.setRootDirectory(SimIO.getWorkbenchDirectory());
	if( local_host != null ) { ph.setLocalhost(local_host); }
	try {
		if( show_users_panel ) {
		  ph.readXML();
		} else {
		  ph.readXML( user_name );
		}
		ph.showTreeView(false,show_users_panel);
	} catch( SNPException err ) {
		SimIO.show_error(null,err);	
	}
  }
  
   public void save() {
	 if( _changes_made ) {
	  int rv = JOptionPane.showConfirmDialog( null, 
		  "Save WorkSpace changes?", "JST confirm", JOptionPane.YES_NO_CANCEL_OPTION, JOptionPane.QUESTION_MESSAGE );
	  SimIO.print("Got response: " + rv );
	  if( rv == 0 ) { 
		_changes_made = false;
		writeXML(); 
	  }
	}
   }

	class SaveWSAction extends QueuedExecutable  { 
	  public void execute()  {
		_changes_made = false;
		writeXML(); 
	  }
    } 
   
  public static ProjectHandler create( String workbench_name, String local_host ) { 	
	int int_mode = (local_host==null) ? LOCAL_MODE : GLOBUS_MODE;
	ProjectHandler ph = new ProjectHandler(workbench_name,int_mode);
	if( int_mode != LOCAL_MODE ) { ph.setLocalhost(local_host); }
	return ph;
  }

  public static ProjectHandler create( WorkSpaceRoot root, String local_host ) { 	
	int int_mode = (local_host==null) ? LOCAL_MODE : GLOBUS_MODE;
	ProjectHandler ph = new ProjectHandler(root,int_mode);
	if( int_mode != LOCAL_MODE ) { ph.setLocalhost(local_host); }
	return ph;
  }
  
  public void setUserRegister( UserRegister ur ) {
	  _user_manager = ur;
//	  _filter_workspaces = true; 
  }

}

class ProjDocListener extends Object implements TreeSelectionListener {
  JTextArea _text;
  ProjDocListener( JTextArea ta ) {
	_text = ta;
  }
  public void valueChanged(TreeSelectionEvent e) {
	try {
	  XMLComponent doc = (XMLComponent)e.getPath().getLastPathComponent();
	  _text.setText( (String) doc.getProperty("doc") );
	} catch ( ClassCastException err ) { 
	  _text.setText("");
	} 
  }
  
}
