package miiee.mml;

import java.util.*;
import java.io.*;
import javax.swing.*;
import miiee.xml.*;
import org.xml.sax.*;
import miiee.util.*;

public class  SimulationRun extends XMLContainer {

  private static Icon _icon;
  File _dataFile;
  SimulationData _simData;
  		
  public  SimulationRun( String id )  {
	 super(id);
  }	 

  public  SimulationRun( String id, String data_path ) throws XMLException  {
	 super(id);
	 setProperty( "directory", data_path );
  }	 

  public  SimulationRun( String id, File data_file ) throws XMLException  {
	 super(id);
	 setDataFile( data_file );
  }	 
    
  public  SimulationRun( Attributes atts )  {
	 super(atts);
  }	 

  public  SimulationRun( Attributes atts, XMLContainer parent )  throws XMLException {
	 super(atts,parent);
  }	

  public  SimulationRun( String id, XMLContainer parent ) throws XMLException  {
	 super(id, parent);
  }
  
  public void setDataFile( File dir ) throws XMLException {
	_dataFile = dir;
	setProperty( "directory", dir.getAbsolutePath() );
  }

  public File getDataFile() {
	if( _dataFile == null ) {
	   String dir = (String) getProperty("directory");
	   _dataFile = new File ( dir ); 
	}
	return _dataFile;
  }
  
  public String getDataPath() { 
	return (String) getProperty("directory");
  }

  public String getElementType( int format ) { return "simulation_run"; }
  
  public Icon getIcon() {
	if( _icon == null ) {
		_icon   = SimIO.loadIcon(  "spatial.gif" );	
	}
	return _icon;
  } 
  
  public XMLHandler getHandler( ) { return new MMLHandler(); }
  
  public SimulationData getDataSet() {
	if( _simData == null ) {
	  try {
		File datafile = getDataFile();
		_simData = readSimulationData( datafile );
	  } catch ( Exception err ) {
		SimIO.show_error(null,"Error getting DataSet: ",err);
	  }
	} 
	return _simData;
  } 

   public static SimulationData readSimulationData( File path ) 
	  throws FileNotFoundException, StreamCorruptedException, IOException, ClassNotFoundException, OptionalDataException { 
	  FileInputStream os = new FileInputStream( path );
	  ObjectInputStream ois = new ObjectInputStream(os);
	  SimulationData ro = (SimulationData) ois.readObject();
	  ois.close();
	  return ro;
   }

   public static SimulationData readSimulationData( java.io.InputStream is ) 
	  throws FileNotFoundException, StreamCorruptedException, IOException, ClassNotFoundException, OptionalDataException { 
	  ObjectInputStream ois = new ObjectInputStream(is);
	  SimulationData ro = (SimulationData) ois.readObject();
	  ois.close();
	  return ro;
   }
  
}
