package miiee.mml;

import java.util.Vector;
import javax.swing.*;
import miiee.xml.*;
import org.xml.sax.*;
import miiee.util.*;

public class  WorkSpace extends XMLContainer implements LocalizedObject {
    		
  public  WorkSpace( String id )  {
	 super(id);
 }	 
 
  public  WorkSpace( Attributes atts )  {
	 super(atts);
  }	 

  public  WorkSpace( Attributes atts, XMLContainer parent ) throws XMLException {
	 super(atts,parent);
	 System.out.println("Setting attributes for WorkSpace: " + atts.toString() );
  }	
  
  public Project getProject( String id ) {
	return (Project) getChild( id );
  }
  
  public String getElementType( int format ) { return "workspace"; }  

  public Icon getIcon() {
	if( _icon == null ) {
		_icon   = SimIO.loadIcon(  "workspace.gif" );	
	}
	return _icon;
  }

  public void writeXML( String xml_name, String dtd_name, int format ) { 
	 String dir = getDirectory();
	 if( dir != null ) { setNamespace(dir); }  
	 super.writeXML( xml_name, dtd_name, format );
  }
  
  public String getDirectory() {
	  return SimIO.getWorkbenchDirectory() + "/workspace/";
  } 
}

