package miiee.mml;

import java.util.*;
import javax.swing.*;
import miiee.xml.*;
import miiee.util.*;
import org.xml.sax.*;
import java.io.*;

public class  WorkSpaceRoot extends XMLContainer {
		
  public  WorkSpaceRoot( String id )  {
	 super(id);
	 addAttribute("workbench.name",id);
  }	
   
  public  WorkSpaceRoot( Attributes atts )  {
	 super(atts);
	 addAttribute( "workbench.name", ID() );
  }
   
  public String getElementType( int format ) { return "workspace_root"; }  

  public Icon getIcon() {
	if( _icon == null ) {
	  _icon  = SimIO.loadIcon( "symbol.gif" );
	}
	return _icon;
  } 
  
  public void writeSpecificXML( BufferedWriter out, int format )  throws IOException {  
	Iterator iter = childIterator();
	String dtd_file =  "workspace";
	while( iter.hasNext() ) {
	   XMLComponent obj = (XMLComponent) iter.next();
	   obj.setNamespace( ((WorkSpace)obj).getDirectory() );
	   if( obj.isVisible() ) {
		 String xml_file = obj.ID() + ".workspace";
		 obj.writeXML( xml_file, dtd_file, format ); 
		 obj.writeXML( out, DECLARATION ); 
	   }
	}
  }
  
}
