package miiee.python;

import miiee.util.*;
import java.util.Vector;
import java.util.Iterator;
import java.util.ListIterator;
import miiee.client.*;
import miiee.xml.*;
import miiee.mml.ConfigurationHandler;
import org.python.core.*;
import miiee.mml.MMLException;

//---- SPyGrid ---------------------------------------------------------

public class SPyGrid extends PyList  {

  DataSet _ds;
  int _cols = 0;
  int _rows = 0; 
  int[] _map;

  public SPyGrid( DataSet ds ) {
	_ds = ds;
	_cols = _ds.size( 0 );
	_rows = _ds.size( 1 );
	addPoints();
  }
  
  public void addPoints() {
	_map = _ds.generateCompressionMap();
	int index, mindex = -1;
	byte[] mask = _ds.getActiveRegion();
	byte format = _ds.format();
	for (int y=0; y < _rows; y++ ) {
	  for (int x = 0; x < _cols; x++ ) {
		index = x + y*_cols;
		if( ( mask == null ) || ( mask[index] > 0 ) ) { 
		  if( format == 0 ) { mindex = index; }
		  else { mindex++; }
		  append( new SPyPoint(mindex,y,x,this) );
		}
	  }		
	}
  }
    
  public PyObject getPoint( int row, int col ) {
	if( ( row < 0 ) || ( row >= _rows ) || ( col < 0 ) || ( col >= _cols ) ) return Py.None;
	int index = col + row * _cols;
	int cindex = _map[index];
	return (PyObject) ( ( cindex < 0 ) ? Py.None : get( cindex ) );
  }

  public PyObject trans( SPyPoint pt, int row_offset, int col_offset ) {
	int row = pt.row() + row_offset;	
	int col = pt.col() + col_offset;
	return 	getPoint( row, col ); 
  }

  public PyObject trans( SPyPoint pt, SPyPoint offset ) {
	int row = pt.row() + offset.row();	
	int col = pt.col() + offset.col();
	return 	getPoint( row, col ); 
  }
	
	public static PyList n4() {
	  PyList rv = new PyList();
	  rv.append( new SPyPoint( 1, 0 ) );
	  rv.append( new SPyPoint( 0, 1 ) );
	  rv.append( new SPyPoint(-1, 0 ) );
	  rv.append( new SPyPoint( 0,-1 ) );
	  return rv; 
	}
	
	public static PyList n8() {
	  PyList rv = n4();
	  rv.append( new SPyPoint( 1, 1 ) );
	  rv.append( new SPyPoint(-1, 1 ) );
	  rv.append( new SPyPoint(-1,-1 ) );
	  rv.append( new SPyPoint( 1,-1 ) );
	  return rv; 
	}

	public PyObject var( String info ) { return var(info,0f); }
	public PyObject var() { return var("",0f); }

	public PyObject var( String info, float fill_val ) {
	  try {
		DataEntry de = _ds.lastEntry();
		byte format = _ds.format();
		int dsize = de.dataSize(); 
		float time = de.time();
		float[] data = new float[dsize];
		for( int i=0; i<dsize; i++ ) {  data[i] = fill_val; }
		DataEntry de1 = new DataEntry( data, info, format, 0f, 0f, time );
		DataSet ds_new = SPyObject.getLocalDataSet( de1, de );
		SPyObject rv = new SPyObject( de1, SPyMethods.getClient() );
		return rv;
	  } catch( Exception err ) {
		SPyInterface.error( err.getMessage() );
	  }
	  return Py.None;
	}

    // __class__ boilerplate -- see PyObject for details
    public static PyClass __class__;

    protected PyClass getPyClass() {
        return __class__;
    }
	
  public String toString() { 
	return  "grid(" + _rows + "," + _cols + ")"; 
  }
  
}
