package miiee.python;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;
import java.io.*;
import javax.swing.border.*;
import java.util.*;
import java.text.SimpleDateFormat;
import javax.swing.tree.*;
import java.awt.event.*;
import miiee.util.*;
import miiee.TGraph.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.filechooser.*;
import miiee.dataview.*;
import miiee.tree.JTreeTable;
import javax.help.*;
import java.lang.reflect.*;
import miiee.mml.MMLException;
import miiee.client.*;
import org.python.util.PythonInterpreter;
import org.python.core.*;
import miiee.xml.*;
import javax.swing.text.*;
import spyconsole.*;

//---- SPyInterface ---------------------------------------------------------

public class SPyInterface {

  protected static String _python_dir = System.getProperty("LIBDIR") + "/python";
  protected static SPyConsole _console = new SPyConsole();		 
  protected static Class _string_class;  
  protected static boolean _debug = true;
  protected static boolean _initialized = false;
  protected static boolean _waitForSelection = false;
  protected static ModelObjectTree _selection_tree;
  protected static AttributeValuePair _time;
  protected static JPanel _selectionPanel;
  protected static DefaultStyledDocument _shell_doc;
  protected static Object _selection;
  protected static JTabbedPane _tabbedPanel = new JTabbedPane(); 
  protected static int _autoSelectionIndex = -1;
  protected static ViewserverControlPanel  _viewserver;
  protected static int _choose_var_index = 0;
  
  protected static final int kShellTab = 0;
  protected static final int kMessageTab = 1;
  protected static final int kViewTab = 2;
  
  /** constructs a SPyInterface */
  public static void setSelectionTree( ModelObjectTree object_tree ) {  
	 _selection_tree =  object_tree;
  }
 
  public static DefaultStyledDocument getDocument( StyleContext c ) {
	if( _shell_doc == null ) {
	  _shell_doc = new DefaultStyledDocument(c);
	}
	return _shell_doc;
  }
  
  public static String getLocalNameSpace() {
	return _console.getLocalNameSpace();
  }
  
  public static void main(String args[]) {
	 SPyInterface.startup(args);
  }
  
  public static void layout() {
	_selectionPanel.revalidate();
  }
 
   static void setTime( float time ) { 
	 _time.setValue( Float.toString( time ) ); 
   }

	public static void error( String message ) {
		_console.error( message );
	}
	public static void error( Exception err ) {
	  String message = err.getMessage();
	  if( err == null ) { message = err.toString(); }
	  _console.error( message );
	  err.printStackTrace();
	}

	public static void output( String message ) {
		_console.output( message );
	}
   
   static void write( String msg ) { output( msg ); }
   
   static void selectTab( int tabIndex, boolean overrideUserSelectiion ) {
	 int selectedIndex = _tabbedPanel.getSelectedIndex();
	 if( (tabIndex != selectedIndex) && (overrideUserSelectiion || (_autoSelectionIndex == selectedIndex) ) ) {
	   _autoSelectionIndex = tabIndex;
	   _tabbedPanel.setSelectedIndex(tabIndex);
	 }
   }
/*
   public static JMenuBar constructMenuBar( JFrame frame ) {
	  JMenu            menu;
	  JMenuBar         menuBar = new JMenuBar();
	  JMenuItem        menuItem;

	  menu = new JMenu("File");
	  menu.setBackground(Color.lightGray);
	  menuBar.add(menu);

	  menuItem = menu.add(new JMenuItem("Open Python Script"));
	  menuItem.addActionListener(new OpenAction());

	  menuItem = menu.add(new JMenuItem("Save Shell"));
	  menuItem.addActionListener(new SaveAction());

	  menuItem = menu.add(new JMenuItem("Save Shell As..."));
	  menuItem.addActionListener(new SaveAsAction());

	  menuItem = menu.add(new JMenuItem("Quit"));
	  menuItem.addActionListener( new ShutdownAction( frame ) );

	  menu = new JMenu("Edit");
	  menu.setBackground(Color.lightGray);
	  menuBar.add(menu);

	  menuItem = menu.add(new JMenuItem("Cut"));
	  menuItem.addActionListener( _console.getAction(DefaultEditorKit.cutAction ) );

	  menuItem = menu.add(new JMenuItem("Copy"));
	  menuItem.addActionListener( _console.getAction(DefaultEditorKit.copyAction ) );
	  
	  menuItem = menu.add(new JMenuItem("Paste"));
	  menuItem.addActionListener( _console.getPasteAction() );
		  
	  return menuBar;
	}
*/	 
  	public static void startup(String args[]) {
	  if( _initialized ) return;
	  _initialized = true;
		
	  JFrame frame = new JFrame("JPython Console");
	  WindowListener l = new WindowAdapter() {
		  public void windowClosing(WindowEvent e) {;}
	  };
	  frame.addWindowListener( l );
	  frame.getContentPane().add( _tabbedPanel, BorderLayout.CENTER );
	  
	  JPanel main = new JPanel(false);
	  _tabbedPanel.add(main,kShellTab);
	  _tabbedPanel.setTitleAt(kShellTab,"Shell");
	  _tabbedPanel.addChangeListener( new TabSelectionListener() );
	  
	  MessageReader mr = SPyMethods.getClient().getMessageReader(); 
	  _tabbedPanel.add( mr.getPanel(), kMessageTab );	
	  _tabbedPanel.setTitleAt(kMessageTab,"Messages");

	  BoxLayout bl0 = new BoxLayout(main, BoxLayout.Y_AXIS );  main.setLayout( bl0 ); 	   
	  main.setMaximumSize(new Dimension(Short.MAX_VALUE,  Short.MAX_VALUE)); 
	  main.setBorder( BorderFactory.createEtchedBorder() );

	  JPanel pH = new JPanel(false);	
	  BoxLayout bl1 = new BoxLayout(pH, BoxLayout.X_AXIS );  pH.setLayout( bl1 ); 	   
	  pH.setMaximumSize(new Dimension(Short.MAX_VALUE,  Short.MAX_VALUE)); 

	  JScrollPane shell_panel = _console.getConsolePanel();
	  _console.setAppFrame(frame);
	  ConsoleMenubar cmb = new ConsoleMenubar(_console);
	  frame.setJMenuBar( cmb );
	  cmb.addFileMenuItem( "Script Editor", new EditScriptAction() );
	  try {
		HelpBroker hb = SimIO.getHelpBroker( "SME", "SPyConsole"  );
		cmb.addHelpMenuItem( "SPyConsole help", new CSH.DisplayHelpFromSource(hb) );
	  } catch( Exception err ) {;}

	  pH.add( shell_panel );
	  pH.add( create_selection_panel() );
	  main.add(pH);

	  JButton  cButton = new JButton("close");
	  cButton.addActionListener( new ShutdownAction(frame) );  
	  
	  JButton hButton = new JButton("help");
//		hButton.addActionListener( new HelpAction() );

	  _time = AttributeValuePair.New( "time:", false, 10 );
	  _time.setValue( " 0.0 " );
		
	  JPanel status_panel = new JPanel(true);
	  SoftBevelBorder bb = new SoftBevelBorder(SoftBevelBorder.LOWERED);  	
	  status_panel.setBorder( bb );
	  status_panel.setMaximumSize(new Dimension(Short.MAX_VALUE, cButton.getMaximumSize().height)); 
	  main.add(status_panel);
	  status_panel.add( cButton );
	  status_panel.add( hButton );		
	  status_panel.add(_time);
		
/*		
		_inet_addr = AttributeValuePair.New( "host:", false, 18 );
		_inet_addr.setValue( " (no data) " );
		status_panel.add(_inet_addr);

		AttributeValuePair aport = AttributeValuePair.New( "port:", false, 6 );
		aport.setValue( Integer.toString(_port) );
		status_panel.add(aport);
*/
		

//		frame.setJMenuBar( constructMenuBar(standalone) );
		
		frame.setSize(900, 600);
		SimIO.set_centered_location( frame, 0.5f, 0.5f );
		frame.setVisible(true);	
		_console.addInitCommand("from miiee.python.SPyMethods import *");		
		_console.addInitCommand("open()");		
		_console.processArgs(args);
		_console.runShell();
	  }
	  
	  public static void exec( String script, String file_path  ) {
//		StringReader sr = new StringReader(sr);
		StringBufferInputStream s = new StringBufferInputStream(script);
		_console.execfile(s,file_path);
	  }

	  public static void exec( PyObject code ) {
		_console.exec(code);
	  }
	  	  
	  public static void compile( String script, String file_path ) {
		StringBufferInputStream s = new StringBufferInputStream(script);
		PyObject obj = _console.compile( s, file_path );
		if( obj != null ) {
		  String var_name = SimIO.showTextInputDialog( null, "Please specify code object name", "Python compile", "v0" );
		  if( var_name != null ) {
			  File f = new File(file_path);
			  String filename = f.getName();
			  SPyMethods.putCode(filename,obj);
			  String cmd = var_name + " = getCode( \"" + filename + "\" )";
			  _console.executeCommand( cmd );
		  }
		}
	  }
	  

	  public static void execfile( String file_path ) {
		_console.execfile(file_path);
	  }
	 
	  static public void setViewserver(ViewserverControlPanel cp) {
		_viewserver = cp;
		cp.setTabbedPane ( _tabbedPanel );
		_tabbedPanel.add(cp,kViewTab);
		_tabbedPanel.setTitleAt(kViewTab,"View");
		ViewserverControlPanel.addTreeModelListener( new ViewPanelInsertionListener() );
	  }
	  
	  static public void browseDataSet ( DataSet ds, DataEntry de ) {
	    _viewserver.browse( ds, de );
	  }

	static JPanel create_selection_panel() {

	  EmptyBorder eb7 = new EmptyBorder( 7, 7, 7, 7 );	
	  EmptyBorder eb3 = new EmptyBorder( 3, 3, 3, 3 );	

	  JPanel pV  = new JPanel(true);
	  BoxLayout bl = new BoxLayout(pV, BoxLayout.Y_AXIS );  pV.setLayout( bl ); 	   
	  Border bb = BorderFactory.createCompoundBorder( eb3, new BevelBorder(BevelBorder.LOWERED) ); pV.setBorder( bb );
	  	  
	  JLabel title = new JLabel("Selection:");
	  title.setBorder(eb7);
	  title.setAlignmentX(Component.CENTER_ALIGNMENT);
	  pV.add(title);
	  
	  JScrollPane scrollPane = new JScrollPane();
	  JTreeTable tt = _selection_tree.getTreeTable();
	  tt.setBorder( BorderFactory.createEtchedBorder()  );
//	  _selection_tree.addTreeSelectionListener(
//		new TreeSelectionListener() {
//		   public void valueChanged(TreeSelectionEvent e) { treeValueChanged(); }
//	   });
	  scrollPane.getViewport().setView(tt);
	  scrollPane.setBorder( bb );
	  scrollPane.setMaximumSize(new Dimension(400, Short.MAX_VALUE)); 
	  scrollPane.setMinimumSize(new Dimension(300, 300)); 
	  pV.add(scrollPane);

	  JPanel buttonPanel  = new JPanel(false);
	  bl = new BoxLayout(buttonPanel, BoxLayout.X_AXIS );  buttonPanel.setLayout( bl ); 
	    
	  JButton chooseButton = new JButton("Choose");
	  chooseButton.addActionListener( new ChooseAction() );
	  chooseButton.setMaximumSize( new Dimension( Short.MAX_VALUE, chooseButton.getMaximumSize().height ) );
	  buttonPanel.add( chooseButton );

	  JButton viewButton = new JButton("View");
	  viewButton.addActionListener( new ViewAction() );
	  viewButton.setMaximumSize( new Dimension( Short.MAX_VALUE, viewButton.getMaximumSize().height ) );
	  buttonPanel.add( viewButton );
	  
	  buttonPanel.setMaximumSize( new Dimension( 400, buttonPanel.getMaximumSize().height ) );
	  pV.add( buttonPanel );
	  _selectionPanel = pV;
	  
	  return pV;
	}
	
	public static void addSelectionNode( XMLContainer parent, XMLComponent node ) {
	  if( parent == null ) parent = (XMLContainer) getTreeModel().getRoot();
	  try {
		parent.addChild( node );
	  } catch ( XMLException err ) {
		SimIO.print( err.getMessage() );
	  }
	}
	
	public static String addDependencies() {
	  AddDependenciesAction	ad = new AddDependenciesAction(null);
	  ad.executeOnEventDispatchTread();
	  return "";
	}

	public static String addDependencies(Variable v) {
	  AddDependenciesAction	ad = new AddDependenciesAction(v);
	  ad.executeOnEventDispatchTread();
	  return "";
	}

	public static void refresh() {
	  XMLTreeModel tm = getTreeModel();
	  tm.reload();	
	  _selectionPanel.revalidate();
	  _selectionPanel.repaint();
	}
/*
	public static void clear() {
	  XMLTreeModel tm = getTreeModel();
	  _root_node.removeChildren();
	  tm.reload();	
	}
*/	
	public static JTree getSelectionTree() {
	  return _selection_tree.getTree();	  
	}
	
	public static ModelObjectTree getModelObjectTree() { return _selection_tree; }
	
	static  XMLTreeModel getTreeModel() {
	  JTree tree = getSelectionTree();
	  return (XMLTreeModel) tree.getModel();
	}
	
	public static void saveFile(String filename) throws IOException {
	  File file = (filename == null ? null : new File(filename));
	  saveFile(file);
	}

	/** saves the given file */
	public static void  saveFile(File file) throws IOException {
	  byte[] bytes = _console.getText().getBytes();
	  FileOutputStream out = new FileOutputStream(file);
	  out.write(bytes);
	  out.close();
	}	
	
	static XMLComponent getSelection() {
	  try {
		TreePath tp = _selection_tree.getTree().getSelectionPath();
		XMLComponent tn = (XMLComponent) tp.getLastPathComponent();	
		SimIO.print( "Got Selected Object: " + tn.ID()  );
		return tn;
	  } catch( NullPointerException err )          { SimIO.beep(); }
		catch( java.lang.ClassCastException err1 ) { SimIO.beep(); }
	  return null;
	}

  public static void setSelectedComponent(Object c) {
	_selection = c;
	if( _waitForSelection ) {
		_waitForSelection = false;
	} else {
		String var_name = SimIO.showTextInputDialog( null, "Please specify variable name", "Python variable import", "v" + _choose_var_index++ );
		if( var_name != null ) {
			String cmd = var_name + " = choose(\"" + var_name + "\")";
			_console.executeCommand( cmd );
		}
	}
  }

  public static Object getSelectedComponent( boolean waitForSelection ) {
	_selection = getSelection(); 
	if( waitForSelection ) {
		if( _selection != null ) { return _selection; }
		_waitForSelection = true;
		SimIO.show_info( null, "Please choose node in selection tree and click on <choose> button" );
		while ( _waitForSelection ) {
			try {  Thread.sleep(200L);   }
			catch (InterruptedException e0) {  break;  }
		}
	}
	return _selection;
  }
  	
	public boolean executeCommand( String cmd ) {
	   return  _console.executeCommand( cmd );
	}
	
	static class TabSelectionListener implements ChangeListener {
	  public void stateChanged(ChangeEvent e) {
		 JTabbedPane tabbed_pane =  (JTabbedPane) e.getSource();
		 int selectedIndex = tabbed_pane.getSelectedIndex();
		 if( selectedIndex != _autoSelectionIndex ) { _autoSelectionIndex = -1; }
	  }
	}

	static class ChooseAction extends QueuedExecutable {  
	  public void execute() { 
		 setSelectedComponent( getSelection() );
	  }
	}

	static class ViewAction extends QueuedExecutable {  
	  public void execute() { SPyMethods.view();  }
	}

	static class EditScriptAction extends QueuedExecutable {  
	  public void execute() { SPyMethods.read();  }
	}

  
	static class ViewPanelInsertionListener implements TreeModelListener {

	   public void treeNodesInserted(TreeModelEvent e) {
		 TreePath parent_path = e.getTreePath();
		 Object parent = parent_path.getLastPathComponent(); 
		 RepairedMutableTreeNode root = ViewserverControlPanel.getRoot();
		 if( parent == root ) { selectTab( kViewTab, true ); }	 
	   }
	   public void treeNodesChanged(TreeModelEvent e) {;}
	   public void  treeNodesRemoved(TreeModelEvent e) {;} 
	   public void treeStructureChanged(TreeModelEvent e) {;}	

	}

}


class AddDependenciesAction  extends QueuedExecutable   {
  Variable _v;
  AddDependenciesAction( Variable v ) { _v = v; }
  public void execute() {
	try { 
	  Module m = null;
	  ModelObjectTree mt = SPyInterface.getModelObjectTree(); 
	  if( _v == null ) {	  
		TreePath tp = mt.getTree().getSelectionPath();
		XMLContainer tn = (XMLContainer) tp.getLastPathComponent();
		XMLContainer mn = (XMLContainer) tp.getPathComponent(1);
		_v = (Variable)tn;  
		m = (Module)mn;  
	  } else {
		m = (Module) _v.getParent();
	  }
	  mt.addDependencies( SPyMethods.getClient(), m, _v );
	} catch( NullPointerException err ) {
	  SimIO.beep();
	  return;
	} catch( java.lang.ClassCastException err ) {
	  SimIO.beep();
	  return;
	}
  }
}

class ShutdownAction extends QueuedExecutable {  
  JFrame _frame;
  ShutdownAction( JFrame f ) { _frame = f; }
  public void execute() { 
	_frame.setVisible(false);
	_frame.dispose();
	 SPyMethods.shutdown( false ); 
	 System.exit(0); 
  }
}

//  protected static PythonInterpreter _interpreter = new PythonInterpreter();  

/*    
  public void startup_external() { 
	try {
	  PyString python_path = (PyString) _interpreter.get("python.path");
	  String pypath = null;
	  if( python_path == null ) {
		_interpreter.set("python.path", (pypath = _python_dir) );
	  } else {
	  	pypath = python_path.toString();
		if ( pypath.indexOf( _python_dir ) == -1 ) {
		  _interpreter.set("python.path", (pypath = pypath + ":" + _python_dir) );
		}
	  }
	  SimIO.print("Startup python console, python.path = " + pypath );
	  _interpreter.execfile( _python_dir + "/Console.py");
	} catch ( Exception err ) {
	  SimIO.show_error( null, "Python error:", err );
	  if( _debug ) {
		err.printStackTrace();
	  }
	}
  }
*/
